%IF (0) THEN (
Expand_all.asm 

							Spec Expansion

Prior to 3.0, spec expansion was done in the file system, the cluster, and in ICC. In CTOS 3.0 the kernel does spec expansion and all servers (like the file system and the cluster) can expect fully expanded specs in request blocks.

The specs are expanded in a heap area allocated at OS initialization. When a spec requires expansion a heap node is allocated and a new spec is created therein which contains the the user's spec appended to the default path from the user's UCB. The pbcb of the original spec and the request's response exchange is also put in the heap node so that it can be replaced in the request block at Respond. Also at Respond the heap node is freed. This "unexpansion" is done only if the request response exchange equals the response exchange saved in the heap node (i.e. unexpansion of an "original" pbcb is not done for a Respond to a two-way filter).  The kernel calls ExpandRqSpecs in Request, and FreeRqSpecs in Respond. Since Termination Responds to all outstanding requests, the expanded specs need no terminating.

To determine if an rq.pbcb is a spec which needs expanding, 3 things must be known: the netRouting associated with the request code, the number of the pbcb pairs in the request block, and the contents of the spec. A jump table is used to resolve netRouting and iPbCb:

  										  iPbCb
 								0		1		2		3
  (netRouting and 17h)		------------------------------------
 	0	NoSpec				RetOk	    -  		-		-
 	1	DevSpec				DevSpec	  RetOk		-		-
 	2	DirSpec				DirSpec	  RetOk		-		-
 	3	FileSpec			FilSpec	  RetOk		-		-
 	4	FileSpec2			FilSpec	  FilSpec  RetOk	-
 	5	FileSpecP2S2		NextPbCb  NextPbCb FilSpec RetOk
 	6	CloseFh				RetOk       -		-		-
 	7	Illegal				RetNotOk	-		-		-

 	10	NoSpec+pswd			Pswd	  RetOk		-		-
 	11	DevSpec+pswd		DevSpec	  Pswd	   RetOk	-
 	12	DirSpec+pswd		DirSpec	  Pswd     RetOk	-
 	13	FileSpec+pswd		FilSpec	  Pswd	   RetOk	-
 	14	FileSpec2+pswd		FilSpec	  Pswd     FilSpec  Pswd
 	15	FileSpecP2S2+pswd	NextPbCb  NextPbCb FilSpec  Pswd
 	16	CloseFh+pswd		Pswd      RetOk		-		-
 	17	Illegal+pswd		RetNotOk	-		-		-


  Net Routing Code bits:
 
  		0	= DevSpec \_______FileSpec  \
 		1	= DirSpec /  \____CloseFh    \_____FileSpecP2S2
 		2	= FileSpec2  /               /
 		3	= FileHandle
 		4 	= SpecPw - pbcb following spec above is password
 		5 	= closeAtTerm 
 		6	= openFH  
 		7 	= RW    


)FI



;*****************************************************************************
;  LITERALS
;*****************************************************************************
ucbDefaultVol  EQU 2
ucbDefaultDir  EQU ucbDefaultVol+13
ucbDefaultPW   EQU ucbDefaultDir+13
ucbPrefix      EQU ucbDefaultPW+13
ucbDefaultNode EQU ucbPrefix+41

heapNodeRaUser 	EQU 0
heapNodeSaUser 	EQU 2
heapNodeCbUser 	EQU 4
heapNodeRgbSpec EQU 6

mDevSpec         EQU 1
mDirSpec         EQU 2
mFileSpec        EQU 3
mFileSpec2       EQU 4
mFileSpecP2S2    EQU 5
mCloseFh		 EQU 6
mSpecType        EQU 7
mPswdType        EQU 10H
lrqsCntInfo	 	 EQU 0
lrqReqPbCb		 EQU 2
lrqUserNum		 EQU 4
lrqExchResp		 EQU 6
lsRqHeader		 EQU 12
true			 EQU 1
false			 EQU 0


ercInconsistency EQU 3


;************
; Macros
;************


%*DEFINE(InitHeapNode(cb)) LOCAL JumpLabel (
	MOV  AX, Dgroup
	MOV  ES, AX
ASSUME ES:Dgroup, DS:Nothing
	PUSH WORD PTR [sgSpecHeap]
	PUSH %cb
	LEA  AX, pHeapNode
	PUSH SS
	PUSH AX
	MOV  AL, fNoWait
	PUSH AX
	CALL IntraSegHeapAlloc
	OR   AX, AX
	JZ   %JumpLabel
	JMP  RetAX
%JumpLabel:
	LES  DI, pHeapNode
; save exchResp in first 2 node bytes so we know when to replace pbcb
	MOV  CX, exchResp
	MOV  ES:[DI], CX
	ADD  DI, 2
; save user pbcb in next 6 bytes of node so we can replace it on Respond
	LDS  SI, pPbCb
	MOV  CX, 3
	REPNZ MOVSW	
)

%*DEFINE(GetpUcbDSBX)(
	MOV  SI, userNum
	AND  SI, 3FFh
	SHL  SI, 1
	MOV  AX, Dgroup
	MOV  DS, AX
ASSUME DS:Dgroup
	LDS  BX, DWORD PTR [prgoUcb]
ASSUME DS:Nothing
	MOV  BX, [BX][SI]
)


;*******************
; External calls
;*******************
EXTRN	IntraSegHeapAlloc:FAR
EXTRN	IntraSegHeapDeAlloc:FAR
EXTRN	Crash:FAR 


;*******************
; External data
;*******************
Stack SEGMENT WORD PUBLIC 'Stack'
Stack ENDS
Data SEGMENT WORD PUBLIC 'Data'
EXTRN sgSpecHeap:WORD
EXTRN prgoUcb:DWORD
Data ENDS
DGroup Group Stack,Data


; ExpandRqSpecs and FreeRqSpecs are NEAR to kernel
Kernel SEGMENT PUBLIC 'Code'	
KGroup GROUP Kernel
ASSUME CS:KGroup, DS:Nothing, SS:Stack

ExpandCase LABEL WORD
	DW	RetOk,		BadRt,		BadRt,		BadRt	; 0h  NoSpec
	DW	DevSpec,	RetOk,		BadRt,		BadRt	; 1h  DirSpec
	DW	DirSpec,	RetOk,		BadRt,		BadRt	; 2h  DirSpec
	DW	FilSpec,	RetOk,		BadRt,		BadRt	; 3h  FileSpec
	DW	FilSpec,	FilSpec,	RetOk,		BadRt	; 4h  FileSpec2
	DW	NextPbCb,	NextPbCb,	FilSpec,	RetOk	; 5h  FileSpecP2S2
	DW	RetOk,		BadRt,		BadRt,		BadRt	; 6h  CloseFh
	DW	BadRt,   	BadRt,		BadRt,		BadRt	; 7h  illegal routing

	DW	Pswd,		RetOk,		BadRt,		BadRt	; 10h NoSpec + SpecPw
	DW	DevSpec,	Pswd,		RetOk,		BadRt	; 11h DirSpec + SpecPw
	DW	DirSpec,	Pswd,		RetOk,		BadRt	; 12h DirSpec + SpecPw
	DW	FilSpec,	Pswd,		RetOk,		BadRt	; 13h FileSpec + SpecPw
	DW	FilSpec,	Pswd,		FilSpec,	Pswd	; 14h FileSpec2 + SpecPw
	DW	NextPbCb,	NextPbCb,	FilSpec,	Pswd	; 15h FileSpecP2S2 + SpecPw
	DW	Pswd,		RetOk,		BadRt,		BadRt	; 16h CloseFh + SpecPw
	DW	BadRt,   	BadRt,		BadRt,		BadRt	; 17h illegal routing


;
; ExpandRqSpecs
;		ES:BX = pRq
;		DX = (netRouting,iccRouting)
;       AL = fNoWait
;		rq.userNum is local (has a UCB)
;		netRouting has spec bits set
;		rq.nReqPbcb > 0
;
;		all registers corrupted
;
ExpandRqSpecs PROC NEAR
PUBLIC ExpandRqSpecs
ASSUME DS:Nothing, ES:Nothing

pHeapNode	EQU DWORD PTR [BP-4]
pPbCb		EQU DWORD PTR [BP-8]
raPbCb		EQU WORD PTR [BP-8]
saPbCb		EQU WORD PTR [BP-6]
iPbcb		EQU WORD PTR [BP-10]
userNum		EQU WORD PTR [BP-12]
fExpandDir	EQU BYTE PTR [BP-13]
bRouting	EQU BYTE PTR [BP-14]
exchResp	EQU WORD PTR [BP-16]
fNoWait		EQU BYTE PTR [BP-18]
fNodeOnly	EQU BYTE PTR [BP-19]
sLocals		EQU 20

	PUSH BP
	MOV  BP, SP
	SUB  SP, sLocals
	MOV  bRouting, DH
	MOV  fNoWait, AL
	MOV  AX, ES:WORD PTR [BX+lrqUserNum]    
	MOV  userNum, AX
	MOV  AX, ES:WORD PTR [BX+lrqExchResp]
	MOV  exchResp, AX
	MOV  AL, ES:BYTE PTR [BX+lrqsCntInfo]    
	ADD  AL, lsRqHeader
	CBW
	MOV  DI, BX
	ADD  DI, AX
; ES:DI = @rq.pbcb(0)
	CLD
	MOV  BH, ES:BYTE PTR [BX+lrqReqPbCb]    
; only 1st 4 specs are expandable
	XOR  BL, BL	 ; iPbCb
	CMP  BH, 4
	JBE  PbCbLoopTop
	MOV  BH, 4

PbCbLoopTop:
; DX = netRouting/iccRouting
; convert routing byte to jump table index 	
	MOV  fNodeOnly, FALSE
	MOV  DL, DH
	AND  DL, mSpecType
	SHL  DL, 2
	ADD	 DL, BL
	TEST DH, mPswdType
	JZ   DoCase
	OR	 DL, 20h

DoCase:
	MOV	 raPbCb, DI
	MOV  saPbCb, ES
	MOV  iPbcb, BX	; BL = iPbcb, BH = nReqPbCb
	XOR  DH, DH	
	SHL  DX, 1
	MOV  SI, DX
	JMP  WORD PTR ExpandCase[SI]

NextPbCb:
	MOV  BX, iPbCb
	INC  BL
	CMP  BL, BH
	JB   AddressNextPbCb
	JMP  RetOk
AddressNextPbCb:
	MOV  DI, raPbCb
	ADD  DI, 6
	MOV  ES, saPbCb
	MOV  DH, bRouting
	JMP  SHORT PbCbLoopTop

DevSpec:
; expand nul specs to default node
	CMP  ES:WORD PTR [DI+4], 0
	JNE  NextPbCb
	%GetpUcbDSBX
	MOV  AL, [BX+ucbDefaultNode]
	OR   AL, AL
	JE   NextPbCb
	ADD  AL, 10		; size(exchResp) + size(pbcb) + size('{}')
	XOR  CX, CX						; pbcb.cb
	LES  DI, ES:DWORD PTR [DI]		; pbcb.pb
	MOV  fNodeOnly, TRUE
	JMP  StartNodeExpansion

DirSpec:
	MOV  fExpandDir, false	
	JMP  SHORT TestFileSpec

FilSpec:
	MOV  fExpandDir, true
TestFileSpec:
	MOV  CX, ES:WORD PTR [DI+4]
	JCXZ NextPbCb
	LES  DI, ES:DWORD PTR [DI]
	MOV  AX, ES
	OR   AX, AX
	JZ   NextPbCb
; ES:DI = rq.pbcb(i).pb
; CX = rq.pbcb(i).cb
	CMP  ES:BYTE PTR [DI], '{'
	JE   NextPbCb
	CMP  ES:BYTE PTR [DI], '['
	JE   NextPbCb
	CMP  ES:BYTE PTR [DI], '<'
	JNE  StartExpansion
	MOV  fExpandDir, FALSE

StartExpansion:
	%GetpUcbDSBX
; DS:BX = @ucb
	MOV  AL, 15		; size(exchResp) + size(pbcb) + size('{}[]<>>')
	ADD  AL, [BX+ucbDefaultNode]
	ADD  AL, [BX+ucbDefaultVol]
	ADD  AL, [BX+ucbDefaultDir]
	ADD  AL, [BX+ucbPrefix]
StartNodeExpansion:
	CBW
	ADD  CX, AX

	%InitHeapNode(CX)
; ES:DI = @heapNode.rgbSpec(0)
; heapNode.userExchResp contains rq.exchResp
; heapNode.userPbCb contains rq.pbCb 

	%GetpUcbDSBX
; DS:BX = @ucb
; ES:DI = @heapNode.rgbSpec(0)

; Move '{UcbNode}[' to new spec
	LEA  SI, [BX+ucbDefaultNode]
	MOV  DX, DI  ; save starting ra to figure count later
	LODSB 
	OR   AL, AL
	JZ   ExpandVolume
	CBW
	MOV  CX, AX
	MOV  ES:BYTE PTR [DI], '{'
	INC  DI
	REPNZ MOVSB
	MOV  ES:BYTE PTR [DI], '}'
	INC  DI
	CMP  fNodeOnly, 0
	JNE  AppendUserSpec	; finish devSpec expansion

ExpandVolume:
; Append '[UcbVol]' to new spec
	MOV  ES:BYTE PTR [DI], '['
	INC  DI
	LEA  SI, [BX+ucbDefaultVol]
	LODSB 
	CBW
	MOV  CX, AX
	REPNZ MOVSB
	MOV  ES:BYTE PTR [DI], ']'
	INC  DI

ExpandDir:
	TEST fExpandDir, true
	JZ   AppendUserSpec

; Append '<UcbDir>' to new spec
	MOV  ES:BYTE PTR [DI], '<'
	INC  DI
	LEA  SI, [BX+ucbDefaultDir]
	LODSB 
	CBW
	MOV   CX, AX
	REPNZ MOVSB
	MOV  ES:BYTE PTR [DI], '>'
	INC  DI

; Append 'UcbPrefix' to new spec
	LEA  SI, [BX+ucbPrefix]
; DS:SI = ucb.sbPrefix
; ES:DI = @heapNode.rgbSpec(FileSpec)
	LODSB 
	OR   AL, AL
	JZ   AppendUserSpec
	CBW
	MOV  CX, AX
	REPNZ MOVSB

; Append user spec to new spec
; also come here to finish devSpec expansion (pbcb.cb = 0)
AppendUserSpec:
	LDS  SI, pPbCb	
; DS:SI = @rq.pbCb(i)
	MOV  CX, [SI+4]
	JCXZ SkipMove
	LDS  SI, DWORD PTR [SI]
; DS:SI = rq.pbcb(i).pb
; CX = rq.pbcb(i).cb
	REPNZ MOVSB
	LDS  SI, pPbCb

SkipMove:
; Replace rq.pbcb(i) with pbNewSpec, cbNewSpec
; DS:SI = pPbCb
; ES:DI = @heapNode.rgbSpec(end)
; DX = .heapNode.rgbSpec(0)
	SUB  DI, DX
	MOV  WORD PTR [SI], DX			;rq.pbcb(i).ra
	MOV  WORD PTR [SI+2], ES		;rq.pbcb(i).sa
	MOV  WORD PTR [SI+4], DI		;rq.pbcb(i).cb

	JMP  NextPbCb	
	
Pswd:
	MOV  CX, ES:WORD PTR [DI+4]
; CX = rq.cbSpec
	JCXZ CheckNullUcbPswd
	JMP NextPbCb

CheckNullUcbPswd:
	%GetpUcbDSBX
	MOV  CL, BYTE PTR [BX+ucbDefaultPW]
	OR   CL, CL
	JNZ  ExpandPswd	
	JMP  NextPbCb	

ExpandPswd:
	PUSH DS				; save pUcb
	PUSH BX
	XOR  CH, CH
	ADD  CL, 8			; + size(exchResp) + size(pbcb)
	%InitHeapNode(CX)
; ES:DI = @heapNode.rgbSpec(0)
; heapNode.userPbCb contains rq.pbCb 
; heapNode.userPbCb contains rq.pbCb 
	MOV  DX, DI			; save starting ra
	POP BX
	POP DS
; Move 'UcbPassword' to new spec
	LEA  SI, [BX+ucbDefaultPW]
	LODSB 
	CBW
	MOV  CX, AX
	REPNZ MOVSB

; Replace rq.pbcb(i) with pbNewSpec, cbNewSpec
; ES:DI = @heapNode.rgbSpec(end)
; DX = .heapNode.rgbSpec(0)
	MOV  BX, ES
	LES  DI, pPbCb	
	MOV  ES:WORD PTR [DI], DX		;rq.pbcb(i).ra
	MOV  ES:WORD PTR [DI+2], BX		;rq.pbcb(i).sa
	MOV  ES:WORD PTR [DI+4], AX		;rq.pbcb(i).cb
	JMP  NextPbCb

BadRt:
	MOV  AX, ercInconsistency
	JMP  SHORT RetAX
RetOk:
	XOR  AX, AX
RetAX:
	MOV SP, BP
	POP BP
	RET

ExpandRqSpecs ENDP



;
; FreeRqSpecs 
; 		ES:BX = pRq
;		scan rq.pbcbs for pbs which are in the spec expansion heap.
;		replace the original pbcb and deallocate the heap space.
;		all registers preserved.
;		returns AX 
;
FreeRqSpecs PROC NEAR
PUBLIC FreeRqSpecs
ASSUME DS:Nothing, ES:Nothing

	MOV  AL, ES:BYTE PTR [BX+lrqReqPbCb]    
	OR   AL, AL
	JNZ  ScanPbCbs
	RET

ScanPbCbs:
; save Respond regs 
	PUSH DX
	PUSH SI
	PUSH DI
	PUSH DS
	PUSH ES
	PUSH BX

; ES:BX = pRq
	MOV  CX, ES:WORD PTR [BX+lrqExchresp]
	XOR  AH, AH
	MOV  DX, lsRqHeader
	ADD  DL, ES:BYTE PTR [BX+lrqsCntInfo]    
	ADD  BX, DX
; ES:BX = @rq.pbcb(0)
; AL = nPbCb
; AH = iPbCb
; CX = rq.exchResp
	
	MOV  DX, Dgroup
	MOV  DS, DX
ASSUME DS:Dgroup
	MOV  DX, WORD PTR [sgSpecHeap]
	OR   DX, DX		; check if heap initialized
	JE   FreeRqSpecsRetOk

TestNextSpec:
; AH = iPbcb
; ES:BX = @rq.pbcb(i)
	INC  AH		
	CMP  AH, AL
	JA   FreeRqSpecsRetOk
	CMP  DX, ES:[BX+2]	
	JE	 DeAllocSpec
GetNextSpec:
	ADD  BX, 6
	JMP  SHORT TestNextSpec

DeAllocSpec:
	LDS  SI, ES:DWORD PTR [BX]
ASSUME DS:Nothing
	CMP  CX, [SI-8]
	JNE  GetNextSpec

; DS:SI = pbSpec
; prior 8 bytes are user's original unexpanded pbcb and exchResp
; 
;			 exchResp
;			 userRa
;			 userSa
;			 userCb
;	DS:SI -> rgbExpandedSpec	
; 
	SUB  SI, 6
	MOV  DI, BX
	PUSH CX		; save rq.exchResp
; ES:DI = pPbCb
	MOV  CX, 3
; replace user's pbcb 
	CLD
	REPNZ MOVSW

	PUSH DX		; save sgHeap
	PUSH AX		; save iPbcb/nPbCb
	PUSH ES		; save @rq.pbcb(iPbCb)
	PUSH BX
	SUB  SI, 8
	PUSH DS
	PUSH SI
	CALL IntraSegHeapDeAlloc
	OR   AX, AX
	JNZ  FreeRqSpecsError 
	POP  BX
	POP  ES
	POP  AX		
	POP  DX
	POP  CX
	JMP  SHORT GetNextSpec

FreeRqSpecsError:
	PUSH ercInconsistency
	CALL Crash 

FreeRqSpecsRetOk:
	XOR  AX, AX
FreeRqSpecsRetAx:
	POP  BX
	POP  ES
	POP  DS
	POP  DI
	POP  SI
	POP  DX
	RET
FreeRqSpecs ENDP


Kernel ENDS


END

; Log
; 10/20/88 JM created
; 03/21/89 MTR ExpandRqSpecs saves rq.exchResp in heapNode, FreeRqSpecs
;              frees heapNode (unexpands) iff rq.exchResp=heapNode.userExchResp
; 03/29/89 MTR Pass fNoWait to IntraSegHeapAlloc
; 07/14/89 JM  do CLDs.
; 12/06/89 MTR No file/dir spec expansion if source (rq) cb is 0
; 12/11/89 JA/MTR Append ucbPrefix as-is (don't add a trailing '>'!)
;				  Don't expand spec nor password if source sa (in rq) is nil
; 12/15/89 MTR Ha ha--do expand password if source sa is nil
; 02/25/91 JM  devSpec expand zero length specs to include default node.
; 03/21/91 JM  fix uninitialized fNodeOnly.
