$MOD386
;*************************************************************************
; This little module supplies an entry point that JMPs to a PLM routine
; with arguments on the stack.  PLM doesn't allow argument passing to Main.
;*************************************************************************

; LITERALS

ATpOPcbRun				EQU 24Ch
pcbUserNum				EQU	14
maskSlot				EQU 03FFH       ;1024 usernums max

; EXTERNAL PROCEDURES

EXTRN CheckErc:FAR
EXTRN GetPStructure:FAR
EXTRN SetSegmentAccess:FAR

Data SEGMENT PUBLIC 'Data'
EXTRN pEntryPoint						:DWORD
EXTRN fSoftBus							: BYTE
Data	ENDS
DGroup	GROUP Data

EntryPoint_Code	SEGMENT PUBLIC 'Code'
PUBLIC EntryPoint
EntryPoint PROC FAR
ASSUME	CS:EntryPoint_Code, DS:DGroup
ppPcbRun		EQU DWORD PTR [BP-2*4]
pa				EQU DWORD PTR [BP-2*5]
	ENTER  2*8,0
	PUSH	ATpOPcbRun
	PUSH	0
	LEA		AX,ppPcbRun
	PUSH	SS
	PUSH	AX
	CALL	GetPStructure
	PUSH	AX
	CALL	CheckErc
	LES		BX,ppPcbRun				;ES:BX points to pPcbRun
	LES		BX,DWORD PTR ES:[BX]	;ES:BX points to pcbRun
	TEST	WORD PTR ES:[BX+pcbUserNum],maskSlot
	JE		Ep01
; If our userNumber is not zero, we are on the soft bus
	MOV		fSoftBus, 0FFh
; Make the code segment executable.  It was linked COED.
	PUSH	WORD PTR pEntryPoint+2
	PUSH	10
	CALL	SetSegmentAccess
	PUSH	AX
	CALL	CheckErc
; Set up parameters for entry point
	MOV		pa,0
	LEA		AX,pa
	PUSH	AX
	PUSH	SS
	PUSH	AX
	PUSH	SS
	JMP pEntryPoint
	
Ep01:
	LEAVE
	JMP pEntryPoint
EntryPoint ENDP
EntryPoint_Code	ENDS
	END EntryPoint
; 04/01/93 JF Make this work for soft bus agents
