;	Data_All.asm
;
;	This file generates the following object modules depending on switches:
;
;	Module			Switches
;
;	Data_Os			Os
;	Data_OsMf		Os, Mf
;	Data_Fs			Fs
;	Data_FsMf		Fs, Mf
;	Data_LDM		Fs, LDM


;
;
PUBLIC	commDmaAddr
PUBLIC	commDmaWrdCnt
PUBLIC	commDmaEar
PUBLIC	counter08254Ngen
PUBLIC	DmaEarEnable
PUBLIC	DmaMask
PUBLIC	DmaMode
PUBLIC	DmaCommand
PUBLIC	DmaBytePtrClr
PUBLIC	modeWord8254Ngen
PUBLIC	ModeWord8254RTC
PUBLIC  RTCCounter8254
PUBLIC	FingerPort
PUBLIC	NonVolatileRamBaseAddr
PUBLIC	ProtectedModeEnabl
PUBLIC	rdsrL
PUBLIC	rdsrH
PUBLIC	shCpuSpeed
PUBLIC	tdsrL
PUBLIC	tdsrH
PUBLIC	TimeClockBaseAddr
PUBLIC	pcsarL
PUBLIC	pcsarH
PUBLIC	pcrl
PUBLIC	pcrH
PUBLIC	cPort
PUBLIC	stat
PUBLIC	timerCtl
PUBLIC	timerComm
PUBLIC	EarPort
%IF(NOT %MF) THEN (
PUBLIC	FloppyChkBdWordAddr
PUBLIC	mpbSlotiSlot
PUBLIC	mpiFpbSlot
PUBLIC	pFloppyChkBdBuffer
PUBLIC	pFloppyIoBuffer
)FI
PUBLIC	ClearRtcIntPort
PUBLIC	shCpuSpeed
PUBLIC	videoType
PUBLIC  Rs232DmaAddr0
PUBLIC  Rs232DmaWrdCnt0
PUBLIC  Rs232DmaAddr1
PUBLIC  Rs232DmaWrdCnt1
PUBLIC  Rs232DmaAddr2
PUBLIC  Rs232DmaWrdCnt2
PUBLIC  Rs232DmaAddr3
PUBLIC  Rs232DmaWrdCnt3
PUBLIC  Rs232DmaCommand
PUBLIC  Rs232DmaRequest
PUBLIC  Rs232DmaMask
PUBLIC  Rs232DmaMode
PUBLIC  Rs232DmaBytePtrClr
PUBLIC  Rs232DmaMstrClr
PUBLIC  Rs232DmaMaskAll
PUBLIC  Rs232DmaEar0
PUBLIC  Rs232DmaEar1
PUBLIC  Rs232DmaEar2
PUBLIC  Rs232DmaEar3
PUBLIC  Rs232DmaEarEnable
PUBLIC  LedDisplayPort

PUBLIC	baudRateCtrA
PUBLIC	baudRateCtrB
PUBLIC	baudRateCtrC
PUBLIC	baudRateCtrD
PUBLIC	BeeperPortNGen
PUBLIC	cascadeOCW1_8259 
PUBLIC	cascadeOCW2_8259 
PUBLIC	ExtCtlReg

PUBLIC	ioCommDataA
PUBLIC	ioCommCtlA
PUBLIC	ioCommDataB
PUBLIC	ioCommCtlB
PUBLIC	ioCommDataC
PUBLIC	ioCommCtlC
PUBLIC	ioCommDataD
PUBLIC	ioCommCtlD
PUBLIC	modeWord8253 
PUBLIC	NGenPortsStructure
PUBLIC	OCW1_8259 
PUBLIC	OCW2_8259 
PUBLIC	oMemAvail 

PUBLIC	ParityErrPort0NGen
PUBLIC	ParityErrPort1NGen
PUBLIC	pIBusIDTable
PUBLIC	pSGBusIDTable
PUBLIC	pXBusIDTable
PUBLIC  pEBifIsrTable
PUBLIC	pEisaTable
PUBLIC	vid6845Addr
PUBLIC	vid6845Data
PUBLIC	XINTR3vector
PUBLIC	ParityEnablePortNGen
PUBLIC	vidControl

PUBLIC	processorType

PUBLIC	LptIntClear
PUBLIC	LptDmaBytePtrClr
PUBLIC	LptDmaAddr
PUBLIC	LptDmaEar
PUBLIC	LptDmaEarH
PUBLIC	LptDmaCount
PUBLIC	LptDmaCountH
PUBLIC	maskLptDmaChannel
PUBLIC	maskLptDmaEnable
PUBLIC	maskLptDmaDisable
PUBLIC	LptDmaCommand
PUBLIC	LptDmaMode
PUBLIC	LptDmaMask
PUBLIC	LptPortDirection
PUBLIC	ParLpPort
PUBLIC	ParInPort
PUBLIC	commDmaEarHigh
PUBLIC  Counter18254Ngen
PUBLIC  Counter28254Ngen
PUBLIC  RTCmosAddressReg
PUBLIC  RTCmosDataReg
PUBLIC  RTCSecs
PUBLIC  RTCMins
PUBLIC  RTCHrs
PUBLIC  RTCDayOfWeek
PUBLIC  RTCDate
PUBLIC  RTCMonthOfYear
PUBLIC  RTCYear
PUBLIC  RTCStatusA
PUBLIC  RTCStatusB
PUBLIC  RTCStatusC
PUBLIC  RTCStatusD
PUBLIC  RTCReset
PUBLIC  RTCRAMMonth
PUBLIC  RTCRAMHours
PUBLIC  RTCRAMYear
PUBLIC  RTCRamFlag
PUBLIC  RTCStatusBit
;*AA*
Public mpeConfigReg0
Public mpeConfigReg1
Public mpeConfigReg2

PUBLIC  pCoprocessorState
PUBLIC  oCoprocessor

PUBLIC	cbLineTable
PUBLIC	mpiLinebSlot

%IF(%FS) THEN (
PUBLIC	saDataOs
PUBLIC	pSysTime

;* Local Disk Mirroring data definition
%IF(%Ldm) THEN (
PUBLIC pLdmData
PUBLIC prgLdmDiskInfo
)FI

)FI

%IF(%OS) THEN (
PUBLIC	pHeaderBuffer
)FI

DGroup	GROUP	Const, Data

Const	SEGMENT WORD PUBLIC 'Const'
Const	ENDS

Data	SEGMENT	WORD PUBLIC	'Data'

EXTRN rgOsTable:WORD

; public variables for support of generic NGen CTOS

			EVEN
; Following words are in fixed order. Applications get pointer to this structure.
NGenPortsStructure	Label WORD	; Symbol must exist even when not NGen
BeeperPortNGen			DW	0
ioCommCtlA				DW	0
ioCommDataA				DW	0
ioCommCtlB				DW	0
ioCommDataB				DW	0
modeWord8253			DW	0
baudRateCtrA			DW	0
baudRateCtrB			DW	0
OCW1_8259				DW	22H
OCW2_8259				DW	0A0H
cascadeOCW1_8259		DW	0
cascadeOCW2_8259		DW	0
extCtlReg				DW	0
earPort					DW	0
parityEnablePortNGen	DW	0
parityErrPort0NGen		DW	0
parityErrPort1NGen		DW	0
vidControl				DW	0
vid6845Addr				DW	0
vid6845Data				DW	0
commDmaAddr				DW	0
commDmaWrdCnt			DW	0
commDmaEar				DW	0
dmaMask					DW	0
dmaMode					DW	0
dmaCommand				DW	0
dmaBytePtrClr			DW	0
rdsrL					DW	0
rdsrH					DW	0
tdsrL					DW	0
tdsrH					DW	0
pcsarL					DW	0
pcsarH					DW	0
pcrl					DW	0
pcrH					DW	0
cPort					DW	0
stat					DW	0
timerCtl				DW	0
timerComm				DW	0
ClearRtcIntPort			DW	0
xINTR3Vector			DW	47H
processorType			DW	0
dmaEarEnable			DW	0
timeClockBaseAddr		DW	0
nonVolatileRamBaseAddr	DW	0
protectedModeEnabl		DW	0
fingerPort				DW	0
shCpuSpeed				DW	0
videoType				DW	0
rs232DmaAddr0			DW	0
rs232DmaWrdCnt0			DW	0
rs232DmaAddr1			DW	0
rs232DmaWrdCnt1			DW	0
rs232DmaAddr2			DW	0
rs232DmaWrdCnt2			DW	0
rs232DmaAddr3			DW	0
rs232DmaWrdCnt3			DW	0
rs232DmaCommand			DW	0
rs232DmaRequest			DW	0
rs232DmaMask			DW	0
rs232DmaMode			DW	0
rs232DmaBytePtrClr		DW	0
rs232DmaMstrClr			DW	0
rs232DmaMaskAll			DW	0
rs232DmaEar0			DW	0
rs232DmaEar1			DW	0
rs232DmaEar2			DW	0
rs232DmaEar3			DW	0
rs232DmaEarEnable		DW	0
ledDisplayPort			DW	0
ioCommCtlC				DW	0
ioCommDataC				DW	0
ioCommCtlD				DW	0
ioCommDataD				DW	0
baudRateCtrC			DW	0
baudRateCtrD			DW	0
hDiskDmaAddr			DW	0
hDiskDmaBytePtrClr		DW	0
hDiskDmaChan			DW	0
hDiskDmaWrdCnt			DW	0
hDiskDmaWrdCntHigh		DW	0
hDiskDmaEar				DW	0
hDiskDmaEarHigh			DW	0
hDiskDmaMask			DW	0
hDiskDmaMode			DW	0
floppyDmaAddr			DW	0
floppyDmaBytePtrClr		DW	0
floppyDmaChan			DW	0
floppyDmaWrdCnt			DW	0
floppyDmaWrdCntHigh		DW	0
floppyDmaEar			DW	0
floppyDmaEarHigh		DW	0
floppyDmaMask			DW	0
floppyDmaMode			DW	0
LptIntClear				DW	0
LptDmaBytePtrClr		DW	0
LptDmaAddr				DW	0
LptDmaEar				DW	0
LptDmaEarH				DW	0
LptDmaCount				DW	0
LptDmaCountH			DW	0
maskLptDmaChannel		DW	0
maskLptDmaEnable		DW	0
maskLptDmaDisable		DW	0
LptDmaCommand			DW	0
LptDmaMode				DW	0
LptDmaMask				DW	0
LptPortDirection		DW	0
ParLpPort				DW	0
ParInPort				DW	0
CommDmaEarHigh			DW  0
counter08254Ngen		DW	0
modeWord8254Ngen		DW	0
ModeWord8254RTC			DW	0
RTCCounter8254			DW	0
counter18254Ngen		DW  0
counter28254Ngen		DW	0
RTCmosAddressReg		DW  0
RTCmosDataReg			DW  0
RTCSecs					DW  0
RTCMins					DW  0
RTCHrs					DW  0
RTCDayOfWeek			DW  0
RTCDate					DW  0
RTCMonthOfYear			DW  0
RTCYear					DW  0
RTCStatusA				DW  0
RTCStatusB				DW  0
RTCStatusC				DW  0
RTCStatusD				DW  0
RTCReset				DW  0
RTCRAMMonth				DW  0
RTCRAMHours				DW  0
RTCRAMYear				DW  0
RTCRAMFlag				DW  0
RTCStatusBit			DW  0
mpeConfigReg0			DW  0 ;*AA*
mpeConfigReg1			DW  0 ;*AA*
mpeConfigReg2			DW  0 ;*AA*

			DW	(144 - ((. - nGenPortsStructure) / 2)) DUP (0)

; END Structure

%IF(NOT(%MF)) THEN (
floppyChkBdWordAddr		DW	0
						DW	0
mpbSlotiSlot			LABEL BYTE	;Unused if not MF
mpiFpbSlot				DW	0		;Unused if not MF
pFloppyChkBdBuffer		DD	0
pFloppyIoBuffer			DD	0

)FI
pIBusIDTable			DD	0
pSGBusIDTable			DD	0
pXBusIDTable			DD	0
pEBifIsrTable			DD	0
pEisaTable				DD	0

pCoprocessorState		DD	0
oCoprocessor			DW	0

oMemAvail			DW	%IF(%FS) THEN (0FFFFh) ELSE (OFFSET DGroup:rgOsTable)FI
saDataOs				DW	DGroup

$INCLUDE(:f1:vfEqu.idf)
PUBLIC  vf,pVf
pVf DD ?
vf 						DB svf DUP (0)

%IF (%OS) THEN (
PUBLIC	pScreenMap 
pScreenMap				DD	?
PUBLIC	sScreenMap
sScreenMap				DW	0

PUBLIC mask8259A
mask8259A				DW 	?

PUBLIC Ext8259_OCW2
Ext8259_OCW2			DW  214H

PUBLIC Ext8259_OCW1
Ext8259_OCW1			DW  215H

PUBLIC cascade8259A
cascade8259A			DW 	?

PUBLIC third8259A
third8259A				DW 	?
  
PUBLIC mAHighest
maHighest				DB 	?

PUBLIC mACascade
mACascade				DB 	?

PUBLIC bIntVectorBase, bIntVectorBaseCascade, bIntVectorBaseExternal
bIntVectorBase			DB	0
bIntVectorBaseCascade	DB	0
bIntVectorBaseExternal	DB	0

PUBLIC IntervalTimerSelect
IntervalTimerSelect		DW 	?

PUBLIC IntervalTimerStatus
IntervalTimerStatus		DW 	?

PUBLIC rateGeneratorSelect
rateGeneratorSelect		DW 	?

PUBLIC PITintervalCount 
PITintervalCount		DW	?

PUBLIC MaxWriteCount 
MaxWriteCount			DW	?

PUBLIC	fDbgLockedIn 
fDbgLockedIn			DB	0
)FI

%IF(%OS) THEN (

MiscData SEGMENT PUBLIC 'OEMSeg'
headerBuffer			DB 512 DUP (0)
MiscData ENDS

pheaderBuffer DD headerBuffer
)FI

%IF(NOT(%FS)) THEN (
PUBLIC cphFileCache, pCsbFileCache, pRgSdFileCache
cphFileCache			DD 0		; cache pool handle
pCsbFileCache			DD 0		; cache statistics block
pRgSdFileCache			DD 0		; cache memory table
PUBLIC wSysCtl
wSysCtl					DW 0E0h		; system control word
)FI

%IF(%FS) THEN (
%IF(%Ldm) THEN (
pLdmData DD 0
prgLdmDiskInfo DD 0
)FI
)FI

cbLineTable				DW	66
mpiLinebSlot			DB	66 DUP(?)

%IF(%FS) THEN (

PUBLIC Config,  osType, nPcb, nExchg, nMsgWait
PUBLIC nPTiming, nUcb, nParDesc
PUBLIC saSemiLowest, saSemiHighest, saTempLowest, saTempHighest, saEndMemory
PUBLIC hardwareType, fCommIop, fMulpar
PUBLIC nIob, nFcb, nFub
PUBLIC fLfsToMaster, vfAllowDirSlashes
; Next line dummy vars on non-Srp.
Public	bMySlot, fMasterFp

; System configuration block
; The following variables must be in order:

EVEN
Config LABEL WORD
wsType			DB ?
osType			DB 1	;Resident, not swapping
saSemiLowest	DW 0
saSemiHighest	DW 0
saTempLowest	DW 0
saTempHighest	DW 0
saEndMemory		DW 0
nPcb			DW ?
nExchg			DW ?
nMsgWait		DW ?
vfAllowDirSlashes	DB ?
fLfsToMaster	DB ?
nPTiming		DW ?
nIob			DW ?
nFcb			DW ?
nVhb			DW ?
nParDesc LABEL WORD
nUcb			DW ?
nFub			DW ?
hardwareType	DB 4
clusterConfig	DB ?
fNoFileSystem	DB ?
fCommIop		DB 0
fMulpar DB ?
fMasterFP		DB	0
bMasterFpCpuId		Db	?
bMySlot				Db	?
bMasterCpCpuId		Db	?

PUBLIC userNumLast, userNumClstrLast, nNetUsers, NetServerData
PUBLIC cbNodeName,NodeName
PUBLIC userNumNetMin,userNumNetMax
PUBLIC pRgRcMax, pBootBlock
PUBLIC userExchFirst
PUBLIC pRgWsAbortRq, pRgChgUserNumRq, pRgTerminationRq, pRgSwappingRq
PUBLIC nWsAbortRq, nChgUserNumRq, nTerminationRq, nSwappingRq
PUBLIC pAckOutBuf, pAckInBuf
PUBLIC prgoUcb

EVEN
; NetServerData: These variables are in a structure known by the CtNetServer.
; The NetServer calls InitNetServer (an OS common subroutine) to get a pointer
; to this structure
; ****NOTE **** This structure is known to CtNet and the Mouse and possible
; other system services. Don't insert data in the middle!!!
NetServerData LABEL WORD
pRgWsAbortRq  DD  0
nWsAbortRq  DW  0
pRgChgUserNumRq  DD  0
nChgUserNumRq  DW  0
pRgTerminationRq  DD  0
nTerminationRq  DW  0
userNumLast  DW  ?
userNumClstrLast  DW  ?
nNetUsers  DW  ?
pRgSwappingRq DD 0
nSwappingRq DW  0
exchNetServer DW 0
cbNodeName DB 0
nodeName DB 12 DUP(0)
pRgPrgNetRouting DD ?
pRgRcMax DD ?
obsoleteUnused DD ?	; was bitMapExchsSave
userExchFirst DW ?
pSysTime DD ?
pBootBlock DD ?
pRgOUcb DD ?
pRgOExUcb DD ?
userNumNetMin DW 0	; Set by board where Net installed.
userNumNetMax DW 0
pDmaBuf			DD	0
pAckOutBuf		DD	0
pAckInBuf		DD	0
)FI %' Fs

Data	ENDS

%if (%os) then (
DGroup	GROUP	Const, Data, vStatsSeg
;
; vStats
;
vStatsSeg		SEGMENT WORD PUBLIC 'Const'

PUBLIC vStats, statSpecHeap, statLoaderHeap, statHdHeap, nameStats
PUBLIC statTermHeap, statQuietHeap

vstats LABEL WORD
statTop EQU THIS BYTE

cbStats  DW 0
wVersion DW 1

; see intraSegHeap for statsType. statstypes is rounded up to paragraph.
statSpecHeap 		DW 8 DUP (0) 
statLoaderHeap		DW 8 DUP (0)
statHdHeap			DW 8 DUP (0)
statTermHeap		DW 8 DUP (0)
statQuietHeap		DW 8 DUP (0)

nameStats 			DB 30h DUP (0)


statEnd EQU THIS BYTE
ORG OFFSET vstats
DW statEnd-statTop
vStatsSeg		ENDS
)fi

%if (%os) then (
BufSeg SEGMENT WORD PUBLIC 'OemSeg'
swapBuff DB 512 DUP(?)
logBuff  DB 600 DUP(?) ; change here and ctosGlobal.edf (sLogBuff).
rgVectorDirty DW 256 DUP(0)
BufSeg ENDS
Data SEGMENT WORD PUBLIC	'Data'
PUBLIC pSwapBuff
pSwapBuff DD swapBuff
PUBLIC pLogBuff
pLogBuff DD logBuff
PUBLIC prgVectorDirty
prgVectorDirty DD rgVectorDirty
Data ENDS
)fi

%if (%os) then (
SdbSeg SEGMENT WORD PUBLIC 'Memory' 	; class MEMORY is init data
Sdb 	DB 144 DUP(0)
rgSdb 	DB (144*5) DUP(0)
SdbSeg ENDS
Data SEGMENT WORD PUBLIC 'Data'
PUBLIC pSdb, prgSdb
pSdb 	DD Sdb
prgSdb	DD rgSdb
Data ENDS
)fi

END
;
; LOG
;8/25/86 by JA, Created from Kernel_all.asm for FS.
;11/14/86 by JA, created Data_MF.
;11/21/86 by JA, oMemAvail -> rgOsTable.
;12/9/86 by JA, remove floppyIoByteAddr
; CTOS 2.3
;1/26/88 by JA, remove pStat,pDiskStat.
;2/9/88 by JM, add vf.
;2/15/88 by JA, update ports struc.
;2/18/88 by JA, ports for channel C,D.
;2/26/88 by JA, oMemAvail=0FFFFh if FS so AllocM can set it right.
;5/06/88 by SAR, CachePoolDirStruct
;6/27/88 by PGJ, expand nGenPortsStructure
;9/6/88 by JM, add mpiModuleMemBlock to _osmf.
;11/8/88 by KH, mACascade and mAHighest are var bytes for DO_EOI
;11/28/88 by KH, add intervalTimerSelect and rateGeneratorSelect
;12/6/88 by KH, add PITintervalCount and MaxWriteCount
;12/9/88 by JA, add third8259A
;01/25/89 by MTR, + cphFileCache, nSdFileCache, pRgSdFileCache.
;				  - cachePoolDirStruct, CachePoolSignature.
;02/21/89 by AT, headerBuffer.
;03/24/89 by MTR, Merge 2.3
;05/04/89 by RLM, Make portstructure for lpt's.
;02/08/90 by AT, Removed fReboot, not needed in FS.
;02/21/90 by DR,  Moved pCoprocessorState and oCoprocessor from RmosSwitch
;02/22/90 by JC	Added Name Space modifications from BTOS
;02/27/90 by JA, removed daiLocal.
;06/20/90 by RR, merged LDM code (search for LDM switch)
;07/21/90 by MTR, LDM pointers & NmbHeap now initialized in Initfs
;07/23/90 by GWH, added Ext8259_OCW2/Ext8259_OCW1 for SuperGen
;08/15/90 by JC, added counter08254Ngen, modeWord8254Ngen to NgenPortStructure
;08/29/90 by JA, add Config,NetServerData.  Vf for everybody.
;09/10/90 by JA, add nParDesc back.
;09/14/90 by AT,  add pSGBusIdTable.
;10/15/90 by AT,  NGenPortsStructure disk changes.  This changed the order of
;                 some of the fields, but they had never been documented.
;10/24/90 by GWH, Added ModeWord8254RTC, RTCCounter8254.
;2/18/91 by  JA,  nmb in sysgen.
;02/19/91 by GWH, Added CommdmaEarHigh, moved 8254 stuff to NgenPortsStructure.
;03/15/91 by AT,  cbLineTable is 4 if not MF (dummy plus 1 line).
;04/04/91 by AT,  add bIntVectorBase*.
;04/10/91 by GWH, enlarged ngenportstructure, moved calendar/clock ports here
;				  for 386i and SG5000.				
;04/25/91 by GWH/JR/MTR/AT, wSysCtl
;10/15/92 by JF, remove PUBLICS for clusterConfig and wsType.  These must be
;		based on pSysConfig because they can change when Stnd converts.
;11/06/92 by KK   add pEisaTable for storing EISA configuration information.
;12/02/92 by KK   add pEBifIsrTable for EBif Service.
;01/23/93 by JA   remote mpiModuleMemBlock; add wSysCtl for MF (Srp).
;02/27/93 by JM	  headerBuffer out of dgroup.
;03/05/93 by RA   Added mpeConfigReg(s) in ngenPortsStructure.
;03/30/93 by JA   Remote cbLineTable, mpiLinebSlot to Data_Mstr.
;03/30/93 by JA   Recant above; everybody gets it here now.
;05/13/93 by JM   move swapBuff out of dgroup
;05/14/93 by JM   move logbuff, rgVectorDirty out of dgroup