; 2/05/81 RH
; 1/25/82 RH, allow nested 7201 interrupt on AWS
; 1/1/83  NGEN t1 by MO
; 2/09/83 JA use PIT on AWS
; 8/17/83 JA folded all versions
; 1/3/84 JA removed MOber KBD Baud Rate Kludge,
;	define InSub, OutSub, InPlm, OutPlm for NGEN
; 1/29/84 MO add EOI support for T2 and 8086 NGen
;	CTOS 10.0
; 5/25/84 JA inc Asib.ScheduleTime
; 7/11/84 JA VP-Wakeup sched every 2 seconds
; 2/15/85 JA don't do debugger check if Vp
; 4/2/85 MO GWS
; 4/25/85 JA Vp timer limit 0FF00h. jl->jb jg->ja
; 6/16/85 JA don't dec fWakeupSched - check for <> 0
; 2/27/86 JM Vp timer limit 0FE00 so time+prio+1 cant be zero.
; 4/10/86 DR Remove ngen vp cs:ip checking (lowerBoundAddr)
; 4/15/86  FW support for NewGen.
; 4/24/86 JM Add SetMode3DmaCount, Sched's wakeup timer configurable.
; 5/9/86 JM Sched's wakeup timer defaults to never.
; 5/27/86 JM sched timer limit 0F800h
; 9/27/86 DR CTOS II 2.0 merge
; 11/15/86 DR do not load up es for PIT if user swapped (may be not present)
; 12/18/86 RLM/JA make cluster timer double speed
; 2/9/87 FW Add "JMP .+2" to SetMode3DmaCount code.
; 10/6/87 JA  Asib,Arib now selector-based.
; 11/9/87 merge 9.9 -
 ; 6/08/85 MO add CWS changes for 9.5
 ; -- 9.7 --
 ; 2/27/86 FW add JMP $+2 to flush pipe between consecutive IO ops.
 ; 9/3/86 GVW fix InPlm for CP003 test.
; 1/11/87 by JA/RLM Merge Srp 1.4 version.
; CTOS 2.3
; 1/29/88 JA public InPlm,OutPlm for MF.
; 2/3/88 JA add WatchDog,PollEcc calls.
; 2/588 JA public InputPlm,OutputPlm for MF.
; 2/17/88 JA use vf_f186.  Remove Ngen checks.
; 7/1/88 JM Handle50MsInt callable from TpPoller.
; 7/18/88 PGJ add In32Bit, Out32Bit
; 8/4/88 JA add MF ctosp front panel code.
; 8/20/88 JA Make RTCInterrupt mediated in ctosp.
; 9/1/88 AT mask userNum slot when indexing ContextStatus.
; 09/10/88 MTR  rgPTimingSwap--TRBs continue to age if owner swapped-out,
;				upon expiration SendP(,pRqTiming) may cause swap-in
; 10/10/88 JM Srp RTCInterrupt is now mediated.
; 10/21/88 KH Merge in 8 bit I/O for PS2 - InputPlmByte, OutPlmByte
; 11/4/88 JA All MF call PollEcc.
; 11/28/88 JA MF ctosp (GP) use sysTime.ticks.
; 12/05/88 KH PS2 changes. PS2 uses Motorola MC146818 RTC/CmosRAM, not 8254
;             Also, use vf instead of processortype
; 4/5/89 JA GP use cMsToNextSysTimeTick in RtcInterrupt.
; 7/17/89 JA NGen+MF+PS2 use deltaTimeNext50Ms in RtcInterrupt.
;		Also remove PollEcc.
; 09/19/89 MTR  Swap-in upon timer expiration only for 'DZ' (Doze) timer
; 10/17/89 MTR  rg*Timing* now sparse instead of compact (interrupt latency)
; 10/27/89 MTR  leave non-DZ swapped-out timers alone, streamline timer code
; 02/08/90  AT  fReboot,fEnableCluster=TRUE and panel=20 when fInitExit FALSE.
; 02/13/90  AT  Checking fInitExit must be done every 100 ms, not every second.
; 09/05/90  SG  Add b38lcw support.
; 11/15/90 GWH  Moved RTC to Ext. 8254 on SG-5000
; 11/29/90 MTR  DisplayInfoOnLeds unconditional
; 08/08/91 FW   PCAT
; 01/21/92 JM   update ginfoseg.msec every 50ms.
; 03/20/92 JM	don't dispatch TRBs when cEvents wraps.
; 03/26/92 JM   remove 03/20/92, instead don't dispatch when trb.respExch = 0.
;				don't disable NMIs on PC.
; 04/24/92  JA  Srp version (Pc, Comarch)
; 06/08/92 MTR  Time slice off ContextState
; 11/16/92 JWF  Make ContextStatus and ContextState based
; 02/02/93  JA  Srp fGotTick, c50MsMissed.
; 02/23/93  JA  Srp c50MsPassed instead.
; 05/17/93  JA  Watchdog into RtcInterrupt (not at process level)
;				Also remove MF, 186, Vp, ctosp.  FIx maskSrpPoll for PC Srp.
; 06/03/93  JA  update  GInfo by 100ms so works on PC.
;				Hurry watchdog timer on PC.
; 06/17/93  JM  update sysTime atomically
; 06/26/93  JM  nProcTick is not in dgroup, use pnProcTick.
;				update nProcTick at interrupt level.
; 07/27/93  JA  use pProcStat instead pnProcTick.
;
%IF (not(%*Isdef(%CTOSv))) THEN (%Define(CTOSv)(0))FI
%IF (not(%*Isdef(%Srp))) THEN (%Define(Srp)(0))FI
%SET(FS,0)

%IF (%Srp) THEN (
$Include(:f1:Cdt.Mdf)
)FI
tyInfoHeartbeat EQU 0

ticks		EQU	0
hundredMsec	EQU	1
seconds		EQU	2
dayTimes2	EQU	4
cksm		EQU	6
magicT		EQU	1234
secondsInHalfDay	EQU	43200
;
timeInterval	EQU	0
resetValue	EQU	2
cEvents		EQU	4
respExch	EQU	6
signature	EQU	8	; Signature distinguishes "special" timers:
				;    'RM' secret double time timer for cluster
				;    'DZ' timer that runs even if swapped-out

RTCmosAddressReg	EQU 070h  
bitSwapped	EQU	1

sRqTiming	EQU 12

gInfoSeg_msec EQU 4

EXTRN	WriteScat: FAR
EXTRN	KPSend: FAR, Crash: FAR
EXTRN	KSendP: FAR
%IF(%Srp)THEN(
extrn KWait: FAR
extrn ExchSync: FAR
extrn WatchDog: FAR
)FI

extrn DisplayInfoOnLEDs: FAR


PUBLIC	InSub, OutSub
PUBLIC	fLastIntMed

PUBLIC  cTickWakeup

PUBLIC	RTCInterrupt, fDbgSwappedIn
PUBLIC	InPlm, OutPlm, InputPlm, OutputPlm, InputPlmByte, OutputPlmByte
PUBLIC	In32Bit, Out32Bit


Data	SEGMENT	PUBLIC	'Data'
DGroup	Group	Data

EXTRN	sysTime: WORD, oRgPTiming: WORD, nTicks: BYTE
EXTRN	saSemiLowest: WORD, saTempHighest: WORD
EXTRN	OCW2_8259: WORD, cascadeOCW2_8259: WORD
EXTRN	ClearRtcIntPort: WORD
EXTRN	fEnableCluster: BYTE
EXTRN	fInitExit: BYTE
EXTRN	fReboot: BYTE
EXTRN	prgContextState: DWORD
EXTRN	prgContextStatus: DWORD, oRgPTimingUserNum: WORD, nRqTiming: WORD
EXTRN	pRgPTimingSwap: DWORD
EXTRN	oPcbRun: WORD, Runq: WORD
EXTRN	fTimeSlice: BYTE, timeSliceLB: BYTE, timeSliceHB: BYTE
EXTRN	rgsgAsib: WORD, nParDesc: WORD, fWakeupSched: BYTE, exchSched: WORD

%IF(%Srp)THEN(
Extrn	iMySlot:Byte
Extrn	mpiSlotpCdt: Dword
sPcb	Equ 18
Extrn	orgPcb  : Word
Extrn	pProcStat : dword
)FI

pcbPriority		EQU	3
pcbUserNum		EQU	14
bitTimeSlice	EQU	80h		; contextState bit

%if(%ctosv) then(
EXTRN 	pGinfoSeg: DWORD
)fi


PUBLIC	deltaTimeRtcInterrupt, deltaTime50Ms, cIntsPerTick
deltaTimeRtcInterrupt DW 5
deltaTime50Ms DW 50
deltaTimeNext50Ms DW 50
cIntsPerTick DW 2
cIntsToNextTick DW 2
bSignal DB 7fh   ;Debug RTC on PS2/SuperGen

fDbgSwappedIn	DB	0
f50MSInt	DB	0		; true everyother cycle
						; to keep RTCint's at 100ms
EVEN
PUBLIC c50MsPassed
c50MsPassed	DW 0

PUBLIC c50MsTo1Sec
c50MsTo1Sec DW 20

fLastIntMed		DB	0
timeSliceMax DB 0F8h
lTimeSliceLimit EQU 015BCh
lTimeSliceScat EQU 596

PUBLIC maskSrpPoll
maskSrpPoll		DW	0AA4Ch
maskSrpPoll2	DW	09691h
maskSrpPoll3	DW	0868Ch
maskSrpPoll4	DW	08D8Ch
maskSrpPoll5	DW	0919Ah
maskSrpPoll6	DW	0D28Bh

;ctick2sec			db	0
cTickWakeup			dw  0FFFFh ;0FFFFh -> never send wakeup msg to Sched
cTickWakeupTemp		dw  0

pRqTiming			DD	?

EXTRN	vf: byte
$Include(:f1:VfEqu.idf)

PUBLIC pbLock
pbLock	DD	bLock

%IF (%Srp) THEN (
exchClockPro DW 0
pMsg    	 DD 0
)FI

Data	ENDS

%Clock	SEGMENT	PUBLIC	'CODE'
ASSUME	CS: %Clock, DS: DGroup


PUBLIC Handle50MsInt
Handle50MsInt PROC FAR
;
; called from RtcInterrupt every 50 ms.
;
;  Some features run every 100ms.  Use f50MSInt as flip-flop.
	XOR	f50MSInt,0FFh
	JZ	Do100msInt
	JMP	ServiceRtcClients 

Do100msInt:
%IF (%ctosv) THEN (
; OS/2 emulation - update ginfoSeg.msec 
	LES BX, pGInfoSeg
	ADD ES: DWORD PTR [BX+gInfoSeg_msec], 100
)FI
	mov AL, nTicks			; Sync ticks with 100ms
	mov BYTE PTR SysTime, AL

;	Rotate pcbs of same priority on run q.
	cmp WORD PTR sysTime+4,lTimeSliceLimit
	jne @22
	inc WORD PTR sysTime+dayTimes2
	dec WORD PTR sysTime+cksm
	lea bx, timeSliceMax
	push lTimeSliceScat
	push ds
	push bx
	call WriteScat
	lea bx, timeSliceMax
	mov cx, 6
@21:not word ptr [bx]
	inc bx
	inc bx
	loop @21
@22:
	mov	AL, fTimeSlice
	or	AL, AL
	jz	@10
	cli
	lea	BX, Runq
@16:	mov	DI, BX
	mov	BX, WORD PTR [BX]
	or	BX, BX
	jz	@10
	mov	AL, [BX+pcbPriority]
	mov	SI, [BX+pcbUserNum]
	and	SI, 3FFh
	ADD SI,prgcontextState
	MOV ES,prgcontextState+2
	test BYTE PTR ES:[SI], bitTimeSlice
	jnz	@69
	cmp	AL, TimeSliceLB
	jb	@16
	cmp	AL, TimeSliceHB
	ja	@16
@69:mov	SI, BX
	push	DI
	push	BX
	jmp	@13
@12:	mov	DI, BX
	mov	BX, SI
@13:	mov	SI, WORD PTR [SI]
	or	SI, SI
	jz	@14
	mov	CL, BYTE PTR [SI+3]
	cmp	AL, CL
	je	@12
@14:	pop	AX
	cmp	AX, BX
	je	@17
	cmp	AX, DI
	je	@15
	mov	DI, AX
	mov	AX, WORD PTR [DI]
	mov	WORD PTR [DI], SI
	mov	WORD PTR [BX], DI
	pop	DI
	mov	WORD PTR [DI], AX
	jmp	@10
@15:	mov	WORD PTR [DI], SI
	mov	WORD PTR [BX], DI
	pop	SI
	mov	WORD PTR [SI], BX
	jmp	@10

@17:	pop	AX

@10:	sti

; Do the following more often than every second because the program that reset
; LL memory may expect the Front Panel to be correct immediately (e.g. Batch).

; Do we need to set fReboot and fEnableCluster ?
	test fReboot, 1
	jnz  @01                   ; Already done
	test fInitExit, 1
	jnz  @01                   ; Not yet
	mov  fReboot, 0FFh         ; Reboot if crash
	mov  fEnableCluster, 0FFh  ; Make sure polling is enabled
@01:

	lea	BX, sysTime
	inc	BYTE PTR [BX+hundredMsec]
	cmp	BYTE PTR [BX+hundredMsec], 10
	jae	TickSec
	jmp	ServiceRtcClients
TickSec:
;------start critical section
	cli
	mov	AX, WORD PTR [BX+seconds]
	add	AX, WORD PTR [BX+dayTimes2]
	add	AX, WORD PTR [BX+cksm]
	cmp	AX, magicT
	jz	@2
	mov	WORD PTR [BX+seconds], 0
	mov	WORD PTR [BX+dayTimes2], 0
@2:
	mov	BYTE PTR [BX+hundredMsec], 0
	inc	WORD PTR [BX+seconds]
	cmp	WORD PTR [BX+seconds], secondsInHalfDay
	jb	@3
	mov	WORD PTR [BX+seconds], 0
	inc	WORD PTR [BX+dayTimes2]
@3:
	mov	AX, magicT
	sub	AX, WORD PTR [BX+seconds]
	sub	AX, WORD PTR [BX+dayTimes2]
	mov	WORD PTR [BX+cksm], AX
	sti
;------end critical section

; Toggle led heartbeat.
	mov ax, tyInfoHeartbeat
	push ax
	mov ax, 0
	push ax
	call DisplayInfoOnLEDs    ;call DisplayInfoOnLEDs(tyInfoHeartbeat, 0)

ServiceRtcClients:
	xor	SI, SI
	push	SI				;cRqTiming

DoTiming:
	pop	AX				;cRqTiming
	cmp	AX, nRqTiming
	jb	NextTrb

;RtcXit:
	ret

NextTrb:
	mov	BX, oRgPTiming
	mov	DX, WORD PTR [BX][SI+2]
	or	DX, DX
	jnz	ProcessTrb
	add	SI, 4
	jmp	SHORT NextTrb

ProcessTrb:
	inc	AX
	push	AX				;cRqTiming
	mov	DI, WORD PTR [BX][SI]		;DX:DI=pRqTiming

; save pointer for later Send
	mov	WORD PTR pRqTiming, DI
	mov	WORD PTR pRqTiming+2, DX

; Check if timer user is swapped
; IF ContextStatus(rgPTimingUserNum(i)).bDontSwap&bitSwapped <> 0 THEN
	shr	SI, 1				;word index
	mov	BX, WORD PTR oRgPTimingUserNum
	mov	BX, WORD PTR [BX][SI]		;userNum owning the trb
	and	BX, 3FFh			;mask slot for indexing
	ADD BX,prgContextStatus
	MOV ES,prgContextStatus+2
	shl	SI, 1
	add	SI, 4
	test	BYTE PTR ES:[BX], bitSwapped
	; If rqTiming swapped and signature is 'DZ', use rqTimingSwap instead
	jz	NotTimingSwap			;DX:DI=pRqTiming (not swapped)
	mov	AX, SI
	sub	AX, 4
	shr	AX, 2				;ordinal
	mov	CX, sRqTiming
	mul	CX
	les	DI, pRgPTimingSwap
	add	DI, AX				;DX:DI=pRqTimingSwap (swapped)
	cmp	WORD PTR ES: [DI+signature], 'DZ'
	jne	DoTiming			;skip: swapped but not 'DZ'
	jmp	SHORT CheckCounter		;faster than double ES load!
NotTimingSwap:
	mov	ES, DX

CheckCounter:
	cmp	WORD PTR ES: [DI], 0
	je	DoTiming			;skip: counter 0

	test	f50MSInt, 0FFh			;only do every other int
	jz	DoTime2
	CMP	WORD PTR ES:[DI+signature], 'RM';if cluster do double time
	jne	DoTiming

DoTime2:
	dec	WORD PTR ES: [DI]		;decrement counter
	jnz	DoTiming			;skip: counter not 0
	mov	AX, ES: [DI+resetValue]
	mov	ES: [DI], AX			;reload counter
	cmp	WORD PTR ES: [DI+cEvents], 0
	je	SendTrbHome
	inc WORD PTR ES: [DI+cEvents]
	jmp	DoTiming			;done with this trb

SendTrbHome:
	inc	WORD PTR ES: [DI+cEvents]
	CMP     WORD PTR ES: [DI+respExch], 0
	JE      NoDispatch
	push	SI				;save

	push	WORD PTR ES: [DI+respExch]
; Use saved pointer as ES:DI may be pRqTimingSwap
	push	WORD PTR pRqTiming+2
	push	WORD PTR pRqTiming
	call	KSendP

	pop	SI				;restore
NoDispatch:
	jmp	DoTiming			;done with this trb

Handle50MsInt ENDP



RTCInterrupt	PROC	FAR

	test	vf_fpcAT,1
	jnz		@b38orPCAT
	test	vf_fb38lcw,1
	jz		@NotB38LCW
@b38orPCAT:
	mov	DX, RTCmosAddressReg
	mov	AL, 0Ch  ; RTCmosStatusC
	out DX, AL
	jmp $+2
	mov	DX, ClearRtcIntPort
	IN	DX, AL

; on B38LCW, RTCInterrupt every 100ms - set f50msInt toggle so
; Handle50msInt treats this one as the 2nd 50ms interrupt.
	mov f50msInt, 0FFh
	DEC  c50MsTo1Sec           ; Really 62.5ms so hurry up watchdog timer.
	jmp short UpdateSysTime    ; process RTC int (62.5ms)

@NotB38LCW:	
	mov	DX, ClearRtcIntPort
	test	vf_fNewgen, 1
	jz		@NotNewGen              ;NewGen
	in al,dx                        ;NewGen (Input clears interrupt)
	jmp Short UpdateSysTime         ;NewGen
@NotNewGen:                         
	out	DX, AL						; Write Garbage to clear port.

UpdateSysTime:
; Time for a tick?
	dec	cIntsToNextTick
	jz	TickDec
TickDone:

; Time for 50ms real time clock processing?
	mov ax, deltaTimeRtcInterrupt
	sub deltaTimeNext50Ms, ax
	jle Is50MsInterval
	ret

; Update sysTime.ticks so it looks like 40hz.
TickDec:
	mov ax,cIntsPerTick
	mov cIntsToNextTick, ax
; Count sysTime.ticks down, if 0 reset to nTicks.
	dec	BYTE PTR SysTime
	jnz TickDone
	mov AL, nTicks
	mov BYTE PTR SysTime, AL
	jmp short TickDone

; Process 50ms real time clock.
Is50MsInterval:
	mov ax, deltaTime50Ms
	add deltaTimeNext50Ms, ax
%IF (%Srp) THEN (
	DEC  c50MsTo1Sec
	JGE  RTCSend
; Poll all cpu boards. Take action if any board quit responding.
; Non-masterfp poll master fp, crash if it died.
	CALL Watchdog
	MOV  c50MsTo1Sec, 20
RTCSend:
; do Handle50msInt at process level - reduces latency on GP where RTC int
; is highest priority while keeping time of day correct
	INC  c50MsPassed
	CMP  c50MsPassed, 1
	JNE  RTCRet

; update statistics: ticks per pcb 
	mov	ax, oPcbRun
	sub	ax, oRgPcb
	xor	dx, dx
	mov cx, sPcb
	div	cx
	mov	si, ax
	shl	si, 1
	les bx, pProcStat
	inc	es:word ptr [bx][si]

	MOV  CX, WORD PTR exchClockPro	; not initialize until clockPro runs
	JCXZ RTCRet
	PUSH CX
	PUSH 0
	PUSH 0
	CALL KPSend
RTCRet:
	RET
)ELSE (
	jmp Handle50msInt
)FI


RTCInterrupt	ENDP

%IF (%Srp) THEN (
; on the GP, most of the RTC work is done here at process level to reduce 
; latency. The RTC is highest priority int on GP.
PUBLIC ClockPro
ClockPro PROC FAR
	PUSH BP
	MOV  BP, SP
	PUSH DS
	LEA  AX, exchClockPro
	PUSH AX
	CALL ExchSync
ClockProLoop:
	CALL Handle50msInt
	LOCK DEC c50MsPassed
	JNZ  ClockProLoop
	PUSH WORD PTR exchClockPro
	LEA  AX, pMsg
	PUSH DS
	PUSH AX
	CALL KWait
	JMP  SHORT ClockProLoop
; keep linker happy
	POP  BP
	RET
ClockPro ENDP
) FI


InputPlm PROC FAR
	push bp
	mov bp,sp
	mov dx,[bp+6]
	in ax,dx
	pop bp
	ret 2
InputPlm ENDP

InputPlmByte PROC FAR
	push bp
	mov bp,sp
	mov dx,[bp+6]
	in al,dx
	pop bp
	ret 2
InputPlmByte ENDP

In32Bit		PROC FAR
			PUSH	BP
			MOV		BP,SP
			MOV		DX,[BP+6]
			IN		EAX,DX
			MOV		EDX,EAX
			SHR		EDX,16
			POP		BP
			RET		2
In32Bit		ENDP

OutputPlm PROC FAR
	push bp
	mov bp,sp
	mov dx,[bp+8]
	mov ax,[bp+6]
	out dx,ax
	pop bp
	ret 4
OutputPlm ENDP

OutputPlmByte PROC FAR
	push bp
	mov bp,sp
	mov dx,[bp+8]
	mov ax,[bp+6]
	out dx,al
	pop bp
	ret 4
OutputPlmByte ENDP

Out32Bit	PROC FAR
			PUSH	BP
			MOV		BP,SP
			MOV		DX,[BP+10]
			MOV		EAX,[BP+6]
			OUT		DX,EAX
			POP		BP
			RET		6
Out32Bit	ENDP

;	Routines which handle 186 Internal timer registers.

bitChange	EQU	4
bitStart	EQU	2

InPlm	PROC	FAR
push bp
mov bp,sp
mov dx,[bp+6]

;This label is used to check whether a 386 processor is present.
;On the 386 the lock in instruction causes an illegal opcode exception.
;The handler (in kernel_all) patches the lock to a nop.
bLock LABEL BYTE
lock in ax,dx

pop bp
ret 2
InPlm	ENDP


OutPlm	PROC	FAR
	push bp
	mov bp,sp

;   Not 80186 cpu
;   Do what we were called to do.
	mov dx,[bp+8]
	mov ax,[bp+6]
	out dx,ax
	pop bp
	ret 4

OutPlm	ENDP



InSub	PROC	FAR

	IN	AX, DX
	RET

InSub	ENDP


OutSub	PROC	FAR
;	DOES NOT PRESERVE AX or DX!

	out dx,ax
	RET

OutSub	ENDP


%Clock	ENDS
