/***
*sys\wait.h - defines structure used by wait() and waitpid()
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structure used by the wait() and waitpid() routines.
*	[POSIX]
*
****/

#if !defined(_SYS_WAIT_DEFINED)

#define _SYS_WAIT_DEFINED

#include <limits.h>
#include <sys/types.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


#define WNOHANG   1
#define WUNTRACED 2
#define WSTOPPED  0x7F

#define WSHIFT ((sizeof(int) - sizeof(char)) * CHAR_BIT)

#define WIFEXITED(stat_val)    (((stat_val) & UCHAR_MAX) == 0)
#define WEXITSTATUS(stat_val)  ((stat_val) >> WSHIFT & UCHAR_MAX)
#define WIFSTOPPED(stat_val)   (((stat_val) & UCHAR_MAX) == WSTOPPED)
#define WSTOPSIG(stat_val)     ((stat_val) >> WSHIFT & UCHAR_MAX)
#define WIFSIGNALED(stat_val)  (!WIFEXITED(stat_val) && !WIFSTOPPED(stat_val))
#define WTERMSIG(stat_val)     ((stat_val) & UCHAR_MAX)


/* function prototypes */

extern pid_t _FAR_ _cdecl wait(signed int _FAR_ *);
extern pid_t _FAR_ _cdecl waitpid(pid_t, signed int _FAR_ *, signed int);

#endif /* !_SYS_WAIT_DEFINED */
