/***
*stdio.h - definitions/declarations for standard I/O routines
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structures, values, macros, and functions
*	used by the level 2 I/O ("standard I/O") routines.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_STDIO_DEFINED)

#define _STDIO_DEFINED

#include <stdarg.h>
#include <stddef.h>
#include <limits.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* buffered I/O macros */

#define BUFSIZ	512
#if defined(_MT)
#define _NFILE	40
#elif !defined(_POSIX_SOURCE)
#define _NFILE	20
#else
#define _NFILE	OPEN_MAX
#endif
#define EOF	(-1)

struct _iobuf {
#if !defined(_POSIX_SOURCE)
	char _FAR_ *_ptr;
	signed int _cnt;
	char _FAR_ *_base;
	char  _flag;
	char  _file;
#else /* _POSIX_SOURCE */
	unsigned char _FAR_ *_ptr;
	signed int _cnt;
	unsigned char _FAR_ *_base;
	signed short _flag;
	signed int _fd;
	signed int _bufsize;
#endif /* _POSIX_SOURCE */
	};
typedef struct _iobuf FILE;


/* P_tmpnam: Directory where temporary files may be created.
 * L_tmpnam size =  size of P_tmpdir
 *	+ 1 (in case P_tmpdir does not end in "\\")
 *	+ 6 (for the temp number string)
 *	+ 1 (for the null terminator)
 */

#if !defined(_POSIX_SOURCE)
#define P_tmpdir "[Scr]<$>"
#define L_tmpnam sizeof(P_tmpdir)+8
#else /* _POSIX_SOURCE */
#define P_tmpdir "/tmp"
#define L_tmpnam sizeof(P_tmpdir)+5
#define L_cuserid 14
#define L_ctermid 32
#endif /* _POSIX_SOURCE */


/* fseek constants */

#define SEEK_CUR 1
#define SEEK_END 2
#define SEEK_SET 0


/* minimum guaranteed filename length, open file count, and unique
 * tmpnam filenames.
 */

#if !defined(_POSIX_SOURCE)
#define FILENAME_MAX 63
#define FOPEN_MAX 20
#define SYS_OPEN 20
#define TMP_MAX 32767
#else /* _POSIX_SOURCE */
#define FILENAME_MAX PATH_MAX
#define TMP_MAX 1000
#endif /* _POSIX_SOURCE */


/* declare _iob[] array */

#if defined(_DLL)
extern FILE _FAR_ _cdecl _iob[];
#else
extern FILE _near _cdecl _iob[];
#endif


/* define file position type */

typedef signed long fpos_t;


/* standard file pointers */

#define stdin  (&_iob[0])
#define stdout (&_iob[1])
#define stderr (&_iob[2])
#if !defined(_POSIX_SOURCE)
#define stdaux (&_iob[3])
#define stdprn (&_iob[4])
#endif


#if !defined(_POSIX_SOURCE)
#define _IOREAD 	0x01
#define _IOWRT		0x02

#define _IOFBF		0x0
#define _IOLBF		0x40
#define _IONBF		0x04

#define _IOMYBUF	0x08
#define _IOEOF		0x10
#define _IOERR		0x20
#define _IOSTRG 	0x40
#define _IORW		0x80
#else /* _POSIX_SOURCE */
#define _IOFBUF		0x0001
#define _IOLBUF		0x0002
#define _IONBUF		0x0004

#define _BUFFERED	0x0001
#define _READING	0x0002
#define _WRITING	0x0004
#define _APPENDING	0x0008
#define _END_OF_FILE	0x0010
#define _ERROR		0x0020
#define _FORMATTED_TEXT	0x0040
#define _UNINITIALIZED	0x0080
#define _SETBUF_BUFFER	0x0100
#define _TEMP_FILE	0x0200
#define _CTRL_Z		0x0400
#define _READ_LAST	0x0800
#define _TTY		0x1000
#define _PROCESS	0x2000
#define _LINE_BUFFERED	0x4000
#endif /* _POSIX_SOURCE */


/* function prototypes */

#if !defined(_POSIX_SOURCE)
extern signed int   _FAR_ _cdecl _filbuf(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl _filbuff(FILE _FAR_ *); /* _CTOS */
extern signed int   _FAR_ _cdecl _flsbuf(signed int, FILE _FAR_ *);
extern FILE _FAR_ * _FAR_ _cdecl _fsopen(const char _FAR_ *,
	const char _FAR_ *, signed int);
extern signed int   _FAR_ _cdecl _pclose(FILE _FAR_ *);
extern FILE _FAR_ * _FAR_ _cdecl _popen(const char _FAR_ *,
	const char _FAR_ *);
extern signed int   _FAR_ _cdecl fcloseall(void);
extern signed int   _FAR_ _cdecl flushall(void);
extern signed int   _FAR_ _cdecl getw(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl putw(signed int, FILE _FAR_ *);
extern signed int   _FAR_ _cdecl rmtmp(void);
extern char _FAR_ * _FAR_ _cdecl tempnam(char _FAR_ *, char _FAR_ *);
#else /* _POSIX_SOURCE */
extern signed int   _FAR_ _cdecl _fillbuf(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl _flsbuf(signed int, FILE _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl ecvt(double, signed int, signed int _FAR_ *,
	signed int _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl fcvt(double, signed int, signed int _FAR_ *,
	signed int _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl gcvt(double, signed int, char _FAR_ *);
extern signed int   _FAR_ _cdecl pclose(FILE _FAR_ *);
extern FILE _FAR_ * _FAR_ _cdecl popen(const char _FAR_ *,
	const char _FAR_ *);
#endif /* _POSIX_SOURCE */
extern void         _FAR_ _cdecl clearerr(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fclose(FILE _FAR_ *);
extern FILE _FAR_ * _FAR_ _cdecl fdopen(signed int, const char _FAR_ *);
extern signed int   _FAR_ _cdecl feof(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl ferror(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fflush(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fgetc(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fgetchar(void);
extern signed int   _FAR_ _cdecl fgetpos(FILE _FAR_ *, fpos_t _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl fgets(char _FAR_ *, signed int,
	FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fileno(FILE _FAR_ *);
extern FILE _FAR_ * _FAR_ _cdecl fopen(const char _FAR_ *,
	const char _FAR_ *);
extern signed int   _FAR_ _cdecl fprintf(FILE _FAR_ *, const char _FAR_ *,
	...);
extern signed int   _FAR_ _cdecl fputc(signed int, FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fputchar(signed int);
extern signed int   _FAR_ _cdecl fputs(const char _FAR_ *, FILE _FAR_ *);
extern size_t       _FAR_ _cdecl fread(void _FAR_ *, size_t, size_t,
	FILE _FAR_ *);
extern FILE _FAR_ * _FAR_ _cdecl freopen(const char _FAR_ *,
	const char _FAR_ *, FILE _FAR_ *);
extern signed int   _FAR_ _cdecl fscanf(FILE _FAR_ *, const char _FAR_ *,
	...);
extern signed int   _FAR_ _cdecl fsetpos(FILE _FAR_ *, const fpos_t _FAR_ *);
extern signed int   _FAR_ _cdecl fseek(FILE _FAR_ *, signed long,
	signed int);
extern signed long  _FAR_ _cdecl ftell(FILE _FAR_ *);
extern size_t       _FAR_ _cdecl fwrite(const void _FAR_ *, size_t, size_t,
	FILE _FAR_ *);
extern signed int   _FAR_ _cdecl getc(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl getchar(void);
extern char _FAR_ * _FAR_ _cdecl gets(char _FAR_ *);
extern void         _FAR_ _cdecl perror(const char _FAR_ *);
extern signed int   _FAR_ _cdecl printf(const char _FAR_ *, ...);
extern signed int   _FAR_ _cdecl putc(signed int, FILE _FAR_ *);
extern signed int   _FAR_ _cdecl putchar(signed int);
extern signed int   _FAR_ _cdecl puts(const char _FAR_ *);
extern signed int   _FAR_ _cdecl remove(const char _FAR_ *);
extern signed int   _FAR_ _cdecl rename(const char _FAR_ *,
	const char _FAR_ *);
extern void         _FAR_ _cdecl rewind(FILE _FAR_ *);
extern signed int   _FAR_ _cdecl scanf(const char _FAR_ *, ...);
extern void         _FAR_ _cdecl setbuf(FILE _FAR_ *, char _FAR_ *);
extern signed int   _FAR_ _cdecl setvbuf(FILE _FAR_ *, char _FAR_ *,
	signed int, size_t);
extern signed int   _FAR_ _cdecl sprintf(char _FAR_ *, const char _FAR_ *,
	...);
extern signed int   _FAR_ _cdecl sscanf(const char _FAR_ *,
	const char _FAR_ *, ...);
extern FILE _FAR_ * _FAR_ _cdecl tmpfile(void);
extern char _FAR_ * _FAR_ _cdecl tmpnam(char _FAR_ *);
extern signed int   _FAR_ _cdecl ungetc(signed int, FILE _FAR_ *);
extern signed int   _FAR_ _cdecl unlink(const char _FAR_ *);
extern signed int   _FAR_ _cdecl vfprintf(FILE _FAR_ *, const char _FAR_ *,
	va_list);
extern signed int   _FAR_ _cdecl vprintf(const char _FAR_ *, va_list);
extern signed int   _FAR_ _cdecl vsprintf(char _FAR_ *, const char _FAR_ *,
	va_list);

/* macro definitions */

#if !defined(_POSIX_SOURCE)
#define feof(_stream)	  ((_stream)->_flag & _IOEOF)
#define ferror(_stream)   ((_stream)->_flag & _IOERR)
#define fileno(_stream)   ((signed int)(unsigned char)(_stream)->_file)
/* _CTOS getc */
#define getc(_stream)	  (--(_stream)->_cnt >= 0 ? 0xFF & *(_stream)->_ptr++ \
	: _filbuff(_stream))
#define putc(_c,_stream)  (--(_stream)->_cnt >= 0 \
	? 0xFF & (*(_stream)->_ptr++ = (char)(_c)) :  _flsbuf((_c),(_stream)))
#define getchar()	  getc(stdin)
#define putchar(_c)	  putc((_c),stdout)
#else /* _POSIX_SOURCE */
#define clearerr(_stream)	((_stream)->_flag &= ~(_ERROR|_END_OF_FILE))
#define feof(_stream)		((_stream)->_flag & _END_OF_FILE)
#define ferror(_stream)		((_stream)->_flag & _ERROR)
#define fileno(_stream)		((_stream)->_fd)
#define getc(_stream)		((--(_stream)->_cnt < 0) ? _fillbuf(_stream) : \
	(signed int) *(_stream)->_ptr++)
#define putc(_c,_stream)	((--(_stream)->_cnt < 0 || \
	(_stream)->_flag & (_BUFFERED|_LINE_BUFFERED) && \
	(_c) == '\n') ? \
	_flsbuf((_c),(_stream)) : \
	(signed int) (*(_stream)->_ptr++ = (unsigned char)(_c)))
#define getchar()		getc(stdin)
#define putchar(_c)		putc((_c),stdout)
#endif /* _POSIX_SOURCE */

#if defined(_MT)
#undef	getc
#undef	putc
#undef	getchar
#undef	putchar
#endif

#endif /* !_STDIO_DEFINED */
