/***
*setjmp.h - definitions/declarations for setjmp/longjmp routines
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the machine-dependent buffer used by
*	setjmp/longjmp to save and restore the program state, and
*	declarations for those routines.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_SETJMP_DEFINED)

#define _SETJMP_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

/* define the buffer type for holding the state information */

#if !defined(_POSIX_SOURCE)
#define _JBLEN	9  /* bp, di, si, sp, ret addr, ds */
typedef  signed int  jmp_buf[_JBLEN];
#else
#define _PR	7
#define _JBLEN	10  /* bp, di, si, sp, ret addr, ds, pr */
typedef  unsigned short  jmp_buf[_JBLEN];
typedef  jmp_buf         sigjmp_buf;
#endif


/* function prototypes */

extern signed int _FAR_ _cdecl setjmp(jmp_buf);
extern void       _FAR_ _cdecl longjmp(jmp_buf, signed int);
#if defined(_POSIX_SOURCE)
extern signed int _FAR_ _cdecl _sigsetjmp(sigjmp_buf, signed int);
#define sigsetjmp(env, savemask) (_sigsetjmp((env), (savemask)))
extern void       _FAR_ _cdecl siglongjmp(sigjmp_buf, signed int);
#endif

#endif /* !_SETJMP_DEFINED */
