/***
*ctype.h - character conversion macros and ctype macros
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	Defines macros for character classification/conversion.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_CTYPE_DEFINED)

#define _CTYPE_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/*
 * This declaration allows the user access to the ctype look-up
 * array _ctype defined in ctype.obj by simply including ctype.h
 */

#if defined(_DLL)
extern unsigned char _FAR_ _cdecl _ctype[];
#else
extern unsigned char _near _cdecl _ctype[];
#endif

/* set bit masks for the possible character types */

#define _UPPER		0x1	/* upper case letter */
#define _LOWER		0x2	/* lower case letter */
#define _DIGIT		0x4	/* digit[0-9] */
#define _SPACE		0x8	/* tab, carriage return, newline, */
				/* vertical tab or form feed */
#define _PUNCT		0x10	/* punctuation character */
#define _CONTROL	0x20	/* control character */
#define _BLANK		0x40	/* space char */
#define _HEX		0x80	/* hexadecimal digit */

/* character classification function prototypes */

extern signed int _FAR_ _cdecl isalpha(signed int);
extern signed int _FAR_ _cdecl isupper(signed int);
extern signed int _FAR_ _cdecl islower(signed int);
extern signed int _FAR_ _cdecl isdigit(signed int);
extern signed int _FAR_ _cdecl isxdigit(signed int);
extern signed int _FAR_ _cdecl isspace(signed int);
extern signed int _FAR_ _cdecl ispunct(signed int);
extern signed int _FAR_ _cdecl isalnum(signed int);
extern signed int _FAR_ _cdecl isprint(signed int);
extern signed int _FAR_ _cdecl isgraph(signed int);
extern signed int _FAR_ _cdecl iscntrl(signed int);
extern signed int _FAR_ _cdecl toupper(signed int);
extern signed int _FAR_ _cdecl tolower(signed int);
extern signed int _FAR_ _cdecl _tolower(signed int);
extern signed int _FAR_ _cdecl _toupper(signed int);
extern signed int _FAR_ _cdecl isascii(signed int);
extern signed int _FAR_ _cdecl toascii(signed int);
#if !defined(_POSIX_SOURCE)
extern signed int _FAR_ _cdecl iscsymf(signed int);
extern signed int _FAR_ _cdecl iscsym(signed int);
#endif

/* the character classification macro definitions */

#define isalpha(_c)	( (_ctype+1)[_c] & (_UPPER|_LOWER) )
#define isupper(_c)	( (_ctype+1)[_c] & _UPPER )
#define islower(_c)	( (_ctype+1)[_c] & _LOWER )
#define isdigit(_c)	( (_ctype+1)[_c] & _DIGIT )
#define isxdigit(_c)	( (_ctype+1)[_c] & _HEX )
#define isspace(_c)	( (_ctype+1)[_c] & _SPACE )
#define ispunct(_c)	( (_ctype+1)[_c] & _PUNCT )
#define isalnum(_c)	( (_ctype+1)[_c] & (_UPPER|_LOWER|_DIGIT) )
#define isprint(_c)	( (_ctype+1)[_c] & (_BLANK|_PUNCT|_UPPER|_LOWER|_DIGIT) )
#define isgraph(_c)	( (_ctype+1)[_c] & (_PUNCT|_UPPER|_LOWER|_DIGIT) )
#define iscntrl(_c)	( (_ctype+1)[_c] & _CONTROL )
#ifndef _NO_EXT_KEYS
#define toupper(_c)	( (islower(_c)) ? _toupper(_c) : (_c) )
#define tolower(_c)	( (isupper(_c)) ? _tolower(_c) : (_c) )
#endif
#define _tolower(_c)	( (_c)-'A'+'a' )
#define _toupper(_c)	( (_c)-'a'+'A' )
#define isascii(_c)	( (unsigned int)(_c) < 0x80 )
#define toascii(_c)	( (_c) & 0x7F )

/* MS C version 2.0 extended ctype macros */

#if !defined(_POSIX_SOURCE)
#define iscsymf(_c)	(isalpha(_c) || ((_c) == '_'))
#define iscsym(_c)	(isalnum(_c) || ((_c) == '_'))
#endif

#endif /* !_CTYPE_DEFINED */
