$MOD286
; assembly routines for making EISA BIOS calls

EXTRN CallBios: FAR

DGroup GROUP Data

Data SEGMENT PUBLIC 'Data'
PUBLIC pLevel1EPT
PUBLIC pLevel2EPT
PUBLIC pHexChars
PUBLIC cbHexChars
PUBLIC pCfgPrefix
PUBLIC pCfgSuffix
PUBLIC pAlphaNumericChars
PUBLIC cbAlphaNumericChars
PUBLIC pYes

pLevel1EPT          DD level1EPT
pLevel2EPT          DD level2EPT
pCfgPrefix          DD cfgPrefix
pCfgSuffix          DD cfgSuffix
pHexChars           DD hexChars
pAlphaNumericChars  DD validChars
pYes                DD yesString
cbHexChars          DB 16
cbAlphaNumericChars DB 62
Data ENDS

EisaParseTableSeg SEGMENT PUBLIC 'Memory'

level1EPT LABEL BYTE
DB '|BOARD'
DB '|IOPORT'
DB '|GROUP'
DB '|ENDGROUP'
DB '|FUNCTION'
DB '|SUBFUNCTION'
DB '|CHOICE'
DB '|'
DB 0

level2EPT LABEL BYTE
DB '|INITVAL'
DB '|LINK'
DB '|FREE'
DB '|COMBINE'
DB '|DMA'
DB '|IRQ'
DB '|PORT'
DB '|MEMORY'
DB '|SHARE'
DB '|TRIGGER'
DB '|INIT'
DB '|ADDRESS'
DB '|PORTADR'
DB '|WRITABLE'
DB '|MEMTYPE'
DB '|DECODE'
DB '|SIZE'
DB '|DISABLE'
DB '|CACHE'
DB '|'
DB 0

cfgPrefix LABEL BYTE
DB '[sys]<sys>!'
DB 0

cfgSuffix LABEL BYTE
DB '.cfg'
DB 0

hexChars LABEL BYTE
DB '0123456789ABCDEF'
DB 0

validChars LABEL BYTE
DB '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'
DB 0

yesString LABEL BYTE
DB 'YES'
DB 0

EisaParseTableSeg ENDS

InitEisaBIOS_Code SEGMENT 'COED'

ASSUME cs:InitEisaBIOS_Code, ds:DGroup

slot     EQU   word  ptr [BP+10]
pInfo    EQU   dword ptr [BP+6]

slotType       EQU  ES: byte ptr[BX]
fReadableID    EQU  ES: byte ptr[BX+1]
wCFGChecksum   EQU  ES: word ptr[BX+2]
bNumFunctions  EQU  ES: byte ptr[BX+4]
rgbID          EQU  5   ;array of 7 bytes

Public ReadEisaSlotInfo
ReadEisaSlotInfo PROC FAR
    PUSH BP
    MOV  BP, SP
    MOV  AX, 15h                   ;use INT 15h
    PUSH AX
	MOV  AX, slot
    MOV  CL, AL                    ;slot number
    MOV  AH, 0D8h                  ;EISA specific
    MOV  AL, 0                     ;Read Slot Config Info
    CALL CallBios
    CMP  AH, 0                     ;check for success
    JE   Success
    JMP  BiosCallFailed
Success:
    LES  BX, pInfo
    MOV  wCFGChecksum, CX          ;CFG file checksum
    MOV  bNumFunctions, DH         ;number of device functions in EISA CMOS
    TEST AL, 40h                   ;determine if product ID is readable
    JZ   IdNotReadable
    MOV  fReadableID, 0FFh         ;product ID is readable
    JMP  SHORT GetSlotType
IdNotReadable:
    MOV  fReadableID, 0            ;product ID is not readable
GetSlotType:
    SHR  AL, 4
    AND  AL, 3
    MOV  slotType, AL

    MOV  CX, DI
    SHR  CX, 2
    AND  CX, 1Fh
    ADD  CX, 40h
    MOV  ES: byte ptr [BX+rgbID], CL

    MOV  CX, DI
    XCHG CL, CH
    SHR  CX, 5
    AND  CX, 1Fh
    ADD  CX, 40h
    MOV  ES: byte ptr [BX+rgbID+1], CL

    MOV  CX, DI
    SHR  CX, 8
    AND  CX, 1Fh
    ADD  CX, 40h
    MOV  ES: byte ptr [BX+rgbID+2], CL

    MOV  CX, SI
    SHR  CX, 4
    AND  CX, 0Fh
    ADD  CX, 30h
    CMP  CX, 39h
    JLE  GetNumTwo
    ADD  CX, 7
GetNumTwo:
    MOV  ES: byte ptr [BX+rgbID+3], CL
    MOV  CX, SI
    AND  CX, 0Fh
    ADD  CX, 30h
    CMP  CX, 39h
    JLE  GetNumThree
    ADD  CX, 7
GetNumThree:
    MOV  ES: byte ptr [BX+rgbID+4], CL
    MOV  CX, SI
    SHR  CX, 12
    AND  CX, 0Fh
    ADD  CX, 30h
    CMP  CX, 39h
    JLE  GetNumFour
    ADD  CX, 7
GetNumFour:
    MOV  ES: byte ptr [BX+rgbID+5], CL
    MOV  CX, SI
    SHR  CX, 8
    AND  CX, 0Fh
    ADD  CX, 30h
    CMP  CX, 39h
    JLE  SlotInfoComplete
    ADD  CX, 7
SlotInfoComplete:
    MOV  ES: byte ptr [BX+rgbID+6], CL
BiosCallFailed:
    MOV  AL, AH                    ;error is returned in AH
    MOV  AH, 0
    MOV  SP, BP
    POP  BP
    RET  6
ReadEisaSlotInfo ENDP

plaInfo  EQU   word ptr [BP+6]
function EQU   word ptr [BP+8]
datalen  EQU   word ptr [BP+8]
slotnum  EQU   word ptr [BP+10]

$MOD386
Public ReadEisaFunctionInfo
ReadEisaFunctionInfo PROC FAR
    PUSH BP
    MOV  BP, SP
    MOV  AX, 15h                ;use INT 15h
    PUSH AX
    MOV  ECX, plaInfo           ;get real mode segment register
    SHL  ECX, 16                ;
    MOV  SI, 0                  ;offset is always zero
    MOV  EAX, ECX               ;
    MOV  AX, slotnum
    MOV  CL, AL                 ;slot number
    MOV  AX, function
    MOV  CH, AL                 ;function number
    MOV  AH, 0D8h               ;EISA specific
    MOV  AL, 1                  ;Read Function Config Info
    CALL CallBios
    MOV  AL, AH                 ;error is returned in AH
    MOV  AH, 0
    MOV  SP, BP
    POP  BP
    RET  6
ReadEisaFunctionInfo ENDP

Public WriteEisaCmos
WriteEisaCmos PROC FAR
    PUSH BP
    MOV  BP, SP
    MOV  AX, 15h                ;use INT 15h
    PUSH AX
    MOV  ECX, plaInfo           ;get real mode segment register
    SHL  ECX, 16                ;
    MOV  SI, 0                  ;offset is always zero
    MOV  EAX, ECX               ;
    MOV  CX, datalen            ;Length of data structure
    MOV  AH, 0D8h               ;EISA specific
    MOV  AL, 3                  ;16-bit addressing
    CALL CallBios
    MOV  AL, AH                 ;error is returned in AH
    MOV  AH, 0
    MOV  SP, BP
    POP  BP
    RET  6
WriteEisaCmos ENDP
$MOD286

InitEisaBIOS_Code ends

end
