;	KbdTs1.asm
;	Last update 8/31/90 by SG

txDisable		EQU	26h
txDisable8274	EQU	0E2h
ResetTxInt8274	EQU	28h
ResetInt8274	EQU	38h
InitUart6402 EQU 3bh
EOI_8259		EQU	20H
EOI_186			EQU	8000H
EOIREG_186		EQU	0FF22H

; Hardware/processor types
iws      EQU 0
t1       EQU 4
t2       EQU 5
cws186   EQU 7
GWS      EQU 8
NewGen   EQU 9
B38lcw   EQU 14

PUBLIC SetKbdIntHandler
EXTRN InstallInterruptVector:far

DGroup GROUP Data

Data SEGMENT PUBLIC 'Data'
EXTRN fInputInterrupt: BYTE
EXTRN fKbdInterrupt: BYTE
EXTRN kbdControlReg: WORD
EXTRN kbdClearInt: WORD
EXTRN kbdDataReg: WORD
EXTRN hardwareType: BYTE
EXTRN processorType: BYTE
EXTRN OCW2_8259: WORD
EXTRN ioCommCtlA: WORD
EXTRN cascadeOCW2_8259: WORD		;
		EVEN
pKbdInterrupt	DD	KbdIntHandler
Data	ENDS

Kbdtest1Code SEGMENT PUBLIC 'COED'
ASSUME	CS: KbdTest1Code, DS: DGroup

SetKbdIntHandler	PROC	FAR
	push	BP
	mov	BP, SP
	cmp	hardwareType, iws
	je	@3

	cmp	processorType, cws186
	je	@6

	cmp	processorType, GWS
	je	@6

	cmp	processorType, B38lcw
	je	@7

	mov	BX, 70 	; kbd int vector for NGen/NewGen is 70
	jmp	@4

@7:	mov	BX, 83			; kbd int vector for b38lcw
	jmp	@4

@6:	mov	BX, 15			; kbd int vector for CWS and GWS is 15
	jmp	@4

@3:	mov	BX, 12			; kbd int vector for IWS is 12

@4:	push bx
	lea	SI, pKbdInterrupt
	push word ptr [si+2]
	push word ptr [si]
	xor ax, ax
	push ax
	call InstallInterruptVector
	pop	BP
	ret
SetKbdIntHandler	ENDP


KbdIntHandler	PROC	FAR
KbdIntTop:
	push	AX
	push	DX
	cmp	processorType, cws186
	je	@10
	cmp	processorType, GWS
	jne	@8

@10:             ;do for GWS and CWS.
	mov	AL, 2
	mov	DX, kbdControlReg
	out	DX, AL
	in	DX, AL
@8:
	cmp processorType, NewGen
	jne NotNewGen1
	mov dx, kbdControlReg
	mov al,InitUart6402
	out dx,al            ;clear transmit interrupt

NotNewGen1:
	cmp	fInputInterrupt, 0	; Should this be an incoming character 
	jne	@1
	cmp	processorType, NewGen
	je	@2
	cmp	processorType, cws186
	je	CWSorGWS
	cmp	processorType, GWS
	jne	NotCWS

CWSorGWS:
	mov	AL, ResetTxInt8274	; No, Reset Tx interrupt
	mov	DX, kbdControlReg
	out	DX, AL
	jmp	@2

NotCWS:

	mov	AL, TxDisable		; No, disable transmit
	mov	DX, kbdControlReg
	out	DX, AL
	jmp	@2
@1:
	mov	DX, kbdDataReg		; Yes, input character to clear int
	in	AL, DX
	cmp processorType, NewGen
	jne @2
	mov dx, kbdClearInt
	mov al,1
	out dx,al           ;clear receive int
@2:
	mov	fKbdInterrupt, 0FFh	; flag the interrupt for main line code
	cmp	hardwareType, iws
	je	@5
	cmp	processorType, cws186
	je	xCWSorGWS
	cmp	processorType, GWS
	jne	@9
xCWSorGWS:
	mov	AL, ResetInt8274	; Reset interrupt
	mov	DX, ioCommCtlA
	out	DX, AL

@9:
	cmp processorType, b38lcw
	jne @x5
	mov	AL, EOI_8259		; issue an EOI to the 8259 slave
	mov	DX, cascadeOCW2_8259
	out	DX, AL
	jmp @5

@x5:
	cmp processorType, NewGen
	je @5
	cmp processorType, T2
	je @5
	mov	AX, EOI_186		; issue an EOI to the 186 int controller
	mov	DX, EOIREG_186
	out	DX, AX
	cmp	processorType, cws186
	je	@11
	cmp	processorType, GWS
	je	@11

@5:	mov	AL, EOI_8259		; issue an EOI to the 8259 int controller
	mov	DX, OCW2_8259
	out	DX, AL

@11: pop	DX
	pop	AX
	iret
	jmp KbdIntTop ; for protected mode
KbdIntHandler	ENDP

Kbdtest1Code	ENDS

END

; LOG
; 8/20/80, RH: created
; 3/1/83   MO: make module machine independent as part of NGen port
; 1/29/84  MO: Send EOI to 186 for T1 only to support T2 and 8086 NGens
; 7/30/84  MO: Add support for CWS
; 3/18/85  NJ:Added support for GWS
; 4/16/86   FW: Add support for NewGen
; 8/31/90  SG: Add support for B38lcw
