{$LINESIZE:96
 $TITLE:'06 FEB 85: Install General Synchronous Communications Support'
 $PAGESIZE:60}

{$DEBUG-}
{$OCODE+}

program GenSyncInstall;

{$INCLUDE:'<PascalEdf>CTOS.Edf'}
{$INCLUDE:'<PascalEdf>ProcessMgt.Edf'}
{$INCLUDE:'<PascalEdf>PartitionMgt.Edf'}
{$INCLUDE:'<PascalEdf>ClusterMgt.Edf'}
{$INCLUDE:'<PascalEdf>SystemServicesMgt.Edf'}
{$INCLUDE:'<PascalEdf>ConfigurationMgt.Edf'}
{$INCLUDE:'<PascalEdf>FileMgt.Edf'}
{$INCLUDE:'<PascalEdf>VideoMgt.Edf'}
{$INCLUDE:'<PascalEdf>TimerMgt.Edf'}
{$INCLUDE:'<PascalEdf>ContextMgt.Edf'}
{$PAGE+}
{$INCLUDE:'<PascalEdf>GenSync.Edf'}

const
   stackSize = 256;
   bgPriority = 31;
   requestPriority = 30;
   responsePriority = 15;
   timerPriority = 16;

var [extern]
   sbVerRun :lstring(255);
   ccb :array[0..1] of ccbType;
   pExtCntlReg :ads of byte;
   pRequestHandler, pResponseHandler, pTimeout :adsMem;

var [public]
   servExch, complExch, deinstallExch, timerExch :word;
   origExch :array[0..9] of word;
   genSyncDeinstallable :Boolean;

var
   erc, iRq, sMap, userNumber, wsNum :word;
   requestStack, responseStack, timerStack :array[1..stackSize] of word;
   pAscb :pAscbType;
   pScb :pScbType;
   pdb :pdbType;
   pMsgRet :adsMem;
   pVcb :pVcbType;
   vidHdw :vidHdwType;
   idMsg :string(19);
   alreadyInstalledMsg :string(36);

value
   idMsg := 'Datapoint GSCS Ver ';
   alreadyInstalledMsg := 'The GSCS has already been installed.';
{$PAGE+}
{Mainline of the installation code first checks to see that the General
 Synchronous Communications Support has not already been installed.  If not,
 a new priority is established, exchanges allocated and three new processes
 (request, completion and timeout) created.  Notification is given that we are
 ready to serve at one of the allocated exchanges and then we convert to system
 status.  The original process associated with this program waits at an
 exchange---if we were initiated under control of the Context Manager it is
 reawakened after a deinstall request and exits.}

begin
   erc := NotifyCm(markContextClean, ads null, 0);
   if (erc <> ercOK) and (erc <> ercServiceNotAvailable) then
      ErrorExit(erc);
   CheckErc(GetpAscb(ads pAscb));		{ASCB pointer}
   if not pAscb^.fExecScreen then [		{Video frames not yet set up}
      CheckErc(QueryVidHdw(vidHdw, sizeof(vidHdw)));
      CheckErc(ResetVideo(vidHdw.nColsNarrow, vidHdw.nLinesMax, true, ' ',
                          sMap));
      CheckErc(GetpStructure(vcbCode, 0, ads pVcb));
      CheckErc(InitVidFrame(0, 0, 3, pVcb^.cColsMax, pVcb^.cLinesMax - 3,
               noBorder, ' ', 0, false, false));
      CheckErc(InitVidFrame(1, 0, 0, pVcb^.cColsMax, 2, bottomBorder, '', 0,
               false, false));
      CheckErc(InitCharMap(pVcb^.pMap, sMap));
      CheckErc(SetScreenVidAttr(videoRefresh, true));
   ];
   CheckErc(ResetFrame(0));			{Identify ourselves, version}
   CheckErc(PutFrameChars(0, 0, 1, ads idMsg, upper(idMsg)));
   CheckErc(PutFrameChars(0, upper(idMsg), 1, ads sbVerRun[1], sbVerRun.len));
   CheckErc(QueryWsNum(wsNum));
   for var i := 0 to 9 do [			{Already installed locally?}
      iRq := abortGenSyncRqCode + wrd(i);
      CheckErc(QueryRequestInfo(iRq, ads origExch[i], sizeof(origExch[i])));
      if wsNum = mstrWs then [
         if origExch[i] <> 0 then [		{Don't install twice!}
            CheckErc(PutFrameChars(0, 0, 3, ads alreadyInstalledMsg,
                                   upper(alreadyInstalledMsg)));
            Exit;
         ];
      ] else if origExch[i] <> 12 then [	{Likewise, for cluster}
            CheckErc(PutFrameChars(0, 0, 3, ads alreadyInstalledMsg,
                                   upper(alreadyInstalledMsg)));
            Exit;
      ];
   ];
   CheckErc(ChangePriority(bgPriority));		{Set our new priority}
   CheckErc(GetpStructure(configBlkCode, 0, ads pScb));		{SCB pointer}
   CheckErc(GetpStructure(extCntlRegCode, 0, ads pExtCntlReg)); {ECSR pointer}
   case pScb^.hardwareType of
     iws:    [
		ccb[0].ctrl := iwsZ80SioCh0Ctrl;
		ccb[0].data := iwsZ80SioCh0Data;
		ccb[0].clock := iws8254Clock1;
		ccb[0].mode := iws8254Mode;
		ccb[0].ecsr := iwsEcsr;
		ccb[1].ctrl := iwsZ80SioCh1Ctrl;
		ccb[1].data := iwsZ80SioCh1Data;
		ccb[1].clock := iws8254Clock0;
		ccb[1].mode := iws8254Mode;
		ccb[1].ecsr := iwsEcsr;
	     ];

     aws210,
     aws230,
     aws240: [
		ccb[0].ctrl := aws8274Ch0Ctrl;
		ccb[0].data := aws8274Ch0Data;
		ccb[0].clock := aws8254Clock1;
		ccb[0].mode := aws8254Mode;
		ccb[0].ecsr := awsEcsr;
		ccb[1].ctrl := aws8274Ch1Ctrl;
		ccb[1].data := aws8274Ch1Data;
		ccb[1].clock := aws8254Clock0;
		ccb[1].mode := aws8254Mode;
		ccb[1].ecsr := awsEcsr;
	     ];

     nGen:   [
		ccb[0].ctrl := nGen8274Ch0Ctrl;
		ccb[0].data := nGen8274Ch0Data;
		ccb[0].clock := nGen8254Clock1;
		ccb[0].mode := nGen8254Mode;
		ccb[0].ecsr := nGenEcsr;
		ccb[1].ctrl := nGen8274Ch1Ctrl;
		ccb[1].data := nGen8274Ch1Data;
		ccb[1].clock := nGen8254Clock0;
		ccb[1].mode := nGen8254Mode;
		ccb[1].ecsr := nGenEcsr;
	    ];
   end;
   CheckErc(AllocExch(complExch));		{Allocate needed exchanges...}
   ccb[0].txIob.complExch := complExch;
   ccb[0].rxIob.complExch := complExch;
   ccb[1].txIob.complExch := complExch;
   ccb[1].rxIob.complExch := complExch;
   CheckErc(AllocExch(deinstallExch));
   CheckErc(AllocExch(servExch));
   CheckErc(AllocExch(timerExch));
   ccb[0].txIob.trb.exchResp := timerExch;
   ccb[0].rxIob.trb.exchResp := timerExch;
   ccb[1].txIob.trb.exchResp := timerExch;
   ccb[1].rxIob.trb.exchResp := timerExch;
   ccb[0].txIob.trb.rqCode := retype(word, adr ccb[0]);	{RqCode field is...}
   ccb[0].rxIob.trb.rqCode := retype(word, adr ccb[0]);	{...unused by RT...}
   ccb[1].txIob.trb.rqCode := retype(word, adr ccb[1]);	{...clock, so use..}
   ccb[1].rxIob.trb.rqCode := retype(word, adr ccb[1]);	{...it as pCcb!}
   with pdb do [
      pEntry := pRequestHandler;		{Start the request process....}
      saStack := (ads requestStack).s;
      saData := saStack;
      saExtra := saData;
      oStackInit := (ads requestStack[stackSize]).r + 2;
      priority := requestPriority;
      fSys := false;
      CheckErc(AllocExch(defaultResponseExchange));
      fDebug := false;
   ];
   CheckErc(CreateProcess(pdb));
   with pdb do [
      pEntry := pResponseHandler;		{...and the response process..}
      saStack := (ads responseStack).s;
      oStackInit := (ads responseStack[stackSize]).r + 2;
      priority := responsePriority;
      CheckErc(AllocExch(defaultResponseExchange));
   ];
   CheckErc(CreateProcess(pdb));
   with pdb do [
      pEntry := pTimeout;			{...and the timer process}
      saStack := (ads timerStack).s;
      oStackInit := (ads timerStack[stackSize]).r + 2;
      priority := timerPriority;
      CheckErc(AllocExch(defaultResponseExchange));
   ];
   CheckErc(CreateProcess(pdb));
   CheckErc(OpenRTClock(ccb[0].txIob.trb));	{Open two RT clocks...}
   CheckErc(OpenRTClock(ccb[0].rxIob.trb));
   CheckErc(OpenRTClock(ccb[1].txIob.trb));
   CheckErc(OpenRTClock(ccb[1].rxIob.trb));	{...for each channel}
   for iRq := abortGenSyncRqCode to controlGenSyncRqCode do
      CheckErc(ServeRq(iRq, servExch));		{Ready to serve!}
   CheckErc(GetUserNumber(userNumber));
   genSyncDeinstallable := pScb^.fMultiPartition and (userNumber <> 1);
   if genSyncDeinstallable then [
      CheckErc(SetPartitionLock(true));		{Prevent inadvertent expulsion}
      CheckErc(Wait(deinstallExch, ads pMsgRet));
      CheckErc(SetPartitionLock(false));	{OK, someone asked us to go}
      Exit;				{Should invoke CmNull.Run under CM}
   ] else [
      CheckErc(ConvertToSys);
      Exit;					{NOP for system services}
      CheckErc(Wait(deinstallExch, ads pMsgRet));	{Sleep forever..}
   ];
end.
