%SET(ctosp,0FFh)
%SET(ctosv,0FFh)
%SET(nGDTSlots, 6000)
%set(wsType,9)
%SET(hardwareType,4)
%SET(clusterConfig,2)
%SET(fNoFileSystem,0)
%SET(fCommIop,0)
%SET(fSrp,1)
%' sOsData is set to its maximum possible value when the OS is released.
%' It must be reduced if any further static data is declared in any OS module.
%' See Sysgen.asm for more information.
%SET(sOsData,38100)

%SET(nPartitions, 96)
%SET(nPcb, 2*%nPartitions)
%SET(nUsrExchange, 3*%nPcb)
%SET(nWsLine1,32)
%SET(nWsLine2,0)
%SET(wsTotal,%nWsLine1+%nWsLine2)
%SET(nXBlk, %wsTotal)
%SET(sXBlk,4096+64)
%SET(nXBlkSmall,%wsTotal*3)
%SET(sXBlkSmall,64)
%SET(nMsgWait, 280+%nPartitions*3+(%nXBlk+%nXBlkSmall))
%SET(nPTiming, %nPcb)


%SET(cParSCHeap,10h)
%SET(fMulpar,0FFh)
%SET(fVarpar,0FFh)
%SET(sParExitRunFile, 8192)
%SET(fTimeSliceEnable, 0FFh)
%SET(lbTimeSlicePriority, 146)
%SET(hbTimeSlicePriority, 178)
%SET(lineHz, 40)
%SET(sContingencyLog, 1)
%SET(sKbdBuffer, 256)
%Set(maxMedInterruptType, 87)
%SET(nFrames, 8)
%SET(nUcb, %nPartitions)
%SET(nUserNum, %nUcb + %wsTotal*20)
%SET(nNetUsers, 60)
%SET(sioClock,4)
%SET(nSwapFabs, 0)
%SET(nIOPermissionBits, 0)
; new parameters useful for cluster tuning
%SET(MaxErrorCount, 15)
%SET(MaxTimeOutCount, 10)
%SET(TimeOutTicks, 4)
%SET(TeleclusterTiming, 7)

%SET(nMountedDisks, 32)
%SET(sStatArea, 2)
%SET(nRcb, 200)

; If these are set to non-zero values here, 
; they override the values in Fs_N.Asm.
%SET(nFcb, 0)
%SET(nFab, 0)
%SET(nIob, 0)
%SET(nFub, 0)
%SET(nLucb, 0)
%SET(nUpb, 0)
%SET(nScsiIob, 0)
%SET(nVhb, 0)

$INCLUDE(Sysgen.Mdf)
$INCLUDE(Sysgen.Asm)
