;
; OsLabl.asm
;
; resolves request procedural interface and kernel labels with absolute 
; addresses (cs:ip hacks). this module is a subset of 
; ctos.lib(RqLabl* kernelNames). 
;

$INCLUDE(osLabl.mdf)


;
; Procedural interfaces used by OS, clstr, and filesystem
;
%RqName(4,OpenFile)
%RqName(5,CreateFile)
%RqName(6,DeleteFile)
%RqName(8,GetFileStatus)
%RqName(9,SetFileStatus)
%RqName(10,CloseFile)
%RqName(11,MountVolume)
%RqName(13,ChangeFileLength)
%RqName(14,GetDateTime)
%RqName(15,GetVhb)
%RqName(20,QuietIO)
%RqName(33,DeviceRead)
%RqName(34,DeviceWrite)
%RqName(35,Read)
%RqName(36,Write)
%RqName(40,AllocExch)
%RqName(41,DeallocExch)
%RqName(42,AllocMemorySL)
%RqName(44,AllocMemoryLL)
%RqName(49,OpenRTClock)
%RqName(50,CloseRTClock)
%RqName(51,SetDateTime)
%RqName(69,SetIntHandler)
%RqName(70,ResetKbd)
%RqName(71,ResetSysIn)
%RqName(99,ServeRq)
%RqName(121,SetLpISR)
%RqName(124,QueryDcb)
%RqName(125,WriteLog)
%RqName(176,RemovePartition)
%RqName(179,TerminatePartitionTasks)
%RqName(200,LogRemote)
%RqName(215,ChangeOpenMode)
%RqName(285,SetSegmentAccess)
%RqName(288,SetCommISRRawSFN)
%RqName(294,ReOpenFile)
%RqName(295,SwapInContext)
%RqName(303,ReadSwap)
%RqName(304,WriteSwap)
%RqName(305,DeactivateRunFile)
%RqName(310,SetDeviceHandler)
%RqName(312,GetRouteTable)
%RqName(313,UpdateRouteTable)
%RqName(315,GetWsStatus)
%RqName(323,ServiceOverlayA)
%RqName(324,ServiceOverlayB)
%RqName(334,FSCableDrop)
%RqName(340,QueryDeviceNames)
%RqName(346,QueryDeviceName)
%RqName(352,SetFSConfigParams)
%RqName(354,ReservePartitionMemory)
%RqName(355,OpenScsiPath)
%RqName(358,CloseScsiPath)
%RqName(360,ScsiCdbDataIn)
%RqName(361,ScsiCdbDataOut)
%RqName(362,ScsiRequestSense)
%RqName(376,RemoteCacheOpen)
%RqName(377,RemoteCacheClose)
%RqName(386,RemoteCacheControl)



;
; KernelNames
;
%KCallName (0, "Send")
%KCallName (1, "Wait")
%KCallName (1, "Waitp")
%KCallName (2, "Check")
%KCallName (3, "CreateProcess")
%KCallName (4, "Request")
%KCallName (5, "Respond")
%KCallName (6, "PSend")
%KCallName (7, "SetTimerInt")
%KCallName (8, "ResetTimerInt")
%KCallName (9, "MediateIntHandler")
%KCallName (10, "ChangePriority")
%KCallName (11, "RequestDirect")
%KCallName (12, "RequestRemote")
%KCallName (13, "SendRemote")
%KCallName (14, "SetDeltaPriority")
%KCallName (15, "ChangeProcessPriority")
%KCallName (16, "NewProcess")
%KCallName (17, "KillProcess")
%KCallName (18, "RescheduleProcess")
%KCallName (19, "ForwardRequest")
%KCallName (23, "ControlInterrupt")
%KCallName (24, "DeviceInService")
%KCallName (25, "SuspendUser")
%KCallName (26, "UnSuspendUser")
%KCallName (27, "SuspendProcess")
%KCallName (28, "UnSuspendProcess")
%KCallName (29, "SemLockCritical")
%KCallName (30, "SemClearCritical")
%KCallName (31, "QueryProcessInfo")
%KCallName (32, "ProcessControl")
%KCallName (33, "SetKernelMode")
%KCallName (34, "SendRequest")

END

; 11/01/91 JM created
; 01/20/93 JA SendRequest
; 03/02/93 KK ScsiCdbDataOut
