PAGE	55,132
TITLE	(C) COPYRIGHT ADAPTEC, 1993, Base Code no. 557304-00
NAME	biosdrvr
.286p


;******************************************************************************
;
;	AIC-6360 BIOS
;
;       basecode: 	  557304-00
;
;	The files listed in this document comprise the complete BIOS for
;	the AIC-6360 SCSI Protocol Controller.  The files required to
;	generate the b636.hex hex code file are listed below:
;
;		ATSBIOS.ASM	B636OPT.ASM	BIOSDRVR.ASM	COMMON.ASM
;		CUSTOM.ASM	DUMMYFLP.ASM	DUMMYFMT.ASM	DUMMYI4B.ASM
;		FLPINSIT.ASM	FLPTEAC.ASM	FORMAT.ASM	INIT.ASM
;		MESSAGES.ASM	SBIOS.ASM
;
;		BIOSEQUS.INC	COMMON.INC	FORMAT.INC	FORMATST.INC
;		GLOBAL.INC	SBIOS.INC	SCSIDEFS.INC	SPAREQU.INC
;
;	date:  08/15/91
;
;	written by:  Arlen Young
;
;******************************************************************************

;
;   "Copyright (c) 1989-1993 Adaptec Inc.  All rights reserved.
;    This software contains the valuable trade secrets of
;    Adaptec.  This software is protected under copyright
;    laws as an unpublished work of Adaptec.  Notice is 
;    for informational purposes only and does not imply 
;    publication.  The user of this software may make copies
;    of the software for use with parts manufactured by
;    Adaptec or under license from Adaptec and for no other 
;    use."
;

  
;--- HISTORY
;
;  06/15/93  REM.  Added multi-segment transfer support.
;
;  04/01/93  YWL   Modified Base Code No. for V1.01L pilot release.
;
;  09/28/92  REM.  Added AIC-6360 support.
;
;  08/20/91  Parity error detection upgrade introduced an error in subroutine
;            'config4parity'.  When called by 'intrsel', the parity error
;            clearing also disabled selection timeout.  If a command has been
;            loaded into the 6360 at the time of reselection, and selection
;            times out when the 6360 eventually tries to select, then no 
;            selection timeout interrupt would occur.  The problem was fixed
;            by preserving all bits in register sxfrctl1 when bit enspchk is
;            changed.  Changes in outputting to sxfrctl1 were made at intse1,
;            config4par0, & config4par4.
;
;  08/15/91  -JP001 - created routine InitXferOption to eliminate redundant code,
;	     added routine "ChkHAPresent" for presence check -merged my 6/3 changes
;	      and my 8/15 changes (Floptical BIOS branch) with Arlen's
;	     8/15 changes below. Deleted Arlen's "load_6360_stack" routine 
;	     as it conflicted/overlapped with some of my changes (keycode 
;	     changes, needed to separate out the initialzing of async xfer,etc.)
;
;  08/15/91  Rewrote sections of code to reduce program size for Judy's
;            floptical BIOS.  Rewrote 'bit_test:' to test all passed in bits
;            for a given register with only one call.  At 'msgrej:', replaced
;            code with a call to 'msgrej$:'.  Restructured 'getem2:', 
;            'extmsgo:', and 'syno00:' to be same as for 1210.  Replaced code
;            at 'synm40:' and 'synnego:' with call to 'xfer_option:'.  Replaced
;            code at 'ackreq:' with call to 'scsiack'.  Replaced code with
;            subroutine 'load_6360_stack:'.  Deleted copyright message at top
;            of program.  Replaced code with 'my_address:' subroutine.
;            Created 'async_xfer_option:' subroutine.  Removed 'jmp init_spar'
;            from 'schrs1:' to fall thru to 'init_spar'.
;
;
;  06/18/91  Released ASW-B626 S2, ver. 1.0, base code 454302-00,
;            checksum E500.
;
;  06/04/91  PupDelay (atsbios.asm):  Inserted 'ret' at end of procedure.
;
;  06/03/91  -JP - Modified pass-in structure.
;
;  04/23/91  Replaced 04/12/91 Daiwoo beta release with an upgrade.  cksm 6000
;            Removed 'retf' for Intel.
;            Beta release special to Intel (B626 S1, cksm 9400).
;
;  04/18/91  Additional parity detection upgrade.
;
;  04/12/91  Upgraded parity detection as per new understanding of 6260.
;            Beta release special to Daiwoo.
;
;  04/09/91  sendmo:, scnoop:  Deassertion of ATN was added.
;
;  03/26/91  Compressed and repositioned transfer option bytes in Sparrow stack
;            Replaced many 'mov dx,' with 'mov dl,LOW' to save time & bytes.
;            Moved configuration parameters into a custom module.
;            Check for powered-down target on bus before first selection to
;              prevent hanging the host adapter.  (Intel B626 S1)
;
;  01/04/91  Defined 'rep insw' direction in 'pio_cmd' and 'pio_xfer'.
;            Defined 'rep movs' direction at ItsDrv0: (custom.asm).
;
;  01/02/91  Revised 'Intel' special.
;  12/14/90  Incorporated 'Intel' special.
;
;  11/01/90  intrsel():  Fixed a problem in handling Restore Data Pointers mes-
;            sage.  Sent ack for the message, but didn't wait for req.  Re-
;            entered sio510: and looked at bus phase before it was correct.
;            Changed return from the message to be the same as for NOP.
;
;  10/30/90  getem5:  Define expected phase = Message In for possible loop back
;            to extmsg1:.  Without this, would hang on the third sync nego
;            message from the drive:  Expected phase would still be Message Out
;            while new phase is Message In;  when ackreq is called, ack would
;            not go out.
;
;           scstmsg():  Clear any attention which the target did not respond to
;           earlier.  It can't be important now, and a Message Out phase after
;           this point will be disasterous.
;
;  l0/16/90  Released BIOS Version 1.4a, base code 442607-00, cksm 0000.
;
;  10/02/90  Released BIOS Version 1.4, base code 442606-00, cksm 0100.
;
;  10/01/90  Eliminated bitad storage on 6260 stack.  Generate adapter id
;            (1-of-8) on the fly.
;            Changed power-save feature to be active for motherboard BIOS only.
;
;  09/17/90  Released ASW-B626 standard motherboard BIOS, cksm 0800.
;	     base code 454301-00  (release updated 10/01/90)
;
;  09/12/90  Upgraded dutil.asm for stack bug.
;            Added power-down feature, identified by +P.  (Alpha Ver.1.004)
;
;  09/07/90  intse4:  Wait for bus free after abort message to be sure select-
;            ion status is cleared.
;
;  08/23/90  Created Northgate special to take 'no error' return to system BIOS
;	     when no SCSI drive is connected.  Alpha Ver. 1.002.
;
;  08/17/90  Released base code 442604-00.  cksm = 2300,  Version 1.3
;
;  07/20/90  Created BIOS with alternate port address 140h for Version 1.3A
;	     ("A" for "alternate address").
;	     Released base code 442605-00.  cksm = 6700, Version 1.3A
;
;  05/29/90  discon:  Send ACK to Disconnection message after enabling
;	     reselection.  Wait for bus free to ensure clearing SELDI status.
;
;  05/03/90  Clear atn at sio150 in case target did not respond to attempt
;	     of sync xfer negotiation.
;
;  04/06/90  Modified use of reqinit status to correct for a Sparrow bug.
;	     +W  identifies code changes.
;	     Released base code 442603-00.  cksm = 6200,  Version 1.2
;
;  03/22/90  Changed CcrInt to pass out dl = HrdCnt for drive = 80h &
;	     command = 08h.
;	     Released base code 442602-00.  cksm= 8D00
;
;  03/13/90  pio_c0:  Check that target received all cdb bytes by comparing
;	     transfer count with cdb block size.  sempty will not be set if
;	     sync data xfer has already started, & is therefore no longer used.
;  03/02/90  Released base code 442601-00.
;
;  02/28/90  Deleted scsi Recal command from ChkDsk.
;	     Added check for block size = 512 bytes.
;
;  02/12/90  Released base code BETA ver B.01.

	PAGE

;  Sparrow BIOS Driver source
;

;	.LIST

;******************************************************************************
;
;  Sparrow Driver dedicated to executing BIOS PC commands from a BIOS
;  manager.
;
;	pass thru:  es, sp, ds
;
;	+R:  Code changed for 2nd turn of Sparrow device.
;
;******************************************************************************

	INCLUDE biosequs.inc	;equates for BIOS Driver & Manager
	INCLUDE	sparequ.inc	;equates for Sparrow BIOS Driver only
 	INCLUDE global.inc	;*JP001*

IFDEF	EXE
	INCLUDE format.inc	;*JP001*
ENDIF
	PAGE
;******************************************************************************
;
;	Sparrow device port definitions
;
;******************************************************************************

	EXTRN	BasePort:ABS		;base port address

scsiseq   EQU	BasePort+00h		;scsi sequence control		(write/read)
sxfrctl0  EQU	BasePort+01h		;scsi transfer control 0	(write/read)
sxfrctl1  EQU	BasePort+02h		;scsi transfer control 1	(write/read)
scsisig   EQU	BasePort+03h		;scsi signal			(write)
scsisig   EQU	BasePort+03h		;actual scsi bus signals	(read)
scsirate  EQU	BasePort+04h		;scsi rate control		(write)
scsiid	  EQU	BasePort+05h		;scsi id			(write)
selid	  EQU	BasePort+05h		;selection/reselection id	(read)
scsidat   EQU	BasePort+06h		;scsi latched data		(write/read)
scsibus   EQU	BasePort+07h		;scsi data bus			(read)
stcnt0	  EQU	BasePort+08h		;scsi transfer count, lsb	(write/read)
stcnt1	  EQU	BasePort+09h		;		    , mid	(write/read)
stcnt2	  EQU	BasePort+0Ah		;		    , msb	(write/read)
clrsint0  EQU	BasePort+0Bh		;clear scsi interrupts 0	(write)
sstat0	  EQU	BasePort+0Bh		;scsi status 0			(read)
clrsint1  EQU	BasePort+0Ch		;clear scsi interrupts 1	(write)
sstat1	  EQU	BasePort+0Ch		;scsi status 1			(read)
sstat2	  EQU	BasePort+0Dh		;scsi status 2			(read)
scsitest  EQU	BasePort+0Eh		;scsi test control		(write)
sstat3	  EQU	BasePort+0Eh		;scsi status 3			(read)
clrserr   EQU	BasePort+0Fh		;clear scsi errors		(write)
sstat4	  EQU	BasePort+0Fh		;scsi status 4			(read)
simode0   EQU	BasePort+10h		;scsi interrupt mask 0		(write/read)
simode1   EQU	BasePort+11h		;scsi interrupt mask 1		(write/read)
dmacntrl0 EQU	BasePort+12h		;dma control 0			(write/read)
dmacntrl1 EQU	BasePort+13h		;dma control 1			(write/read)
dmastat   EQU	BasePort+14h		;dma status			(read)
fifostat  EQU	BasePort+15h		;number of bytes in dma fifo	(read)
dmadata   EQU	BasePort+16h		;16 bit host data port		(write/read)
brstcntrl EQU	BasePort+18h		;burst control			(write)
porta	  EQU	BasePort+1Ah		;LED/jumpers			(write/read)
portb	  EQU	BasePort+1Bh		;more jumpers				(read)
rev	  EQU	BasePort+1Ch		;Sparrow revision level		(read)
sparstack EQU	BasePort+1Dh		;16 byte stack in Sparrow	(write/read)

	PAGE
;******************************************************************************
;
;  RAM Allocation
;
;	RAM is located in the system stack.  RAM locations must be accessed via
;	the BP register, offset by the following equates.  RAM locations are
;	valid only within each command, and are assumed to be lost upon return
;	to the caller.
;
;******************************************************************************


;******************************************************************************
;
;  Sparrow Stack Allocation
;
;******************************************************************************



key0_xlatmode	EQU	00h	;key to authenticate configuration bytes    (1)
porta$	EQU	01h		;configuration byte from Sparrow Port A	    (1)
portb$	EQU	02h		;"                                  " B     (1)
synspd	EQU	03h		;data xfer option byte for each target	    (7)
				;byte number as a function of target id =
				;[[(ha id) - (targ id)] AND 07] + synspd - 1
		      		; bytes 03h through 09h inclusive
flpt0inf1	EQU 0Ah		;info for 1st floptical drive
flpt1inf1	EQU 0Bh		;info for 2nd floptical drive
std_floppy	EQU 0Ch		;standard floppy service entry point
				;stored offset (bytes 0ch-0dh) and segment
				;(bytes 0eh-0fh) ,intel byte ordering


; ********** floptical bytes bit masks **********************

Scsi_ID		EQU    07H		;SCSI ID bits 0-2
MC_Active	EQU	08H		;media change active (bit 3)
LastCmd16	EQU	10h		;last BIOS function =16 or not (bit 4)
Curr_Media	EQU	60h		;current physical media type (bits 5,6)
Down_format	EQU	80H		;1.44 formatted as 720k

CurrMediaOffset EQU	05		;shift right 5 bits to normalize
					;curr media type

;******************************************************************************
;
;  General equates used within this module.
;
;******************************************************************************

	PAGE


code SEGMENT PUBLIC 'CODE'	;same segment as bios manager

EXTRN	in_porta:NEAR		;in b636opt.asm
EXTRN	in_portb:NEAR		;in b636opt.asm
EXTRN	sltime:BYTE		;in b636opt.asm
EXTRN	dbuson:BYTE		;in b636opt.asm
EXTRN	dbusoff:BYTE		;in b636opt.asm
EXTRN	InCompatDriver_Msg:byte	;in b636opt.asm

EXTRN	getxcfg2byte:near	;in atsbios.asm
EXTRN	TestRR:near		;in atsbios.asm

EXTRN	DspStr:near		;in sbios.asm

IFNDEF	EXE
	ASSUME	cs:code,ds:nothing,es:nothing,ss:nothing
ELSE
	ASSUME	cs:ConfigSeg,ds:nothing,es:nothing,ss:nothing
ENDIF
	PUBLIC	bios_driver
bios_driver	PROC	NEAR


	mov	[bp].original_sp,sp ; *JP001* save sp upon entry
	mov	dx,porta	;turn led on
	mov	al,led_on
	out	dx,al
				;bp does not change during this procedure.
				;All ram accesses are referenced to bp.

	;Check that configuration parameters are saved on Sparrow stack if 6360
	;enhanced features are turned on. If 6360 enhanced features
	;are turned on and config info was wiped out, then it's an old driver,
	;so lock up system.
	
	mov	dl, LOW dmacntrl1	
	mov	al, key0_xlatmode 
	out	dx, al                  ;enable to start reading from byte 00H

	mov	dl, LOW sparstack
	in	al, dx                  ;read byte 00H - signature byte

	cmp	al, SIGNATURE_6360	
	je	bios_drive0	        ;=> AIC-6360 BIOS signature

	cmp	al, key0code6360	
	je	bios_drive0	        ;=> AIC-6360 BIOS signature

	call	in_porta
	out	dx, al                  ;restore Port A

	call	in_portb
	out	dx, al                  ;restore Port B

bios_drive0:
	call	my_address	;get host adapter address
	mov	cl,al
	shl	al,4		;move id to bits 6-4
	mov	ah,al		;save ah = id for pass-in to seladdr


;******************************************************************************
;
;  Start a SCSI command.
;
;******************************************************************************

siostrt:
	call	seladdr		;select the target
	mov	dl,LOW sstat0	;selection complete?
	in	al,dx
	test	al,seldo
	jnz	siostr0		;  jump if yes
	call	waitfor		;wait for selection complete or timeout
siostr0:
	mov	dx,clrsint1	;clear bus free interrupt
	mov	al,clrbusfree
	out	dx,al
	mov	dl,LOW scsiseq	;disable selection out & auto atn assertion
	xor	al,al
				;leave resel disabled until disconnection:
				;  BIOS is single threaded.
	out	dx,al		;
	mov	dl,LOW simode0	;disable selection complete interrupt
	in	al,dx
	and	al,NOT enseldo
	out	dx,al
        mov	dl,LOW clrsint0	;clear selection interrupts
	mov	al,clrseldo+clrselingo
	out	dx,al
	mov	dl,LOW sstat0	;bus free?  (If bus free occurred since
	in	al,dx		;  selection complete, then seldo = 0.)
	test	al,seldo
	jnz	j1
	jmp	ckreset  	;  jump if yes:  unexpected bus free
j1:
				;selection complete

	call	config4par0	;configure 6360 for parity detection
	call	wt4req		;wait for req
	mov	ah,al
	mov	al,mophase	;expected phase = message out
	out	dx,al
	mov	dl,LOW clrsint1	;clear attn
	mov	al,clratno
	out	dx,al
	mov	al,ah
	cmp	al,mophase	;phase = message out?
	je	j42
	jmp	siostr1		;  jump if no
j42:

				;phase = message out

				;read jumper options -
	mov	dx,dmacntrl1
	mov	al,portb$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	test	al,endiscon	;  enable disconnection?
	mov	ah,msgid_d	;		identify message+disconnect option
	jnz	siostr9		;    jump if yes
	mov	ah,msgid	;		identify message w/o disconnect
siostr9:
	test	al,nego4sync	;  do we initiate sync xfer negotiation?
	jz	siostr2		;    jump if no
				;    yes:
	call	xfer_option	;sync xfer negotiation done?
	in	al,dx		;al = transfer option
	test	al,80h
	jnz	siostr2		;  jump if yes
	mov	dl,LOW scsisig	;  no.  Set atn to negotiate xfer option.
	mov	al,atno+mophase
	out	dx,al
siostr2:			;identify message -> target
	mov	al,[bp].dlun
	and	al,07h		;lun
	or	al,ah		;identify message =
	mov	dx,scsidat	;  id msg flag + disconnect option + lun
	out	dx,al
	call	scsiack		;assert ack
siostr3:
	call	wt4req		;wait for next req
	cmp	al,miphase	;scsi phase = Message In?
	jne	sio105		;  jump if no
	call	ckmsgi		;  yes.  Handle the message.
	jmp	SHORT siostr3	;wait for another req
sio105:	cmp	al,cmdphase	;scsi phase = Command?
	je	sio150		;  jump if yes
	cmp	al,stphase	;	    = Status?
	jne	j2
	jmp	siobusy  	;  jump if yes
j2:	cmp	al,mophase	;	    = Message Out?
	je	j3
	jmp	badseq		;  jump if no:  invalid phase
j3:
				;do we initiate sync xfer negotiation?
	mov	dx,dmacntrl1
	mov	al,portb$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	test	al,nego4sync
	jnz	sio120		;  jump if yes
				;  no:	
sio110:	call	sendmo		;message -> target
	jmp	siostr3

sio120:	call	xfer_option	;negotiate with target if it hasn't been done.
	in	al,dx		;al = transfer option
	test	al,80h
	jnz	sio110		;  jump if it has been done
	call	synnego		;initiate negotiation with target
	jmp	SHORT siostr3

siostr1:			;not Message Out phase after selection
	cmp	al,cmdphase	;phase = command?
	je	siostr3		;  jump if yes
	cmp	al,stphase	;      = status?
	je	j4		;  jump if yes
	jmp	badseq		;bad scsi sequence
j4:	jmp	siostat

sio150:				;scsi phase = Command
	out	dx,al		;define expected phase
	mov	dl,LOW clrsint1	;clear atn in case no sync xfer nego
	mov	al,clratno
	out	dx,al
	call	xfer_option	;set transfer option for data phase
	in	al,dx		;al = transfer option
	and	al,7fh
	call	config4data	;  & configure Sparrow device.

	jmp	pio_cmd  	;transfer mode = pio

sio171:				;assume unexpected phase change during
				;  cdb transfer to target.
	mov	dl,LOW scsisig	;check scsi bus phase-
	in	al,dx
	and	al,busphase
sio204:	cmp	al,stphase	;phase = status?
	jne	j5
	jmp	siobusy  	;  jump if yes
j5:	cmp	al,miphase	;      = message in?
	je	j6
	jmp	badseq		;  jump if no:  invalid sequence
j6:	out	dx,al		;expected phase = message in
	mov	dl,LOW scsidat	;+R  read in message from target
	in	al,dx
	cmp	al,msg03	;message = Restore Data Pointers?
	jne	sio108		;  jump if no
				;  yes:  possible parity error detected by targ
	call	ackreq		;complete handshake
	jmp	siostr3		;restart CDB -> target transfer

sio108:	call	msgrej$		;  no:  reject the message.
	jmp	sio204
				;end of Command phase

	PAGE


;  PIO cdb to target.


pio_cmd:

	cld				;define 'rep' direction
	mov	dx,dmacntrl0		;enable pio to host
        mov     al,rstfifo+writeread    ;clear dma fifo
        out     dx,al
        mov     al,endma+writeread      ;enable pio - direction = write
        out     dx,al
        mov     dl,LOW sxfrctl0
	mov	al,ch1ch2+clrstcnt+clrch1	;reset scsi fifo
	out	dx,al
        mov     al,scsien+dmaen+ch1ch2		;enable scsi transfer
        out     dx,al

	mov	si,bp
	add	si,ddcb		;si points to cdb in current scb
				;  = segment offset
	push	ds
	mov	ax,ss
	mov	ds,ax		;ds = data segment

	mov	cl,[bp].dcmdlen	;cdb length
	xor	ch,ch

	mov	dl,LOW simode1	;enable interrupts -
	in	al,dx		;  scsi reset, phase change, bus free
	or	al,enscsirst+enphasemis+enbusfree
	out	dx,al

	mov	dl,LOW dmadata	;Sparrow dma fifo port address
	shr	cx,1		;cx = # of words to transfer from host
				;cf = 1 if odd byte to transfer from host

	rep	outsw		;data transfer:  host words -> fifo

	rcl	cx,1
	rep	outsb		;data transfer:  last byte (if any) <- host
				;host -> fifo transfer is complete
	
	pop	ds		;restore ds reg

pio_c0:	mov	dl,LOW sstat2	;wait for scsi fifo to empty
	in	al,dx
	test	al,sempty
	jnz	pio_c1		;jump if write across scsi is done
	mov	dl,LOW dmastat
	in	al,dx
	test	al,intstat	;scsi interrupt?
	jz	pio_c0		;  jump if no:  continue waiting


				;+R  Workaround deleted.

	mov	dl,LOW stcnt0	;  yes.  Did target take all cdb bytes?
	in	al,dx		;(note:  sempty will not be set is sync data
	cmp	al,[bp].dcmdlen	;xfer already started.)
	je	pio_c2		;    jump if yes:  cdb transfer is done
				;    no:  data underrun
	mov	dl,LOW simode1	;disable phase change interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al
	jmp	sio171		;scsi phase change before cdb xfer done	

pio_c1:				;end of command transfer to target

				;+R  Workaround deleted.
pio_c2:

	mov	dl,LOW simode1	;disable phase change interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al


	PAGE

;  data transfer
compute_segementation:
	; set current buffer address and lengths
	mov	ax,[bp].dseg
	mov	[bp].curseg,ax
	mov	ax,[bp].doffset
	mov	[bp].curoff,ax
	mov	ax,[bp].ddlen
	mov	[bp].curlen,ax
	mov	al,byte ptr [bp].ddlen+2
	mov	byte ptr [bp].curlen+2,al

	mov	cx,[bp].doffset
	mov	bx,[bp].ddlen
	mov	dl,byte ptr [bp].ddlen+2

	; is it a multi-segment transfer?
	cmp	dl,1
	ja	Overlapped		; greater than 1 segment, overlapped
	jb	PossiblyOverlapped	; less than a segment, possibly 
	or	bx,bx			; exacctly 64K ?
	jnz	Overlapped		; more, overlapped
	or	cx,cx	  		; exactly 64K and offset 0 ?
	jnz	Overlapped
	jmp	short siodata

	;test for overlapp for transfer
	; lengths of less than 64K
PossiblyOverlapped:
	or	cx,cx
	jz	siodata
	mov	ax,cx			; save cx
	mov	di,bx			; save bx
	not	cx
	inc	cx
	sub	bx,cx
	mov	cx,ax			;restore cx
	mov	bx,di			;restore bx
	jz	siodata
	jc	siodata

	;definitely overlapped of some kind
	;break up request into segments since
	;it's overlapped
Overlapped:
	; cx = offset
	; bx = count, LOW 16 bits
	; dl = count, HI 8 bits

	;set beginning fragment
	or	cx,cx
	jz	WholeSegs
BegSegs:
	not	cx
	inc	cx

	mov	[bp].bscnt,cx
	mov	[bp].curlen,cx
	mov	byte ptr [bp].curlen+2,0
	mov	ax,[bp].dseg
	mov	[bp].bseg,ax

	sub	bx,cx
	sbb	dl,0

	;set whole segments
WholeSegs:
	or	dl,dl
	jz	EndSeg
	xor	dh,dh
	mov	[bp].wsegs,dx
	mov	[bp].curlen,0
	mov	byte ptr [bp].curlen+2,1
	or	cx,cx
	jnz	EndSeg
	dec	[bp].wsegs

	;set ending segment
EndSeg:
	or	bx,bx
	jz	siodata
	mov	[bp].escnt,bx
	mov	dx,[bp].wsegs
	inc	dx
	shl	dx,12
	mov	cx,[bp].dseg
	add	cx,dx
	mov	[bp].eseg,cx

				;re-entry point after reselection

siodata:			;
	mov	dx,sxfrctl0	;clear transfer counter
	mov	al,ch1ch2+clrstcnt
	out	dx,al

	mov	dl,LOW clrsint0	;clear dma done status
	mov	al,clrdmadone
	out	dx,al

	mov	ax,[bp].curlen
	or	ah,BYTE PTR [bp].curlen+2
	or	al,ah
	jnz	j7
	jmp	sio500		;jump if data transfer length = 0
j7:
	jmp	pio_xfer	;jump if transfer mode = pio
	

sio310:				;phase changed, but data transfer not done
	call	wt4req		;next phase =
sio311:	test	al,cdi+msgi	;	data?
	jnz	j0
	jmp	siodata 	;		jump if yes
j0:	cmp	al,stphase	;	status?
	jne	j8
	jmp	siostat 	;		jump if yes
j8:	cmp	al,miphase	;	message in?
	jne	j9
	jmp	sio411		;		jump if yes
j9:	cmp	al,mophase	;	message out?
	je	j10
	jmp	badseq		;		jump if no:  invalid phase
j10:	call	sendmo		;		yes:  message -> target
	jmp	SHORT sio311

	PAGE


;  data transfer mode = PIO


pio_xfer	LABEL	NEAR

sio215p:
	cld			;define 'rep' direction
	call	wt4req		;wait for req to determine transfer direction
	test	al,cdi+msgi	;phase = data?
	jz	sio180p		;  jump if yes
				;  no.  phase =
	cmp	al,miphase	;	message in?
	jne	j11
	jmp	sio411		;		jump if yes
j11:	cmp	al,stphase	;	status?
	jne	j12
	jmp	siobusy 	;		jump if yes
j12:	cmp	al,mophase	;	message out?
	je	j13
	jmp	badseq		;		jump if no:  invalid phase
j13:	call	sendmo		;		yes:  message -> target.
	jmp	sio215p

sio180p:
	out	dx,al		;Define expected data phase.
	xchg	al,ah
	call	getxcfg2byte
	and	al,TXWIDTH32
	xchg	dl,ah
	mov	ah,al
	shl	ah,4

	test	dl,ioi		;direction = read?
	jnz	sio190p		;  jump if yes
	or	ah,writeread	;direction = write

sio190p:
	mov	dl,LOW dmacntrl0 ;enable pio to host
	mov	al,rstfifo
	or	al,ah		;define direction
	out	dx,al
	mov	al,endma
	or	al,ah
	out	dx,al
	mov	dl,LOW sxfrctl0	;enable scsi transfer
	mov	al,scsien+dmaen+ch1ch2
	out	dx,al
	test	ah,writeread
	jz	pio_read	;jump if pio transfer = read
	jmp	pio_write	;jump if pio transfer = write

	PAGE


;*************************************************************************
;
;  PIO Read data transfer:  target -> host -
;
;*************************************************************************
pio_read:
	push	es		;save es segment register

	mov	di,[bp].curoff	;segment offset -> di
	mov	ax,[bp].curseg	;target segment -> es
	mov	es,ax

	mov	dx,simode1	;enable interrupts -
	in	al,dx		;  scsi reset, phase change, bus free
	or	al,enscsirst+enphasemis+enbusfree
	out	dx,al

	call	getxcfg2byte
	test	al,TXWIDTH32
	jz	pio_rdwords

;*************************************************************************
;
;  DOUBLE-WORD TRANSFERS
;
;*************************************************************************

	.386p
pio_rddwords:
	;data transfer length -> ah bx Max length is 64K (10000H)
	mov	ah,BYTE PTR [bp].curlen+2
	mov	cx,[bp].curlen
	mov	bx,cx

	shr	ah,1
	rcr	bx,1		;data transfer length -> bx  [dwords]
	shr	bx,1

	; save fragment byte count in ah
	mov	ah,cl
	and	ah,3
	xor	ch,ch

;*************************************************************************
;
;  READ DOUBLE-WORD TRANSFERS
;
;*************************************************************************

pio_rdw0:
	sub	bx, fifosize/4			;dwords remaining to be transferred
	jc	pio_rdw10
pio_rdw11:
	mov	cl,fifosize/4
	mov	dx,dmastat			;wait for fifo to fill from target
pio_rdw2:
	in	al,dx
	test	al,dfifofull			;fifo full?
	jz	pio_rdw12			;  jump if no

	mov	dx,brstcntrl			;Sparrow dma fifo port address for
	rep	insd				;  double-word transfers
	jmp	pio_rdw0

pio_rdw12:
	test	al,intstat	;scsi interrupt?
	jz	pio_rdw2		;  jump if no
				;scsi transfer halted.  Flush fifo to host.
	add	bx, fifosize/4
	shl	bx, 2		;bx = # of bytes expected from target
	; don't forget fragment count in ah
	shr	ax, 8
	add	bx, ax
	jmp	pio_r9

pio_rdw10:
				;words remaining to be transferred
	add	bx, fifosize/4	;  < dma fifo size.
	shl	bx, 2		;bx = bytes remaining to be transferred
	; don't forget fragment count in ah
	shr	ax, 8
	add	bx, ax
	jnz	pio_r5
	jmp	pio_r4		;jump if transfer is done

;*************************************************************************
;
;  WORD TRANSFERS for 6360/80286 compatibility
;
;*************************************************************************
	.286p
pio_rdwords:
	mov	ah,BYTE PTR [bp].curlen+2  ;assume < = 1  (length = 64k max)
	mov	bx,[bp].curlen	;data transfer length -> ah bx  [bytes]
	shr	ah,1
	rcr	bx,1		;data transfer length -> bx  [words]
	mov	ah,fifosize/2	;fifo size [words]
	mov	ch,0
	jc	pio_r0a		;jump if length = odd number of bytes

pio_r0:	sub	bl,ah		;words remaining to be transferred
	jc	pio_r10
pio_r11:
	mov	cl,ah
	mov	dl,LOW dmastat	;wait for fifo to fill from target
pio_r2:	in	al,dx
	test	al,dfifofull	;fifo full?
	jz	pio_r12		;  jump if no

	mov	dl,LOW dmadata	;Sparrow dma fifo port address
	rep	insw		;transfer data:  fifo -> host
	jmp	pio_r0

pio_r12:
	test	al,intstat	;scsi interrupt?
	jz	pio_r2		;  jump if no
				;scsi transfer halted.  Flush fifo to host.
	add	bx,fifosize/2
	add	bx,bx		;bx = # of bytes expected from target
	jmp	pio_r9

pio_r10:
	sbb	bh,0		;bx = words remaining to be transferred
	jnc	pio_r11		;  <  dma fifo size?  jump if no
				;		      yes

				;words remaining to be transferred
				;  < dma fifo size.
	add	bx,fifosize/2
	add	bx,bx		;bx = bytes remaining to be transferred
	jz	pio_r4		;jump if transfer is done
	jmp	SHORT pio_r5

pio_r0a:
	sub	bl,ah		;words remaining to be transferred
	jc	pio_r10a
pio_r11a:
	mov	cl,ah
	mov	dl,LOW dmastat	;wait for fifo to fill from target
pio_r2a:
	in	al,dx
	test	al,dfifofull	;fifo full?
	jz	pio_r12a	;  jump if no

	mov	dl,LOW dmadata	;Sparrow dma fifo port address
	rep	insw		;transfer data:  fifo -> host
	jmp	pio_r0a

pio_r12a:
	test	al,intstat	;scsi interrupt?
	jz	pio_r2a		;  jump if no
				;scsi transfer halted.  Flush fifo to host.
	add	bx,fifosize/2
	stc
	adc	bx,bx		;bx = # of bytes expected from target
	jmp	pio_r9

pio_r10a:
	sbb	bh,0		;bx = words remaining to be transferred
	jnc	pio_r11a	;  <  dma fifo size?  jump if no
				;		      yes

				;words remaining to be transferred
				;  < dma fifo size.
	add	bx,fifosize/2
	stc
	adc	bx,bx		;bx = bytes remaining to be transferred
	jz	pio_r4		;jump if transfer is done

;*************************************************************************
;
;  COMMON EXIT FOR READ DWORD/WORD TRANSFERS
;
;*************************************************************************

pio_r5:	mov	dl,LOW dmastat	;wait for all remaining bytes from target
	in	al,dx
	test	al,dfifofull	;dma fifo full?
	jnz	pio_r6		;  jump if yes:  data overrun
	test	al,intstat	;  no.  scsi interrupt?
	jz	pio_r5		;    jump if no
				;    yes


pio_r9:	mov	dl,LOW fifostat	;wait for quiescent fifo
	in	al,dx
pio_r7:	mov	ch,al
	in	al,dx
	cmp	al,ch
	jne	pio_r7
				;ch = # of bytes in dma fifo
	mov	dl,LOW sstat2
	in	al,dx
	and	al,sfull+sfcnt2+sfcnt1+sfcnt0	;# of bytes in scsi fifo
	add	al,ch
	mov	cl,al
	xor	ch,ch		;cx = # of bytes in both fifos


	;check if any data transfer occurred
	or	di,di
	jnz	pio_r8c
	cmp	ah,0
	jne	pio_r8

pio_r8c:
	cmp	bx,cx		;data underrun?
	jna	pio_r6		;  jump if no
				;  yes
pio_r8:
	mov	dl,LOW dmadata
	shr	cx,1		;cx = # of words to transfer to host
				;cf = 1 if odd byte to transfer to host
	rep	insw		;data transfer:  fifo words -> host
	rcl	cx,1
	rep	insb		;data transfer:  last byte (if any) -> host
				;fifo -> host transfer is complete
	mov	dl,LOW simode1	;disable phase change interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al
	pop	es		;restore segment register
	jmp	sio310

pio_r6:
	mov	dl,LOW dmadata
	mov	cx,bx		;normal transfer or data overrun
	shr	cx,1		;cx = # of words to transfer to host
				;cf = 1 if odd byte to transfer to host
	rep	insw		;data transfer:  fifo words -> host
 	rcl	cx,1
	rep	insb		;data transfer:  last byte (if any) -> host
				;fifo -> host transfer is complete


pio_r4:
	pop	es		;restore segment register
	add	[bp].curseg,1000h
	mov	[bp].curoff,0

	mov	cx,[bp].curlen
	mov	bl,byte ptr [bp].curlen+2

pio_r_wholesegs:
	;check for whole segments
	cmp	[bp].wsegs,0
	je	pio_r_esegs

	dec	[bp].wsegs
	mov	[bp].curlen,0
	mov	byte ptr [bp].curlen+2,1
	jmp	pio_r_reset_counters

pio_r_esegs:
	;check for ending segments
	cmp	[bp].escnt,0
	je	pio_r_done

	mov	ax,[bp].escnt
	mov	[bp].curlen,ax
	mov	byte ptr [bp].curlen+2,0
	jmp	pio_r_reset_counters

pio_r_reset_counters:

	mov	dx,sxfrctl0
	in	al,dx
	and	al,NOT scsien
	out	dx,al
	iowait

pio_r15:
	in	al,dx
	test	al,scsien
	jnz	pio_r15

	mov	dx,stcnt0
	in	al,dx
	sub	al,cl
	out	dx,al
	inc	dx
	in	al,dx
	sbb	al,ch
	out	dx,al
	inc	dx
	in	al,dx
	sbb	al,bl
	out	dx,al

	mov	dx,sxfrctl0
	in	al,dx
	or	al,scsien
	out	dx,al

	jmp	pio_read		;next segment -> host


pio_r_done:
	mov	dl,LOW simode1	;disable phase change interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al
	jmp	sio400

	PAGE


;  PIO Write data transfer:  host -> target -

pio_write:
	mov	si,[bp].curoff	;segment offset -> si
	push	ds		;save ds segment register
	mov	ax,[bp].curseg	;target segment -> ds
	mov	ds,ax

	mov	dx,simode1	;enable interrupts -
	in	al,dx		;  scsi reset, phase change, bus free
	or	al,enscsirst+enphasemis+enbusfree
	out	dx,al

	call	getxcfg2byte
	test	al,TXWIDTH32
	jz	pio_wwords

;*************************************************************************
;
;  DOUBLE-WORD TRANSFERS
;
;*************************************************************************

	.386p
pio_wdwords:
	;data transfer length -> ah bx  Max length is 64K (10000H)
	mov	ah,BYTE PTR [bp].curlen+2
	mov	cx,[bp].curlen
	mov	bx,cx

	shr	ah,1
	rcr	bx,1		;data transfer length -> bx  [dwords]
	shr	bx,1

	; save fragment byte count in ah
	mov	ah,cl
	and	ah,3
	xor	ch,ch

;*************************************************************************
;
;  WRITE DOUBLE-WORD TRANSFERS
;
;*************************************************************************
pio_wdw0:
	sub	bx, fifosize/4		;bytes remaining to be transferred
	jc	pio_wdw10
pio_wdw11:
	mov	cl, fifosize/4
	mov	dx, dmastat		;wait for fifo to empty to target
pio_wdw2:
	in	al, dx
	test	al, dfifoemp				;fifo empty?
	jz	pio_wdw12				;  jump if no

	mov	dx, brstcntrl		;Sparrow dma fifo port address
	rep	outsd					;transfer data:  host -> fifo
	jmp	pio_wdw0

pio_wdw12:
	test	al, intstat	;scsi interrupt?
	jz	pio_wdw2		;  jump if no

	add	bx, fifosize/4	;  < dma fifo size.
	shl	bx, 2		;bx = bytes remaining to be transferred
	; don't forget fragment byte count
	shr	ax, 8
	add	bx, ax
	jmp	pio_w7

pio_wdw10:
				;words remaining to be transferred
	add	bx, fifosize/4	;  < dma fifo size.
	shl	bx, 2		;bx = bytes remaining to be transferred
	; don't forget fragment byte count
	shr	ax, 8
	add	bx, ax
	jz	pio_w4		;jump if transfer is done
	jmp	SHORT pio_w1

;*************************************************************************
;
;  WORD TRANSFERS for 6360/80286 compatibility
;
;*************************************************************************
	.286p
pio_wwords:
	mov	ah,BYTE PTR [bp].curlen+2  ;assume < = 1  (length = 64k max)
	mov	bx,[bp].curlen	;data transfer length -> ah bx  [bytes]
	shr	ah,1
	rcr	bx,1		;data transfer length -> bx  [words]
	mov	ah,fifosize/2	;fifo size [words]
	mov	ch,0
	jc	pio_w0a		;jump if length = odd number of bytes

pio_w0:	sub	bl,ah		;words remaining to be transferred
	jc	pio_w10
pio_w11:
	mov	cl,ah
	mov	dl,LOW dmastat	;wait for fifo to empty to target
pio_w2:	in	al,dx
	test	al,dfifoemp	;fifo empty?
	jz	pio_w12		;  jump if no

	mov	dl,LOW dmadata	;Sparrow dma fifo port address
	rep	outsw		;transfer data:  host -> fifo
	jmp	pio_w0

pio_w12:
	test	al,intstat	;scsi interrupt?
	jz	pio_w2		;  jump if no
	add	bx,fifosize/2
	add	bx,bx		;bx = # of bytes expected from target
	jmp	pio_w7

pio_w10:
	sbb	bh,0		;bx = words remaining to be transferred
	jnc	pio_w11		;  < dma fifo size?   jump if no
				;		      yes

				;words remaining to be transferred
	add	bx,fifosize/2	;  < dma fifo size.
	add	bx,bx
	jz	pio_w4		;jump if transfer is done
	jmp	SHORT pio_w1

pio_w0a:
	sub	bl,ah		;words remaining to be transferred
	jc	pio_w10a
pio_w11a:
	mov	cl,ah
	mov	dl,LOW dmastat	;wait for fifo to empty to target
pio_w2a:
	in	al,dx
	test	al,dfifoemp	;fifo empty?
	jz	pio_w12a		;  jump if no

	mov	dl,LOW dmadata	;Sparrow dma fifo port address
	rep	outsw		;transfer data:  host -> fifo
	jmp	pio_w0a

pio_w12a:
	test	al,intstat	;scsi interrupt?
	jz	pio_w2a		;  jump if no
	add	bx,fifosize/2
	stc
	adc	bx,bx		;bx = # of bytes expected from target
	jmp	pio_w7

pio_w10a:
	sbb	bh,0		;bx = words remaining to be transferred
	jnc	pio_w11a	;  < dma fifo size?   jump if no
				;		      yes

				;words remaining to be transferred
	add	bx,fifosize/2	;  < dma fifo size.
	stc
	adc	bx,bx
	jz	pio_w4		;jump if transfer is done

;*************************************************************************
;
;  COMMON EXIT FOR WRITE TRANSFERS
;
;*************************************************************************

pio_w1:	mov	cx,bx
 	mov	dl,LOW dmastat	;wait for fifo to empty to target
pio_w5:	in	al,dx
	test	al,intstat	;scsi interrupt?
	jnz	pio_w7		;  jump if yes
	test	al,dfifoemp	;fifo empty?
	jz	pio_w5		;  jump if no

	mov	dl,LOW dmadata	;Sparrow dma fifo port address
	shr	cx,1		;cx = # of words to transfer from host
				;cf = 1 if odd byte to transfer from host
	rep	outsw		;data transfer:  host words -> fifo
	rcl	cx,1
	rep	outsb		;data transfer:  last byte (if any) <- host
				;host -> fifo transfer is complete
	
				;end of data transfer from host
pio_w4:	pop	ds		;restore segment registers

	;more whole segements to transfer ?
	cmp	[bp].wsegs,0
	je	piow_EndFrag

	mov	[bp].curlen,0
	mov	byte ptr [bp].curlen+2,1
	add	[bp].curseg,1000h
	mov	[bp].curoff,0
	dec	[bp].wsegs
	jmp	short pio_w13

	; check for end fragment
piow_EndFrag:
	cmp	[bp].escnt,0
	je	pio_w3		; done

	; point to ending fragment segment
	add	[bp].curseg,1000h
	mov	ax, [bp].escnt
	mov	[bp].curlen,ax
	mov	byte ptr [bp].curlen+2,0
	mov	[bp].curoff,0
	mov	[bp].escnt,0
	jmp	short pio_w13

pio_w3:	mov	dl,LOW sstat2	;wait for scsi fifo to empty
	in	al,dx
	test	al,sempty
	jnz	pio_w6		;jump if write across scsi is done
	mov	dl,LOW dmastat
	in	al,dx
	test	al,intstat	;scsi interrupt?
	jz	pio_w3		;  jump if no:  continue waiting
	mov	dl,LOW sstat2	;  yes.  fifo empty?
	in	al,dx
	test	al,sempty
	jnz	pio_w6		;  jump if yes:  data transfer is done
pio_w8:				;  no:  data underrun
	mov	dl,LOW simode1	;disable phase change interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al
	jmp	sio310	

pio_w7:	pop	ds		;data underrun
	jmp	SHORT pio_w8

pio_w6:				;end of data transfer to target
	mov	dl,LOW simode1	;disable phase change interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al
	jmp	sio400

pio_w13:
	mov	dx,sstat2	;wait for scsi fifo to empty
	in	al,dx
	test	al,sempty
	jnz	pio_w6a		;jump if write across scsi is done
	mov	dl,LOW dmastat
	in	al,dx
	test	al,intstat	;scsi interrupt?
	jz	pio_w13		;  jump if no:  continue waiting
	jmp	pio_w8		;segment data underrun

				;end of segment transfer to target.
				;not last segment;  start next segment.
pio_w6a:
				;clear 6260 Scsi Transfer Counter
	mov	dx,sxfrctl0
	in	al,dx
	or	al,clrstcnt
	out	dx,al

	jmp	pio_write	;transfer next segment to host

	PAGE


;  end of data transfer  -  All bytes have been transferred to/from host.


sio400:	mov	dx,sxfrctl0	;disable dma
	mov	al,ch1ch2
	out	dx,al
 	mov	dl,LOW dmacntrl0
	xor	al,al
	out	dx,al

	mov	dl,LOW sstat2	;if either fifo not empty,
	in	al,dx
	test	al,sempty
	jz	sio402
	mov	dl,LOW dmastat
	in	al,dx
	test	al,dfifoemp
	jnz	sio403
sio402:	mov	[bp].dhst,err12 ;  then data overrun.
sio403:
	call	wt4req		;next phase =
sio401:	out	dx,al		;define expected phase = current phase
	cmp	al,stphase	;	status?
	jne	j14
	jmp	siostat 	;		jump if yes
j14:	cmp	al,miphase	;	message in?
	je	sio411		;		jump if yes
	cmp	al,mophase	;	message out?
	jne	sio540		;		jump if no
	call	sendmo		;send message out to target
	jmp	SHORT sio401

sio411:				;phase = Message In during data transfer
	call	ckmsgi		;handle message from target
				;if message = disconnect, return to here
				;  after reselection.
	jmp	siodata		;restart data transfer

sio500:				;no data to be transferred
	mov	dx,simode1	;wait for next req
	in	al,dx
	or	al,enreqinit+enscsirst+enbusfree
	out	dx,al
;+W	mov	dl,LOW sstat1
;+W	in	al,dx
;+W	test	al,reqinit
;+W	jnz	sio510
;+W	call	waitfor

sio509:	mov	dx,sstat1	;+W
	in	al,dx		;+W
	test	al,reqinit	;+W
	jz	sio508		;+W
	mov	dl,LOW scsisig	;+W
	in	al,dx		;+W
	test	al,acki		;+W
	jnz	sio509		;+W
	mov	dl,LOW sstat1	;+W
	in	al,dx		;+W
	test	al,reqinit	;+W
	jnz	sio510		;+W
sio508:	call	waitfor		;+W

sio510:	mov	dx,simode1	;disable latched req interrupt
	in	al,dx
	and	al,NOT enreqinit+enbusfree
	out	dx,al
sio511:	mov	dx,scsisig	;
	in	al,dx		;define expected phase = current phase
	and	al,busphase
sio513:	out	dx,al		;scsi phase =
	cmp	al,stphase	;	status?
	jne	j15
	jmp	siostat 	;		jump if yes
j15:	cmp	al,mophase	;	message out?
 	je	sio512		;		jump if yes
	cmp	al,miphase	;	message in?
	jne	sio540		;		jump if no
	call	ckmsgi		;handle message from target
	call	wt4req		;possible reselection here
	jmp	SHORT sio513

sio512:				;phase = Message Out
	call	sendmo		;message -> target
	jmp	SHORT sio511

sio540:	test	al,cdi+msgi	;phase = data?
	jz	j16
	jmp	badseq		;  jump if no:  invalid phase
j16:	mov	dx,sxfrctl1	;handshake all data in bit bucket mode
	in	al,dx
	or	al,bitbucket
	out	dx,al
	mov	dl,LOW simode1	;enable interrupt on phase mismatch
	in	al,dx
	or	al,enphasemis+enscsirst+enbusfree
	out	dx,al
	call	waitfor		;wait for end of data phase
	mov	dx,sxfrctl1	;disable bit bucket mode
	in	al,dx
	and	al,NOT bitbucket
	out	dx,al
	mov	dl,LOW simode1	;disable phase mismatch interrupt
	in	al,dx
	and	al,NOT enphasemis+enbusfree
	out	dx,al

	mov	dl,LOW scsisig	;
	in	al,dx		;define expected phase = current
	and	al,busphase
sio548:	out	dx,al		;next bus phase =
	cmp	al,stphase	;	status?
	je	sio550		;		jump if yes
	cmp	al,mophase	;	message out?
	je	sio547		;		jump if yes
	cmp	al,miphase	;	message in?
	jne	sio540		;		jump if no
	
	call	ckmsgi		;	yes:  handle message from target
	call	wt4req
	jmp	SHORT sio548

sio547:	call	sendmo		;send message byte to target
	jmp	SHORT sio548

sio550:	call	scstmsg		;get completion status & message from target
	mov	ah,err12	;host status = data overrun
	jmp	bad0

;  scsi phase = COMPLETION STATUS
 
siostat:
	call	scstmsg		;get completion status & message
	mov	[bp].dhst,err00	;set HA Status = no error
	jmp	siodone		;end of command.  Return to caller.


;  phase = Status before phase = Command or Data

siobusy:			;get completion status & message
	jmp	siostat		;retry for "busy" is performed by SCSI Manager

	

;  Get completion status and message from target.
;
;

scstmsg:			;subroutine -
	mov	dx,sxfrctl0	;disable scsi transfer to dma fifo
	mov	al,ch1ch2
	out	dx,al

	mov	dl,LOW clrsint1	;clear any Attention which the target has not
	mov	al,clratno	;  responded to.  It can't be important now.
	out	dx,al		;

	mov	dl,LOW scsisig	;expected phase = status
	mov	al,stphase
	out	dx,al

	mov	dl,LOW scsidat	;+R  read in target status
	in	al,dx
	mov	[bp].dtst,al	;  & save it in scb.

	call	ackreq		;wait for next req
scstms5:
	cmp	al,miphase	;phase = message in?
	out	dx,al		;define expected phase, whatever it is
	jne	scstms0		;  jump if no:  problem
	mov	dl,LOW scsidat	;+R  read in message from target
	in	al,dx
	mov	ah,al
	call	scsiack
	cmp	ah,msg00	;message = Command Complete?
	jne	scstms1		;  jump if no:  problem

scstms2:			;wait for bus to go free:  Need to wait (expect
	mov	dl,LOW sstat1	;-ing a short wait) to be sure that seldo
	in	al,dx		;status has been cleared by bus free before
	test	al,busfree	;starting another scsi command.
	jz	scstms2

	ret

scstms0:			;not Message In phase
	cmp	al,mophase	;Message Out phase?
	jne	scstms1		;  jump if no:  invalid phase
	call	sendmo		;  yes.  message -> target
	jmp	scstms5

scstms1:
	add	sp,2		;pop return addr off stack
	jmp	badseq		;error:  invalid scsi sequence


badseq:				;error:  invalid scsi sequence
	call	rstscsi		;reset scsi bus
	mov	ah,err14	;host status = invalid sequence
bad0:	mov	[bp].dhst,ah
	mov	[bp].dtst,0

siodone:
	jmp	return		;return to Sparrow BIOS Driver caller

	PAGE
;******************************************************************************
;
;  Sparrow interrupt handler
;
;******************************************************************************

spar_int:
	mov	dx,dmastat	;Sparrow interrupt?
	in	al,dx
	test	al,intstat
	jz	spar_int	;  wait until yes

	mov	dl,LOW simode0	;look only at status bits for which interrupt
	in	al,dx		;  interrupt has been enabled.
	mov	bl,al
	mov	dl,LOW simode1
	in	al,dx
	mov	bh,al

	test	bh,enbusfree	;bus free interrupt enabled?
	jz	spar_in0	;  jump if no
	and	bl,NOT enseldi	;  yes.  If bus free has not occurred, an active
spar_in0:			;  reselected status is old:  ignore it.  If an
				;active reselected status is current, bus free
				;had to have occurred, & will be handled first.

	mov	dl,LOW sstat1	;look at interrupts in order of priority
	in	al,dx
	and	al,bh
	test	al,scsirsti	;scsi bus reset?
	jz	j41
	jmp	intsrst		;  jump if yes
j41:	test	al,selto	;selection timeout?
	jz	j17
	jmp	inttmout 	;  jump if yes
j17:	test	al,busfree	;bus free?
	jnz	intfree		;  jump if yes

	mov	dl,LOW sstat0	;
	in	al,dx
	and	al,bl
	test	al,seldo	;selection complete?
	jz	j18
	jmp	intsel		;  jump if yes
j18:	test	al,seldi	;have we been reselected by target?
	jz	j19
	jmp	intrsel 	;  jump if yes
j19:	test	al,dmadone	;dma done?
	jz	j20
	jmp	ret2active 	;  jump if yes:  return to the active scb
j20:	mov	dl,LOW sstat1
	in	al,dx
	and	al,bh
	test	al,phasemis	;phase <> expected?
	jz	j21
	jmp	ret2active 	;  jump if yes:  return to the active scb
j21:	test	al,reqinit	;req from target?
	jz	j22

	mov	dl,LOW scsisig	;+W
	in	al,dx		;+W
	test	al,acki		;+W
	jnz	j22		;+W
	mov	dl,LOW sstat1	;+W
	in	al,dx		;+W
	and	al,bh		;+W
	test	al,reqinit	;+W
	jz	j22		;+W

	jmp	ret2active 	;  jump if yes:  return to the active scb
j22:
	jmp	spar_int	;whatever caused the interrupt has been cleared



intfree:			;bus free interrupt occurred
	mov	[bp].dhst,err13 ;unexpected bus free -> host status
	mov	dx,sxfrctl0	;disable dma
	mov	al,ch1ch2
	out	dx,al
	mov	dl,LOW dmacntrl0
	xor	al,al
	out	dx,al
	mov	dl,LOW sxfrctl1	;disable bit bucket mode
	in	al,dx
	and	al,NOT bitbucket
	out	dx,al

	mov	dl,LOW simode1	;disable & clear bus free interrupt
	in	al,dx
	and	al,NOT enbusfree
	out	dx,al
	mov	dl,LOW clrsint1
	mov	al,clrbusfree
	out	dx,al
	jmp	return

intsrst:			;scsi bus reset occurred
	mov	[bp].dhst,err1b ;scsi reset error -> host status
intsr0:	call	init_spar	;clear interrupts & initialize Sparrow

        call    async_xfer_option	;scsi transfer option = asynchronous
	jmp	return


				;selection of target completed
intsel:	ret			;pop return addr off stack,
				;  and resume command from this address.

abort_targ:			;abort message -> target
	call	wt4req		;atn is asserted;  wait for req
	mov	ah,al		;bus phase
intse2:	cmp	ah,mophase	;phase = message out?
	jne	intse1		;  jump if no:  can't abort
	mov	dl,LOW clrsint1	;deassert atn
	mov	al,clratno
	out	dx,al
	mov	dl,LOW scsisig
	mov	al,mophase	;expected phase = message out
	out	dx,al
	mov	al,msg06	;abort message -> target
	mov	dl,LOW scsidat
	out	dx,al
	call	scsiack		;complete handshake

intse5:				;wait for bus to go free:  Need to wait (expect
	mov	dl,LOW sstat1	;-ing a short wait) to be sure that seldi,seldo
	in	al,dx		;status has been cleared by bus free before
	test	al,busfree	;the next Sparrow interrupt.
	jz	intse5


intse4:				;configure interrupts for return -
	mov	dl,LOW clrsint1	;deassert atn
	mov	al,clratno
	out	dx,al
	mov	dl,LOW simode1	;disable bus free interrupt
	in	al,dx
	and	al,NOT enbusfree+enphasemis+enscsiperr+enphasechg+enreqinit
	out	dx,al
	mov	dl,LOW scsiseq	;disable parity checking
	in	al,dx
	and	al,NOT enautoatnp
	out	dx,al
	mov	dl,LOW sxfrctl1
	in	al,dx
	and	al,NOT enspchk
	out	dx,al
	jmp	return

intse1:				;can't abort.  Wait for phase = msg out or free
	mov	al,ah		;set expected phase = current phase
	mov	dl,LOW scsisig
	out	dx,al
	mov	dl,LOW sxfrctl1	;set mode = bit bucket
        in      al,dx
	or	al,bitbucket
	out	dx,al
	mov	dl,LOW sstat1	;wait for a scsi phase change
intse3:	in	al,dx
	test	al,scsirsti+phasemis+busfree
	jz	intse3
	test	al,scsirsti+busfree
	jnz	intse4		;jump if target is off the bus
	mov	dl,LOW scsisig	;phase changed.  Check it out.
	in	al,dx
	and	al,busphase
	mov	ah,al
	jmp	intse2



inttmout:			;selection timeout occurred
 	mov	dx,scsiseq	;disable selection out & auto atn
	in	al,dx
	and	al,NOT enselo+enautoatno
	out	dx,al
	mov	dl,LOW sxfrctl1	;disable selection timer
	in	al,dx
	and	al,NOT enstimer
	out	dx,al
	mov	dl,LOW clrsint1	;clear timeout interrupt
	mov	al,clrseltimo
	out	dx,al

	mov	[bp].dhst,err11 ;selection timeout status -> host status
	jmp	return

ret2active:			;return to the active scb -
	ret		  	;get return addr saved on stack, and
				;  resume from this address.
	PAGE
;******************************************************************************
;
;  Reselected by target
;
;******************************************************************************

intrsel:
				;+R  workaround deleted

	mov	dx,scsiseq	;disable reselection for the following clears
	in	al,dx
	and	al,NOT enrseli
	out	dx,al
	mov	dl,LOW clrsint0	;clear reselected interrupt
	mov	al,clrseldi	;  Does not clear seldi.
	out	dx,al

	mov	dl,LOW clrsint1	;clear bus free interrupt
	mov	al,clrbusfree
	out	dx,al

	mov	dl,LOW sstat0	;has bus gone free since reselection?
	in	al,dx
	mov	ah,al
	mov	dl,LOW scsiseq	;re-enable reselection
	in	al,dx
	or	al,enrseli
	out	dx,al
	test	ah,seldi
	jnz	j23
	jmp	spar_int 	;  jump if yes:  wait for another resel
j23:
	call	read_porta
	and	al,adapid
	mov	cl,al
	inc	cl
	xor	ah,ah
	stc
	rcl	ah,cl		;  ah = adapter id, 1-of-8
	mov	dx,selid	;get ids from scsi bus
	in	al,dx
	xor	al,ah		;mask out adapter id
	mov	ah,0ffh		;convert target id to binary
intrs0:	inc	ah
 	shr	al,1
	jnc	intrs0
	ror	ah,3		;bits 7-5 = target id
	call	config4parity	;configure 6360 for parity detection
	call	wt4req		;wait for 1st req
intrs1:	cmp	al,miphase	;phase = message in?
	je	intrs2		;  jump if yes
	cmp	al,mophase	;      = message out?
	je	j24
	jmp	intrs3		;  jump if no:  error - no identify message
j24:	call	sendmo		;  yes.  Send message to target.
	jmp	SHORT intrs1

intrs2:	out	dx,al		;expected phase = message in
	mov	dl,LOW scsidat	;+R  read in message from target
	in	al,dx
	test	al,80h		;message = identify?
	jnz	j25
	jmp	intrs3		;  jump if no:  abort
j25:	and	al,07h		;  yes.  Save lun.
	or	ah,al		;ah = target id/lun

	cmp	ah,[bp].dlun	;is reconnecting targ/lun the same targ/lun
	jne	intrs3		;  that disconnected?  Jump if no.

	call	xfer_option	;load Sparrow transfer speed option
	in	al,dx
	and	al,7fh		;  -> Sparrow.  Configuration Sparrow in
	call	config4data	;  anticipation of an immediate sync data xfer.

intrs15:
	call	ackreq		;ack for id msg.  Wait for req.
intrs13:
	cmp	al,miphase	;phase = message in?
	je	intrs11		;  jump if yes
	cmp	al,mophase	;	 message out?
 	jne	intrs12		;  jump if no:  complete reselection
	call	sendmo		;  yes.  message -> target.
	jmp	SHORT intrs13	;look at phase after next req

intrs11:			;phase = message in after Identify from target
	out	dx,al		;expected phase = message in
	mov	dl,LOW scsidat	;+R  read in message from target
	in	al,dx
	cmp	al,msg03	;message = Restore Data Pointers?
	je	intrs15		;  jump if yes
	test 	al,80h		;	 = Identify?
	jnz	intrs15		;  jump if yes (Should also check for con-
				;		sistent lun.)
	cmp	al,msg02	;	 = Save Data Pointers?
	je	intrs15		;  jump if yes
	cmp	al,msg08	;	 = nop?
	je	intrs15		;  jump if yes
	cmp	al,msg01	;	 = Extended Message?
	je	intrs12		;  jump if yes
	cmp	al,msg04	;	 = Disconnect?
	je	intrs16		;  jump if yes
				;invalid message in

				;reselection failed - reset scsi
	call	rstscsi
	mov	[bp].dhst,err14 ;14 -> host status
	jmp	return

	
intrs3:				;reselection w/o identify message - reset
	call	rstscsi		;
	mov	[bp].dhst,err14 ;phase sequence error -> host status
	jmp	return

				;complete reselection
intrs12:
	mov	dl,LOW scsiseq	;disable reselection until next disconnect:
	in	al,dx		;  BIOS is single threaded.
	and	al,NOT enrseli
	out	dx,al
 	ret		  	;continue execution at addr saved on stack

intrs16:			;message = Disconnect
	call	scsiack		;complete handshake
	jmp	spar_int

	PAGE
;******************************************************************************
;
;  Message In handler
;
;******************************************************************************

ckmsgi:	mov	dx,sxfrctl0	;disable data channel
	mov	al,ch1ch2
	out	dx,al
	mov	dl,LOW simode1	;enable bus free & scsi reset detection
	mov	al,enbusfree+enscsirst
	out	dx,al
	mov	dl,LOW scsisig	;define expected scsi phase
	in	al,dx
	and	al,busphase
	out	dx,al

	mov	dl,LOW scsibus	;get message byte from bus
	in	al,dx
	cmp	al,msg02	;	Save Data Pointers?
	je	svdptr		;		jump if yes
	cmp	al,msg01	;	Extended Message?
	jne	j26
	jmp	extnmsg 	;		jump if yes
j26:	cmp	al,msg04	;	Disconnection?
	jne	j27
	jmp	discon		;		jump if yes
j27:	cmp	al,msg07	;	Message Reject?
	je	ckmsg0		;		jump if yes
	cmp	al,msg08	;	NOP?
	je	ckmsg0		;		jump if yes

msgrej:				;reject the message
        call    msgrej$
	jmp	SHORT ckmsg1


ckmsg0:	call	ackreq		;complete message handshake,
ckmsg1:	cmp	al,miphase	;  & check next scsi phase.
	je	ckmsgi		;jump if another message in
	ret

msgrej$:			;subroutine:  reject the current message in
	mov	dx,scsisig	;assert attn & complete msg in handshake
	mov	al,atno+miphase
	out	dx,al
	call	ackreq		;  assert ack & wait for next req
	mov	ah,al		;Since atn was asserted before ack, next phase
				;must be Message Out.
	mov	dl,LOW clrsint1	;clear atn
	mov	al,clratno
	out	dx,al
	cmp	ah,mophase
	mov	dl,LOW scsisig	;pass out:  dx = scsisig
	mov	al,ah		;	    al = scsi phase
	je	$+3
	ret			;return if not expected phase
	out	dx,al		;define expected phase
	mov	dl,LOW scsidat	;send Message Reject message to target
	mov	al,msg07	;
	out	dx,al
	jmp	ackreq		;complete handshake & wait for next req
				;  & return

;  message = Save Data Pointers

svdptr:	mov	dx,stcnt0
	in	al,dx		;# of bytes xferred across scsi, lsb
				;update scb transfer count to number of bytes
				;  remaining to be transferred.
	sub	BYTE PTR [bp].curlen,al
	inc	dx
	in	al,dx
	sbb	BYTE PTR [bp].curlen+1,al
	inc	dx
	in	al,dx
	sbb	BYTE PTR [bp].curlen+2,al
	jc	svdpt2		;jump if data overrun

				;offset addressing -
	mov	dl,LOW stcnt0	;generate new starting segment offset
	in	al,dx		;# of bytes transferred across scsi, lsb
	add	BYTE PTR [bp].curoff,al
	inc	dx
	in	al,dx
	adc	BYTE PTR [bp].curoff+1,al
svdpt1:
	jmp	ckmsg0		;end of message
	
svdpt2:	xor	ax,ax		;data overrun:  0 ->  curlen
	mov	WORD PTR [bp].curlen,ax
	mov	BYTE PTR [bp].curlen+2,al
	jmp	SHORT svdpt1

	
;  message = Extended Message

extnmsg:
	mov	[bp].extmsg,0ffh ;flag first entry into extmsg1:
extmsg1:
	call	ackreq		;get 2nd byte of extended message
	cmp	al,miphase
	je	$+3
	ret			;return if not still in Message In phase

	mov	dl,LOW scsidat	;2nd byte = message length
	in	al,dx
	mov	cl,al
	mov	bx,extmsg+1
	add	bx,bp
getem1:	mov	ss:[bx],al
	inc	bx
	call	ackreq		;get 3rd message byte
	cmp	al,miphase
	je	$+3
	ret			;return if not still in Message In phase
	mov	dl,LOW scsidat
	in	al,dx
	dec	cl
	jnz	getem1		;loop until last byte
	mov	ss:[bx],al	;last extended message byte

	mov	bx,extmsg	;2nd message byte = length
	add	bx,bp
	cmp	BYTE PTR ss:[bx].1,03 ;sync xfer negotiation?
	je	j29
getem6:	jmp	msgrej		;if not, reject message
j29:	cmp	BYTE PTR ss:[bx].2,01 ;sync xfer negotiation message:
	jne	getem6		;	length = 03
				;	message = 01
	call	synmsgi		;analyze offset, rate
	jc	getem2		;jump if negotiation needed
	cmp	BYTE PTR ss:[bx],0ffh ;Negotiation not needed.  First message
	je	getem2		;  exchanged?  Jump if yes.
	call	syncset		;set sync transfer control
	and	ah,7fh		;set up Sparrow here in case next phase is
	mov	al,ah		;  sync data.
	call	config4data
	call	ackreq		;assert ack & wait for req
getem4:	cmp	al,miphase	;still in Message In phase?
	jne	j40
	jmp	ckmsgi		;  jump if yes:  Get next message.
j40:	ret

getem2:				;try to send negotiation message to target
        call    extmsgo
	jc	getem4		;  jump if not successful
	call	syncset		;set sync transfer control
	and	ah,7fh		;set up Sparrow here in case next phase is
	mov	al,ah		;  sync data.
	call	config4data
	call	ackreq		;assert ack & wait for req
	cmp	al,miphase	;phase = Message In?
	je	getem5		;  jump if yes
	ret			;  no.  return
getem5:	out	dx,al		;define expected phase in case msg = Extended
	mov	dl,LOW scsidat	;+R  message = Extended?
	in	al,dx
	cmp	al,msg01
        je      extmsg1         ;  yes.  Try again.
	jmp	ckmsgi		;  no.  Handle the new Message In.


				;subroutine -
				;  pass out:  carry = 1:  negotiation needed
				;  pass thru:  bx
synmsgi:			;analyze the sync xfer message
	call	read_portb              ;read port B information in AL	

        mov     cl, sync_rate           ;assume 5 MBytes/sec 
        and     al, FAST_SCSI
        jz      synmsgi_0               ;=> 5 MBytes/sec transfer rate
        mov     cl, sync_rate_ef        ;10 MBytes/sec            

synmsgi_0:
	mov	ah,ss:[bx].3	;minimum delay between req's, from message
	mov	al,ss:[bx].4	;sync xfer offset count, from message
	cmp	al,sync_offset+1
	jc	synm10		;if offset count too large,
	mov	BYTE PTR ss:[bx].4,sync_offset ;  set it back to max value.
	cmp	ah,cl		;sync_rate
	jnc	synm05				;if req delay < sync_rate,
	mov	BYTE PTR ss:[bx].3,cl		;sync_rate set it back to sync_rate.
	ret			;carry =1:  negotiation needed

synm05:	cmp	ah,113
	jnc	synm16		;if req delay > 113, set offset to 0
	ret			;carry = 1

synm10:	and	al,al		;if offset = 0, ignore the delay
	jnz	synm11
	ret			;carry = 0

synm11:	cmp	ah,cl		;sync_rate
	jnc	synm15				;if req delay < sync_rate,
	mov	BYTE PTR ss:[bx].3,sync_rate	;  set it to sync_rate.
	ret			;carry = 1

synm15:	cmp	ah,113
	jnc	synm16		;jump if req delay > = 113  (452 ns)
	clc			;carry = 0
	ret
 
synm16:	mov	BYTE PTR ss:[bx].4,0 ;set offset to 0
	stc			;carry = 1
	ret


				;subroutine -
				;  pass out:  ah = sync transfer control
syncset:			;generate sync transfer control byte for chip
	mov	bx,xfrcnt
	add	bx,bp
	mov	al,ss:[bx]	;al = transfer period  [4 ns]
	mov	ah,0
	cmp	al,25		;
	je	synm40		;jump if = 25  ->  00		(100 ns)
	mov	ah,10h
	cmp	al,38
	jc	synm40		;	 = < 37  ->  10		(148 ns)
	mov	ah,20h
	cmp	al,51
	jc	synm40		;	 = < 50  ->  20		(200 ns)
	mov	ah,30h
	cmp	al,63
	jc	synm40		;	 = < 62  ->  30		(248 ns)
	mov	ah,40h
	cmp	al,76
	jc	synm40		;	 = < 75  ->  40		(300 ns)
	mov	ah,50h		;
	cmp	al,88
	jc	synm40		;	 = < 87  ->  50		(348 ns)
	mov	ah,60h
	cmp	al,101
	jc	synm40		;	 = < 100  ->  60	(400 ns)
	mov	ah,70h
synm40:	or	ah,ss:[bx].1	; + sync xfer offset
	or	ah,80h		;turn on negotiated indicator
	call    xfer_option	;derive pointer to data transfer option
	mov	al,ah
	out	dx,al		;store sync transfer control
	ret

;  Start synchronous transfer negotiation.

				;pass in:  SCSI phase = message out
synnego:
	mov	dx,scsisig	;raise atn
	mov	al,atno+mophase
	out	dx,al
	mov	bx,xfrcnt
	add	bx,bp

	call	read_portb
        mov     cl, sync_rate           ;assume 5 MBytes/sec 
        and     al, FAST_SCSI
        jz      synnego_0               ;=> 5 MBytes/sec transfer rate
        mov     cl, sync_rate_ef        ;10 MBytes/sec            

synnego_0:
	mov	BYTE PTR ss:[bx], cl
	mov	BYTE PTR ss:[bx].1,sync_offset ;max sync offset allowed by Sparrow
				;flag negotiation done here in case of
				;  negotiation failure.  Default to async.
	call 	xfer_option	;derive pointer to data transfer option
	mov	al,80h
	out	dx,al

        call    syno00          ;send sync transfer message out to target


	jnc	$+3
 	ret			;return if not successful

	call	ackreq		;complete handshake & wait for next req
	cmp	al,miphase	;phase = message in?
	je	$+3		;
	ret			;  return if no
				;  yes
	out	dx,al		;define expected phase
	mov	dl,LOW scsidat	;+R  read in message from target
	in	al,dx
	cmp	al,msg01	;message = Extended?
	jne	j31
	jmp	extmsg1 	;  jump if yes
j31:	ret			;  no.  return




;  Send sync transfer message out to target.

				;pass out:  carry = 1 for error return
				;	    al = bus phase when carry =1
extmsgo:
	mov	dx,scsisig	;assert atn
	mov	al,atno+miphase
	out	dx,al
	call	ackreq		;assert ack & wait for next req
	cmp	al,mophase	;phase = message out?
	jne	syno20		;  jump if no:  error return
	or	al,atno		;assert atn
	out	dx,al


syno00:                         ;build extended message
	mov	bx,extmsg
	add	bx,bp
	mov	BYTE PTR ss:[bx],01     ;1st 3 bytes:  01  03  01
	mov	BYTE PTR ss:[bx].1,03
	mov	BYTE PTR ss:[bx].2,01

	mov	cx,4			;send 1st 4 bytes to target
syno10:
	mov	dl,LOW scsidat
	mov	al,ss:[bx]
	out	dx,al
	inc	bx
	call	ackreq		;assert ack & wait for next req
	cmp	al,mophase	;phase = message out?
	jne	syno20		;  jump if no

				;+R  workaround deleted

	loop	syno10
	mov	dl,LOW scsidat
	mov	al,ss:[bx]	;last byte -> target
	out	dx,al
	mov	dl,LOW clrsint1	;clear atn
	mov	al,clratno
	out	dx,al
	clc			;pass out:  carry = 0
        ret

syno20:
	mov	ah,al		;save pass-out
	mov	dl,LOW clrsint1	;clear atn
	mov	al,clratno
 	out	dx,al
	mov	al,ah		;pass out:  al = bus phase
	stc			;	    carry = 1
        ret




;  message = Disconnect

discon:				;jumpered to allow disconnection?
	mov	dx,dmacntrl1
	mov	al,portb$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	test	al,endiscon
	jnz	j32
	jmp	msgrej		;  jump if no:  reject message
j32:
	mov	dx,simode1	;disable & clear bus free interrupt
	in	al,dx
	and	al,NOT enbusfree
	out	dx,al
	mov	dl,LOW clrsint1
	mov	al,clrbusfree
	out	dx,al
	mov	dl,LOW scsiseq	;enable reselected interrupt
	in	al,dx
	or	al,enrseli
	out	dx,al
	mov	dl,LOW simode0
	in	al,dx
	or	al,enseldi
	out	dx,al
	call	scsiack		;complete message handshake

disco0:				;wait for bus to go free:  Need to wait (expect
	mov	dl,LOW sstat1	;-ing a short wait) to be sure that seldi
	in	al,dx		;status has been cleared by bus free before
	test	al,busfree	;the next Sparrow interrupt.
	jz	disco0

				;expect a long wait  -  return cpu to system
;********************************
;  long_wait routine -
;
;	Anticipate a long wait.  Return the cpu to the system.
;	Return from this subroutine after a Sparrow interrupt.

long_wait:
	mov	dx,dmacntrl0	;enable Sparrow interrupt to the system
	in	al,dx
	or	al,inten
	out	dx,al

long_wai0:
				;  return cpu to system while waiting

	;***********************
;	A substantial delay is anticipated.  Return the CPU to the system via
;	INT 15.  INT 15 will return to this subroutine on its own accord or
;	when prompted by a Sparrow interrupt.  This routine is operating system
;	- dependent, and belongs in atsbios.asm, but has been located here to
;	to save a stack level.

	mov	ah,90h
	mov	al,00h
	int	15h
	;***********************



	mov	dl,LOW dmastat	;did a Sparrow interrupt occur?
	in	al,dx
	test	al,intstat
	jz	long_wai0	;  jump if no:  continue waiting

	mov	dl,LOW dmacntrl0 ;disable Sparrow interrupt to the system
	in	al,dx
	and	al,NOT inten
	out	dx,al

;********************************

				;Sparrow interrupt returns cpu to here.
	jmp	spar_int	;handle Sparrow interrupt
				;spar_int will return to the caller of ckmsgi

return:	mov	dx,dmacntrl0	;make sure Sparrow interrupt is disabled
	xor	al,al
	out	dx,al

	mov	dl,LOW porta	;turn led off
	mov	al,0
	out	dx,al

	IFDEF	B636
	IFNDEF	Intel
	mov	dl,LOW dmacntrl1 ;+P  power down 6360
	mov	al,pwrdwn	;+P
	out	dx,al		;+P
	ENDIF
	ENDIF

	mov	sp,[bp].original_sp ;restore original sp
	
	ret			;return to caller

	PAGE
;******************************************************************************
;
;  SUBROUTINES
;
;******************************************************************************

;  Check for bus free or scsi reset.  If neither, return.  If one or the other,
;  exit the caller, and respond to the condition.

ckreset:
	mov	dx,sstat1	;scsi reset or bus free?
	in	al,dx
	test	al,busfree+scsirsti
 	jnz	$+3		;  jump if yes
	ret			;  no.  return

	public	unknown_nesting
unknown_nesting:
	mov	sp,[bp].original_sp ;restore stack pointer
	test	al,scsirsti	;scsi reset?
	jnz	j33		;  jump if yes
	jmp	intfree 	;  no.  bus free
j33:	jmp	intsrst



;  subroutine -
;
;	Configure Sparrow in anticipation of a Data Phase.
;
;	pass in:  al = transfer option

config4data:

	mov	dx,scsirate
	out	dx,al

	mov	dl,LOW sxfrctl0	;clear Channel 1 & transfer counter
	mov	al,ch1ch2+clrstcnt+clrch1
	out	dx,al

	mov	dl,LOW clrsint0	;clear dma done status
	mov	al,clrdmadone
	out	dx,al

	mov	dl,LOW clrserr	;clear any scsi errors
	mov	al,clrsyncerr+clrfwerr+clrfrerr
	out	dx,al

				;+R  workaround deleted

	ret








;******************************************************************************
;
;  config4parity, config4par0 -
;
;	This subroutine configures the 6360 for SCSI parity checking.
;
;	pass thru:  all registers except al, dx
;
;******************************************************************************

config4par0:				;subroutine entry
                                        ;  pass in:  dh = HIGH port address
        mov     dl, LOW sxfrctl1        ;clear relic parity error status
        xor     al,al                   ;  & disable selection timeout
        jmp     config4par5

config4parity:
					;+W  wait for scsi req
	mov	dx,sstat1		;+W
config4par1:				;+W
	in	al,dx			;+W
	test	al,busfree+scsirsti+reqinit  ;+W
	jz	config4par1		;+W  wait until latched req = 1, bus
					;+W    free, or reset.
					;+W  assume scsi req detected  (Reset
					;+W  or bus free will be detected
					;+W  below.)

	mov	dl,LOW scsisig		;+W  bus direction determines how relic
	in	al,dx			;+W    parity error status is to be
	test	al,ioi			;+W    cleared.
	jnz	config4par3		;+W

        mov     dl,LOW sxfrctl1         ;+W  clear relic parity error status
        in      al,dx                   ;+W  direction = out:
        and     al,NOT enspchk          ;+W    clear parity status via enable

config4par5:
	out	dx,al			;+W    clear parity status via enable
config4par3:				;+W
	mov	dl,LOW clrsint1		;clear relic parity error status
	mov	al,clrscsiper		;+W  for direction = in.
	out	dx,al

	mov	dl,LOW dmacntrl1	;enable parity check?
	mov	al,porta$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	test	al,dispar
	mov	dl,LOW sxfrctl1
	jz	config4par6
	in      al,dx
        and     al,NOT enspchk          ;  no
        jmp     SHORT config4par4

config4par6:
        in      al,dx
        or      al,enspchk              ;  yes
config4par4:
	out	dx,al			;disable selection timer, enable
					;  parity check.
	mov	dl,LOW scsiseq		;enable auto atn on parity error
	in	al,dx
	or	al,enautoatnp
	out	dx,al
	ret


rstscsi:			;reset scsi bus only if it is not free
	mov	dx,simode1	;disable bus free interrupt
	in	al,dx
	and	al,NOT enbusfree
	out	dx,al
	mov	dl,LOW clrsint1	;clear bus free interrupt
	mov	al,clrbusfree
	out	dx,al
	mov	dl,LOW scsisig	;scsi bus busy?
	in	al,dx
	test	al,bsyi
	jnz	$+3		;  jump if yes
	ret			;  no.  return

	jmp	schrst		;assert scsi bus hard reset
				;  & configure Sparrow device & return.

	
;  scsi phase = Message Out
;
;	Send message to target.  If atn is asserted, assume a parity error
;	occurred.  Otherwise, send a nop.
;
;		pass out:  al = bus phase for next req
;			   dx = scsisig

sendmo:	mov	dx,scsisig	;atn asserted?
	in	al,dx
	test	al,atni
	mov	al,msg08	;message = nop
	jz	sendmo0		;  jump if no
				;+W  yes:  clear parity error status
	mov	dl,LOW sxfrctl1	;+W
	in	al,dx		;+W
	and	al,NOT enspchk	;+W
	out	dx,al		;+W
	or	al,enspchk	;+W
	out	dx,al		;+W
	mov	al,msg05	;message = parity error detected
sendmo0:
	mov	dl,LOW scsidat	;message -> scsi bus
	out	dx,al
	mov	dl,LOW clrsint1	;deassert atn
	mov	al,clrscsiper+clratno
	out	dx,al
	mov	dl,LOW scsisig	;expected phase = message out
 	mov	al,mophase
	out	dx,al
	jmp	ackreq		;handshake message & wait for next req
				;  & return.



				;+R  original scsiack restored.
scsiack:			;assert scsi ack & wait for handshake done
	mov	al,ch1ch2+spioen	;enable auto pio
	mov	dx,sxfrctl0
	out	dx,al
	mov	dl,LOW scsidat
	in	al,dx		;assert ack
	mov	al,ch1ch2	;disable auto pio
	mov	dl,LOW sxfrctl0
	out	dx,al
scsiac0:			;wait for ack = 0
	mov	dl,LOW scsisig
	in	al,dx
	and	al,acki
	jnz	scsiac0		;jump if not done
	ret			;pass out:  dh = port address/hi





ackreq:	call	scsiack		;assert ack to complete handshake

wt4req:	mov	dx,sstat1	;wait for next scsi req
wt4req1:
	in	al,dx
	test	al,busfree+scsirsti+reqinit
	jz	wt4req1		;wait until latched req = 1, bus free, or reset
	test	al,busfree+scsirsti
	jnz	wt4req4		;jump if bus free or scsi reset

	mov	dl,LOW scsisig	;+W
	in	al,dx		;+W
	test	al,acki		;+W
	jnz	wt4req		;+W
	mov	dl,LOW sstat1	;+W
	in	al,dx		;+W
	test	al,reqinit	;+W
	jz	wt4req1		;+W

				;latched req = 1 -
	mov	dl,LOW clrsint1	;scsiperr = previous + current parity error
	mov	al,clrscsiper	;clear any parity error interrupt
	out	dx,al		;scsiperr = current parity error
				;If current or previous parity error, 
				;  atn is asserted.
	mov	dl,LOW sstat1	;current scsi parity error?
	in	al,dx
	test	al,scsiperr
	jnz	wt4req2		;  jump if yes

	mov	dl,LOW scsisig	;  no
	in	al,dx		;pass out:  al = bus phase
wt4req3:
	and	al,busphase	;	    carry = 0
	ret			;	    dx = scsisig

wt4req2:			;current parity error
	mov	dl,LOW scsisig	;phase = data?
	in	al,dx
	test	al,ioi		;+W
	jz	wt4req3		;+W
	test	al,cdi+msgi
	jz	wt4req3		;  jump if yes: Caller will handle the error.
				;  no.  Attn has been automatically asserted.
				;Ignore current byte from target.
	and	al,busphase	;set expected phase = current to enable ack
	out	dx,al		;
	jmp	SHORT ackreq	;Next phase should be Message Out:
				;  parity error -> targ
	
wt4req4:			;bus free or scsi reset detected
	jmp	ckreset		;handle the error condition


				;subroutine -
				;pass in:  ah = own_id
				;pass out:  dh = port address/hi
seladdr:			;set up Sparrow for selection
	mov	dx,dmacntrl1	;+P  wake up 6360
	xor	al,al		;+P
	out	dx,al		;+P
				;load scsi ids -
	mov	al,[bp].dlun	;target addr/lun
	shr	al,5		;bits 2-0 = targ addr [binary]
	or	al,ah		;bits 6-4 = adapter id [binary]
	mov	dl,LOW scsiid
	out	dx,al

	mov	dl,LOW dmacntrl0 ;disable hardware interrupt (inten)
	xor	al,al
	out	dx,al

				;enable selection timer
	mov	dl,LOW sxfrctl1
	mov	al,cs:sltime	;selection time option
	or	al,enstimer
	out	dx,al
	mov	dl,LOW sxfrctl0	;clear scsi transfer counter
	mov	al,ch1ch2+clrstcnt
	out	dx,al
				;enable interrupts -
	mov	dl,LOW simode0
	mov	al,enseldo
 	out	dx,al
	mov	dl,LOW simode1
	mov	al,enseltimo+enscsirst
	out	dx,al
				;clear old interrupts -
	mov	dl,LOW clrsint0
	mov	al,clrseldo+clrselingo+clrswrap+clrsdone+clrspiordy+clrdmadone
	out	dx,al
	mov	dl,LOW clrsint1
	mov	al,clrseltimo+clratno+clrbusfree+clrscsiper+clrphasechg+clrreqinit
	out	dx,al

				;arbitrate, select, and assert atn
	mov	dl,LOW scsiseq
	mov	al,enselo+enautoatno	;enrseli is disabled until disconnect:
	out	dx,al			;  BIOS is single threaded.
	ret


;  The return address is saved on the stack by the call of this subroutine.
;  This subroutine jumps to the interrupt handler to await a Sparrow interrupt.
;  The interrupt handler will return to the caller of this subroutine.

waitfor:
	jmp	spar_int	;wait for interrupt, then return



;  Access the data transfer option in the Sparrow stack.
;
;	pass out:  dx = port address of transfer option
;

xfer_option:
				;derive pointer to data transfer option
	mov	dx,dmacntrl1
	mov	al,porta$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx		;	bits 2-0 = host adapter scsi id
	mov	dl,[bp].dlun
	shr	dl,5		;	bits 2-0 = target scsi id
	sub	al,dl
	and	al,07h		;	al = ha id - target id
	add	al,synspd-1	;al = byte number in stack of transfer option
	mov	dl,LOW dmacntrl1;     byte for current target
	out	dx,al
	mov	dl,LOW sparstack
	ret


;
;  Get the host adapter SCSI address.
;
my_address:
	call	in_porta
	and    	al,adapid               ;adapter id, binary
        ret


;
;  Set transfer options to asynchronous for all SCSI targets.
;

async_xfer_option:
	mov	cx,7
	mov	dx,dmacntrl1
	mov	al,synspd
	out	dx,al
	xor	al,al
	mov	dl,LOW sparstack
async0:	out	dx,al
	loop	async0
        ret

bios_driver	ENDP

	PAGE

;******************************************************************************
;
;  The subroutines in this section are Sparrow BIOS Driver modules.  They are
;  called by the BIOS Manager to perform special functions.
;
;******************************************************************************

; *JP001* - begin JP001 addition

;************************************************************************
;									*
;  ChkHAPresent - part of JP001 additions
;									*
;	This subroutine checks for the existence of a 6360-based host	*
;	adapter at port addresse BASEPORT				*
;									*
;	Exit:	carry = 1 if host adapter not found			*
;									*
;									*
;************************************************************************

	PUBLIC	ChkHAPresent
ChkHAPresent	PROC	NEAR

	pusha			;save ax, bx, cx, dx, sp, bp, si, di
			   
	mov	dx,scsiseq
	in	al,dx
	test	al,enselo+enautoatno+scsirsto
	jnz	ha_err
	mov	dx,sxfrctl0
	in	al,dx
	test	al,scsien+dmaen+clrstcnt+spioen+clrch1+05h
	jnz	ha_err
	mov	dx,sxfrctl1
	in	al,dx
	test	al,bitbucket+swrapen+01
	jnz	ha_err
	mov	dx,sstat0
	in	al,dx
	test	al,seldo+spiordy
	jnz	ha_err
	mov	dx,sstat2
	in	al,dx
	cmp	al,sempty
	jne	ha_err
	mov	dx,sstat3
	in	al,dx
	test	al,0ffh
	jnz	ha_err
	mov	dx,dmastat
	in	al,dx
	and	al,dfifofull+dfifoemp
	cmp	al,dfifoemp
	jne	ha_err

	popa			;restore registers
	clc			;cf = 0 for normal return
	ret

ha_err:
	popa			;restore registers
	stc			;cf = 1 for error return
	ret

ChkHAPresent	ENDP

; *JP001* - end JP001 addition


	PUBLIC	bios_init
bios_init	PROC	NEAR

	pusha			;save ax, bx, cx, dx, sp, bp, si, di

	call	schrst		;issue a scsi bus reset
	call	sparrow_diag	;perform diagnostics on Sparrow device
	jc	init_err	;  jump if diagnostics failed

				;load Sparrow stack with configuration
	mov	dx,dmacntrl1
        mov	al,key0_xlatmode; *JP001*
	out	dx,al
	mov	dl,LOW sparstack
IFNDEF	EXE			;If EXE is defined, we don't want to
	mov	al,SIGNATURE_6360	;JP001 overwrite the translation mode bits
ELSE				;JP001 or the floptical bits when the format
	mov	dx,dmacntrl1	;JP001 utility calls bios_init
	mov	al,key0_xlatmode;JP001 because we might return to DOS
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	push	ax		;
	and	al,not keybits	;JP001
	or	al,key0code6360	;JP001
ENDIF
	out	dx,al

	call	InitXferOption	;JP001
	
	call	init_spar	;clear & disable all Sparrow interrupts
				;configure Sparrow device for idle
	call	InitXferOption2
	popa			;restore registers
	clc			;cf = 0 for normal return
	ret

init_err:
	popa			;restore registers
	stc			;cf = 1 for error return
	ret


;  
;  InitXferOption2 - sets transfer width and FAST SCSI options
;

InitXferOption2	proc	near

	; check chip revision
	mov	dx,rev
	in	al,dx
	test	al,0FFh
	jz	ITxWRet

	mov	dl,LOW dmacntrl1
	mov	al,portb$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx

	test	al, FAST_SCSI
	jz	ITxWRet

	; determine CPU type
	xor	bx,bx
	pushf	     
	xor	ax,ax
	push	ax   
	popf	     
	pushf				;  or below, label
	pop	ax			;  'TransferUtil' will be
	and	ax,0F000h		;  branched to
	cmp	ax,0F000h
	je	NotA386
	mov	ax,0F000h
	push	ax
	popf
	pushf
	pop	ax
	and	ax,0F000h
	je	NotA386
	popf
	jmp	SHORT Is386or486

NotA386:
	popf				;Not a 386 or above so branch
	mov	ah,0
	jmp	short ITxW

Is386or486:
	mov	ah,TXWIDTH32

ITxW:
	or	ah,FASTSCSI_ON

	; set tx width bit
	mov	dl,LOW dmacntrl1	; point to xcfg2
	mov	al,xcfg2 or enstk32
	out	dx,al
	mov	dl,LOW sparstack	; read from stack
	in	al,dx
	or	ah,al			; reset/set txwidth bit

	mov	dl,LOW dmacntrl1	; point again to xcfg2
	mov	al,xcfg2 or enstk32
	out	dx,al

	mov	dl,LOW sparstack	; store in stack
	mov	al,ah
	out	dx,al
ITxWRet:
	ret

InitXferOption2	endp



;  
;  InitXferOption - sets transfer option to asynchronous transfer
;

	PUBLIC InitXferOption
InitXferOption	proc	near

	mov	dx,dmacntrl1	; *JP001*
	mov	al,porta$
	out	dx,al		; *JP001* select config byte in sparrow stack
	call	in_porta	;  *JP001* port A jumper options
	mov	dx,sparstack	; *JP001*
	out	dx,al		; *JP001*
	call	in_portb	; *JP001* port B jumper options
	mov	dx,sparstack	; *JP001*
	out	dx,al		; *JP001*
   	call	async_xfer_option ; *JP001* set scsi transfer option to async
	ret

InitXferOption	endp



;  subroutine -
;
;  Issue a SCSI bus reset, then initialize Sparrow chip.


schrst:
	mov	dx,scsiseq
	mov	al,scsirsto
	out	dx,al
	mov	cx,0100h	;define reset pulse width
schrs0:	loop	schrs0
	xor	al,al
	out	dx,al
		                ;scsi transfer option = asynchronous
        call    async_xfer_option
	                        ;initialize Sparrow
                                ;  (fall thru to init_spar:)


;  subroutine -
;
;	Initialize Sparrow device.

	PUBLIC init_spar

init_spar:
	mov	dx,scsiseq	;disable selection, etc.
	xor	al,al
	out	dx,al

	mov	dl,LOW sxfrctl0	;disable transfer;  clear transfer count
	mov	al,ch1ch2+clrstcnt+clrch1
	out	dx,al

	mov	dl,LOW sxfrctl1	;disable selection timer, etc.
	xor	al,al
	out	dx,al

	mov	dl,LOW scsisig	;deassert scsi signals
	xor	al,al
	out	dx,al
	mov	dl,LOW scsirate	;default to async xfer
	out	dx,al

	mov	dl,LOW scsiid	;my id is not loaded into Sparrow.  Therefore,
	xor	al,al		;  any participation on scsi cannot be enabled.
	out	dx,al

	mov	dl,LOW clrsint0	;clear interrupts & status
	mov	al,clrseldo+clrseldi+clrselingo+clrswrap+clrsdone+clrspiordy+clrdmadone
	out	dx,al
	mov	dl,LOW clrsint1
	mov	al,clrseltimo+clratno+clrscsirsti+clrbusfree+clrscsiper+clrphasechg+clrreqinit
	out	dx,al

	mov	dl,LOW clrserr	;clear scsi errors
	mov	al,clrsyncerr+clrfwerr+clrfrerr
	out	dx,al

	mov	dl,LOW simode0	;disable all interrupts
	xor	al,al
	out	dx,al
	mov	dl,LOW simode1
	out	dx,al

	mov	dl,LOW dmacntrl0	;clear dma fifo
	mov	al,rstfifo
	out	dx,al

	IFDEF	B636
	IFNDEF	Intel
	mov	dl,LOW dmacntrl1 ;+P  power down 6360
	mov	al,pwrdwn	;+P
	out	dx,al		;+P
	ENDIF
	ENDIF
	ret

	PAGE
;******************************************************************************
;
;  Sparrow chip diagnostic
;
;	pass out:  cf = 1 if test failed
;
;******************************************************************************

sparrow_diag:

;  Test all Sparrow registers which can be tested by walking a "1"
;  across all 8 bits.

	mov	dx,dmacntrl1		;+P  wake up 6360
	xor	al,al			;+P
	out	dx,al			;+P

	mov	dl,LOW stcnt0
	call	walk_1
	inc	dx
	call	walk_1
	inc	dx
	call	walk_1
	mov	dl,LOW simode1
	call	walk_1

;  Selectively test Sparrow register bits.

	mov	dl,LOW scsiseq
        mov     ch,temodeo+enautoatno+enautoatni+enautoatnp
        call    bit_test

	mov	dl,LOW sxfrctl0
        mov     ch,scsien+dmaen+ch1ch2+spioen
        call    bit_test

	mov	dl,LOW sxfrctl1
        mov     ch,bitbucket+swrapen+enspchk+stimesel1+stimesel0+enstimer
        call    bit_test

	mov	dl,LOW simode0
        mov     ch,enseldo+enseldi+enselingo+enswrap+ensdone+enspiordy+endmadone
        call    bit_test

	mov	dl,LOW dmacntrl0
        mov     ch,bit8bit16+dmapio+writeread+inten+swint
        call    bit_test

;  Check clear of scsi transfer counter

	mov	al,0ffh
	mov	dl,LOW stcnt0
	out	dx,al
	inc	dx
	out	dx,al
	inc	dx
	out	dx,al
	mov	dl,LOW sxfrctl0
	mov	al,clrstcnt
	out	dx,al
	mov	dl,LOW stcnt0
	in	al,dx
	mov	ah,al
	inc	dx
	in	al,dx
	or	ah,al
	inc	dx
	in	al,dx
	or	ah,al
	jz	j34
	jmp	spar_err 	;jump if transfer counter not cleared
j34:

;  Check set and clear of sdone interrupt.

	mov	dl,LOW clrsint0
	mov	al,clrsdone
	out	dx,al
	mov	al,setsdone
	out	dx,al		;set sdone
	mov	dl,LOW sstat0
	in	al,dx
	test	al,sdone
	jnz	j35
	jmp	spar_err	;  jump if not set
j35:	mov	dl,LOW clrsint0
	mov	al,clrsdone	;clear sdone
	out	dx,al
	mov	dl,LOW sstat0
	in	al,dx
	test	al,sdone
	jz	j36
	jmp	spar_err	;  jump if still set
j36:

;  Test software assertion and clear of interrupt.

;	mov	dl,LOW dmacntrl0
;	mov	al,0
;	out	dx,al
;	mov	al,swint
;	out	dx,al		;set intstat
;	mov	dl,LOW dmastat
;	in	al,dx
;	test	al,intstat
;	jnz	j37
;	jmp	spar_err	;  jump if not set
;j37:	mov	dl,LOW dmacntrl0
;	mov	al,0		;clear intstat
;	out	dx,al
;	mov	dl,LOW dmastat
;	in	al,dx
;	test	al,intstat
;	jz	j38
;	jmp	spar_err	;  jump if still set
;j38:

IFNDEF EXE			;if executable formatter is running, we
				;don't want to wipe out the floptical bits
;  Sparrow stack test -		;in the sparrow stack!

	mov	dl,LOW dmacntrl1 ;address & write to each element in stack
	xor	al,al
	mov	cx,32
stack_t0:
	or	al,enstk32
	out	dx,al
	mov	dl,LOW sparstack
	and	al,not enstk32
	out	dx,al
	mov	dl,LOW dmacntrl1
	inc	al
	loop	stack_t0

	mov	ax,enstk32	;pop off stack and check value
	out	dx,al		;	initialize stack pointer
	mov	dl,LOW sparstack
	mov	cx,32
stack_t1:
	in	al,dx
	cmp	ah,al
	je	j39
	jmp	spar_err
j39:	inc	ah
	loop	stack_t1

	mov	al,enstk32	;push onto stack
	mov	dl,LOW dmacntrl1
	out	dx,al
	xor	al,al
	mov	dl,LOW sparstack
	mov	cx,32
stack_t2:
	out	dx,al
	inc	al
	loop	stack_t2

	mov	ax,enstk32	;read stack elements and check values
	mov	dl,LOW dmacntrl1
	out	dx,al
	mov	dl,LOW sparstack
	mov	cx,32
stack_t3:
	in	al,dx
	cmp	ah,al
	jne	spar_err
	inc	ah
	loop	stack_t3

	; clear stack
	mov	al,enstk32	;push onto stack
	mov	dl,LOW dmacntrl1
	out	dx,al
	xor	al,al
	mov	dl,LOW sparstack
	mov	cx,32
stackclr:
	out	dx,al
	loop	stackclr


ENDIF


;  Test dma fifo.

	mov	dl,LOW sxfrctl0
	xor	al,al		;disable scsien, dmaen
	out	dx,al
	mov	dl,LOW dmacntrl0
	mov	al,rstfifo	;clear dma fifo counter
	out	dx,al
	mov	al,endma+writeread ;enable dma, write, pio
	out	dx,al
	mov	dl,LOW dmadata
	mov	ax,0100h
	mov	cx,fifosize/2	;write words into fifo
dma_t0:
	out	dx,ax
	add	ax,0202h
	loop	dma_t0

	mov	dl,LOW fifostat	;check for fifo count = fifosize
	in	al,dx
	cmp	al,fifosize
	jne	spar_err
	mov	dl,LOW dmastat
	in	al,dx
	test	al,dfifofull	;check for fifo full
	jz	spar_err
	test	al,dfifoemp	;check for fifo not empty
	jnz	spar_err
	
	mov	dl,LOW dmacntrl0 ;read bytes back out of fifo & check values
	mov	al,endma+bit8bit16
	out	dx,al
	mov	dl,LOW dmadata
	xor	ah,ah
	mov	cx,fifosize
dma_t1:
	in	al,dx
	cmp	ah,al
	jne	spar_err
	inc	ah
	loop	dma_t1

	mov	dl,LOW fifostat	;check for fifo count = 0
	in	al,dx
	cmp	al,0
	jne	spar_err
	mov	dl,LOW dmastat
	in	al,dx
	test	al,dfifofull	;check for fifo not full
	jnz	spar_err
	test	al,dfifoemp	;check for fifo empty
	jz	spar_err

	IFDEF	B636
	IFNDEF	Intel
	mov	dl,LOW dmacntrl1 ;+P  power down 6360
	mov	al,pwrdwn	;+P
	out	dx,al		;+P
	ENDIF
	ENDIF
	clc
	ret			;end of test -  no error

spar_err:			;error observed while testing Sparrow
	IFDEF	B636
	IFNDEF	Intel
	mov	dx,dmacntrl1	;+P  power down 6360
	mov	al,pwrdwn	;+P
	out	dx,al		;+P
	ENDIF
	ENDIF
	stc
	ret



;  subroutine -
;
;	Save bit pattern from register.
;	Write passed in pattern to register.
;	Read pattern from register & compare with passed in pattern.
;	Restore bit pattern to register.
;
;	pass in:  ah = pattern to write to register
;		  dx = port address of register
;
;	pass out:  z = 0  if read miscompare
;		   ah = pass in
;		   dx = pass in

wrt_rd_reg:
	in	al,dx
	iowait
	xchg	ah,al
	out	dx,al
	iowait
	mov	bl,al
	in	al,dx
	iowait
	cmp	al,bl
	xchg	ah,al
	out	dx,al
	ret



;  subroutine -
;
;       Test all specifed bits in a 6360 register.  If error, jump instead
;       of returning.
;
;       pass in:  dx = register
;                 ch = bits which can be set to 1
;

bit_test:
        mov     cl,01h                  ;initialize sliding '1' mask

bit_t1: mov     ah,ch                   ;bits to be tested as '1'
        and     ah,cl                   ;select next bit to test
	call	wrt_rd_reg              ;test bit
	jnz	bit_t0		        ;jump if error
        shl     cl,1                    ;slide '1' to left
        jnc     bit_t1
	ret			        ;normal return

bit_t0:	add	sp,2
	jmp	SHORT spar_err	;error return



;  subroutine -
;
;	Test a register by walking a "1" thru it.
;
;	pass in:  dx = port address of register
;
;	pass out:  If compare error, pop ret addr & jump to error return.
;		   dx = pass in

walk_1:
	mov	cx,8
	xor	ah,ah
	stc
walk_10:
	rcl	ah,1
	call	wrt_rd_reg
	loopz	walk_10
	jnz	walk_11		;jump if miscompare error
	ret
walk_11:
	add	sp,2		;error:  jump back to caller
	jmp	SHORT spar_err


bios_init	ENDP


;******************************************************************************
;
;  RESET SCSI DEVICES
;
;  This module resets the SCSI bus and initializes the Sparrow device if the
;  SCSI bus is not free.  If the bus is free, no action is taken.
;
;  Note that no ram locations are used in this procedure.  If ram should be
;  required in the future, it will have to be located in the stack and register
;  BP will have to be defined.
;
;******************************************************************************

	; reset scsi version where interrupts are enabled
	PUBLIC	rst_scsi
rst_scsi	PROC	NEAR

	pusha			;save ax, bx, cx, dx, sp, bp, si, di
	call	TestRR
	jnz	rst_0000
	call	rstscsi
rst_0000:
	popa
	ret

rst_scsi	ENDP


;******************************************************************************
;
;  Return Configuration Parameters host adapter command
;
;	Pass out:  al = DMA channel
;		   ah = interrupt channel
;
;  Note that no ram locations are used in this procedure.  If ram should be
;  required in the future, it will have to be located in the stack and register
;  BP will have to be defined.
;
;******************************************************************************

	PUBLIC	HA_Return_Config_cmd

HA_Return_Config_cmd	PROC	NEAR


	push	dx		;save all registers used
	push	bx

				;get dma channel from jumpers
	mov	dx,dmacntrl1
	mov	al,porta$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	and	al,dmachnl
	mov	bl,1		;channel 0
	jz	config0
	mov	bl,20h		;channel 5
	cmp	al,20h
	je	config0
	mov	bl,40h		;channel 6
	cmp	al,40h
	je	config0
	mov	bl,80h		;channel 7

config0:
	mov	dx,dmacntrl1
	mov	al,porta$
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	and	al,intchnl	;get interrupt channel
	mov	bh,01h		;channel 9
	jz	config1
	mov	bh,02h		;channel 10
	cmp	al,08h
	je	config1
	mov	bh,04h		;channel 11
	cmp	al,10h
	je	config1
	mov	bh,08h		;channel 12

config1:
	call	my_address	;get my address
				;(not passed out at this time.)

	mov	ax,bx		;pass out:  ax
	pop	bx		;restore registers
	pop	dx

	ret

HA_Return_Config_cmd	ENDP


;******************************************************************************
;
;  Read Port A and Port B jumpers for the caller.
;
;	Pass out:  al = Port B jumpers
;		   ah = Port A jumpers
;
;  Note that no ram locations are used in this procedure.  If ram should be
;  required in the future, it will have to be located in the stack and register
;  BP will have to be defined.
;
;******************************************************************************

	PUBLIC	Get_Jumpers

Get_Jumpers	PROC	NEAR

IFNDEF B636
	push	dx		;save all registers used
ENDIF

	call	in_porta	;read Port A jumpers
	mov	ah,al
	call	in_portb	;read Port B jumpers

IFNDEF B636
	pop	dx
ENDIF
	ret

Get_Jumpers	ENDP


;  read_porta subroutine -
;
;	registers to be preserved:  all except al
;
;	pass out register al:  bit 7 = disable scsi parity checking
;	                       bits 6-5 = 00:  DMA channel 0
;	                                  01:  DMA channel 5
;	                                  10:  DMA channel 6
;	                                  11:  DMA channel 7
;	                       bits 4-3 = 00:  interrupt channel 9
;	                                  01:  interrupt channel 10
;	                                  10:  interrupt channel 11
;	                                  11:  interrupt channel 12
;	                       bits 2-0 = host adapter scsi address (binary)
read_porta:
	push	dx
	mov	dx,dmacntrl1
	mov	al,enstk32+porta$
	out	dx,al
	mov	dx,sparstack
	in	al,dx
	pop	dx
	ret


;  read_portb subroutine -
;
;	registers to be preserved:  all  except al
;
;	pass out register al:  bit 7 = 0:  PIO data transfer
;	                               1:  DMA data transfer
;	                       bit 6:  enable Int 19 boot
;	                       bits 5-4:  message display options -
;	                                  00:  header & error messages
;	                                  01:  header, errors, boot progress
;	                                  10:  all display options
;	                                  11:  error messages
;	                       bit 3:  initiate synchronous negotiation
;	                       bit 2:  enable target disconnection
;			       bit 1 = 0:  disable BIOS floptical/SCSI support
;				       1:  enable BIOS floptical/SCSI support
;			       bit 0 = 0:  disable AIC-6360 compatibility mode
;				       1:  enable AIC-6360 compatibility mode

read_portb:
	push	dx
	mov	dx,dmacntrl1
	mov	al,enstk32+portb$
	out	dx,al
	mov	dx,sparstack
	in	al,dx
	pop	dx
	ret

;******************************************************************************
;
;	Check_Bus
;
;	Checks that no SCSI bus lines are active.  Used to detect a situation
;	where a target has not been powered up and is dragging the bus down.
;
;	pass out:  Z flag = 0  if bus is not free
;
;	pass thru:  dx
;
;******************************************************************************

	PUBLIC Check_Bus

Check_Bus	PROC	NEAR
	push	dx
	mov	dx,scsisig
	in	al,dx
	mov	ah,al
	mov	dx,scsibus
	in	al,dx
	or	ah,al
	mov	dx,scsisig
	in	al,dx
	or	ah,al
	mov	dx,scsibus
	in	al,dx
	or	ah,al
	pop	dx
	ret
Check_Bus	ENDP


code	ENDS
 
	END

