	.MACRO .ALL
	.LIST

	.MCALL ..V2..,.REGDEF,.CSISPC,.PRINT,.SRESET,.CLOSE
	.MCALL .WRITW,.READW,.TTYIN,.ENTER,.LOOKUP,.FETCH
	.MCALL GENJSR,RET,GENSOP,PUSH,PULL,MSG,MSGW,GENS

	.NLIST
	..V2..
	.REGDEF
	GENSOP
	.ENDM .ALL
	.MACRO GENS OPC
	.NLIST
	.MACRO OPC'S C,OP1
	.REPT C
	OPC OP1
	.ENDR
	.ENDM OPC'S
	.MACRO OPC'BS C,OP1
	.REPT C
	OPC'B OP1
	.ENDR
	.ENDM OPC'BS
	.LIST
	.ENDM GENS

	.MACRO GENJSR LAB
	.MACRO LAB LA,LB
	.IF NB,LA
	.IIF B,LB,MOV LA,%0
	.IIF NB,LB,MOV LA,LB
	.ENDC
	JSR PC,LAB
	.ENDM
	.ENDM

	.MACRO GENSOP
	GENS ASL
	GENS ASR
	GENS ROL
	GENS ROR
	GENS INC
	GENS DEC
	.ENDM GENSOP

	.MACRO PULL ARG
	.IRP A,<ARG>
	MOV (SP)+,A
	.ENDR
	.ENDM
	.MACRO PUSH ARG
	.IRP A,<ARG>
	MOV A,-(SP)
	.ENDR
	.ENDM

	.MACRO MSG ARG
	.CSECT MSGS
..MSG=.
	.ASCIZ	/ARG/
	.CSECT
	.PRINT #..MSG
	.ENDM

	.MACRO MSGW ARG
	.CSECT MSGS
..MSG=.
	.ASCII	/ARG/<200>
	.CSECT
	.PRINT #..MSG
	.ENDM
	.MACRO RET
	RTS PC
	.ENDM

.MACRO ..V1..
...V1=1
.ENDM

.MACRO ..V2..
...V2=1
.ENDM

.MACRO ...CM1
.ENDM
.MACRO ...CM2
.ENDM
.MACRO ...CM3
.ENDM
.MACRO ...CM4
.ENDM

.MACRO .CDFN .AREA,.ADD,.NUM
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#6400,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
.IF NB .NUM,
		MOV	.NUM,4.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .CHAIN
		MOV	#4000,%0
		EMT	^O374
.ENDM

.MACRO .CHCOPY .AREA,.CHAN,.OCHAN
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#11.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .OCHAN
		MOV	.OCHAN,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .CNTXSW	.AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#15400,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .CLOSE	.CHAN
.IF DF ...V1
		EMT	^O<160+.CHAN>
.IFF
		MOV	#3000,%0
.IF NB .CHAN
		BISB	.CHAN,%0
.ENDC
		EMT	^O374
.ENDC
.ENDM

.MACRO .CMKT .AREA,.ID,.TIME
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#11400,(0)
.ENDC
.IF NB .ID
		MOV	.ID,2.(0)
.ENDC
.IF NB .TIME
		MOV	.TIME,4.(0)
.IFF
		CLR	4.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .CSIGEN .DEVSPC,.DEFEXT,.CSTRING
		MOV	.DEVSPC,-(6.)
		MOV	.DEFEXT,-(6.)
.IF B .CSTRING
		CLR	-(6.)
.IFF
		MOV	.CSTRING,-(6.)
.ENDC
		EMT	^O344
.ENDM


.MACRO .CSISPC .OUTSPC,.DEFEXT,.CSTRING
		MOV	.OUTSPC,-(6.)
		MOV	.DEFEXT,-(6.)
.IF B .CSTRING
		CLR	-(6.)
.IFF
		MOV	.CSTRING,-(6.)
.ENDC
		EMT	^O345
.ENDM

.MACRO .CSTAT	.AREA,.CHAN,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#23.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .DATE
		MOV	@#^O54,%0
		MOV	^O262(0),%0
.ENDM

.MACRO .DELETE	.AREA,.CHAN,.DEVBLK,.SPF
.IF DF ...V1
.IF NB .CHAN
		MOV	.CHAN,%0
.ENDC
		EMT	^O<.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		CLRB	1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .DEVBLK
		MOV	.DEVBLK,2.(0)
.ENDC
.IF B .SPF
		CLR	4.(0)
.IFF
		MOV	.SPF,4.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .DEVICE	.AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#6000,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .DSTATUS .RETSPC,.DNAME
.IF NB .DNAME
		MOV	.DNAME,%0
.ENDC
		MOV	.RETSPC,-(6.)
		EMT	^O342
.ENDM

.MACRO .ENTER	.AREA,.CHAN,.DEVBLK,.LEN,.SPF
.IF DF ...V1
		MOV	.CHAN,%0
.IF B .DEVBLK
		CLR	-(6.)
.IFF
		MOV	.DEVBLK,-(6.)
.ENDC
		EMT	^O<40+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#2.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .DEVBLK
		MOV	.DEVBLK,2.(0)
.ENDC
.IF NB .LEN
		MOV	.LEN,4.(0)
.IFF
		CLR	4.(0)
.ENDC
.IF NB .SPF
		MOV	.SPF,6.(0)
.IFF
		CLR	6.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .EXIT
		EMT	^O350
.ENDM

.MACRO .FETCH .ADD,.DNAME
.IF NB .DNAME
		MOV	.DNAME,%0
.ENDC
		MOV	.ADD,-(6.)
		EMT	^O343
.ENDM

.MACRO .GTIM	.AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#10400,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .GTJB	.AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#10000,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .HERR
		MOV	#2400,%0
		EMT	^O374
.ENDM

.MACRO .HRESET
		EMT	^O357
.ENDM

.MACRO .LOCK
		EMT	^O346
.ENDM

.MACRO .INTEN .PRIO,.PIC
.IF NB .PIC
		MOV	@#^O54,-(6.)
		JSR	5.,@(6.)+
.IFF
		JSR	5.,@^O54
.ENDC
		.WORD	^C<.PRIO*32.>&224.
.ENDM

.MACRO .LOOKUP	.AREA,.CHAN,.DEVBLK,.SPF
.IF DF ...V1
.IF NB .CHAN
		MOV	.CHAN,%0
.ENDC
		EMT	^O<20+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#1,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .DEVBLK
		MOV	.DEVBLK,2.(0)
.ENDC
.IF NB .SPF
		MOV	.SPF,4.(0)
.IFF
		CLR	4.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO	.MFPS	.ADD
		MOV	@#^O54,-(6.)
		ADD	#^O362,(6.)
		JSR	7.,@(6.)+
.IF NB	.ADD
		MOVB	(6.)+,.ADD
.ENDC
.ENDM


.MACRO .MRKT	.AREA,.TIME,.CRTN,.ID
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#11000,(0)
.ENDC
.IF NB .TIME
		MOV	.TIME,2.(0)
.ENDC
.IF NB .CRTN
		MOV	.CRTN,4.(0)
.ENDC
.IF NB .ID
		MOV	.ID,6.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO	.MTPS	.ADD
.IF NB	.ADD
		CLR	-(6.)
		MOVB	.ADD,(6.)
.ENDC
		MOV	@#^O54,-(6.)
		ADD	#^O360,(6.)
		JSR	7.,@(6.)+
.ENDM


.MACRO .MWAIT
		MOV	#4400,%0
		EMT	^O374
.ENDM

.MACRO .PRINT .ADD
.IF NB .ADD
		MOV	.ADD,%0
.ENDC
		EMT	^O351
.ENDM

.MACRO .PROTECT	.AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#14400,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .PURGE .CHAN
		MOV	#1400,%0
.IF NB .CHAN
		BISB	.CHAN,%0
.ENDC
		EMT	^O374
.ENDM

.MACRO .QSET .QADD,.QLEN
.IF NB .QLEN
		MOV	.QLEN,%0
.ENDC
		MOV	.QADD,-(6.)
		EMT	^O353
.ENDM

.MACRO .RCTRLO
		EMT	^O355
.ENDM

.MACRO .RCVD .AREA,.BUFF,.WCNT
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#13000,(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		MOV	#1,8.(0)
		EMT	^O375
.ENDM

.MACRO .RCVDC .AREA,.BUFF,.WCNT,.CRTN
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#13000,(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
.IF NB .CRTN
		MOV	.CRTN,8.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .RCVDW .AREA,.BUFF,.WCNT
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#13000,(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		CLR	8.(0)
		EMT	^O375
.ENDM

.MACRO .READ	.AREA,.CHAN,.BUFF,.WCNT,.BLK
.IF DF ...V1
.IF NB .WCNT
		MOV	.WCNT,%0
.ENDC
		MOV	#1,-(6.)
		MOV	.BUFF,-(6.)
		MOV	.CHAN,-(6.)
		EMT	^O<200+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#8.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		MOV	#1,8.(0)
		EMT	^O375
.ENDC
.ENDM

.MACRO .READC .AREA,.CHAN,.BUFF,.WCNT,.CRTN,.BLK
.IF DF ...V1
 .IF NB .CRTN
		MOV	.CRTN,%0
.ENDC
		MOV	.WCNT,-(6.)
		MOV	.BUFF,-(6.)
		MOV	.CHAN,-(6.)
		EMT	^O<200+.AREA>
.IFF
 .IF NB .AREA
		MOV	.AREA,%0
		MOVB	#8.,1(0)
 .ENDC
 .IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
 .IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
 .IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
 .IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
 .IF NB .CRTN
		MOV	.CRTN,8.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .READW .AREA,.CHAN,.BUFF,.WCNT,.BLK
.IF DF ...V1
 .IF NB .WCNT
		MOV	.WCNT,%0
.ENDC
		CLR	-(6.)
		MOV	.BUFF,-(6.)
		MOV	.CHAN,-(6.)
		EMT	^O<200+.AREA>
.IFF
 .IF NB .AREA
		MOV	.AREA,%0
		MOVB	#8.,1(0)
 .ENDC
 .IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
 .IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
 .IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
 .IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		CLR	8.(0)
		EMT	^O375
.ENDC
.ENDM

.MACRO .REGDEF
R0=%0
R1=%1
R2=%2
R3=%3
R4=%4
R5=%5
SP=%6
PC=%7
.ENDM

.MACRO .RELEASE .DEVBLK
.IF NB .DEVBLK
		MOV	.DEVBLK,%0
.ENDC
		CLR	-(6.)
		EMT	^O343
.ENDM

.MACRO .RENAME	.AREA,.CHAN,.DEVBLK
.IF DF ...V1
.IF NB .CHAN
		MOV	.CHAN,%0
.ENDC
		EMT	^O<100+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#4.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .DEVBLK
		MOV	.DEVBLK,2.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .REOPEN	.AREA,.CHAN,.CBLK
.IF DF ...V1
.IF NB .CHAN
		MOV	.CHAN,%0
.ENDC
		EMT	^O<140+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#6.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .CBLK
		MOV	.CBLK,2.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .SAVESTAT .AREA,.CHAN,.CBLK
.IF DF ...V1
.IF NB .CHAN
		MOV	.CHAN,%0
.ENDC
		EMT	^O<120+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#5.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .CBLK
		MOV	.CBLK,2.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .RSUM
		MOV	#1000,%0
		EMT	^O374
.ENDM

.MACRO .SDAT	.AREA,.BUFF,.WCNT
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#12400,(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		MOV	#1,8.(0)
		EMT	^O375
.ENDM

.MACRO .SDATC .AREA,.BUFF,.WCNT,.CRTN
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#12400,(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
.IF NB .CRTN
		MOV	.CRTN,8.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .SDATW .AREA,.BUFF,.WCNT
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#12400,(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		CLR	8.(0)
		EMT	^O375
.ENDM

.MACRO .SERR
		MOV	#2000,%0
		EMT	^O374
.ENDM

.MACRO .SETTOP .ADD
.IF NB .ADD
		MOV	.ADD,%0
.ENDC
		EMT	^O354
.ENDM

.MACRO .SFPA	.AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#14000,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .SPFUN	.AREA,.CHAN,.CODE,.BUFF,.WCNT,.BLK,.CRTN
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#26.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
.IF NB .CODE
		MOVB	#^O377,8.(0)
		MOVB	.CODE,9.(0)
.ENDC
.IF NB .CRTN
		MOV	.CRTN,8.(0)
.IFF
		CLR	8.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .SRESET
		EMT	^O352
.ENDM

.MACRO .SPND
		MOV	#400,%0
		EMT	^O374
.ENDM

.MACRO .SYNCH .AREA
.IF NB .AREA
		MOV	.AREA,%4
.ENDC
		MOV	@#^O54,%5
		JSR	5.,@^O324(5.)
.ENDM

.MACRO .TLOCK
		MOV	#3400,%0
		EMT	^O374
.ENDM

.MACRO .TRPSET .AREA,.ADD
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#1400,(0)
.ENDC
.IF NB .ADD
		MOV	.ADD,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .TTINR
		EMT	^O340
.ENDM

.MACRO .TTYIN .CHAR
		EMT	^O340
		BCS	.-2
.IF NB .CHAR
		MOVB	%0,.CHAR
.ENDC
.ENDM

.MACRO .TTOUTR
		EMT	^O341
.ENDM

.MACRO .TTYOUT .CHAR
.IF NB .CHAR
		MOVB	.CHAR,%0
.ENDC
		EMT	^O341
		BCS	.-2
.ENDM

.MACRO .TWAIT	.AREA,.TIME
.IF NB .AREA
		MOV	.AREA,%0
		MOV	#12000,(0)
.ENDC
.IF .TIME
		MOV	.TIME,2.(0)
.ENDC
		EMT	^O375
.ENDM

.MACRO .UNLOCK
		EMT	^O347
.ENDM

.MACRO .WAIT	.CHAN
.IF DF ...V1
		EMT	^O<240+.CHAN>
.IFF
		CLR	%0
.IF NB .CHAN
		
.ENDC
		BISB	.CHAN,%0
		EMT	^O374
.ENDC
.ENDM

.MACRO .WRITE	.AREA,.CHAN,.BUFF,.WCNT,.BLK
.IF DF ...V1
.IF NB .WCNT
		MOV	.WCNT,%0
.ENDC
		MOV	#1,-(6.)
		MOV	.BUFF,-(6.)
		MOV	.CHAN,-(6.)
		EMT	^O<220+.AREA>
.IFF
.IF NB .AREA
		MOV	.AREA,%0
		MOVB	#9.,1(0)
.ENDC
.IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
.IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
.IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
.IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		MOV	#1,8.(0)
		EMT	^O375
.ENDC
.ENDM

.MACRO .WRITC .AREA,.CHAN,.BUFF,.WCNT,.CRTN,.BLK
.IF DF ...V1
 .IF NB .CRTN
		MOV	.CRTN,%0
.ENDC
		MOV	.WCNT,-(6.)
		MOV	.BUFF,-(6.)
		MOV	.CHAN,-(6.)
		EMT	^O<220+.AREA>
.IFF
 .IF NB .AREA
		MOV	.AREA,%0
		MOVB	#9.,1(0)
 .ENDC
 .IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
 .IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
 .IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
 .IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
 .IF NB .CRTN
		MOV	.CRTN,8.(0)
.ENDC
		EMT	^O375
.ENDC
.ENDM

.MACRO .WRITW .AREA,.CHAN,.BUFF,.WCNT,.BLK
.IF DF ...V1
 .IF NB .WCNT
		MOV	.WCNT,%0
.ENDC
		CLR	-(6.)
		MOV	.BUFF,-(6.)
		MOV	.CHAN,-(6.)
		EMT	^O<220+.AREA>
.IFF
 .IF NB .AREA
		MOV	.AREA,%0
		MOVB	#9.,1(0)
 .ENDC
 .IF NB .CHAN
		MOVB	.CHAN,(0)
.ENDC
 .IF NB .BLK
		MOV	.BLK,2.(0)
.ENDC
 .IF NB .BUFF
		MOV	.BUFF,4.(0)
.ENDC
 .IF NB .WCNT
		MOV	.WCNT,6.(0)
.ENDC
		CLR	8.(0)
		EMT	^O375
.ENDC
.ENDM
	.LIST
                                                                                                                                                                                                                                                                                                                                                                                                                   