@echo Off
rem Xilinx:VMH2WIR::
rem	SCCS: @(#)VMH2WIR.BAT	1.6 3/26/93 06:26:19

   if %1. ==-n. shift
   if %1. ==. goto nossdfn
   echo Creating Viewlogic wir simulation file for circuit %1.
   echo This could take ~30 minutes for a large 73108 design on a 386 machine!
   exist -f wir
   if not errorlevel 1 goto fwir_exist

   exist -d wir
   if errorlevel 1 mkdir wir> nul

   if %1. ==-m. goto arg1m

   if exist %1.vmh goto vmh
   if exist %1.vmd goto vmd
	echo Cannot find database file %1.vm[dh]!
	echo Please integrate the design and check for errors
	goto exit
:vmd
   echo edifout -r xnf -i %1 -n %1.xnf -l %1.lgx
   edifout -r xnf -i %1 -n %1.xnf -l %1.lgx
   if errorlevel 2 goto errexit
   goto xnf
:vmh
   echo hedifout -r xnf -i %1 -n %1.xnf -l %1.lgx
   hedifout -r xnf -i %1 -n %1.xnf -l %1.lgx
   if errorlevel 2 goto errexit
:xnf
   del wir\%1.* >nul

   if %2. ==-m. goto marg
   echo xnf2wir %1
   xnf2wir %1
   if errorlevel 1 goto xnferr
   goto okexit
:marg
   echo xnf2wir -m %3 %1
   xnf2wir -m %3 %1
   if errorlevel 1 goto xnferr

:okexit
   exist -d sch
   if errorlevel 1 goto exit

   echo adding dummy %1 wir files for simulation model
   xlstrip DW <wir\%1.1 >nullwir.tmp
   echo EW>>nullwir.tmp
   cd sch
for %%f in (%1.*) do if not exist ..\wir\%%f copy ..\nullwir.tmp ..\wir\%%f >nul
   cd ..
   goto exit

:arg1m
   if exist %3.vmh goto vmh1m
   if exist %3.vmd goto vmd1m
	echo Cannot find database file %3.vm[dh]!
	echo Please integrate the design and check for errors
	goto exit
:vmd1m
   echo edifout -r xnf -i %3 -n %3.xnf -l %3.lgx
   edifout -r xnf -i %3 -n %3.xnf -l %3.lgx
   if errorlevel 2 goto errexit
   goto xnf1m
:vmh1m
   echo hedifout -r xnf -i %3 -n %3.xnf -l %3.lgx
   hedifout -r xnf -i %3 -n %3.xnf -l %3.lgx
   if errorlevel 2 goto errexit
:xnf1m
   del wir\%3.* >nul

   echo xnf2wir %1 %2 %3
   xnf2wir %1 %2 %3
   if errorlevel 1 goto xnferr

   exist -d sch
   if errorlevel 1 goto exit

   echo adding dummy %3 wir files for simulation model
   xlstrip DW <wir\%3.1 >nullwir.tmp
   echo EW>>nullwir.tmp
   cd sch
for %%f in (%3.*) do if not exist ..\wir\%%f copy ..\nullwir.tmp ..\wir\%%f >nul
   cd ..
   goto exit

:nossdfn
	echo Missing parameter option {design name}
	goto exit
:fwir_exist
	echo Cannot make a wir directory because a file with
	echo that name already exists.  Please rename it.
	goto exit
:xnferr
	echo XNF2WIR probably ran out of memory
	echo Consider using DOS VMH2WIR {name} -m {num}
	echo {num} has default 1000, lower values need less memory.
	goto exit
:errexit
	echo Errors found!

:exit
	del nullwir.tmp >nul
