| Filename calc_4k.cmd.  XC4000/4000A/4000H version
| The reset sequence is different from the 3k version.
| This is a sample Viewsim command file.  It steps through 
|   the sequence of commands used in the Calc Viewsim 
|   Tutorial.  
| You can create a command file with any text editor, and 
|   run it in Viewsim simply by typing the name of the 
|   file.  The default extension is .cmd.

| Echo the command file to the screen, display time
dflts cmdfile time
| Re-initialize the circuit
restart
|--------------------VECTOR DEFINITION-------------------
| This file uses the convention that vector names are
|   capitalized; this is just a convenience.
| Use the name of the net between the pad and the buffer 
|   to drive the input at the pad.  Net names at lower 
|   levels of hierarchy are in the format
|   ...block_label\block_label\net_label.
| Use "+" to continue a long line
vector SW sw7\sw6_p sw7\sw5_p sw7\sw4_p sw7\sw3_p +
 sw7\sw2_p sw7\sw1_p sw7\sw0_p
| You can also use bus syntax when defining vectors
vector ALU alu[3:0]
vector STACK stack[3:0]
| Set radices for vectors
|   The default radix is binary for input, hex for output
radix hex SW ALU
radix bin STACK
|---------------SIMULATION OUTPUT DEFINITION--------------
| Select the nets and vectors for display in Viewwave. If 
|   bus syntax is used for nets, nets are still displayed 
|   individually.  If the vector name is used, the value
|   of the whole vector is displayed.
wave scalc.wfm clk SW exc_p ALU STACK we rst
| Save simulation values for these nodes
watch clk SW exc_p ALU STACK we rst
| Output the values of all watched signals each time 
|   "clk" goes high.  Create tabular output.
break clk 1 do (print > scalc.tab)
| Output node and vector transitions and simulation time
|   whenever any of the nodes or vectors changes state
trace clk SW exc_p ALU STACK we rst > scalc.trc
|-------------------CLOCK DEFINITION----------------------
clock clk 0 1
| Use a clock period of 100ns.  Set stepsize=50ns
step 50ns
|------------GLOBAL RESET & INITIAL INPUT VALUES----------
| Set initial values for all inputs using the "H" and "L"
|   commands for nets and "assign" for vectors
h exc_p
assign SW 00\h
| Initialize all flip-flops (globalsetreset is active high 
|   for 4k designs, you can abbreviate to gr)
h gsr
| Viewsim uses units of 0.1 ns, so this statement 
|   simulates for 100 ns.
sim 1000
l gsr
sim 1000
|------------------TESTING THE COMMANDS-------------------
| Exp_p going high is the execute command.  OPCODE is a 
|   three-digit opcode which operates on the DATA.  Opcode 
|   111 activates an extended instruction set which uses 
|   the data field as an extended opcode field, as external 
|   data is not required to execute these commands.

| Execute opcode 110 to Load data of 1 to ALU Register
assign SW 61\h
| Set exc_p low with the "L" command
l exc_p
| The cycle command steps forward by one clock cycle
cycle 2 
| Execute
| Set exc_p high with the "H" command
h exc_p
cycle 3
| Results:  SW=61\h => ALU=1\h STACK=0000

| Opcode 000: Add 13 from Switches to ALU Register
assign SW 0D\h
l exc_p
| You can abbreviate cycle as "c"
c 2
| Execute
h exc_p
c 3
| Results:  SW=0D\h => ALU=E\h STACK=0000

| Opcode 111-101x: Push Register value onto Stack
assign SW 7B\h
l exc_p
c 2
| Execute
h exc_p
c 4
| Results:  SW=7B\h => ALU=E\h STACK=1110

| Opcode 011: XOR 1111 on Switches with ALU Register
assign SW 3F\h
l exc_p     
c 2
| Execute
h exc_p
c 3
| Results:  SW=3F\h => ALU=1\h STACK=1110

| Opcode 111-110x: Pop Stack value into ALU Register
assign SW 7D\h
l exc_p
c 2
| Execute
h exc_p
c 3
| Results:  SW=7D\h => ALU=E\h STACK=0000

| Opcode 101: Clear the ALU Register
assign SW 50\h
l exc_p     
c 2
| Execute
h exc_p
c 3
| Results:  SW=50\h => ALU=0\h STACK=0000
