library synth;
use synth.stdsynth.ALL;

entity sevenx is
  port (
    signal bcd     :  in vlbit_1d(3 downto 0);
    signal seg     : out vlbit_1d(6 downto 0)
  );
end sevenx;

architecture first of sevenx is
    constant tbl : vlbit_2d(0 to 11, 10 downto 0 ) := (
--
--         2
--       1   3
--         6
--       0   4
--         5
--      bcd(3:0) | seg(6:0) | Error
-----------------+----------+-----------
           B"0000_0111111",
           B"0001_0011000",
           B"0010_1101101",
           B"0011_1111100",
           B"0100_1011010",
           B"0101_1110110",
           B"0110_1110111",
           B"0111_0011100",
           B"1000_1111111",
           B"1001_1111110",
           B"101X_XXXXXXX",
           B"11XX_XXXXXXX"
					);

begin
    pla_table( bcd, seg, tbl );
end first;
