Library synth;
Use synth.stdsynth.all;

-- Entity Declaration --- Declare Ports 
--------------------------------------- 
entity fsm_1hot_pla is
 port (
 signal reset, clk, data_in : in vlbit;
 signal pmatch : out vlbit
 );
end fsm_1hot_pla;
----------------------------------------------------
-- Architectural behavioral description

architecture first of fsm_1hot_pla is
 signal S, NXT_S: vlbit_1d (5 downto 0);
 signal tmp : vlbit_1d (6 downto 0);

constant tbl : vlbit_2d (0 to 11 , 12 downto 0) := (
-- S 	|d | NXT_S
--543210|  |543210
--------+--+--------
 B"XXXXX1_1_000010", 	-- S0 & 1 => S1
 B"XXXXX1_0_000001", 	-- S0 & 0 => S0
 B"XXXX1X_1_000100", 	-- S1 & 1 => S2
 B"XXXX1X_0_000001", 	-- S1 & 0 => S0
 B"XXX1XX_1_001000", 	-- S2 & 1 => S3
 B"XXX1XX_0_000001", 	-- S2 & 0 => S0
 B"XX1XXX_1_001000", 	-- S3 & 1 => S3
 B"XX1XXX_0_010000", 	-- S3 & 0 => S4
 B"X1XXXX_1_000010", 	-- S4 & 1 => S1
 B"X1XXXX_0_100000", 	-- S4 & 0 => S5
 B"1XXXXX_1_000010", 	-- S5 & 1 => S1
 B"1XXXXX_0_000001" );  -- S5 & 0 => S0
begin
	pmatch <= S(5) ; --(S= "1XXXXX")
	tmp <= S&data_in;
	pla_table (tmp, NXT_S, tbl);
----------------------------------------------
-- Seperate Clocked Process --
cntl: process
	begin
	wait until (prising(clk) or (reset = '1'));
	if (reset = '1') then
		S <= "000001"; -- reset => S0
	else
 		S <= NXT_S;
	end if;
end process cntl;

end first;

