package xblox is
  procedure xb_ACCUM(
        add_sub: in vlbit;
        c_in: in vlbit;
        b: in vlbit_1d;
        load, clk_en, clock, async_ctrl, sync_ctrl: in vlbit;
        q_out: out vlbit_1d;
        c_out, ovfl: out vlbit;
        attr: in string );
                -- ASYNC_VAL= 0
                -- SYNC_VAL= 0
                -- STYLE= HM/ALIGNED
                --
                --
  procedure xb_ADD_SUB(
        add_sub: in vlbit;
        c_in: in vlbit;
        a: in vlbit_1d;
        b: in vlbit_1d;
        func: out vlbit_1d;
        c_out: out vlbit;
        ovfl: out vlbit;
        attr: in string );
                -- STYLE= HM/ALIGNED
                --
                --
  procedure xb_BIDIR_IO(
        oe: in vlbit;
        outputs: in vlbit_1d;
        ie: in vlbit;
        inputs: out vlbit_1d;
        attr: in string );
                -- ENCODING= BIT/UBIN/TWO_COMP/ONE_HOT
                -- BOUNDS= 0:7/7:0
                -- FLOAT_VAL= 1/0/?/PULLUP/PULLDOWN
                -- LOC=A1
                -- LOC[6]= A11 `LOC[7]= P9
                --
                --
  procedure xb_BUS_DEF(
        xblox_bus: in vlbit_1d;
        attr: in string );
                -- ENCODING= BIT/UBIN/TWO_COMP/ONE_HOT
                -- BOUNDS= 0:7/7:0
                --
                --
  procedure xb_CLK_DIV(
        async_ctrl, sync_ctrl, en, clock: in vlbit;
        clk_out: out vlbit;
        attr: in string );
                -- DIVIDE_BY= 3
                -- DUTY_CYCLE= 1
                --
                --
  procedure xb_COMPARE(
        a: in vlbit_1d;
        b: in vlbit_1d;
        a_eq_b, a_ne_b, a_lt_b, a_gt_b, a_le_b, a_ge_b: out vlbit;
        attr: in string );
                -- STYLE= ARITH/ARITHWIRED/RIPPLE/WIRED/TREE
                --
                --
  procedure xb_COUNTER(
        d_in: in vlbit_1d;
        load, up_dn, async_ctrl, sync_ctrl, clk_en, clock: in vlbit;
        q_out: out vlbit_1d;
        term_cnt: out vlbit;
        attr: in string );
                -- ASYNC_VAL= 0
                -- SYNC_VAL= 0
                -- STYLE= BINARY/JOHNSON/LFSR
                -- COUNT_TO= 10
                --
                --
  procedure xb_DATA_REG(
        d_in: in vlbit_1d;
        async_ctrl, sync_ctrl, clk_en, clock: in vlbit;
        q_out: out vlbit_1d;
        attr: in string );
                -- ASYNC_VAL= 0
                -- SYNC_VAL= 0
                --
                --
  procedure xb_DECODE(
        sel: in vlbit_1d;
        en: in vlbit;
        d_out: out vlbit_1d;
        sel_error: out vlbit;
        attr: in string );
                --
                --
  procedure xb_ELEMENT(
        xblox_bus: in vlbit_1d;
        elem: in vlbit;
        attr: in string );
                -- ELEM= 3
                --
                --
  procedure xb_FORCE(
        force: out vlbit_1d;
        attr: in string );
                -- VALUE= 2#00001111#
                --
                --
  procedure xb_INPUTS(
        inputs: out vlbit_1d;
        attr: in string );
                -- ENCODING= BIT/UBIN/TWO_COMP/ONE_HOT
                -- BOUNDS= 0:7/7:0
                -- FLOAT_VAL= 1/0/?/PULLUP/PULLDOWN
                -- LOC=A1
                -- LOC[6]= A11 `LOC[7]= P9
                --
                --
  procedure xb_MUXBUS(
        mux_in: in vlbit_1d;
        sel: in vlbit_1d;
        mux_out: out vlbit_1d;
        sel_error: out vlbit;
        attr: in string );
                --
                --
  procedure xb_MUXBUS2(
        m1: in vlbit_1d;
        m0: in vlbit_1d;
        sel: in vlbit_1d;
        mux_out: out vlbit_1d;
        sel_error: out vlbit;
        attr: in string );
                --
                --
  procedure xb_MUXBUS4(
        m3: in vlbit_1d;
        m2: in vlbit_1d;
        m1: in vlbit_1d;
        m0: in vlbit_1d;
        sel: in vlbit_1d;
        mux_out: out vlbit_1d;
        sel_error: out vlbit;
        attr: in string );
                --
                --
  procedure xb_MUXBUS8(
        m7: in vlbit_1d;
        m6: in vlbit_1d;
        m5: in vlbit_1d;
        m4: in vlbit_1d;
        m3: in vlbit_1d;
        m2: in vlbit_1d;
        m1: in vlbit_1d;
        m0: in vlbit_1d;
        sel: in vlbit_1d;
        mux_out: out vlbit_1d;
        sel_error: out vlbit;
        attr: in string );
                --
                --
  procedure xb_OUTPUTS(
        outputs: in vlbit_1d;
        attr: in string );
                -- ENCODING= BIT/UBIN/TWO_COMP/ONE_HOT
                -- BOUNDS= 0:7/7:0
                -- FLOAT_VAL= 1/0/?/PULLUP/PULLDOWN
                -- LOC=A1
                -- LOC[6]= A11 `LOC[7]= P9
                --
                --
  procedure xb_PROM(
        addr: in vlbit_1d;
        d_out: out vlbit_1d;
        addr_error: out vlbit;
        attr: in string );
                -- MEMFILE= filename
                -- DEPTH= 1023
                --
                --
  procedure xb_SHIFT(
        par_in: in vlbit_1d;
        load, ms_in, ls_in, right_left: in vlbit;
        async_ctrl, sync_ctrl, clk_en, clock: in vlbit; 
        par_out: out vlbit_1d;
        ls_out, ms_out: out vlbit;
        attr: in string );
                -- STYLE= LOGICAL/CIRCULAR/ARITH
                -- ASYNC_VAL= 0
                -- SYNC_VAL= 0
                --
                --
  procedure xb_SLICE(
        main: in vlbit_1d;
        sub: in vlbit_1d;
        attr: in string );
                -- SLICE= 3:0
                -- SUB_STARTS_AT= 4
                -- SUB= 3:0
                --
                --
  procedure xb_SRAM(
        d_in: in vlbit_1d;
        wr_en: in vlbit;
        addr: in vlbit_1d;
        d_out: out vlbit_1d;
        addr_error: out vlbit;
        attr: in string );
                -- DEPTH= 777
                --
                --
  procedure xb_TRISTATE(
        oe: in vlbit;
        i: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- FLOAT_VAL= 1/0/?/PULLUP/PULLDOWN
                --
                --
-----
  procedure xb_ANDBUS(
        a: in vlbit_1d;
        o: out vlbit;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
  procedure xb_ANDBUS1(
        a: in vlbit;
        b: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
  procedure xb_ANDBUS2(
        a: in vlbit_1d;
        b: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
-----
  procedure xb_INVBUS(
        i: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
-----
  procedure xb_ORBUS(
        a: in vlbit_1d;
        o: out vlbit;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
  procedure xb_ORBUS1(
        a: in vlbit;
        b: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
  procedure xb_ORBUS2(
        a: in vlbit_1d;
        b: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
-----
  procedure xb_XORBUS(
        a: in vlbit_1d;
        o: out vlbit;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
  procedure xb_XORBUS1(
        a: in vlbit;
        b: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
  procedure xb_XORBUS2(
        a: in vlbit_1d;
        b: in vlbit_1d;
        o: out vlbit_1d;
        attr: in string );
                -- INVMASK= 2#1010#
                --
                --
-----
  procedure xb_INELEM(
        elem: in vlbit;
        xblox_bus: out vlbit_1d;
        attr: in string );
                -- ELEM= 2
                --
                --
  procedure xb_OUTELEM(
        xblox_bus: in vlbit_1d;
        elem: out vlbit;
        attr: in string );
                -- ELEM= 2
                --
                --
end xblox;
