restart
| network counters

vector A A[3:0]		| SYNC (input): 4-bit fully synchronous binary counter
vector B B[3:0]		| SYNC (output)
vector C C[3:0]		| ASYNC: 4-bit up/down Johnson ctr. with async. load
vector D D[3:0]		| LFSR: 4-bit linear-feedback shift register
vector E E[3:0]		| DECIMAL: 4-bit BCD counter

wfm gsr @0ns=1 @20ns=0	| Pulse the global reset

l ctrl1 ctrl2		| Deactivate SYNC load and sync_ctrl
l ctrl3 ctrl4		| Down-count on ASYNC, disable async. load
h ctrl5			| Enable clock on LFSR
sim 20ns

clock clk 0 1 0		| System clock, 15ns period = 70MHz
stepsize 5ns

check E 0\h >checkfnc.out	| Decimal zero on DECIMAL?
check tc_dec 0 >checkfnc.out	| Decimal terminal count not reached? (9)
check tc_lfsr 0 >checkfnc.out	| LFSR has not finished? (int. count = 1)
cycle				| Cycle once

check E 1\h >checkfnc.out	| Decimal one on DECIMAL?
check tc_dec 0 >checkfnc.out	| Dec. TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR has not finished? (int. count = 2)
cycle

check E 2\h >checkfnc.out	| Decimal = 2?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 3)
cycle

check E 3\h >checkfnc.out	| Decimal = 3?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 4)
cycle

check E 4\h >checkfnc.out	| Decimal = 4?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 5)
cycle

check E 5\h >checkfnc.out	| Decimal = 5?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 6)
cycle

check E 6\h >checkfnc.out	| Decimal = 6?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 7)
cycle

check E 7\h >checkfnc.out	| Decimal = 7?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 8)
cycle

check E 8\h >checkfnc.out	| Decimal = 8?
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 9)
cycle

check E 9\h >checkfnc.out	| Decimal = 9?
check tc_dec 1 >checkfnc.out	| Decimal TC REACHED at 9?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 10)
cycle

check E 0\h >checkfnc.out	| Decimal = 0? (wraparound)
check tc_dec 0 >checkfnc.out	| Decimal TC not reached?
check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 11)
cycle

check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 12)
cycle

check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 13)
cycle

check tc_lfsr 0 >checkfnc.out	| LFSR not TC? (int. count = 14)
cycle

check tc_lfsr 1 >checkfnc.out	| LFSR is TC? (int. count = 15)
l ctrl5				| Disable LFSR clock
cycle

check tc_lfsr 1 >checkfnc.out	| LFSR is TC? (int. = 15, clock DISABLED)
h ctrl5				| Re-enable LFSR clock
cycle

check tc_lfsr 0 >checkfnc.out	| LFSR is not TC? (int. count = 1)

assign A 0001\b			| Try loading bit 0 of SYNC counter
h ctrl1				| Enable parallel load
l ctrl2				| No synchronous control
cycle

check B 0001\b >checkfnc.out	| Check, is only bit 0 high?
assign A 0010\b			| Try loading bit 1 of SYNC counter
cycle

check B 0010\b >checkfnc.out	| Check, is only bit 1 high?
assign A 0100\b			| Try loading bit 2 of SYNC counter
cycle

check B 0100\b >checkfnc.out	| Check, is only bit 2 high?
assign A 1000\b			| Try loading bit 3 of SYNC counter
cycle

check B 1000\b >checkfnc.out	| Check, is only bit 3 high?
l ctrl1				| Disable parallel load
h ctrl2				| Enable synchronous control
cycle

check B a\h >checkfnc.out	| Is the output equal to 10?
l ctrl2				| Disable all synchronous loads
cycle

check B b\h >checkfnc.out	| Is the output equal to 11?
cycle

check B c\h >checkfnc.out	| Is the output equal to 12?
cycle

check B d\h >checkfnc.out	| Is the output equal to 13?
cycle

check B e\h >checkfnc.out	| Is the output equal to 14?
cycle

check B f\h >checkfnc.out	| Is the output equal to 15?
cycle

check B 0\h >checkfnc.out	| Is the output equal to 0? (wraparound)
cycle

check B 1\h >checkfnc.out	| Is the output equal to 1?
cycle

check B 2\h >checkfnc.out	| Is the output equal to 2?
cycle

check B 3\h >checkfnc.out	| Is the output equal to 3?
cycle

check B 4\h >checkfnc.out	| Is the output equal to 4?
cycle

check B 5\h >checkfnc.out	| Is the output equal to 5?
cycle

check B 6\h >checkfnc.out	| Is the output equal to 6?
cycle

check B 7\h >checkfnc.out	| Is the output equal to 7?
cycle

check B 8\h >checkfnc.out	| Is the output equal to 8?
h ctrl4				| For next stage, load Johnson counter
cycle

check B 9\h >checkfnc.out	| Is the output equal to 9?
cycle

check B a\h >checkfnc.out	| Is the output equal to 10?
cycle

h ctrl3				| Make ASYNC an up Johnson counter
l ctrl4				| Turn off async. load
check C 1110\b > checkfnc.out	| Is Johnson = 1110?
cycle

check C 1111\b > checkfnc.out	| Is Johnson = 1111?
cycle

check C 0111\b > checkfnc.out	| Is Johnson = 0111?
cycle

check C 0011\b > checkfnc.out	| Is Johnson = 0011?
cycle

check C 0001\b > checkfnc.out	| Is Johnson = 0001?
cycle

check C 0000\b > checkfnc.out	| Is Johnson = 0000?
cycle

check C 1000\b > checkfnc.out	| Is Johnson = 1000?
cycle

check C 1100\b > checkfnc.out	| Is Johnson = 1100?
cycle

check C 1110\b > checkfnc.out	| Is Johnson = 1110? (full circle)
l ctrl3				| Try it counting down
cycle

check C 1100\b > checkfnc.out	| Is Johnson = 1100?
cycle

check C 1000\b > checkfnc.out	| Is Johnson = 1000?
cycle

check C 0000\b > checkfnc.out	| Is Johnson = 0000?
cycle

check C 0001\b > checkfnc.out	| Is Johnson = 0001?
cycle

check C 0011\b > checkfnc.out	| Is Johnson = 0011?
cycle

check C 0111\b > checkfnc.out	| Is Johnson = 0111?
cycle

check C 1111\b > checkfnc.out	| Is Johnson = 1111?
cycle

check C 1110\b > checkfnc.out	| Is Johnson = 1110?
cycle

exit
