FTAM ANALYSIS

FTAM analysis supports the  following protocol stack:

         Layer 1      (supports any Chameleon I/O Module)
         Layer 2       HDLC
         Layer 3       X.25
         Layer 4       X.224
         Layer 5       X.225
         Layer 6       X.226
         Layer 7       x.227  (ACSE)
                       X.228  (RTSE)
                       X.229  (ROSE)
                       FTAM


FTAM FUNCTION KEYS

The function keys control how the data is displayed and
interpreted.  The following conventions are used for function 
keys F1 - F6:

   +   The data for that layer is displayed in an interpreted 
       mode.

   "   The data for that layer is displayed in an 
       uninterpreted format.  The format is determined by 
       the selection made with the F10 key.

   *   The data for that layer is displayed in both 
       interpreted and uninterpreted formats.

   -   The data for that layer is acquired, but is 
       not displayed.


F1 PHYS   F1 PHYS specifies how the physical layer (layer 1)
          data is displayed.  The physical layer protocol is 
          determined by the Physical Interface parameter
          in the Chameleon main configuration menu.   

          When the physical layer is uninterpreted (PHYS" 
          or PHYS*), the upper layers are not interpreted,
          regardless of their function key selections.
          This causes all data above layer 1 to be displayed 
          uninterpreted in the format selected with F10.


F2 HDLC   F2 HDLC determines how layer 2 (HDLC) is displayed.
          HDLC is displayed in green.


F3 X25    F3 X25 determines how layer 3 (X.25) is displayed.  
          The X.25 data is displayed in yellow. 


F4 X224   F4 X224 determines how layer 4 (X.224) is displayed.
          The X.224 data is displayed in cyan.


F5 X225   F5 X225 determines how layer 5 (X.225) is displayed.
          The X.225 data is displayed in magenta.


F6 X226   F6 X226 determines how the layer 6 (X.226) data
          is displayed.  This data is displayed in ASN.1 in 
          a combination of white, green, cyan, and magenta.


F7 FTAM   F7 FTAM determines how the layer 7 (X.227, X.228, 
          X.229 and FTAM)) data is displayed.  This data is 
          displayed in ASN.1 in a combination of white, 
          green, cyan, and magenta.


F9        F9 determines how the upper layer data (layers 3 
          and above) is displayed.  The options are:

          Summary  Layers 1 and 2 are fully interpreted.  A 
                   summarized interpretation of layers 3 and 
                   above are displayed:
                   X.25   Displays the packet type
                   X.224  Displays the block type
                   X.225  Displays the Session Command/ 
                          Response and Document Command/ 
                          Response (if applicable)
                   X.226  Displays the highest level X.226
                          element only (nested elements are
                          not shown)
          Full     All layers are fully decoded and displayed.


F10       F10 determines the display format of data item 
          values.  The options are:

          Meaning  When possible, the interpretation of 
                   the value  is displayed.  If the meaning is 
                   not defined by the protocol, the value is 
                   displayed in hex.  
           Hex       The value is displayed in hex.
           Decimal   The value is displayed in decimal. 
           Binary    The value is displayed in binary.
           ASCII     The value is displayed in ASCII.
           EBCDIC    The value is displayed in EBCDIC.
           Offset    The offset of the item from the start of 
                     the acquired event is shown in the format
                     n.m, where n is the number of octets 
                     and m is the number of bits within the 
                     octet.
           Length   The length of the item is shown in the 
                    format n.m, where n is the number of octets
                    and m is the number of bits.


FTAM COMMANDS

The following commands can be used when a history page is 
selected.


?        This command displays the current software version 
         and monitoring mode.  The syntax is:

                ?


\         This command can be used only within a configuration 
          file.  It is a literal escape character which 
          executes a function key command from within a 
          configuration file.  The syntax is: 

                 \ n

          n  is in the range 1 - 9 or 0 and represents the 
          function keys F1 - F10, respectively.  Each time 
          this command is used for a specific function key, it 
          is as though the function key were pressed.  


:assemble   This command reassembles and decodes segmented 
            application layer data.  A maximum of 500 events 
            can be reassembled and decoded.

            :assemble  Reassembles and decodes the segmented 
                       application layer data in the next 500 
                       events, beginning with the event which 
                       is currently displayed at the top of the 
                       history page.

                       If the buffer has already been frozen 
                       using the :freeze command, this 
                       reassembles the data in the frozen 
                       buffer.

            :assemble n1  n2   Reassembles and decodes the 
                               segmented application layer data 
                               in the range of events, where n1 
                               is the first event and n2 the 
                               last event in the range.


:close     This command closes the currently selected  
           history page.  The syntax is:

                :close


:data      This command should be used when the Chameleon is 
           in internal mode only.  (Internal mode enables the 
           Chameleon to analyze  data from a text file.)

           The :data command opens a text file with the data in 
           hex, builds events from the contents, and processes 
           them with the monitoring application.  The 
           text file must adhere to the following format:

           -Contain event data in hex with one event per line
           -Maximum event length of 256 bytes
           -Optional first character of the event can specify 
            which side of the line the data comes from:

                <   DTE event
                >   DCE event (default)

            You can use either of the following commands to 
            analyze a hex file:

                :data "filename"
                :data "filename" HEX

            filename may include a path.  If a path is not 
            included, it searches the directory :

                a:\tekelec\data\hex\


:filter    Filters the traffic in the acquisition buffer so 
           that only events matching user-defined criteria are 
           displayed in history and real time.  The filtering 
           criteria are defined using the triggering editor, 
           which is invoked by the :trigger command.  You can 
           define a maximum of 16 criteria at a time.
   
               :filter number op number...

           number is the criterion number as shown in the 
           triggering editor.  op is one of the following
           operators:

                &    AND
                !    NOT
                ?    OR

            To stop filtering so that all data from the 
            acquisition buffer is displayed, Use:

               :filter off


:freeze    This command freezes the history display so that it 
           is not updated with new data being acquired.  This 
           can be used to view selected data without it being 
           overwritten by newly acquired data.

           :freeze        Freezes the history display to show 
                          the 500 more recently acquired events

           :freeze n1 n2  Freezes the history display, showing 
                          only a user-specified range of events 
                          from the acquisition buffer.  n1 is 
                          the first event in the range, and n2 
                          is the last event in the range.  



:jump      This command displays a specified event at the top 
           of the history page.  The syntax is:
  
              :jump n

           n is the number of the event you want to display.


:open    This command opens a new history page.  A maximum of 
         seven  history pages can be open at a time.  The
         syntax is:

             :open COLOR name PORT

         COLOR is the color of the page banner, as one of the 
         following, and must be in UPPER CASE letters:

             RED     GREEN     YELLOW
             BLUE     MAGENTA     CYAN
             WHITE (default color, if no color is specified)

         name is the page name of 1 - 13 upper and lower case 
         characters.  If you include blank spaces in the name,
         the string must be enclosed in quotation marks.

         PORT is the port being monitored, either A or B.


:print     This command outputs the interpretation of specified 
           events to a disk file or to the printer.  The syntax
           is:

             :print "name" first last  Saves specified range of
                                       events to filename.

             :print .PRT first last  Outputs specified range of 
                                     events to the printer
                                     .PRT must be UPPER CASE

           name may also include a path.  If path is not 
           included, the file is saved to the directory:

             a:\tekelec\data\hist\

           first is the first event number in the range and 
           last is the last event number in the range.  If last 
           is not specified, only the first event is saved.
           If a range is not specified (first and last are 
           omitted), all events are saved in the file until 
           a :print command is given with a different 
           filename or no filename.


:quit    This command closes all  pages and exits the 
          monitoring application.  

         You can also exit  monitoring by selecting 
         the Configuration page and using the Stop or 
         Exit function keys.  The syntax is:

            :quit


:read     This command executes an  configuration file.
          The syntax is:

             :read "filename"


:restore    This command loads a triggering criteria file into 
            memory.  The criteria can then be:

            - Edited by accessing the triggering editor 
              (:trigger)

            - Used for filtering or scanning the data in the 
              acquisition buffer (:filter or :scan)

              :restore  Loads the DEFAULT triggering criteria 
                        file from the directory:

                            a:\tekelec\analysis\x25\trig

              :restore filename   Loads a user-specified file 
                                  from disk.  filename may also 
                                  include a path.  If a path is 
                                  not specified, it searches 
                                  the directory:

                                   a:\tekelec\analysis\x25\trig


:save     This command outputs the specified events in hex to 
          a disk file.  This generates a file in the 
          correct format to be accessed by the :data 
          command. 

            :save "filename" first last 


          first is the first event number in the range and last 
          is the last event number in the range.  If last 
          is not specified, only the first event is saved.

          If a range is not specified (first and last 
          are omitted), all events are saved in the file until 
          a :save command is given with a different filename 
          or no filename.


:scan      Displays the next event matching user-defined 
           criteria as defined using the triggering editor, 
           The syntax is:

               :scan number op number...

           number is the criterion number as shown in the 
           triggering editor  op is one of the following 
           operators:

              &    AND
              !    NOT
              ?    OR

            To stop scanning so that all data from the 
            acquisition buffer is displayed, Use:

               :scan off


:set option   This command sets the value of a protocol 
              specific parameter.  For this release, the only 
              available option is the X.224 transport class.
              The syntax is:

              :set x224 class n

                 where n is the range 0 - 4, as follows:

                   0   Simple Class
                   1   Basic Error Recovery Class
                   2   Multiplexing Class
                   3   Error Recovery and Multiplexing Class
                   4   Error Detection and Recovery Class


:set cham32   Selects the  monitoring mode, as follows:

              External mode is the normal mode which causes the 
              Chameleon to analyze data from its acquisition 
              buffer.   This is the default mode.

              Internal mode enables the Chameleon to analyze 
               data that has been saved in a text file.
              The syntax is:

                set cham32 on        Selects external mode
                set cham32 off       Selects internal mode


:set separator   Toggles the event separator on and off.  
                 When on, a white line with the event number 
                 appears below each event, acting as a 
                 delimiter between events.  When off, there is 
                 no separation between events.  The syntax is:

                   :set separator on    Event separator is on. 
                   :set separator off   Event separator is off.


:set timebase   This command uses a specified event as the time 
                base.  Time stamps for all other events are 
                shown relative to that event.  The syntax is:

                   :set timebase n

                n is the event number to use as the time base.


:show     Displays the number of the criteria currently being 
          used for filtering or scanning. The syntax is:

              :show filter
              :show scan


:store       This command stores a triggering criteria file 
             to disk.  

             :store     Saves the DEFAULT triggering criteria 
                        file from the directory:

                            a:\tekelec\analysis\x25\trig

             :store filename      Saves a user-specified file 
                                  to disk.  filename may also 
                                  include a path.  If a path is 
                                  not specified, it saves to 
                                  the directory:

                                   a:\tekelec\analysis\x25\trig


:trigger     Invokes the triggering editor, which allows you to 
             define up to 16 criteria for searching the data in 
             the acquisition buffer.  You can then use the 
             :filter or :scan commands to use one or more 
             criteria.  The syntax is:

                 :trigger


:unassemble  This command turns assembly mode off so that 
             reassembled application layer data is once again 
             displayed as segmented data.  This command also 
             unfreezes the history display so that newly 
             acquired data is shown in the display.


:unfreeze    This command unfreezes a history display which has 
             been frozen using the :freeze command.

                 :unfreeze

