
Basic Rate Interface Library Filename:   libbri.a

Bas_version   Returns the current version of the BRI library.
              char *Bas_version();


GETIME    Gets the number of milliseconds elapsed since the 
          system was started.
          #include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;


GETPORT   Identifies which port is communicating with the     
          library.
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected.
           -1=Neither port selected.


SetBasic   int SetBasic(cmdblock, resblock);
           int cmdblock [5];
           int resblock [5];

          Error codes for resblock[0]:

          resblock [0]    Meaning
              00          Successful
              01          Hardware has already been set up
              02          Function not avail. for config.
              03          Channel is invalid
              04          Function not avail. for channel
              05          Invalid command or request
              06          DTMF tone position out of range
              07          BRI parameters not set
              09          BRI menu is running (cannot access
                          BRI from the C library)
              10          BRI board is not installed

   Setup
     cmdblock[0] = 1 (Board 0) or cmdblock[0] = 101 (Board 1)
     cmdblock[1]  mode   1   Monitor
                         2   Simulate NT
                         3   Simulate TE
     resblock[1]   Returns current mode, if unsuccessful

   Reactivate
     cmdblock[0] = 2 (Board 0)  or cmdblock[0] = 102 (Board 1)
     Argument     None

   Reset
     cmdblock[0] = 3 (Board 0) or cmdblock[0] = 103 (Board 1)
     Argument     None

   Channel Functions
     cmdblock[0] = 4 (Board 0)  or cmdblock[0] = 104 (Board 1)
     cmdblock[1]   mode   0   Do not override 
                          1   Override 
     cmdblock[2]   channel   1   B1 channel
                             2   B2 channel
                             3   D channel
     cmdblock[3]   selection   1   System
                               2   Milliwatt
                               3   Codec
                               4   External interface
                               5   Idle
     resblock[1]   channel (If resblock[0] ?0)
     resblock[2]   selection (If resblock[0] ?0)

   Signal Functions
     cmdblock[0] = 5 (Board 0)  or cmdblock[0] = 105 (Board 1)
     cmdblock[1]   For NT   1   Deactivate request
                            2   Send info-2
                            3   Send info-4
                            4   Activate NT
                            5   Reserved
                            6   Send single pulses
                            7   Send continuous pulses
                            8   Send info-2, test loop 2
                            9   Send info-4, test loop 2

                   For TE   1   Deactivate
                            2   Activate at priority 8
                            3   Activate at priority 10
                            4   Activate TE
                            5   Reserved
                            6   Reserved
                            7   Reset PEB 2080
                            8   Send single pulses
                            9   Send continuous pulses
                           10   Activate test loop 3

   Get Status
     cmdblock[0] = 6 (Board 0)  or cmdblock[0] = 106 (Board 1)
     Argument   None
     resblock[1]    Control byte received from PEB 2080.

     If Simulating an NT:
       resblock[2]   1   No clock signal
                     2   Lost signal level
                     3   Receiver not synchronous
                     4   Error
                     5   Info-1 received
                     6   Receiver synchronized
                     7   Deacitvation complete
                     8   Undefined

     If Simulating a TE:
       resblock[2]   1   Power up
                     2   Deactivate request
                     3   Slip detected
                     4   Disconnected
                     5   Error
                     6   Resynchronizing
                     7   Info-2 received
                     8   Test mode
                     9   Level recd during test loop
                    10   Info-4 recd, D-ch priority 8 or 9
                    11   Info-4 recd, D-ch priority 10 or 11
                    12   Quiescent state
                    13   Undefined
     If in Monitor mode:
       resblock[1]   Control byte received from PEB 2080.
       resblock[2]   Same as resblock[2] from NT
       resblock[3]   Same as resblock[2] from TE


   Select Trace Option
     cmdblock[0] = 9 (Board A only)
     cmdblock[1]   0   Turns off the trace
                   1   Command/result display
                   2   Detailed trace


   NT Power
     cmdblock[0] = 10 (Board A) or cmdblock[0] = 110 (Board B) 
     cmdblock[1]   mode   1   Power source 1 (normal cond.)
                          2   Power source 1 (emergency)
                          3   Power source 2 (normal cond.)
                          4   Power source 2 (emergency)
                          5   Off


   Board Version
     cmdblock[0] = 11 (Board A) or cmdblock[0] =111 (Board B)

     resblock[1]      BRI board version number


   Bit Inversion
     cmdblock[0] = 12 (Board A) or cmdblock[0] =112 (Board B)

     cmdblock[1]   1     Bit inversion on
                   2     Bit inversion off


   DTMF Tone Selection
     cmdblock[0] = 13 (Board A) or cmdblock[0] =113 (Board B)

     This sets the Dual Tone Multi-Frequency array to specify
     the tones to transmit for the Generate DTMF Tone function.
     Maximum of 20 digits.  The final digit must be zero. 

     cmdblock[1]   Position of the tone in the array.
     cmdblock[2]   DTMF tone (valid ASCII digit)


   Generate DTMF Tone
     cmdblock[0] = 14 (Board A) or cmdblock[0] =114 (Board B)

     This function dials the numbers in the DTMF tone array
     as specified in the DTMF Tone Selection function.



SETLEDS   Controls which port's LEDs are displayed on the 
          front panel.of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
           -1=Invalid parameter
           -2=Dual Port board not installed


SETPORT   Selects Port A or Port B for library.
          #include <cham.h>
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available


SETTIME   Sets the timer value.
          settimer(number,value)
          char number;   0=.01 timer (down)
                         1=.01 timer (up)
                         2=seconds (down)
                         3=seconds (up)
          unsigned int value;       timer setting
          Returns:
            0=Successful
            1=Invalid number
            2=inittime not performed


TIMER     Returns the value of the timer.
          timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)

