APPLICATION PROGRAMMER'S INTERFACE C LIBRARY

The Application Programmer's Interface C Library provides 
function which enable you to develop applications with 
pull-down menu interfaces.  The library is named libui.a 
and is located in the directory a:\lib.  

It contains the functions and commands described below.
For descriptions of the data structures used by the 
functions, refer to the Application Programmer's Interface 
manual.

addNewLine()  Inserts one line to a list selector.

              addNewLine (s, str)
              SCRAREA      *s;
              byte      *str;

              *s  Pointer to scrolling area of a BOXREQ.
              *str  Pointer to the string to be inserted.

              Returns:  None


box_input   BOX_INPUT creates a list box of selections at 
            run-time.  See box_req for more information. 


box_req       The structure type BOXREQ is used to define 
              the box.


cSToggle ()   Marks a specified position within a box 
              or list selector with a character.  

              cSToggle (s, n, mode, ch, ch1)
              SCRAREA  *s;
              int  n, mode;
              char ch, ch1;

              s      A pointer to the scrolling area 
                     within a BOXREQ
              n      Position within the box
              mode   0    Toggle
                     1    Set
              ch     First marker character
              ch1    Second marker character

              Returns:  0  Set to first marker, ch.
                        1  Set to second marker, ch1


dsp_req      Displays text within a window.  The structure 
            type DSPREQ is used to specify the 
            information to be displayed.


erase_field      Request to erase a specific field from a 
                 window.  This will erase both the 
                 description and the associated value.


eraseb_req      This requests that an entire list box be 
                erased from the screen.  The structure 
                required for this request is of the type 
                ERASEREQ.


erasew_req      This requests that a window be erased from 
                the screen.  The structure required for 
                this request is of the type ERASERQ.


eraseEOS()      This function erases the screen from line 
                3 downward.  It is useful in conjunction 
                with pull down menu logic.

                eraseEOS()

                Returns:   None


fillBoxArea()   This function initializes the scrolling
                linked list located within the structure
                BOXREQ.  This must be done once, typically in 
                the beginning of the program, before a box or 
                list selector can be accessed through a call to 
                userInterface().

                fillBoxArea (req, strlist)
                BOXREQ      *req;
                byte      *strlist[];

                req       A pointer to BOXREQ
                strlist   Address of the array containing the 
                          strings to be entered in the list box

                Returns:  None


getBoxArea()    This function allocates space to the 
                scrolling area of a list selector.  The linked 
                list is also initialized.  If the area needs to 
                be re-initialized at any point, this function 
                can be called again.

                getBoxArea (breq)
                BOXREQ    *breq;

                Returns:  None


getFileChoice()   This function displays a list of files.  
                  The function reads the directory specified by 
                  the path for each occurence of a file with 
                  the specified extension.  For each occurence, 
                  the filename is loaded into the list 
                  selector.

                  getFileChoice (boxName, fPath, ext, bTitle, 
                  errMsg, insFlag, inserts, fnum, conf)

                  BOXREQ    *boxName;
                  byte      *fPath;
                  byte      *ext;
                  byte      *bTitle;
                  byte      *errMsg;
                  int       insFlag
                  byte      ** inserts;
                  int       fnum;
                  BOXCONF   *conf;

                  *boxName   A pointer to BOXREQ
                  *fpath     Directory path
                  *ext       File extension
                  *bTitle    Title string to be displayed
                  *errMsg    Error string that will be
                             displayed at if no files exist
                  insFlag    When set to TRUE, this inserts the 
                             "number of lines specified in fnum 
                             into the list box.  Otherwise, set 
                             to FALSE.
                 **inserts   A pointer to an array of strings 
                             to be inserted when insFlag = 
                             TRUE.  Otherwise set to NIL.
                  fnum       When insFlag is set to true, this 
                             is the number of lines to be 
                             inserted.
                  *conf      A pointer to the BOXCONF structure

                 This function contains an optional insert 
                 feature that permits you to insert strings 
                 into the list selector prior to the filenames.  
                 The insert strings are defined by an array of 
                 pointers. This utilizes the parameters 
                 insFlag, **inserts and fnum.

                 Returns:  The BOXCONF structure contains exit 
                           information.


initUI ()      This function initializes the user interface.  
               initUI() must be called before any other call 
               is made to the interface.

               initUI (dsp, box, req, nw, nb)

               DISPLAY      *dsp;
               BOX      *box;
               WINDOWREQ      *req;
               int   nw;
               int   nb;

              *dsp   A pointer to the window administration 
                     area
              *box   A pointer to the list box 
                     administration area
              *req   Window initiation of ERROR_WINDOW
              nw     NUM_OF_WINDOWS
              nb     NUM_OF_BOXES

              Returns:  None.


input_req    This command displays a sequence of fields to be 
             edited.  The following keys can be used during 
             runtime operation to modify the field values.

              CTRL-N      Go to the next field
              CTRL-P      Go to the previous field
              CTRL-I      Insert  mode (Default=overwrite)
              CTRL-D      Delete to end of line
              CTRL-A      Go to the beginning of the line
              CTRL-E      Go to the end of the line
              RETURN      Go to the next field
              Space Bar   Toggle between preset values


             There are three types of structures required to 
             initiate an INPUT_REQ.  

             The INPREQ structure defines the location and 
             color of parameters displayed, the prompt text 
             and other messages.

             The INPUT_FIELD_TYPE structure  defines a field 
             on the screen.  To define a sequence of fields, an 
             array of these structures is declared.  The last 
             entry of this array is defined as {0, 0, 0, 0 ,0 , 
             ...} or zero for all values.

             The FKEY_FIELD_TYPE structure defines the preset 
             acceptable values for a field.


rel_req      This request is used to de-allocate the memory set 
             aside for a window and releases the associated 
             window number.  This should be done when a window 
             will not be used again.


unMark ()    This function removes all marks used to identify 
             selections within a list box.

             unMark (s)
             SCRAREA      *s;

             *s      A scroll area within the box to be cleared

             Returns:  None


userInterface()   This function gives the user access to 
                  the user interface.  Each library request or 
                  command is initiated through a call to this 
                  function.

                  userInterface (req, conf, dsp, box)
                  byte      *req;
                  byte      *conf;
                  DISPLAY   *dsp;
                  BOX      *box:

                  req    A pointer to the structure 
                         containing the request type or event
                  conf   A pointer to the
                  dsp    A pointer to the window admin. area
                  box    A pointer to the list box admin. area

                  The output is put in a structure of the type 
                  CONFIRM, where applicable.  


window_req      The command WINDOW_REQ can be used to 
                initialize a window which will display 
                information or it can display a frame around an 
                input request.  There are three types of 
                windows:

               -A scrolling window displays information each 
                time a DSP_REQ is made.  The window is a fixed 
                size, with the information scrolling either 
                forward, with new information added at the 
                bottom of the list, or backward, with new 
                information added at the top.  

               -A static window displays information at a fixed 
                location within a window.  The information does 
                not remain in an allocated memory position, and 
                requires a subsequent DSP_REQ to redisplay.  
                This can be used to draw a frame.

               -A static window with field sequences displays 
                information from an allocated memory position 
                to a fixed location within a window.  A field 
                sequence is made up of several titles and 
                values.

               The parameters for the WINDOW_REQ are 
               incorporated into four structures:

                    WINDOWREQ
                    FIELD
                    FIELD_DEF 
                    FIELD_SEQ

