/* @(#)video.h	1.4 3/4/91 */

/*********************************************************************
		
		VIDEO.H - CHAMELEON 32 C LIBARY DEFINITIONS

/******************************************************************/

/* VIDEO AND KEYBOARD DEFINITION   */
/* add (char *) , define CR..., first 6, HIGHLIGHT*/

/* video attributes */

#define	CURPOS(x,y)	(char *)"\033[x;y\146"
#define	MOVHOR(n)	(char *)"\033[n\143"
#define	MOVVER(n)	(char *)"\033[n\141"
#define	INSERTLN(n)	(char *)"\033[n\114"
#define	DELETELN(n)	(char *)"\033[n\115"
#define	CURFHOR(c)	(char *)"\033[c\103"
#define	CR	13
#define	LF	10
#define	BS	8
#define	BEL	7
#define	FF	12
#define	VT	11

#define HOME		(char *)"\033[f"
#define	INSERT		(char *)"\033[4h"
#define REPLACE		(char *)"\033[4i"
#define DELETE		(char *)"\033[4P"
#define ERAEOL		(char *)"\033[0K"
#define ERAEOS		(char *)"\033[0J"
#define CLEARS		(char *)"\033[2J"
#define NORM		(char *)"\033[0m"
#define HILITE		(char *)"\033[1m"
#define	UND			(char *)"\033[4m"
#define FLASH		(char *)"\033[5m"
#define IVON		(char *)"\033[7m"

#define HIGHLIGHT	(char *)"\033[1m"	/* alternate for HILITE */

/* Cursor movment requires paramaters, See manual for definition */

/* foreground colors */

#define FBLACK		(char *)"\033[30m"
#define FRED		(char *)"\033[31m"
#define FGREEN		(char *)"\033[32m"
#define FYELLOW		(char *)"\033[33m"
#define FBLUE		(char *)"\033[34m"
#define FMAGENTA	(char *)"\033[35m"
#define FCYAN		(char *)"\033[36m"
#define FWHITE		(char *)"\033[37m"

/* background colors */

#define BBLACK		(char *)"\033[40m"
#define BRED		(char *)"\033[41m"
#define BGREEN		(char *)"\033[42m"
#define BYELLOW		(char *)"\033[43m"
#define BBLUE		(char *)"\033[44m"
#define BMAGENTA	(char *)"\033[45m"
#define BCYAN		(char *)"\033[46m"
#define BWHITE		(char *)"\033[47m"

/* function keys */

#define	FNCT_1		0x81
#define	FNCT_2		0x82
#define	FNCT_3		0x83
#define	FNCT_4		0x84
#define	FNCT_5		0x85
#define	FNCT_6		0x86
#define	FNCT_7		0x87
#define	FNCT_8		0x88
#define	FNCT_9		0x89
#define	FNCT_10		0x8A

/* page libraries calls */

extern	long	_stdvt;			/* stantard vt number */
extern	char	getch ();		/* poll key boards */
extern	char	getcwt ();		/* get one char unbuffered */
extern	long	openform ();	/* opens a form */
extern	long	openvt ();		/* opens a page, returns a vt number */
extern	int	assigleds ();		/* put leds on the function keys */
extern	int	closeform ();	
extern	int	closevt ();
extern	int	disablecur ();
extern	int	enablecur ();
extern	int	endprint ();
extern	int	prntdata ();
extern	int	selprn (); 

/* arrow keys */

#define	UP		11
#define	DOWN	10
#define	RIGHT	12
#define	LEFT	8

/* other keys */

#define	HELP	23
#define GO		25	
#define CANCEL	24
#define SHIFT_CANCEL	-101
