/* @(#)mtosux.h	1.4 2/21/91 */

/***************************************************
*                                                  *
*  Copyright 1986 by INDUSTRIAL PROGRAMMING, Inc.  *
*            1985    Jericho, N.Y.  11753          *
*                                                  *
*                                                  *
*    This software is furnished to the purchaser   *
*  under a license which forbids reproduction in   *
*  whole or part  except as provided  in writing   *
*  by INDUSTRIAL PROGRAMMING, Inc.                 *
*                                                  *
***************************************************/
 
 
/*  C language header for MTOS-UX tasks
 
    Author         David L. Ripps
    Written        23 February 1984
    Version        1.4
    Last edit      16 October 1986  */
 
 
/***********************************************
*                                              *
*        COMPILER-DEPENDENT DEFINITIONS        *
*                                              *
***********************************************/

#if 0
#define	short
#endif

/***********************************************
*                                              *
*          STANDARD  PARAMETER  NAMES          *
*                                              *
***********************************************/
 
 
/* Coordination Modes [qual] */
 
#define WAIFIN 0x00000L /* wait for finish */
#define CTUNOC 0x08000L /* continue: no coor */
#define CLEF0  0x10000L /* continue, set LEF 0 when done */
#define CLEF1  0x10800L /*                   1 */
#define CLEF2  0x11000L /*                   2 */
#define CLEF3  0x11800L /*                   3 */
#define CLEF4  0x12000L /*                   4 */
#define CLEF5  0x12800L /*                   5 */
#define CLEF6  0x13000L /*                   6 */
#define CLEF7  0x13800L /*                   7 */
#define CLEF8  0x14000L /*                   8 */
#define CLEF9  0x14800L /*                   9 */
#define CLEF10 0x15000L /*                  10 */
#define CLEF11 0x15800L /*                  11 */
#define CLEF12 0x16000L /*                  12 */
#define CLEF13 0x16800L /*                  13 */
#define CLEF14 0x17000L /*                  14 */
#define CLEF15 0x17800L /*                  15 */
#define CSIG0  0x18000L /* continue, set SIG 0 when done */
#define CSIG1  0x18800L /*                   1 */
#define CSIG2  0x19000L /*                   2 */
#define CSIG3  0x19800L /*                   3 */
#define CSIG4  0x1A000L /*                   4 */
#define CSIG5  0x1A800L /*                   5 */
#define CSIG6  0x1B000L /*                   6 */
#define CSIG7  0x1B800L /*                   7 */
#define CSIG8  0x1C000L /*                   8 */
#define CSIG9  0x1C800L /*                   9 */
#define CSIG10 0x1D000L /*                  10 */
#define CSIG11 0x1D800L /*                  11 */
#define CSIG12 0x1E000L /*                  12 */
#define CSIG13 0x1E800L /*                  13 */
#define CSIG14 0x1F000L /*                  14 */
#define CSIG15 0x1F800L /*                  15 */
 
 
/* event flag values  */
 
#define EFAND 0L       /* AND-test */
#define EFOR  0x10000L /* OR-test */
#define EFRST 0L       /* reset flag(s) */
#define EFSET 0x10000L /* set flag(s) */
 
#define EF0   0x8000L /* flag 0 */
#define EF1   0x4000L /*      1 */
#define EF2   0x2000L /*      2 */
#define EF3   0x1000L /*      3 */
#define EF4   0x0800L /*      4 */
#define EF5   0x0400L /*      5 */
#define EF6   0x0200L /*      6 */
#define EF7   0x0100L /*      7 */
#define EF8   0x0080L /*      8 */
#define EF9   0x0040L /*      9 */
#define EF10  0x0020L /*     10 */
#define EF11  0x0010L /*     11 */
#define EF12  0x0008L /*     12 */
#define EF13  0x0004L /*     13 */
#define EF14  0x0002L /*     14 */
#define EF15  0x0001L /*     15 */
#define EFALL 0xFFFFL /* all flags */
 
 
/* Mailbox open modes [mode] */
 
#define MBRCV 0L /* receive */
#define MBSND 1L /* send */
 
 
/* Message buffer attributes */
 
#define MSBGBL 0x80000000 /* global */
#define MSBLC0 0x00000000 /* local: proc 0 */
#define MSBLC1 0x00010000 /*             1 */
#define MSBLC2 0x00020000 /*             2 */
#define MSBLC3 0x00030000 /*             3 */
#define MSBLC4 0x00040000 /*             4 */
#define MSBLC5 0x00050000 /*             5 */
#define MSBLC6 0x00060000 /*             6 */
#define MSBLC7 0x00070000 /*             7 */
#define MSBLC8 0x00080000 /*             8 */
#define MSBLC9 0x00090000 /*             9 */
#define MSBLCA 0x000A0000 /*             A */
#define MSBLCB 0x000B0000 /*             B */
#define MSBLCC 0x000C0000 /*             C */
#define MSBLCD 0x000D0000 /*             D */
#define MSBLCE 0x000E0000 /*             E */
#define MSBLCF 0x000F0000 /*             F */
 
 
/* Peripheral I/O Options [pn] */
 
#define NORMAL 0x00L /* normal */
#define PREEMP 0x80L /* pre-emptive */
 
 
/* Peripheral I/O Functions [fun] */
 
#define PIORSV 0L /* reserve unit */
#define PIORLS 1L /* release unit */
#define PIOWRI 2L /* write */
#define PIOREA 3L /* read (with default prompt) */
#define PIOREP 4L /* read with given prompt */
#define PIOWTR 4L /* write then read */
#define PIOFMT 5L /* format */
#define PIORE1 5L /* read 1 char */
#define PIORST 5L /* reset */
 
 
/* Signal parameters */
 
#define SIGBLK  2L /* become blocked */
#define SIGDFL -1L /* reinstate default */
#define SIGIGN  0L /* ignore signal */
#define SIGTRM  4L /* terminate */
 
#define SIG0   0x80000000L /* signal 0 */
#define SIG1   0x40000000L /*        1 */
#define SIG2   0x20000000L /*        2 */
#define SIG3   0x10000000L /*        3 */
#define SIG4   0x08000000L /*        4 */
#define SIG5   0x04000000L /*        5 */
#define SIG6   0x02000000L /*        6 */
#define SIG7   0x01000000L /*        7 */
#define SIG8   0x00800000L /*        8 */
#define SIG9   0x00400000L /*        9 */
#define SIG10  0x00200000L /*       10 */
#define SIG11  0x00100000L /*       11 */
#define SIG12  0x00080000L /*       12 */
#define SIG13  0x00040000L /*       13 */
#define SIG14  0x00020000L /*       14 */
#define SIG15  0x00010000L /*       15 */
#define SIG16  0x00008000L /*       16 */
#define SIG17  0x00004000L /*       17 */
#define SIG18  0x00002000L /*       18 */
#define SIG19  0x00001000L /*       19 */
#define SIG20  0x00000800L /*       20 */
#define SIG21  0x00000400L /*       21 */
#define SIG22  0x00000200L /*       22 */
#define SIG23  0x00000100L /*       23 */
#define SIG24  0x00000080L /*       24 */
#define SIG25  0x00000040L /*       25 */
#define SIG26  0x00000020L /*       26 */
#define SIG27  0x00000010L /*       27 */
#define SIG28  0x00000008L /*       28 */
#define SIG29  0x00000004L /*       29 */
#define SIG30  0x00000002L /*       30 */
#define SIG31  0x00000001L /*       31 */
#define SIGALL 0xFFFFFFFFL /* all signals */
 
 
/*  start-task parameters  */
 
#define CSTART 0x00000L /* coor based on task start */
#define CTERM  0x20000L /*                    termination */
 
#define LRGPTY 0x0000L /* use larger of inh & cur prty */
#define GVNPTY 0x0100L /*     given priority */
#define CURPTY 0x0200L /*     cur prty of requester */
#define INHPTY 0x0300L /*     inh prty of target */
 
 
/*  task language codes (TCD) */
 
#define ASM  0 /* assembler */
#define C    1 /* C */
#define PAS  6 /* PASCAL */
#define C0  15 /* C that returns value in D0, such as UNIX V */
 
 
/*  task attributes */
 
#define DUR 0x00 /* durable */
#define TRN 0x80 /* transient */
#define REL 0x00 /* relocatable */
#define ABS 0x40 /* absolute */
#define APP 0x00 /* application */
#define SYS 0x20 /* system */
#define SUB 0x10 /* subpart (sharing code/data) */
 
 
/*  task restart parameters  */
 
#define STRTIM 0x0000L /* base restart on starting time */
#define TRMTIM 0x8000L /*                 termination time */
 
 
/*  time interval codes  */
 
#define MS    256L /* MS */
#define TMS 2*256L /* 10 MS */
#define HMS 3*256L /* 100 MS */
#define SEC 4*256L /* seconds */
#define MIN 5*256L /* minutes */
#define HRS 6*256L /* hours */
#define DAY 7*256L /* days */
 
#define IMONLY MS+0L /* immediate only */
#define NXTICK MS+1L /* next tick */
#define NOEND  0L    /* no end */
 
 
/*  SVC status values  */
 
#define NOERR 0L /* no error detected */
 
#define DUPTSK 1L /* duplicate task */
#define DUPPUN 1L /* duplicate peripheral unit */
#define NOTFRE 1L /* SF has been released, but is still not free */
#define NOTDMT 1L /* task was not dormant */
#define NOTOUT 1L /* task was not paused (no timeout) */
#define TIMCAN 1L /* pause cancelled */
#define UNXEOT 1L /* UNIX input terminated by prompt */
#define MBDLT  2L /* MB has been deleted */
#define MBEOF  3L /* MB is empty & closed at send end */
 
#define BADPRM -1L /* bad parameter detected */
#define QUEFUL -2L /* no facilities avail to queue or create */
#define BADFUL -3L /* bad parameter detected & no facilities to process err */
#define TIMOUT -4L /* service timedout before completion */
#define NOTAVL -5L /* service not avaiable */
#define NOTSUP -6L /* subservice or option not supported */
#define DLTPND -7L /* deletion pending on target (task, unit, etc) */
#define ATMAXI -8L /* at maximum value */
#define RSVERR -9L /* (pio) reserve/release error */
#define PHYFLR -10L /* (pio) physical failure */
#define BADATT -11L /* bad attribute */
#define BADKEY -12L /* bad key */
#define BADLNG -13L /* bad language index */
#define BADPRC -14L /* bad processor index */
#define BADSTL -15L /* bad stack length */
#define BADTIM -16L /* bad time interval units */
#define NEEDFN -17L /* need file name */
#define NOTOPN -18L /* file or MB not open */
#define NOFILE -19L /* file does not exist */
#define UNIXFL -20L /* read, write or other UNIX failure */
#define MAGICN -21L /* load file has invalid "magic number" */
#define NRELOC -22L /* load file has no relocation entries */
#define FORMAT -23L /* file does not have proper format */
#define NOULDR -24L /* no loader present on UNIX system */
#define EXPOOL -25L /* load file exceeds pool size */
 
/* Change Priority Basis */
 
#define ADDVAL 1L /* add given value to current priority */
#define USEVAL 0L /* use given value as priority */
 
 
/*****************************************
*                                        *
*          STANDARD  STRUCTURES          *
*                                        *
*****************************************/
 
#define KEY(chr1,chr2,chr3,chr4) ((chr1<<24)+(chr2<<16)+(chr3<<8)+chr4)

/*
#define KEY(chr1,chr2,chr3,chr4) (('chr1'<<24)+('chr2'<<16)+('chr3'<<8)+'chr4')
*/
#ifndef ANAL
typedef  char      byte ;
typedef  short int word ;
#endif
 
typedef  long      addr      /* use LONG addresses */;
 
struct bodiop {              /* pio parameters for byte-oriented device */
         char     *aub       /* addr of main user bfr */;
         long int  lub       /* len  of main user bfr */;
         char     *axb       /* addr of auxiliary bfr */;
         long int  spl       /* timeout for read, or special data */;
              };
 
 
struct incprm {              /* pio parameters for UNIX write-then-read */
         char     *ctxt      /* addr of output text */;
         char     *cbuf      /* addr of input bfr */;
         long int  clen      /* len  of input bfr */;
              };
 
 
struct indprm {              /* pio parameters for UNIX read */
         char     *dbuf      /* addr of bufr */;
         long int  dlen      /* len  of bufr */;
              };
 
 
struct edf {					/* exception data frame */
         unsigned short fen;	/* frame type (=0x80) exc vec num */
         short int pin;				/* processor index (0 - 15) */
           };
 
 
struct lcb {                 /* load communication block */
         short int  lfn      /* function: 0 = load */;
         char       lat      /* attributes */;
         char       llg      /* local/global task specifier */;
         char       *lpf     /* ptr to name of pgm file */;
         long int   lti      /* identifier of task being created */;
         long int  (*lep)()  /* entry point */;
         long int   lls      /* len of stack seg, bytes */;
         long int   llu      /* len of uninit data seg, bytes */;
         long int   lai      /* addr of initialized data seg */;
         long int   llc      /* len of code seg, bytes */;
         long int   lli      /* len of initialized data seg, bytes */;
         long int   lac      /* addr of code seg */;
         long int   lau      /* addr of uninitialized data seg */;
           };
 
 
struct mef {                 /* in-MTOS exception frame */
         unsigned short fes  /* frame type (=0x90) // equiv sig */;
         short int msr       /* MTOS SR for fault */;
         long  int mpc       /*      PC           */;
         short int ssw       /* special status word */;
         long  int mra       /* memory ref addr */;
         short int pix       /* processor index (0 - 15) */;
           };
 
 
struct outprm {              /* pio parameters for UNIX write */
         char     *otxt      /* addr of text */;
         long int  olen      /* leng of text */;
              };
 
 
struct radiop {              /* pio parms for block-oriented ra device */
         long int  lba       /* starting logical block addr */;
         short int nb        /* number of blocks */;
         char      lun       /* logical unit number (drive) */;
         char      dsd[3]    /* driver-specific data */;
         char     *iob       /* addr of input/output bfr */;
              };
 
 
struct scf {                 /* signal context frame */
         short int fsn       /* frame type (=0x00) // sig num */;
         long int  tti       /* tid of target task */;
         long int  drg[8]    /* D0 - D7 of target task */;
         long int  arg[7]    /* A0 - A6 */;
         long int  sp        /* sp (A7) */;
         short int sr        /* sr */;
         long int  pc        /* pc */;
         char      et        /* except type: 0 = non-SVC, 1 = SVC */;
         char      pi        /* processor index (0 - 15) */;
         long int  srv       /* SVC return value */;
         char      lsn       /* last sig num (0xFF = none) */;
         char      lsl       /*          level */;
           };
 
 
struct tcd {                 /* task control data */
         long int  key       /* key */;
         char      attr      /* attributes */;
         char      lclgbl    /* local/global task specifier */;
         char      lang      /* language code */;
         char      ipr       /* inherent priority */;
         short int copr      /* coprocessor use flags */;
         long int  (*ep)()        /* entry point */;
         long int  stklen    /* length of stack */;
         long int  udalen    /* len of uninit data, if abs */;
         long int  ida       /* addr of initialized data, if abs */;
         short int apct      /* auto priority change: time interval */;
         char      apci      /*                       increment */;
         char      apcl      /*                       limit */;
         char     *pgmfil    /* ptr to name of pgm file, if rel */;
         };
 
 
struct ucd {                 /* unit control data */
         long int  uky       /* key */;
         int     (*drv)()    /* addr of driver program */;
         long int  uns       /* key of unsolicited interrupt task (0=none) */;
         int      *ddp       /* addr of driver-dependent parameters */;
         char      pid       /* id of processor recv intrpts */;
         char      spr       /* spare */;
         char      ivn[4]    /* vector num for intrpts 0-3 */;
           };
 
 
/*************************************
*                                    *
*          MTOSUX  SERVICES          *
*                                    *
*************************************/


extern long int alloc()        /* allocate blocks from common memory pool */;
extern long int alofbp()       /*                      fixed block mem pool */;
extern int canpau()            /* cancel pause */;
extern long int cansig()       /*        pending signal */;
extern int clsmbx()            /* close mailbox */;
extern int contsk()            /* connect task to interrupt */;
extern long int crcmp()        /* create common memory pool */;
extern long int crcsv()        /*        group of CSVs */;
extern long int crefg()        /*        event flag group */;
extern long int crfbp()        /*        fixed block memory pool */;
extern long int crmsb()        /*        message buffer */;
extern long int crpun()        /*        peripheral unit */;
extern long int crsem()        /*        semaphore */;
extern long int crtsk()        /*        task */;
extern long dalloc()            /* return blocks to memory pool */;
extern int dalfbp()            /*        block to fixed blk pool */;
extern int dlcmp()             /* delete common memory pool */;
extern int dlcsv()             /*        group of CSVs */;
extern int dlefg()             /*        event flag group */;
extern int dlfbp()             /*        fixed block memory pool */;
extern int dlmbx()             /*        mailbox */;
extern int dlmsb()             /*        message buffer */;
extern int dlsem()             /*        semaphore */;
extern dltsk()                 /*        task */;
extern int exeprc()            /* execute on given processor */;
extern exit()                  /* exit (task) */;
extern long int getcmp()       /* get identifier of common memory pool */;
extern long int getdad()       /*     address of data segments */;
extern long int getfbp()       /*     identifier of fixed memory pool */;
extern int getidn()            /*     system identification */;
extern int getime()            /*     (MS) time */;
extern long int getkey()       /*     key given tid */;
extern long int getmsb()       /*     identifier of message buffer */;
extern int getmsn()            /*     message from buffer, no wait */;
extern int getmsw()            /*     message from buffer, with wait */;
extern long int getsig()       /*     response to signal */;
/* note: actual use is: (*getsig())()   but this may cause problems in
                                         extern accessing return value */
extern long int getstc()       /* get standard console */;
extern long int gettid()       /*     identifier of task */;
extern int gettod()            /*     time of day */;
extern long int getuid()       /*     identifier of peripheral unit */;
extern long int opnmbx()       /* open mailbox */;
extern int pause()             /* pause for given time interval */;
extern int pausig()            /*       until signal arrives */;
extern int pio()               /* do peripheral I/O */;
extern int putmsb()            /* post message to beg of buffer */;
extern int putmse()            /*                 end of buffer */;
extern int rcvmbx()            /* recv message from mailbox */;
extern int rlscsv()            /* release group of CSVs */;
extern int rlssem()            /*         semaphore */;
extern unsigned short setpty()  /* set priority of task */;
extern int setsig()            /*     signal response */;
extern int setstc()            /*     standard console */;
extern int settod()            /*     time of day */;
extern long int sgiefg()       /*     event flag after given interval */;
extern int sgisig()            /* send signal after given interval */;
extern int sndmbx()            /*      message to mailbox */;
extern int sndsig()            /*      signal */;
extern long int srsefg()       /* (immediately) set/reset event flags */;
extern long int srslef()       /*                         local event flags */;
extern int start()             /* start task */;
extern int syntod()            /* synchronize with time of day */;
extern trmrst()                /* terminate task w restart aft gvn interval */;
extern int tstart()            /* transfer start of task */;
extern int usecsv()            /* wait to use group of CSVs */;
extern long int waiefg()       /*      for event flag group */;
extern int waicsv()            /*          function of CSVs to be true */;
extern int waisem()            /*          semaphore */;

