/* @(#)cham.h	1.2 11/16/90 */
/*****************************************************************
		
		CHAM.H - CHAMELEON 32 C LIBARY DEFINITIONS

******************************************************************/

#ifndef FALSE
#define	FALSE	0
#endif
#ifndef TRUE
#define	TRUE	1
#endif

#define DONE		0		/* function finished */

					/* standardize error codes */

#define	ERR_PORT_BUSY						-200
#define	ERR_FEP_PARAMETER					-201
#define	ERR_FEP_PARAMETER_PORT				-202
#define	ERR_CANT_DO_ON_AN_ISDN_INTERFACE 	-203
#define	ERR_FEP_CODE_NOT_FOUND 				-208
#define	ERR_FEP_START 						-209
#define	ERR_TXMODE_NOT_VALID				-211
#define	ERR_TIME_OUT 						-212
#define	ERR_NO_MEMORY						-213
#define	ERR_FEP_CODE_READ					-214
#define	ERR_FEP_COPIER_NOT_FOUND			-215
#define	ERR_FEP_CODE_NOT_LOADED				-216
#define	ERR_FEP_HALT						-217
#define	ERR_NO_PORT_B						-218
#define	ERR_INTERNAL_RUNNING				-219
#define	ERR_LOAD_FEP_ERROR					-220
#define	ERR_UNDEFINED_STATUS				-222
#define	ERR_FEP_DATA_NOT_SET				-224
#define	ERR_UNKNOWN_FEP_ERROR				-225
#define	ERR_NOT_IN_A_NORMAL_DISCONNECTED_MODE	-226

#define	ERR_FEP_RECEIVE_BUFFER_OVERFLOW_T	4
#define	ERR_FEP_RECEIVE_BUFFER_OVERFLOW_R	3

#define	NO_FRAME_WAITING 					0
#define FEP_BUSY_TRANSMITING				1
#define	ERR_INITP1_NOT_PERFORMED 			2
#define	ERR_NO_LINK_ESTABLISHED 			3
#define FEP_BUSY_WORKING					4

#define	ERR_TX_PARAMETERS					3
#define	ERR_NOT_A_PRIMARY_STATION			5

#define	ERR_NOT_A_P5						-1
#define	ERR_PARAMETERS 						-1

	/* link states HDLC, LAPD  */

#define	DISCONNECTED				0
#define	LINK_CONNECTION_REQUESTED		1
#define	FRAME_REJECT_STATE			2
#define	LINK_DISCONNECTION_REQUESTED		3
#define	INFORMATION_TRANSFER			4
#define	LOCAL_STATION_BUSY			5
#define	REMOTE_STATION_BUSY			6
#define	LOCAL_AND_REMOTE_STATION_BUSY		7
#define	REMOTE_STATION_NOT_RESPONDING		8
#define	LINK_DISABLED				9

	/* link states SDLC primary */

#define	NORMAL_DISCONNECTED_MODE			0
#define	LINK_REQUEST_STATE				1
#define	DISCONNECT_REQUEST_STATE			2
#define	NORMAL_RESPONCE_MODE				3
#define	LOCAL_PU_BUSY					4
#define	REMOTE_PU_BUSY					5
#define	LOCAL_AND_REMOTE_PU_BUSY			6

	/* different link states meanings SDLC secondary */

#define	INITIALIZATION_MODE		1
#define	FRAME_REJECT_MODE		2

	/* FEP states, returned from get_fep_state */

#define	FEP_BUSY	100
#define	FEP_FREE	101
#define	FEP_RUNNING	102

/* timers numbers */

#define	TIMER_DOWN_HUNDRETHS 	0
#define	TIMER_UP_HUNDRETHS 	1
#define	TIMER_DOWN_SECONDS	2
#define	TIMER_UP_SECONDS	3

/* transmit modes auto lapd				 		*/

#define	IFRAME  	0x80	/* sequenced information frame 		*/
#define	UI		0x81	/* unumbered      ""      ""  		*/
#define	XIDC		0x82	/* xid command    ""      ""   		*/
#define	XIDR		0x83	/* xid responce   ""      ""   		*/
#define	TEST		0x83	/* test frame   		*/

#define RESP_IFRAME	0x84	/* response iframe	*/
/* transmit status bop */

#define	GOOD_CRC	0
#define	BAD_CRC		1
#define	ABORT		2
#define	RX_ABORT	4

	/* data source, SIMON, D<-D, or line */

#define	EXTERNAL	0
#define	INTERNAL	1

	/* interframe fill */

#define		FILL7E		1
#define		FILLFF		0

	/* physical interface */

#define		DCE		0
#define		DTE		1

	/* level 2 side */

#define		NETWORK		0
#define 	SUBSCRB		1 
#define 	SUBSCRIBER	1 
#define		V120		0
#define 	PRIMARY 	0
#define 	SECONDRY 	1
#define 	SECONDARY 	1

	/* bisync idle mode selection */

#define		IDLE		0
#define		SYNC		1

	/* nrz selection */

#define		NRZ		0
#define		NRZI		1

	/* port selection */

#define		PORTA		0
#define		PORTB		1
#define		PORTAB		2

	/* bisync BCC definitions */

#define		CRC_16		0
#define		CCITT		1
#define		LRC		2

	/* bisync data tables */

#define		EBCDIC_DATA	0x10
#define		ASCII_NONE_DATA	0x04
#define		ASCII_EVEN_DATA	0x01
#define		ASCII_ODD_DATA	0x00

	/* bcc simulation control structure */

struct BSC_CTRL {
	unsigned	char	eot;
	unsigned	char	syn;
    unsigned	char	dle;
    unsigned	char	stx;
    unsigned	char	etx;
    unsigned	char	soh;
    unsigned	char	etb;
    unsigned	char	itb;
    unsigned	char	enq;
};

	/* Async definitions */

	/* baud rates */

#define		B50		1	/* 50 baud rate */
#define		B75		2	/* 75 baud rate */
#define		B110		3	/* 110 baud rate */
#define		B150		4	/* 150 baud rate */
#define		B300		5	/* 300 baud rate */
#define		B600		6	/* 600 baud rate */
#define		B1200		7	/* 1200 baud rate */
#define		B2400		8	/* 2400 baud rate */
#define		B4800		9	/* 4800 baud rate */
#define		B9600		10	/* 9600 baud rate */
#define		B19200		11	/* 19200 baud rate */

	/* parity selections */

#define		NONE		0	/* none parity */
#define		ODD		1	/* odd parity */
#define		EVEN		2	/* even parity */

	/* stop bit selections */

#define		STOP1		0	/* 1 stop bit */
#define		STOP15		1	/* 1.5 stop bit */
#define		STOP2		2	/* 2 stop bit */

	/* duplex mode selections */

#define		FULL		0	/* full duplex */
#define		HALF		1	/* half duplex */

	/* reception modes */

#define		BLOCKMODE	0	/* block mode */
#define		CHARMODE	1	/* charactor mode */

	/* Data bits selections */

#define		DATABIT5	5
#define		DATABIT6	6
#define		DATABIT7	7
#define		DATABIT8	8

	/* async control structure */

struct ASC_CTRL {
	int	bitrate;	/* baud rate */
	int	parity;		/* parity */
	int	stop;		/* stop bits */
	int	data;		/* data bits */
	int	duplex;		/* full/half duplex */
	int	block;		/* charactor/block mode */
	unsigned	char 	eob;		/* end of block charactor */
};		

	/* async reception */

#define	GOOD_BLOCK_CHAR		0
#define	PARITY_ERROR		1
#define	BREAK_DETECT		4



/****************************   ANALYSIS DEFINITIONS    **********/



typedef struct {			/* event structure */
	unsigned short	type;		/* type of event */
	unsigned short	length;		/* data length */
	unsigned short	buflen;		/* user buffer length */
	unsigned char	*pdata;		/* user buffer */
	long		seconds;
	long		ms20;
	unsigned short	special;	/* Baud rate or Lead change */
	unsigned short	crc;		/* CRC value */
	unsigned short	flags;		/* flgs count */
} event;

	/*  return from getevent */

#define	SUCCESSFUL			0
#define	NO_EVENT			-1
#define	DATA_OVERRITEN		-2
#define	WRONG_PORT			-3

	/* event type masks */

#define EM_CRC			0x8000	
#define EM_ABT			0x4000
#define EM_SIDE			0x2000
#define	EM_DATA			0x1c00
#define	EM_PORT			0x0002
#define	EM_AMPM			0x0001

	/* data event type (& EM_DATA) */

#define	NULL_EVENT		0x0000
#define	LEAD_TRANS		0x0400
#define	ASYNC_DATA		0x0800
#define	BAUD_RATE		0x0c00
#define	BOP_DATA		0x1000
#define	BSC_DATA		0x1800

	/* protocol definitions */

#define		BOP		1
#define		ISDN		2		/* bop ISDN interfaces */
#define		ASYNC		7
#define		BISYNC		8

#define		ASCII		0		/* bisync control characters */
#define		EBCDIC		1

union PARBLOCK {
					/* BOP parameter block */
	struct {
		unsigned short encode;	/* 0 - NRZ, 1 - NRZI */
	} pbop;

					/* Bisync parameter block */
	struct  {
		unsigned short	table;  /* 0 - ASCII, 1 - EBCDIC */
		unsigned short	bcc;	/* 0 - CRC16, 1 - LRC, 2 - CCITT */
		char		sync1;
		char		sync2; 
		unsigned short	parity;	/* 0 - NONE, 1 - ODD, 2 - EVEN */
	} pbisync;

					/* Async parameter block */
	struct  {
		unsigned short	baud;	/* baud rate */
		unsigned short	parity;	/* 0 - NONE, 1 - ODD, 2 - EVEN */
		unsigned short	databit;/* 5, 6 or 7 data bits */
	} pasync;
};

/****************************************************************/

extern char	*p1vrn ();
extern char	*version ();
extern char	*anal_version ();

/****************************************************************/


