static char SccsId[] = "@(#)bltest.c	1.2 3/25/92" ;


	#include <stdio.h>
	#include <cham.h>
	#include <ctype.h>
	#include <fcntl.h>
	#include <init.h>
	#include <video.h>
	#include <bertlib.h>
	#include <mtosux.h>

extern int tes1, tes2; /* test line */

main()
	{
	char insit,answer;
	extern int rxlen;
	int result,tempi;
	long int oval,newval;


	printf("C program started.\n");
	start_p1();

disp_menu();
set_ptrn(0);
set_mode(1);
reset_data();

while(1){
 answer=0;
while ((answer == -1) || (answer == 0)){
	pause(10+256L);
	answer=getch(_stdvt); 
		}
switch(answer){

	case 'a': error_on();
		  break;

	case 'b': one_block();
		  printf("\033[19;12f");
		  printf("one block test           \n");
		  break;

	case 'c': reset_data();
		  break;

	case 'd': disp_stat();
		  break;

	case 'e': error_sel();
		  break;

	case 'i': one_error();
		  break;

	case 'l': sbl_len();
		  break;

	case 'm': selct_mode();
		  break;

	case 'o': error_off();
		  break;

	case 'p': selct_pat();
		  break;

	case 'r': cont_run();
		  printf("\033[19;12f");
		  printf("STARTING TEST            \n");

		  break;

	case 'q': 
		  exit(0);
		  break;

	case 's': stop_test();
		  printf("\033[19;12f");
		  printf("STOPPING TEST            \n");
		  break;

	case 't': time_test();
		  break;

	case 'u': update();
		}
	}
}

update()
{
 char inp;
 long val;
 double dval;

  inp=0;
  printf("\033[2J\n");
  while (inp != ' ')
{
		  printf("\033[1;1f");
  printf("\033[35m	             TEST RESULTS\n");

  val = get_runtime();
  printf("\n\033[36m Run time .................. %010.0lu seconds      \n",val);

  val = get_tbits();
  printf("\033[36m Transmitted bits .......... %010.0lu       \n",val);

  val = get_rbits();
  printf("\033[36m Received bits ............. %010.0lu       \n",val);

   val = get_tbiterrs();
  printf("\033[33m TX bit errors inserted .... %010.0lu       \n",val);

   val = get_rbiterrs();
  printf("\033[31m RX bit errors ............. %010.0lu       \n",val);

  dval = get_er_rt();
  printf("\033[31m RX bit error ratio ........ %2.2le         \n",dval);

  val = get_blkerrs();
  printf("\033[31m RX block errors ........... %010.0lu       \n",val);

  val = get_errsec();
  printf("\033[31m Errored seconds ........... %010.0lu       \n",val);

  val = get_syncloss();
  printf("\033[33m Sync lost ................. %010.0lu times        \n",val);

disp_stat();

  printf("\n\033[5m\033[35m type A, C, I, O, Q, R, or S.   <space>  exit to menu\033[0m\n");
	pause(10+256L);
	inp=getch(_stdvt);
  switch(inp){
	case 'a': error_on();
		  break;

	case 'c': reset_data();
		  break;

	case 'i': one_error();
		  break;

	case 'o': error_off();
		  break;

	case 'q': 
		  exit(0);
		  break;

	case 'r': cont_run();
		  break;

	case 's': stop_test();
		  break;
	}



}
  disp_menu();

}
disp_stat()
{
char insit;
 insit = status();
		printf("\033[19;12f");
		switch(insit){
		case 0:
			printf("FEP is idle              \n");
			break;
		case 1:
			printf("Test running, out of sync\n");
			break;
		case 2:
			printf("Test running, in sync     \n");
			break;
			}
  }


disp_menu()
{
	printf("\033[2J");
	printf("	BERT LIB TEST PROGRAM FUNCTION MENU\n\n");
	printf("	A - auto error on\n");
	printf("	B - run one block\n");
	printf("	C - clear data buffer\n");
	printf("	D - display FEP status\n");
	printf("	E - set error rate\n");
	printf("	I - insert one error\n");
	printf("	L - set block length\n");
	printf("	M - set mode\n");
	printf("	O - auto error off\n");
	printf("	P - set pattern\n");
	printf("	Q - exit\n");
	printf("	R - run continuous\n");
	printf("	S - stop test\n");
	printf("	T - run timed test\n");
	printf("	U - get/display collected data\n");

}


sbl_len()
{
char answer;
	printf("\033[2J");
	printf("  BERT LIB TEST PROGRAM BLOCK LENGTH SELECTION\n\n");
	printf("	A - 100\n");
	printf("	B - 500\n");
	printf("	C - 1000\n");
	printf("	D - 2000\n");
	printf("	E - 5000\n");
	printf("	F - 10000\n");
	printf("	G - 20000\n");

answer = 0;
while ((answer == -1) || (answer == 0)){
	pause(10+256L);
	answer=getch(_stdvt); 
		}
switch(answer){
	case 'a': block_len(100);
		  break;
	case 'b': block_len(500);
		  break;
	case 'c': block_len(1000);
		  break;
	case 'd': block_len(2000);
		  break;
	case 'e': block_len(5000);
		  break;
	case 'f': block_len(10000);
		  break;
	case 'g': block_len(20000);
		  break;

	}
  disp_menu();

}

error_sel()
{
char answer;
	printf("\033[2J");
	printf("  BERT LIB TEST PROGRAM ERROR RATE MENU\n\n");
	printf("	A - NONE\n");
	printf("	B - 1.00E-5\n");
	printf("	C - 1.00E-4\n");
	printf("	D - 9.84E-4\n");
	printf("	E - 1.00E-3\n");
	printf("	F - 1.02E-3\n");
	printf("	G - 1.04E-2\n");


answer = 0;
while ((answer < 'a') || (answer > 'g')){
	pause(10+256L);
	answer=getch(_stdvt); 
		}

	set_err_rate((answer & 7) - 1);

  disp_menu();

}

selct_pat()
{
char answer;

	printf("\033[2J");
	printf("  BERT LIB TEST PROGRAM PATTERN SELECTION\n\n");
	printf("	A - BERT 63\n");
	printf("	B - BERT 511\n");
	printf("	C - BERT 2047\n");
	printf("	D - BERT 4095\n");
	printf("	E - BERT 32767\n");
	printf("	F - 101010\n");
	printf("	G - FOX MESSAGE\n");
	printf("	H - USER PATTERN\n");


answer = 0;
while ((answer == -1) || (answer == 0)){
	pause(10+256L);
	answer=getch(_stdvt); 
		}

set_ptrn((answer & 0x0f) - 1);

  disp_menu();

}



selct_mode()
{
char answer;

	printf("\033[2J");
	printf("	BERT LIB TEST PROGRAM FUNCTION MENU\n\n");
	printf("	A - REMOTE LOOPBACK\n");
	printf("	B - LOCAL LOOPBACK\n");
	printf("	C - RECEIVE ONLY\n");

answer = 0;
while ((answer == -1) || (answer == 0)){
	pause(10+256L);
	answer=getch(_stdvt);
		}
 set_mode(answer & 7);

  disp_menu();

}

time_test()
{
char answer;
long time;

	printf("\033[2J");
	printf("  BERT LIB TEST PROGRAM  TIMED TEST\n\n");
	printf("	A - RUN 5 SECONDS\n");
	printf("	B - RUN 10 SECONDS\n");
	printf("	C - RUN 20 SECONDS\n");
	printf("	D - RUN 30 SECONDS\n");
	printf("	E - RUN 40 SECONDS\n");
	printf("	F - RUN 50 SECONDS\n");
	printf("	G - RUN 60 SECONDS\n");
	printf("	H - RUN 120 SECONDS\n");
	printf("	\033[5m\033[35m<SPACE> to exit\n");

answer = 0;
while ((answer == -1) || (answer == 0)){
	pause(10+256L);
	answer=getch(_stdvt); 
		}
switch(answer){
	case 'a':  time = 5;
		   break;

	case 'b':  time = 10;
		   break;

	case 'c':  time = 20;
		   break;

	case 'd':  time = 30;
		   break;

	case 'e':  time = 40;
		   break;

	case 'f':  time = 50;
		   break;

	case 'g':  time = 60;
		   break;

	case 'h':  time = 120;
		   break;

	case ' ': return(0);

		}

timed_test(time);

  disp_menu();

}


start_p1()
	{
	int rets,ret2;
	long int rate;

	rate=64000;
	rets= start_sync(0,rate);

	}
