TRIGGER CONDITIONS

You can specify 1-4 conditions using the softkeys.  If the 
trigger is enabled, incoming events are tested for each of the 
conditions. To erase conditions, press Cancel. For logical NOT, 
press the shift key with the function key. This allows you to 
logically negate any of the conditions. Options are:

     DTE/DCE   Trigger on DTE or DCE traffic
     Error     Trigger on CRC errors or Frame Aborts 
     Counter   Trigger on 1-4 user-defined counter values
     Timer     Trigger on 1-4 user-defined timer values
     RLTime    Trigger on Real Time Clock value
     Frame     Trigger on a data string within a frame 
     Framelen  Trigger on frame length    
     Protocol  Trigger on protocol-specific elements. 
               Available for X.25, HDLC, Q.921, Q.931, DASS 2, 
               and SS#7.  See detail below.
     Variable  Compare an integer variable with another 
               integer variable or a constant
     Leads     Trigger on an interface lead state or change
     Port      Trigger on events on a specific port (Displayed 
               on Dual Port machines only)

HDLC     The protocol-specific HDLC options are:

         I-Frame   Information Frames
         RR        Receive Ready
         RNR       Receive Not Ready
         REJ       Reject
         SABM      Set Asynchronous Balanced Mode
         DISC      Disconnect
         FRMR      Frame Reject
         UA        Unnumbered Acknowledgement
         DM        Disconnect Mode
         SABME     Set Async Balanced Mode Extended
         P/F       Poll/Final Bit


X.25     The protocol-specific X.25 options are:

         CallReq     Call Request
         CallCon     Call Confirmation
         Clr Req     Clear Request
         Clr Con     Clear Confirmation
         Data        Data
         Intrupt     Interrupt
         Inrpt C     Interrupt Confirmation
         RRP         Receiver Ready Packet
         RNRP        Receiver Not Ready Packet
         REJP        Reject Packet
         Reset       Reset
         Reset C     Reset Confirmation
         Restrt      Restart
         RestrtC     Restart Confirmation
         Q Bit       Qualifier bit
         D Bit       Delivery Confirmation bit
         M Bit       More bit
         Subscrb     Triggers on a user-specified calling
                     or called address in Call Request packets.


Q.921    The protocol-specific Q.921 options are the same as
         HDLC, with the following additions:

         SAPI    Service Access Point Identifier value (0 - 63)
         TEI     Terminal Endpoint Identifier value (0 - 127)
         C/R     Command/Response bit value of 1 or 0.

         For Northern Telecom ISDN, if LTID bytes are 
         included, Q.921 mnemonic triggering is invalid.


Q.931    The protocol-specific Q.931 options are:

         ProDisc    Protocol Discriminator.  Enter an 8-bit
                    binary string, use x for 'don't care'
         CR Flag    Call Reference flag value of 1 or 0
         CR Valu    Call Reference Value.  Enter a hex value 
                    (0-FFFF) or select a previously assigned 
                    triggering variable ($1-$6) which 
                    contains the call reference value you 
                    are searching for.
         Msg Type   Triggers on Q.931 message type, as follows:

                    ALERTing               CANCel ACK
                    CALL PROceeding        CANCEL
                    CONNECT                RELease COMplete
                    CONNect ACK            RELEASE
                    SETUP                  DISConnect
                    SETUP ACK              DETach ACK
                    RESUME                 DETACH
                    RESUme ACK             USeR INFOrmation
                    RESUme REJ             SUSPend REJ
                    RESTART                SUSPEND ACK
                    RESTart  ACK           SUSPEND
                    CANCel REJ             PROGress
                    CONgestion CONtrol     STATus ENQuiry
                    FACILITY               STATUS
                    FACility ACK           REGister REJection
                    FACILITY REJ           REGister ACK
                    INFOrmation            REGISTER

         For Northern Telecom ISDN, if LTID bytes are 
         included, Q.921 mnemonic triggering is invalid.


DASS 2   The protocol-specific options are DASS 2 are:

         LAP     Link Access Protocol (time slot (0 - 31)

         MsgType    DASS 2 message type, as follows:
                    CS       Channel Seized
                    ICI c    Incoming Call Ind (Complete)
                    ICI i    Incoming Call Ind (Incomplete)
                    SCI i    Subsequent Call Ind (Incomplete)
                    SCI c    Subsequent Call Ind (Complete)
                    CA       Call Arrival
                    NAM      Number Acknowledge
                    NIM      Network Indication
                    CIM      Clear Indication
                    RRM      Recall Rejection
                    WSR      Withhold Service Request
                    SeSR     Send Service Request
                    UDC      User Data Control
                    ISRM c   Initial Service Request (Complete)
                    ISRM i   Initial Service Request (Inc)
                    SSRM i   Subsequent Serv Request (Inc)
                    SSRM c   Subsequent Service Request (Com)
                    CAM      Call Accepted
                    CRM      Clear Request
                    CCF      Clear Confirmation
                    RM c     Recall (Complete)
                    RM i     Recall (Incomplete)
                    SRW      Service Request Withheld
                    CCM      Call Connected
                    SM       Swap
                    UUD c    User to User Data (Complete)
                    UUD i    User to User Data (Incomplete)
                    MIM c    Maintenance Information (Complete)
                    MCM c    Maintenance Command (Complete)
                    MREJM    Maintenance Reject
                    MIDM c   Maintenance Ind. (Complete)
                    MRM c    Maintenance Result (Complete)
                    MRM i    Maintenance Result (Incomplete)
                    MACKM    Maintenance Acknowledge
                    MEOTM    Maintenance End of Task

         SupServ   DASS 2 Supplementary Service type, as follows:

                    Usr>Usr   User to User Signalling
                    CUG       Closed User Group
                    CCL Id    Calling/Called Line Identification
                    CCI       Call Charge Indication
                    NAE       Network Address Extension
                    I Disp    Information for Display
                    MSTRqst   Maintenance Status Test Request
                    MSTResp   Mainentance Status Test Response


#7 L2    The SS#7 Level 2 triggering options are:

         FSN       Forward Sequence Number (1-3 decimal digits)
         BSN       Backward Sequence Number (1-3 decimal digits)
         FIB       Forward Indicator Bit ( 1- 3 decimal digits)
         BIB       Backward Indicator Bit ( 1- 3 decimal digits)
         FISU      Trigger on any Fill In Signal Unit
         LSSU      Trigger on any Link Status Signal Unit. 
                   To trigger on the status indicator of an 
                   LSSU (SIO, SIE, SIOS, etc), use the LSSU_SF 
                   option described below.
         MSU       Message Signal Unit
         LSSU_SF   Link Status Signal Unit (Status Field).
                   Triggers on LSSU status field, as follows:

                   SIO     Link Out of Alignment
                   SIN     Normal Alignment
                   SIE     Emergency Alignment
                   SIOS    Link out of Service
                   SIPO    Processor Outage
                   SIB     Busy

#7 L3L4  The SS#7 Level 3 and Level 4 triggering options are:

         OPC    Origination Point Code (hex value)
         DPC    Destination Point Code (hex value)
         SI     Signaling Indicator.  One of the following:

                MGT   Signaling network management messages
                TMR   Signaling network test and maint. messages
                TMS   Signaling network testing and 
                      maintenance messages (spare)
                SCCP  Signaling Connection and Control Part
                DUPC  Data User Part (call/circuit related)
                DUPF  Data User Part (facility registration
                      and cancellation)
                ISUP  ISDN User Part
                TUP   Telephone User Part

                When you select a Signaling Indicator, the
                function key strip displays the elements on  
                which you can trigger.  Depending on the
                Signaling Indicator selected, the available 
                elements will be among the following options:

                Any   Triggers on any occurrence of the 
                      selected Signaling Indicator.  Displayed 
                      for all Signaling Indicators. 
                SLC   Triggers on user-specified Signaling 
                      Link Code (Signaling Link  Selection) 
                      Displayed for all Signaling Indicator 
                      types except TUP and ISUP.  
                CIC   Triggers on user-specified Circuit 
                      Identification Code.  Displayed only 
                      for ISUP or TUP.  
                H0H1  Triggers on user-selected Heading 
                      Code value or mnemonic.
                IAM   Initial Address Message. Displayed only 
                      when TUP is the selected Signaling
                      Indicator.  See below for detail.

     The following options are available when IAM is selected:

     Num Sig    Number of address signals.  Enter one hex digit 
                or X for 'don't care.'
     Add Sig    Address Signal.  Triggers on a user-specified
                telephone number, or digits of a number.
                You are prompted for the telephone digits (in 
                decimal).  Enter x  for 'don't care'.
     Clg Cat    Calling Party Category
     Msg Ind    Message Indicator.  Triggers on message
                indicator bits A - L, as follows:

          Add Ind     Nature of address indicator (Bits B A)
          Cir Ind     Nature of circuit indicator (Bits D C)
          Con Chk     Continuity check Indicator (Bits F E)
          Echo Su     Echo suppressor indicator (Bit G)
          Inc Intl    Incoming International Call ind (Bit H)
          Redir C     Redirected call indicator (Bit I)
          Dig Pth     All digital path required ind (Bit J)
          Sig Pth     Signalling path indicator(Bit K)
          Spare       Spare (Bit L)


CT TUP    Displays CCITT SS#7 Telephone User Part triggering 
          options.  These are also available with #7 L3L4.  Can
          trigger on DPC, OPC, CIC, Heading code and 
          Address Signal.


CT ISUP   Displays CCITT SS#7 ISDN User Part triggering options.
          These are also available with #7 L3L4.  Can
          trigger on DPC, OPC, CIC, Heading code and 
          Address Signal.

