
MS-DOS COMPATIBLE FILE FUNCTIONS 

The Chameleon MTOS-UX file system is designed to be compatible 
with MS-DOS 2.x and 3.x.  The functions described in this 
section have been added to provide low-level access to the 
Chameleon file system.


The format of a filename is set by the system to be eight bytes 
in length, plus a three-byte extension.  The set of characters 
allowed in a filename and extension are:

       A-Z, 0-9, - _ ! @ # $ % ^ & ( ) " ~ { }

All filenames must be terminated with a NULL (0x00) character.

The question mark can be used as a wild card to describe 
multiple files having similar names.  A wild card character can 
be used only in the search function.  When used with other 
functions, it may produce incorrect results.

The question mark is a single character wild card.  For 
example, if you have three files named test1.txt, test2.txt, 
and test3.txt, they could be identified simultaneously by using 
the name test?.txt. 

Error Codes

When a file function is completed, it returns either 0 for 
success, or a negative number if an error has occurred during 
the execution of the function.

The table below lists the possible codes:

     0       Successful
     -1      Configuration error
     -2      Opcode error
     -3      Parameter error
     -4      Error in volume access
     -5      File not found error
     -6      File already exists error
     -7      Queue empty
     -8      Physical read error
     -9      Physical write error
     -10     Directory full error
     -11     Files open on directory
     -12     File aready open
     -13     Error in filename
     -14     File locked
     -15     Function option error
     -16     Attribute error
     -17     End of file unexpected error
     -18     EOF with partial record
     -19     Fatal error
     -20     Disk full - Temporary


Fmkdir     Creates a directory with the name dirname.  
           dirname is a pointer to the directory name 
           and can include the path for the new directory.

           #include <msfsuse.h>
           Fmkdir(dirname)
           char  * dirname;



Frmdir     Removes a directory with the name dirname.  
           dirname is a pointer to the directory name
           and can include the path to the directory.

           #include <msfsuse.h>
           Frmdir(dirname)
           char  * dirname;


Fsearch    Searches for a file or directory specified by
           name.  name is a pointer to the file/directory 
           name and can also include the path.  

           #include <msfsuse.h>
           Fsearch(name, option, rec)
           char * name;
           int option;
           struct DREC *rec

           If located, the file information is copied to 
           the structure  of type DREC,  which is defined 
           in msfsuse.h, as shown below:

      struct DREC
          {
          char   dc_fn[ ];           /*File name*/
          char  dc_ex[ ];            /*File extension*/
          char  dc_at;               /*File attributes*/
          char  dc_rs[ ];            /*Reserved bytes*/
          unsigned short  dc_tim;    /*Time of file creation*/
          unsigned short  dc_dat;    /*Date of file creation*/
          unsigned short  dc_str;    /*Starting  cluster no.*/
          unsigned long     dc_fsz;  /*File size in bytes*/
          };

     File attributes are defined in msfsuse.h as follows:

          FA_RDF     0x01          Read Only File
          FA_HDF     0x02          Hidden File
          FA_SYS     0x04          System File
          FA_VOL     0x08          Volume
          FA_SDR     0x10          Sub-directory
          FA_ARF     0x20          Archive
 
