#include "stdio.h"
#include "x25.h"
#include "x25lib.h"
#include "com.h"

/****************************************************************
File   : x25_tsk.c
Date   : December 28th 1989
Author : Gilles Lejeune

Description : main control task for simulator
              This program initialize 1 pipe of communication

This program contains a simple state machine of an X25 PAD. It
handles the X25 and Asynchronous responses and the Data transmission
from X25 to Asynchronous and vice versa.
*****************************************************************/


extern long	_stdvt ;

#define	INC8(A)	( ( A == 8 ) ? 0 : A+1)
#define HL_SIZE	600

int	ps,pr ;
int	lcn,lcgn ;

/******* Async responses */

char	*pcom = "COM\r\n" ;
char	*plib = "CLR OCC 2\r\n" ;
char	*plibc = "LIB CONF\n\r" ;

/**** main control task  */


main(argc,argv)
int	argc ;
char	*argv[] ;
{
long	lida,lidb ;		/* protocol task loader ID */
MB_MESS	mess_st ;		/* communication message structure */
MB_MESS	*pmess = &mess_st ;	/* pointer on communication structure */
int	type ;			/* type of message received */

/*--------- Pipe initialization --------------*/

puts("Initalizing Mail boxes") ;
if ( com_crctlmb(1) < 0 )
	puts("cannot create mb") ; 

/*-------- Start HDLC task ------------------*/

puts("Starting HDLC task") ;
if ( ( lida = com_startl("HL_TASK","",0L) ) < 0 )
	{
	puts("Cannot start HDLC task") ;
	exit(0) ;
	} 
if ( com_wrdy(PORT_A,1+MIN) == -1 )	/* wait for HDLC task to be ready */
	puts("Init timed out") ;
puts("HDLC task ready") ;

/*------- Start Asynchronous task -----------*/

puts("Now starting ASYNC task") ;
if ( ( lidb = com_startl("ASY_TSK","",0L) ) < 0 )
	{
	puts("Cannot start Async task") ;
	com_exit(PORT_A,lida) ;
	exit(0) ;
	} 
if ( com_wrdy(PORT_B,1+MIN) == -1 )	/* wait for Async task to be ready */
	puts("Init timed out") ;
puts("ASYNC task ready") ;

/*------- End of initialization ------------*/

puts("Init succesfull, Press a key to set the link on") ;

getchar() ;		/* wait for a keyboard input to continue */

/*------- Initialize screen ---------------*/

disablecur(_stdvt) ;		/* disable cursor */
clears() ;			/* clear screen */
disp_init("X25/Async Simulator") ;	/* display background screen */

/*------- Send a Set Link On message to HDLC task -----*/

pmess->info = HL_SLON ;
pmess->port = PORT_A ;
pmess->type = CT_CMD ;
com_snd(pmess) ;

ps = 0 ;	/* init P(S) to 0 */
pr = 0 ;	/* init P(R) to 0 */

/*------- Main loop of the state machine -------------*/

while(1)
	{
	if ( getch(_stdvt) == 0x1b )	/* check keyboeard input */
		break ;			/* break loop if "ESC" typed */

	/*----- check message reception -------*/

	type = com_chkmb(pmess) ;
	if ( type >= 0 )
		{
		switch( type )
			{
			case CT_DATA :		/* data message */

				if ( pmess->port == PORT_A ) /* from HDLC task */
					x25_resp(PORT_A,pmess->pdata,pmess->len) ;

				else			     /* from Async task */
					asy_resp(PORT_B,pmess->pdata) ;

				com_rel(pmess->pdata) ;	     /* release data */
				break ;

			case CT_ERR :		/* error message */
				if ( pmess->port == PORT_A )
					printf("HDLC error = %d\n",pmess->info) ;
				else
					printf("ASYNC error = %d\n",pmess->info) ;
				break ;
			default :
				break ;
			}
		}
	else
		pause(50+MS) ;		/* Pause if nothing to process */
	}

/*------- State machine stopped, kill children task */

com_exit(PORT_A,lida) ;		/* send kill message to HDLC task */
com_exit(PORT_B,lidb) ;		/* send kill message to Async task */
com_dlctlmb() ;			/* deallocate OS ressource */
clears() ;			/* clear screen */
enablecur(_stdvt) ;		/* reenable cursor */
}

/********* Asynchronous response *****************
parameters :
	port : port of data reception
	pframe : pointer on data received
return :
	none
description :
	This program display the received asynchronous data and
        send a data packet on the X25 side containing the same data 
********************************************************************/	

asy_resp(port,pframe)
int	port ;
uchar	*pframe ;
{
struct	x25_st	x25_enc ;
struct	x25_st	*px25 = &x25_enc ;

int	len ;
uchar	databuf[100] ;
uchar	framebuf[100] ;
uchar	dispbuf[100] ;
int	othport ;

if ( port == PORT_A )
	othport = PORT_B ;
else
	othport = PORT_A ;

sprintf(dispbuf,"ASYNC <- %s\n",pframe) ;
disp_async(dispbuf) ;		/* display async data */

px25->x25_data = databuf ;
px25->x25_q = 0 ;
px25->x25_d = 0 ;
px25->x25_mod = 1 ;
px25->x25_lcgn = lcgn ;
px25->x25_lcn = lcn ;

if ( *pframe  == 0x10 )
	{
	xlate(pframe,' ') ;
	if ( (*(pframe+1) == 'L' ) || ( *(pframe+1) == 'l' ) ) 
		{
		px25->x25_type = PT_CLR ;
		tx_x25(othport,px25) ;
		disp_x25("X25 -> CLEAR") ;
		}
	}
else
	{
	px25->x25_type = PT_DT ;
	px25->x25_data = pframe ;
	px25->x25_dtl = strlen(pframe) ;
	px25->x25_ps = (char)ps ;
	px25->x25_pr = (char)pr ;
	px25->x25_m = 0 ;
	tx_x25(othport,px25) ;		/* send X25 data packet */
	disp_x25("X25 <-  DATA") ;	/* display data packet sent */

	if ( ps >= 7 )			/* update P(S) after each data
                                           packet sent */
		ps = 0 ;
	else
		ps+= 1 ;
	}
}
			
/******** X25 response routine ****************************************
parameters :
	port : port of message reception
        pframe : pointer on the frame received 
        len    : length of the frame received
return :
	none
description :
	This routine handle the X25 state machine and the asynchronous
        data to send if needed. It will decode the receive packet, send
        the appropriate X25 response and send an asynchronous string
        on the other port, if needed.
***********************************************************************/ 

x25_resp(port,pframe,len)
int	port ;
uchar	*pframe ;
int	len ;
{
struct	x25_st	x25_dec ;		/* X25 decode structure */
struct	x25_st	*px25=&x25_dec ;	/* pointer on X25 structure */
int	i,othport ;			/* variables */

unsigned char databuf[100] ;		/* data buffer */
unsigned char cdabuf[10],cgabuf[10] ;	/* addresses buffer */
char	dispbuf[100] ;			/* display buffer */

if ( port == PORT_A )
	othport = PORT_B ;
else
	othport = PORT_A ;

px25->x25_cda = cdabuf ;
px25->x25_cga = cgabuf ;
px25->x25_data = databuf ;
	
x25_ub(pframe,len,px25) ;		/* decode received frame */

strcpy(dispbuf,"X25 -> ") ;

	/*----- X25 state machine ----*/

	switch ( px25->x25_type )
		{
		case PT_CR :	/* call request */

			strcat(dispbuf,"Call request") ;
			disp_x25(dispbuf) ;
			lcn = px25->x25_lcn ;
			lcgn = px25->x25_lcgn ;
			ps = pr = 0 ;
			px25->x25_cgal = 0 ;
			px25->x25_cdal = 0 ;
			px25->x25_dtl = 1 ;
			px25->x25_type = PT_CA ;
			databuf[0] = 0 ;
			tx_x25(port,px25) ;
			disp_x25("X25 <- Call conf") ;
			tx_asy(othport,pcom) ;
			disp_async("ASYNC -> COM") ;
			break ;

		case PT_CA :	/* Call confirm */

			strcat(dispbuf,"Call accepted") ;
			disp_x25(dispbuf) ;
			break ;

		case PT_CLR :	/* clear request */

			strcat(dispbuf,"Clear packet") ;
			disp_x25(dispbuf) ;
			px25->x25_type = PT_CLC ;
			tx_x25(port,px25) ;
			disp_x25("X25 <- Clear Conf") ;
			disp_async("ASYNC -> LIB") ;
			tx_asy(othport,plib) ;
			break ;

		case PT_CLC :	/* Clear confirm */

			strcat(dispbuf,"Clear confirmation") ;
			disp_x25(dispbuf) ;
			disp_async("ASYNC -> LIB CONF") ;
			tx_asy(othport,plibc) ;
			break ;

		case PT_IT :	/* Interrupt */

			strcat(dispbuf,"IT packet") ;
			disp_x25(dispbuf) ;
			break ;

		case PT_ITC :	/* Interrupt confirm */

			strcat(dispbuf,"IT confirmation") ;
			disp_x25(dispbuf) ;
			break;

		case PT_RR :	/* Receive ready */

			strcat(dispbuf,"RR packet") ;
			disp_x25(dispbuf) ;
			break ;

		case PT_RNR :	/* Receive not ready */

			strcat(dispbuf,"RNR packet") ;
			disp_x25(dispbuf) ;
			break ;

		case PT_REJ :	/* Reject */

			strcat(dispbuf,"REJ packet") ;
			disp_x25(dispbuf) ;
			break ;

		case PT_RES :	/* Reset */

			strcat(dispbuf,"RESET packet") ;
			disp_x25(dispbuf) ;
			px25->x25_type = PT_REC ;
			tx_x25(port,px25) ;
			disp_x25("X25 <- RESET Conf") ;
			break;

		case PT_REC :	/* Reset confirm */

			strcat(dispbuf,"RESET confirmation") ;
			disp_x25(dispbuf) ;
			break;

		case PT_RST :	/* Restart */

			strcat(dispbuf,"RESTART packet") ;
			disp_x25(dispbuf) ;
			px25->x25_type = PT_RSTC ;
			tx_x25(port,px25) ;
			disp_x25("X25 <- RESTART Conf") ;
			break;

		case PT_RSTC :	/* restart confirm */

			strcat(dispbuf,"RESTART confirmation") ;
			disp_x25(dispbuf) ;
			break;

		case PT_DIAG :	/* diagnostic */

			strcat(dispbuf,"DIAG packet") ;
			disp_x25(dispbuf) ;
			break;

		case PT_DT :	/* data packet */

			strcat(dispbuf,"DATA packet") ;
			disp_x25(dispbuf) ;
			px25->x25_type = PT_RR ;
			pr = px25->x25_ps ;
			px25->x25_pr = pr ;
			tx_x25(port,px25) ;
			disp_x25("X25 <- RR") ;
			databuf[px25->x25_dtl] = 0 ;
			sprintf(dispbuf,"ASYNC -> %s\n",databuf) ;
			disp_async(dispbuf) ;
			tx_asy(othport,databuf) ;
			break ;
		default :
			strcat(dispbuf,"unknown packet") ;
			disp_x25(dispbuf) ;
			break ;
		}
} 

/******* transmit an X25 packet ********************
parameters :
	port : port to transmit the frame
	px25 : pointer on a "x25_st" structure describing the packet to send
return :
	none
description :
          This routine will code the X25 packet and send the frame to
          send to the HDLC task using the pipe of communication
          between the main control task and the HDLC task.
*******************************************************************/

tx_x25(port,px25)
int	port ;
struct	x25_st	*px25 ;
{
char		*pdata ;		/* pointer used for the data */
MB_MESS		mess_st ;		/* communication message */
MB_MESS		*pmess = &mess_st ;	/* pointer on message */
int		len ;			/* length of data */

if ((pdata = com_gptr(HL_SIZE)) == NULL )	/* get data pointer */
	puts("HDLC tx alloc error");
len = x25_b(pdata,px25) ;			/* build frame */

pmess->pdata = pdata ;
pmess->len = len ;
pmess->port = port ;
pmess->type = CT_DATA ;

com_snd(pmess) ;				/* send message */
}


/******* transmit an asynchronous string to the Async task ********** 
parameter :
	port :	port to transmit the data
	ptr  : pointer on the data to transmit
return :
	none
description :
	this routine will transmit the data from the main control
        task to the asynchronous task using the pipe of communication
**********************************************************************/

tx_asy(port,ptr)
int	port ;
char	*ptr ;
{
char		*pdata ;		/* pointer for the data */
MB_MESS		mess_st ;		/* communication structure */
MB_MESS		*pmess = &mess_st ;	/* pointer on message */
int		len ;			/* length of data */

if ( (pdata = com_gptr(HL_SIZE)) == NULL )	/* get a pointer */
	puts("tx asy alloc error") ; 
strcpy(pdata,ptr) ;				/* copy the data */

pmess->pdata = pdata ;
pmess->len = strlen(pmess->pdata) ;
pmess->port = port ;
pmess->type = CT_DATA ;

com_snd(pmess) ;				/* send the data */
}
		
/********* take out the a character from a string *************
parameters :
	ptr : pointer on the string
	c   : character to take out
return :
	none
description :
	This routine will take out of a string an unwilling
        character 
***************************************************************/

xlate(ptr,c) 
char	*ptr,c ;
{
char	buf[100] ;
char	ch ;
char	*ptmp = ptr ;
char	*pbuf = &buf[0] ;

while((ch = *ptmp++))
	{
	if ( ch != c )
		*pbuf++ = ch ;
	}
*pbuf = 0 ;
strcpy(ptr,&buf[0]) ;
} 
		
