#include "x25.h"

/*******************************************************************
file : x25_build.c
date : Dec 28th 1989
Author : Gilles Lejeune
desc : build x25 packet 
parameters :
	pframe : pointer on user buffer filled by this routine
	px25_st : pointer on the X25 description structure of the
                  X25 packet to send.
return :
	length of the coded frame
Comment : this routine will build the data field of the HDLC I-frame
          with the coded packet described by the structure pointed
          by px25_st.
*******************************************************************/

int	x25_b(pframe,px25_st)
uchar	*pframe ;		/* pointer on data */
struct	x25_st	*px25_st ;	/* packet description pointer */
{
int	i,j,len ;
int	dataflag = 1;

*pframe++ = px25_st->x25_lcgn | (px25_st->x25_q << 7) | (px25_st->x25_d << 6) 
		| (px25_st->x25_mod << 4) ;
*pframe++ = px25_st->x25_lcn ;
*pframe = px25_st->x25_type ;
len = 3 ;

switch(px25_st->x25_type)
	{
	case PT_CLR :
	case PT_RES :
	case PT_REC :
	case PT_DIAG :
	case PT_RST :
		pframe++ ;
		break ;
	case PT_CLC :
	case PT_IT :
	case PT_ITC :
	case PT_RSTC :
		dataflag = 0 ;
		break ;
		
	case PT_RR :
	case PT_RNR :
	case PT_REJ :
		*pframe |= ( px25_st->x25_pr << 5 ) ;
		return(len) ;
		break ;
	case PT_DT :
		*pframe |= ( px25_st->x25_pr << 5 ) ;
		*pframe |= ( px25_st->x25_ps << 1 ) ;
		*pframe++ |= ( px25_st->x25_m << 4 ) ; 
		break ;
	case PT_CR :
	case PT_CA :
		pframe++ ;
		*pframe++ = ( px25_st->x25_cgal << 4 ) |
			   ( px25_st->x25_cdal ) ;
		len++ ;
		for( i=0 ; i!= px25_st->x25_cgal ; i++ )
			{
			if ( i % 2 )
				*pframe++ |= getdig(*(px25_st->x25_cga+i))  ;
			else
				*pframe = getdig(*(px25_st->x25_cga+i)) << 4 ;
			}
		for( j=0 ; j!= px25_st->x25_cdal ; i++,j++ )
			{
			if ( i % 2 )
				*pframe++ |= getdig(*(px25_st->x25_cda+j)) ;
			else
				*pframe = getdig(*(px25_st->x25_cda+j)) << 4 ;
			}
		len += (i/2 + i%2) ;
		break ;
	default :
		break ;
	}
if ( dataflag )
	{
	for(i=0 ; i!= px25_st->x25_dtl ; i++,len++ )
		*pframe++ = *(px25_st->x25_data+i) ;
	}
return(len) ;
}

/****** get digit ******/

getdig(c)
uchar	 c ;
{
if ( ( c >= '0' ) && ( c <= '9') )
	return(c-'0') ;
else if ( ( c >= 'a' ) && ( c<= 'f') )
	return(c - 'a' + 0x0a ) ;
else if ( ( c >= 'A' ) && ( c <= 'F') )
	return(c - 'A' + 0x0a) ;
}

