/**
 *	Program Name:	Translate Address to String
 *
 *	Filename:	nidtostr.c
 *
 *	$Log:   /b/gregs/i960/tcpip/util/nidtostr.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:46:40   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:39:24   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:20:48   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 11:14:26   pvcs
 * 
 *    Rev 1.0   30 Mar 1992 17:27:16   pvcs
 * Initial revision.
 *
 *	Comments:	translate an ethernet address into a string.
 *			i.e. translate 0x00010203040a into "0001020304050A".
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

char *NidToString(unsigned char *nid)

	{
	static	char buffer[24];	/* to return the string	*/

	sprintf(buffer, "%02X%02X%02X%02X%02X%02X",
		*nid, *(nid + 1), 
		*(nid + 2), *(nid + 3), *(nid + 4), 
		*(nid + 5));
	return buffer;
	}
	
