/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

/* Some UDP internals */

struct ph {
	in_name ph_src;		/* source address */
	in_name ph_dest;	/* dest address */
	char	ph_zero;	/* zero (reserved) */
	char	ph_prot;	/* protocol */
	ushort	ph_len;		/* udp length */
	};
/*
 *	sizeof (struct ph) will give 16 rather than 12 because
 *	of the 80960 alignment.
 *	We have to define the size of the udp ph size to be 12
 */
#define	UDP_PH_SIZE	12

extern IPCONN udp;		/* The UDP Internet connection */

int	udp_send_to(in_name fhost, uint fport, in_name, uint lport, 
		PACKET p, uint len);
void	udpswap_hton(struct udp *pup);
void	udpswap_ntoh(struct udp *pup);
PACKET	udp_alloc(int datalen, int optlen);

