/**			       
*
*	Program Name:	Download Module
*
*	Filename:	tftp.c
*
*	$Log:   /b/gregs/i960/tcpip/tftp/tftp.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:45:10   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:38:12   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:56:06   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:46   gregs
 * Initial revision.
 * 
 *    Rev 1.4   16 Jun 1992 17:39:58   vinay
 * changed back to rev 1.2
 * 
 *    Rev 1.3   16 Jun 1992 15:38:16   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.2   13 May 1992 10:55:50   pvcs
 * 
 *    Rev 1.1   27 Apr 1992 19:23:32   pvcs
 * Retry if the error code returned from tftp_req is no resourc error.
 * 
 *    Rev 1.0   30 Mar 1992 17:25:14   pvcs
 * Initial revision.
*
*	Creation Date:	N/A
*
*	Date:		1.23.90
*
*	Version:	1.0
*
*	Programmers:	
*
*	Modifications:	1.1	K Kong	12.3.91
*			Accept "mode" in the function tftp_rrq.
*
*	Comments:	This contains the module to handle tftp to
*			download an image from a tftp server.
*			This is based on terminal server's boot code.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <netbuf.h>
#include <udp.h>
#include <error.h>
#include <tcpip.h>
#include <tftpboot.h>
#include <tftp.h>


extern int	(*TftpRcvPacket)();	/* function to call when load a file */

extern void	StartTftpTimer(void);

#define	RRQ_BUFFER_SIZE		80
#define	ERROR_BUFFER_SIZE	50
#define	CodeToMessage(c)	err_msg[(c)]

#define	NORESOURCE_RETRY	5

/*
 *	Error messages for tftp
 */
static char *err_msg[] = 
	{
	"Not Defined",
	"File not found",
	"Access violation",
	"Disc full or allocation exceeded",
	"Illegal TFTP operation",
	"Unknown transfer ID",
	"File already exists",
	"No such user",
	 };


TFTPTBL tftp;	       /* Information about this tftp connection	*/

/*
 * name		tftp_rrq	- send a tftp read request
 *
 * synopsis	int tftp_rrq(ip, pathstr, mode)
 *		in_name	ip; <<	tftp server ip address 
 *		char	*pathstr; <<	file name to be downloaded
 *		char	*mode;		<< read mode.
 *
 * description	It sends a read request to the specified ip address.
 *		Retry 5 times if there is a no resource error.
 *
 * returns	0		done
 *		error number 	otherwise
 */

int tftp_rrq(ip, pathstr, mode)
in_name	ip;
char	*pathstr;
char	*mode;

	{
	char	buf[RRQ_BUFFER_SIZE];	/* the rrq packet	*/
	TREQ	*rrq = (TREQ*)&buf[0];	/* points to the rrq packet	*/
	char	*ptr;
	int	ErrorCode;
	int	retries = NORESOURCE_RETRY;

	memset(buf, 0, RRQ_BUFFER_SIZE);
	rrq->opcode = htons(RRQ);	/* Read request	*/
	ptr = (char *)&rrq->fname[0];
	strcpy(ptr, pathstr);
	ptr += strlen(pathstr) + 1;	/* File Path */
	strcpy(ptr, mode); 
	ptr += strlen(mode) + 1;	/* mode = octet */
	tftp.state = REQ;		/* in request state	*/
	while(retries--)
		{
		if ((ErrorCode = udp_send(ip, TFTPORT, tftp.sport, buf, 
			ptr - &buf[0], _initp->in_me)) != 0)
			{
			/*
			 *	retry if this is a no 
			 *	resource error.
			 */
			if (ErrorCode == ERR_NORSRC)
				{
				ReSchedule();
				}
			}
		else
			break;
		}			
	if (ErrorCode)
		{
		/*
		 *	We have a problem.
		 */
		tftp.state = NOCON;
		debugc('R');
		if (ErrorCode == ERR_UNKNOWN)
			debugc('A');
		else if (ErrorCode == ERR_NET_UNREACHABLE)
			debugc('U');
		else if (ErrorCode == ERR_NETFAIL)
			debugc('N');
		}
	else
		{
		/*
		 *	Packet has been queued for transmission
		 */
		tftp.fhost = ip;	/* remember server ip address	*/
		tftp.dport = TFTPORT;	/* remember tftp server port no	*/
		tftp.ackno = 0;
		debugc('r');
		}
	return ErrorCode;
	}

/*
 * name		tftprcv		- to receive a tftp packet
 *
 * synopsis	int tftprcv(pkt, length, fhost, sport, dport, tag, lhost)
 *		PACKET	pkt; <<		packet received.
 *		uint	length;<<	of the packet
 *		in_name	fhost;<<	ip address of the sender
 *		uint	sport;<<	from this port number
 *		uint	dport;<<	to this port number of this host
 *		void	*tag;<<		not used`
 *		in_name	lhost; <<	ip address of the receiver, me.
 *
 * description	This function will be called by udp handler when a tftp
 *		packet arrives. 
 *
 * returns	0 	ok
 *		otherwise	error
 */


int tftprcv(pkt, length, fhost, sport, dport, tag, lhost)
PACKET	pkt;
uint	length;
in_name	fhost;
uint	sport;
uint	dport;
void	*tag;
in_name	lhost;

	{
	TDATA	*td = (TDATA *)pkt->nb_prot;/* tftp data packet format	*/
	int	DataLength = length - sizeof(td->opcode) - sizeof(td->blkno);
	int	code;
	static	int	RcvPort = 0;

	if(tftp.state == NOCON)
		{
		debugc('-');
		in_free(pkt);
		return 1;
		}
	if(fhost != tftp.fhost)
		{
		debugc('-');
		in_free(pkt);
		return 1;
		}
	if (dport != tftp.sport)
		{
		/* send unknown transfer id */
		send_error(TETID, fhost, dport, sport);
		debugc('-');
		in_free(pkt);
		return 0;
		}
	code = ntohs(td->opcode);
	switch(code)
	{
	case DATA:
		if((tftp.state == REQ) && (ntohs(td->blkno) == 1))
			{
			/*
			 *	First data packet, 
			 *	From now on, we use "sport" to
			 *	talk to the tftp server.
			 */
			tftp.dport = sport;
			tftp.state = CON;
			RcvPort = pkt->db_rcvportno;
			}
		else if (RcvPort != pkt->db_rcvportno)
			{
			/*
			 *	This is coming from the wrong port
			 */
			debugc('P');
			break;
			}
		if (tftp.dport != sport)
			{
			/*
			 *	The source port does not match
			 *	what we expect from. Reply with an 
			 *	error packet.
			 */
			send_error(TETID, fhost, dport, sport);
			debugc('-');
			break;
			}
		if ((tftp.ackno + 1)  == (uint)ntohs(td->blkno))
			{
			/*
			 *	This is the packet we are expecting
			 *	for - so update the ack no
			 */
	   		tftp.ackno++;
	   		debugc('t');
			}
		else if ((tftp.ackno) == (uint)ntohs(td->blkno))
			{
	   		debugc('T');	/*duplcated pkt or extra */
	       		send_ack(&tftp);
			break;
			}
		else
			{
			/*
			 * 	ignore the packet.
			 */
			debugc('-');
			break;
			}
		/*
		 *	process the packet
		 */
		if((*TftpRcvPacket)(tftp.ackno, (char *)&td->blk,
			DataLength) != FALSE) 
			{
			if (tftp.ackno == 1)
				tftp.length = DataLength;
			else
				tftp.length += DataLength;
			send_ack(&tftp);
			StartTftpTimer();
			tftp.retry = 0;
			if (DataLength != DATALEN)
				{
				/*
				 *	This is the last chunk of the
				 *	file. We are done !
				 */
				tftp.state = NOCON;
				tftp.ackno = 0;
			 	tftp.done = TRUE;
				}
			}
		else
			/* fatal error	*/
			{
			tftp.abort++;	
			tftp.state = NOCON;
			}
		break;

	case ERROR:
		{
		TERROR	*terr;
		char	*ptr;

		tftp.abort++;	/* Abort: we have a problem	*/
		printf("\nTFTP Error: ");
		tftp.state = NOCON;
		terr = (TERROR *)td;
		ptr = (char *)&terr->errmsg;
		for(; *ptr != 0; ptr++)
		     putchar(*ptr);
		printf("\n");
		break;
		}
	default:
		printf("\nUnknown TFTP Opcode %x\n",ntohs(td->opcode));
		}
	in_free(pkt);
	return 0;
	}

/*
 * name		send_ack	- send a tftp ACK packet
 *
 * synopsis	int send_ack(tftp)
 *		TFTPTBL	*ftfp;<<	the tftp table for this connection 
 *
 * description	It sends a tftp ACK packet.
 *
 * returns	0		done
 *		error code	otherwise
 */

int send_ack(tftp)
TFTPTBL	*tftp;

	{
	TACK tack;		/* tftp ACK packet (in network format)	*/
	int ErrorCode;

	tack.opcode = htons(DACK);	
	tack.ackno = htons(tftp->ackno);
	if((ErrorCode = udp_send(tftp->fhost, tftp->dport, tftp->sport,
		(char *)&tack, sizeof(TACK), _initp->in_me)) != 0)
		{
		debugc('A');
		if (ErrorCode == ERR_NETFAIL)
			debugc('N');
		}
	else
		debugc('a');
	return ErrorCode;
	}

/*
 * name		send_error	- send a tftp error packet
 *
 * synopsis	int send_error(code, ip, sport, dport)
 *		uint	code;<<	tftp error code;
 *		in_name	ip;<<	to this host ip address
 *		uint	sport;<<	from this udp port
 *		uint	dport;<<	to this udp port
 *
 * description	Sends a tftp error packet to the host with IP address
 *		"ip". 
 *
 * returns	0		done
 *		error code	otherwise
 */

int send_error(code, ip, sport, dport)
uint	code;
in_name	ip;
uint	sport;
uint	dport;

	{
	char	buf[ERROR_BUFFER_SIZE];
	TERROR	*ErrorPacket = (TERROR *)&buf[0];
	int	PacketLength;	/* error packet length	*/
	int	ErrorCode;	/* from udp send	*/

	memset(buf, 0, ERROR_BUFFER_SIZE);
	ErrorPacket->opcode = htons(ERROR);
	ErrorPacket->errcode = htons(code);
	/*
	 *	Get the error message if error code
	 *	is within range or
	 *	send the code with a null error message
	 */
	if (code <= MAXECODE)
		{
		memcpy(&ErrorPacket->errmsg, 
			CodeToMessage(code), strlen(CodeToMessage(code)));
		}
	PacketLength = sizeof(ErrorPacket->opcode) + 
		sizeof (ErrorPacket->errcode) + 
		strlen(&ErrorPacket->errmsg) + 1;
	if ((ErrorCode = udp_send(ip, dport, sport, buf, 
		PacketLength, _initp->in_me)) != 0)
		{
		debugc('E');
		}
	else
		debugc('e');
	return ErrorCode;
	}

/****************************************/
/* perror - print out the error message */
/****************************************/

/***********
perror(x)
int x;
{
	switch (x) {
	  case ERR_UNKNOWN:
	  		{
			oprintf("Host Unreachable\n");
			break;
			}
	  case ERR_NET_UNREACHABLE:
	  		{
			oprintf("Net Unreachable\n");
			break;
			}
	  case ERR_NORSRC:
	  		{
			oprintf("No Resources\n");
			break;
			}
	  case OUT_OF_RANGE:
	  		{
			oprintf("Packet too long\n");
			break;
			}
	  default:
			oprintf("code %d\n",x);
	  }

}
***************/

