/**
 *	Program Name:	telnet program
 *
 *	Filename:	get.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/get.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:42   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:38   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:20   gregs
 * Initial revision.
 * 
 *    Rev 1.4   01 Dec 1992 16:13:38   kenb
 * Added a goto and check for a full buffer
 * 
 *    Rev 1.3   30 Nov 1992 12:59:56   kenb
 * Added Support for tn3270 EOR handling
 * 
 *    Rev 1.2   27 Jul 1992 17:28:46   forrest
 * Added V2
 * 
 *    Rev 1.1   08 May 1992 10:04:40   ramki
 * Changed the lat related things
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ip.h>
#include <icmp.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <error.h>
#include <telnet.h>

#ifdef V2 
#include <dbd.h>
#include <v2main.h>
#include <v2ptp.h>
#include <v2rsp.h>
#include <v2smp.h>
#include <v2fns.h>
#endif

#define CR 0xd
#define LF 0xa

#define mmin(a,b)  (((a)<(b))?(a):(b))
#define mmax(a,b)  (((a)>(b))?(a):(b))
#define GBLMIN 0x08
#define GBLMAX 0x40


/*
 * MODE CONTROL
 */
tn_set_mode(tn, raw)
telnet	*tn;
int	raw;

	{
	if (tn->tn_chk != TN_CHECK
		|| (tn->tn_nus & ~(TN_NUS_ACTV | TN_NUS_CLOS)) )
		return;	/* not an active session */
	if (tn->tn_psid == PS_LAT)
		return 0;
	if (tn->tn_psid == PS_V2)
		return 0;
	if (raw)
		tn->tn_mode |= M_RAW;
	else
		tn->tn_mode &= ~M_RAW;
	}

/*
 * EVENT AND CHARACTER RECEPTION
 */

/* telnet user gets a character */
tn_getc(tn)
register telnet	*tn; 

{
	register int	c;

	if (tn == NULL || tn->tn_nus & ~(TN_NUS_ACTV | TN_NUS_CLOS | TN_NUS_FCLOSE | TN_NUS_FCLOSED))
	{
		return -1;	/* no chars avail */
	}
	/* manage the window (upward) if required */
#ifdef LAT 
	if (tn->tn_psid == PS_LAT)
	{
		/* make sure chars avail */
		if (tn->tn_gchrs == 0)
			return -1;
		CheckSlotEmpty(tn->tn_tcp);
	}
	else 
#endif
#ifdef  V2 
	if (tn->tn_psid == PS_V2)
	{
		/* make sure chars avail */
		if (tn->tn_gchrs == 0)
			return -1;

		c = (tn->tn_bufs - tn->tn_gchrs) / 64;
		if ( c >= 3)
			v2smpUpdate((V2SESSTBL *)tn->tn_tcp, (c >= 7) ? 7 : c);
	}
	else 
#endif
	{   
		/* TCP Stack */
		/* fetch more chars if buffer empty and pkts queued up */
		if (tn->tn_gchrs == 0) 
		{
			while (tn_fill(tn)  &&  tn->tn_gchrs < tn->tn_bufs)
				continue;
			if (tn->tn_gchrs == 0) 
			{
				tcp_new_wind(((TcpCon)tn->tn_tcp), _initp->tn_maxw);
				return -1;
			}
		}
		/* manage window upwards */
		c = tn->tn_bufs - tn->tn_gchrs;
		if (c - _initp->tn_minw >= ((TcpCon)tn->tn_tcp)->loc_win)
		{
			tcp_new_wind(((TcpCon)tn->tn_tcp), c);
		}
	}
	tn->tn_gchrs--;
	c = tn->tn_gbuf[tn->tn_take];
	if (++tn->tn_take == tn->tn_bufs)	
		tn->tn_take = 0;
	tn->tn_inbytes++;
	return c;
}


/*
 * replenish the inbound data stream from queued pac kets 
 *   reset the TCP window if appropriate .  For use when tn_getc not used 
 */
tn_refill(tn)
register telnet	*tn;
{
	register uint	x;

	if (tn->tn_chk != TN_CHECK
	|| (tn->tn_nus & ~(TN_NUS_ACTV | TN_NUS_CLOS | TN_NUS_FCLOSE | TN_NUS_FCLOSED)) )
		return;	/* not an active session */

	/* fetch more chars if buffer empty and pkts queued up */
	while (tn->tn_gchrs < tn->tn_bufs  &&  tn_fill(tn))
		continue;

	/*
	 * window management
	 */
#ifdef LAT 
	if (tn->tn_psid == PS_LAT)
	{
		/* adjust slot data to match stored character count */
		AdjustSlotData(tn->tn_tcp,tn->tn_gchrs);
	}
	else 
#endif
#ifdef V2
	if (tn->tn_psid == PS_V2)
	{
		x = (tn->tn_bufs - tn->tn_gchrs) / 64;
		if ( x >= 3)
			v2smpUpdate((V2SESSTBL *)tn->tn_tcp, (x >= 7) ? 7 : x);
	}
	else	
#endif
	{  
		/* TCP stack */
		/* if enough buffer space freed, have TCP post new window */
		if ((TcpCon)tn->tn_tcp)
		{
			x = tn->tn_bufs - tn->tn_gchrs;
			if (x >= _initp->tn_minw + ((TcpCon)tn->tn_tcp)->loc_win)
				tcp_new_wind(((TcpCon)tn->tn_tcp), x);
		}
	}
}

/* 
 * get chars from a packet into the rcv buffer 
 * return indic of more to come or not.
 */
tn_fill(tn)
register telnet *tn; 
	{
	register PACKET	p;
	byte	c;
	byte	spare;

#ifdef LAT
	if(tn->tn_psid == PS_LAT)
		return 0;
#endif
	/* get ongoing or next packet */
	if ((p = (PACKET)tn->tn_pktptr) != NULL)
		tn->tn_pktptr = NULL;
	else 
		{
		if ((p = (PACKET)AcptMessage(&tn->tn_mbox)) == NULL)
			return 0;
        	else
			{
			if(tn->tn_mode & M_CR)
				/* the last char of the previous packet is a CR *,
				 ** check if the first char is a LF or NULL and the
				 **  session is a server session
				 **/
				handle_LF(p,tn);
			}
		}
	/*
	 * try to process the characters as a block
	 *   - must be non-urgent, not iac processing 
	 *     have a large enough packet to deserve this, and room for it 
	 *     without wrap around.  
	 *   - scan for IAC, if none, bcopy pkt to buffer
	 *   - scan for CR, if none, bcopy pkt to buffer
	 */
	if (p->nb_len > GBLMIN || (tn->tn_mode & M_RAW ))
		{
		uint amnt = tn->tn_bufs - mmax(tn->tn_gchrs, tn->tn_fill);

		if (amnt > p->nb_len)
			amnt = p->nb_len;
		/*
		 *	K Kong 6.4.91
		 *	Replace sca_iac() and sca_cr() with
		 *	memchr().
		 */
		if ((tn->tn_mode & M_RAW) 
			|| (!memchr(p->nb_prot, TN_IAC, amnt) 
			&& !memchr(p->nb_prot, CR, amnt)))
			{
			/* do it! */
			memcpy(tn->tn_gbuf+tn->tn_fill, p->nb_prot, amnt);
			tn->tn_gchrs += amnt;
			tn->tn_fill += amnt;
			if (tn->tn_fill == tn->tn_bufs)
				tn->tn_fill = 0;
			if (p->nb_len != amnt)	/* more to do */
				{
				p->nb_len -= amnt;
				p->nb_prot += amnt;
				(PACKET)tn->tn_pktptr = p;	/* store for later use */
				return 1;
				}
			else
				{
				in_free(p);
				return (ulong)tn->tn_mbox.mb_mflink;
				}
			}
		}

	/*
	 * character at a time processing
	 *   - the buffer is short, or it has an IAC,
	 *     or it has an CR !
	 */
	while (tn->tn_gchrs < tn->tn_bufs && p->nb_len)
		{
		/* get next character */
		c = *p->nb_prot++;
		p->nb_len--;

		/* watch for change to raw mode */
		if (tn->tn_mode & M_RAW) 	/* raw mode and no other states! */
			{
			tn->tn_gchrs++;
			tn->tn_gbuf[tn->tn_fill] = c;
			if (++tn->tn_fill == tn->tn_bufs)	
				tn->tn_fill = 0;
			continue;
			}

		/* process normal character */
		if (tn->tn_mode == 0)
			{
			if (c == TN_IAC)
				tn->tn_mode = M_IAC;
			else if(!(tn->tn_do & F_BINARY) && c == CR)
				{
				if(p->nb_len)
					handle_LF(p,tn);
				else
					/* the last char of the packet is CR */
					tn->tn_mode |= M_CR;

				continue;
				}
			else
				{
				tn->tn_gchrs++;
				tn->tn_gbuf[tn->tn_fill] = c;
				if (++tn->tn_fill == tn->tn_bufs)	
					tn->tn_fill = 0;
				}
			continue;
			}

		/* sub negotiation mode */
		if (tn->tn_mode & M_SB)
			{
			if (c == TN_IAC)
				tn->tn_mode |= M_IAC; 
			else if (c == TN_SE  &&  (tn->tn_mode & M_IAC))
				{
				tn->tn_mode &= ~(M_SB|M_IAC);
				if (tn->tn_sbln <= SBBFMAX)
					{
					if (tn->tn_sbbf[0] == TN_STATUS)
						proc_status(tn, &tn->tn_sbbf[1], tn->tn_sbln-1);
					else if (tn->tn_sbbf[0] == TN_SYTEK)
						proc_sytek(tn, &tn->tn_sbbf[1], tn->tn_sbln-1);
					else if(tn->tn_sbbf[0] == TN_TERMTYPE)
						   /* if the terminal type */
						   proc_termtype(tn,&tn->tn_sbbf[1],tn->tn_sbln-1);

					}
				}
			else
				{
				tn->tn_mode &= ~M_IAC;
				if (tn->tn_sbln < SBBFMAX)
					tn->tn_sbbf[tn->tn_sbln] = c;
				tn->tn_sbln++;
				}
			continue;
			}

		/* process iac commands, may be urgent or subneg also */
		if (tn->tn_mode & M_IAC)
			{
			tn->tn_mode &= ~M_IAC;
			switch(c)
				{
			case TN_IAC:
				if (!(tn->tn_mode & M_URG))
					{
					tn->tn_gbuf[tn->tn_fill] = TN_IAC;
					if (++tn->tn_fill == tn->tn_bufs)	
						tn->tn_fill = 0;
					tn->tn_gchrs++;
					}
				break;

			case TN_AO:  
			case TN_BREAK: 
			case TN_INTP: 
			case TN_AYT:
				proc_event(tn, c);
				break;

#ifdef TN3270
			case TN_END_OF_REC:
				if ((tn->tn_bufs - tn->tn_gchrs) >= 2)
				{
				tn->tn_gbuf[tn->tn_fill++] = TN_IAC;
				if (tn->tn_fill == tn->tn_bufs)
					tn->tn_fill = 0;
				tn->tn_gbuf[tn->tn_fill++] = TN_END_OF_REC;
				if (tn->tn_fill == tn->tn_bufs)
					tn->tn_fill = 0;
				tn->tn_gchrs += 2;
				break;
				}
				else
				{
					tn->tn_mode |= M_IAC;
					p->nb_prot--;
					p->nb_len++;
					goto stop3270;
				}
#endif
				
			case TN_WILL: 
			case TN_WONT: 
			case TN_DO:   
			case TN_DONT: 
				tn->tn_mode |= M_NEG; 
				tn->tn_negc = c; 
				break;
				
			case TN_DM:   
				if (tn->tn_mode & M_URG)
					{
					tn->tn_mode &= ~M_URG;
					tn->tn_gchrs = 0;
					tn->tn_take = 0;
					tn->tn_fill = 0;
					}
				break;	/* sync cmplt */

			case TN_SB:
				tn->tn_mode |= M_SB;
				tn->tn_sbln = 0;
				break;

			case TN_SE:
				tn->tn_mode &= ~M_SB;
				break;	/* end of SB */
				}
			continue;
			}

		/* process a negotiation */
		if (tn->tn_mode & M_NEG)
			{
			tn->tn_mode &= ~M_NEG;
			proc_option(tn, tn->tn_negc, c);
			continue;
			}

		/* process urgent not negotiating */
		if (tn->tn_mode & M_URG)
			if (c == TN_IAC)
				tn->tn_mode |= M_IAC;
		}

#ifdef TN3270
	stop3270:
#endif

	if (p->nb_len)		 /* not done with packet yet */
		{
		(PACKET)tn->tn_pktptr = p;	/* store for later use */
		return 0;	/*we can do no more now */
		}
	else			/* finished with packet */
		{
		in_free(p);
		return (uint)tn->tn_mbox.mb_mflink;
		}
	}



/****************************************************
**
**        tn_set_eol
** 
**   This routine is called by upcall.c in the main
**   to define eol and expand for the telnet layer
**
**     AWC 2/5/90
*****************************************************/
tn_set_eol(tn,eol,expand)
register telnet	*tn; 
uint	eol;
uint	expand;

	{
	tn->tn_eol = eol;
	tn->tn_expand = expand;
	}

/******************************************************
**
**    check LF or NULL if session is NULL session
**
******************************************************/


handle_LF(p,tn)
PACKET	p;
telnet	*tn; 

	{
	byte	d;

	d = *p->nb_prot;
	/* if the next char is LF or
	** next char is NULL and the session is server 
	** session, treat it as End-Of-Line
	**/
	if(d == LF) /*** || (d == NULL && is_server(tn->tn_tag))) ***/
	{
		/* unstuffed a end-of-line char to application */
		if(tn->tn_eol)
		{
			tn->tn_gchrs++;
			tn->tn_gbuf[tn->tn_fill] = tn->tn_eol;
			if (++tn->tn_fill == tn->tn_bufs)	
				tn->tn_fill = 0;
		}
		/* now if I need to expand the end-of-line */
		if(tn->tn_expand)
		{
			/* I need to expand the end-of-line,
			** check if I have buffer to take the char 
			**/
			if(tn->tn_gchrs < tn->tn_bufs)
			{
				/* still has buffer to take one more char */
				tn->tn_gchrs++;
				tn->tn_gbuf[tn->tn_fill] = tn->tn_expand;
				if (++tn->tn_fill == tn->tn_bufs)	
					tn->tn_fill = 0;
				/* skip the char */
				p->nb_prot++;
				p->nb_len--;
			}
			else
			{
				/* no buffer to take one more char, let's 
				  put the expand in the packet buffer instead
				****/
				*p->nb_prot = tn->tn_expand;
			}
		} /* end of EXPAND is defined */
		else
		{  /* no EXPAND is defined just skip the character */
			p->nb_prot++;
			p->nb_len--;
		}
	} /* end of the char is a LF or NULL with server session */
	else
		{
		/* it is not End-Of-Line indication , put CR into buffer */
		tn->tn_gchrs++;
		tn->tn_gbuf[tn->tn_fill] = CR;
		if (++tn->tn_fill == tn->tn_bufs)	
			tn->tn_fill = 0;
		if(d == NULL)
			{
			/* if the NULL drop the  NULL */
			p->nb_prot++;
			p->nb_len--;
			}
		}
	/* clear the CR mode */
	tn->tn_mode &= ~M_CR;
	return;
	}


