/**			       
*
*	Program Name:	nim960 tcp module
*
*	Filename:	open.c
*
*	$Log:   /b/gregs/i960/tcpip/tcp/tcpopen.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:14   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:20   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:58   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:30:52   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		4.19.91
*
*	Version:	1.0
*
*	Programmers:	not known
*
*	Modifications:	K Kong	4.19.91
*			Port to the 80960 platform. 
*			i.e.	remove "far", int is 32 bit ...etc
*
*			Ramki 2-13-92
*			Modified ttcp_open, tcp_listen, tcp_grab to take the 
*			local host address from the caller. It is stored 
*			in the TcpCon structure.
*			The local host address should always be taken from
*			the TcpCon structure not from initp. If the local
*			host address passed is 0 then the server address is
*			taken from initp.in_me.
*
*	Comments:	This file contains the functions to open 
*			tcp connections.
*			tcp_open()
*			tcp_listen()
*			tcp_grab()
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


/*
 * open.c - routines related to opening a multiple-connection TCP
 * connection.
 *
 * Copyright 1986, 1987 by FTP Software, Inc.
 *
 * Edit History
 * 15-Aug-86	1.1x00	jbvb	tcp_grab() should use in_alloc() instead
 *				 of pkt_alloc().
 * 26-Aug-86	1.1x01	jbvb	Added out_q_... stuff, changed .H files
 * 28-Aug-86	1.1x03	jbvb	he who sets SYN, counts it too...
 *				mask off high word of time for initial seq,
 *				 because I think 2^31+1 is likely to be magic.
 * 29-Aug-86	1.1x04	jbvb	Let get_x_buf() set tcp data offset.
 * 03-Sep-86	1.1x05	jbvb	Use general purpose queue routines (q.h).
 * 04-Sep-86	1.1x06	jbvb	Notice if we use up the last buffer.
 * 10-Sep-86	2.0	jbvb	Cleaned up for release 2.0 of PC/TCP.
 * 02-Nov-86	2.0	jbvb	Wait rather than use up the last buffer
 * 30-Dec-86	2.1x01	jbvb	Load max_data value with MAXBUF for now.
 * 05-Jan-87	2.1x02	jbvb	Fix bogus comments, add probe_tm, fix bug.
 * 14-Jan-87	2.1x03	jbvb	Mask initial seq. # to 28 bits. We hack wrap
 *				 now, but others (incl. old PC/TCPs) don't.
 * 17-Apr-87	2.1x04	jbvb	tcp_grab() puts default MSS in SYN packet,
 *				 tcp_open() calls tcp_set_mss() to adjust it.
 *				 Add tcp_set_mss(), figure out MSS option val.
 * 27-Sep-87		romkey	Put some #ifdef KERNEL's around printf()'s.
 *				 removed "GETTIME" as it is no longer used.
 */
/* MOD: BLL - opening: con->ufield set to 0 */
/* MOD: BLL - opening: listen sets osrcport field */


#include <types.h>
#include <krnl.h>
#include <task.h>
#include <ether.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <error.h>
#include "internal.h"




/* tcp_listen - The passive open routine.  It gets and partially initializes
 * the connection's data structures, and leaves it sitting in LISTEN.  When
 * another machine sends a SYN, then tcp_popen() takes care of the details
 * of the actual open, including the user's upcall.
 *
 * Returns either a pointer (TcpCon) to the tcp_con structure allocated,
 * or NULL if errors occurred.
 * 
 * Called by the receive task when a SYN is received.
 */
TcpCon tcp_listen(fh, fport, lhost,lport)
in_name	fh; 		/* foreign host */
in_name lhost;		/* local host */
uint	fport;		/* foreign socket */
uint	lport;		/* local socket */

	{
	TcpCon	con;	/* connection block being opened  */

	/* first try all the things that could cause failure */
	if (tcp_is_socket(fh, fport, lhost, lport))
		return(NULL);
	if (!(con = tcp_grab(fh, fport, lhost, lport, SYNRCVD)))
		return(NULL);
	return(con);
	}


/* Actively open a tcp connection to foreign host fh on foreign port
 * fport using local port lport.  This routine doesn't wait until the connection
 * is actually opened before returning.  Instead, the user open function
 * is upcalled when the connection is successfully opened. 
 *
 * Returns FALSE if unable to open an internet connection with the specified
 * hosts and sockets, or a pointer (TcpCon) to the struct tcp_con created.
 *
 */

/*
 * name		tcp_open	open an active tcp connection
 *
 * synopsis	TcpCon tcp_open(fhost, fport, lhost, lport, tag)
 *		in_name	fhost; <<	to this ip address
 *		in_name lhost;		local host address
 *		uint	fport; <<	to this port number
 *		uint	lport; <<	my port number
 *		void	*tag; <<	remember this tag for me in the
 *					tcp connection control block
 *
 * description	It opens a connection to the foreign host "fhost" port
 *		number "fport".  The local port number to be used is
 *		"lport".  If "lport" is 0, then the caller doesn't care
 *		about the local port number and this function will 
 *		choose a port number for it.
 *		A TCP connection control block will be created and "tag"
 *		will be stored in "ufield" of the TCP connection.
 *
 * returns	pointer to the TCP connection control block
 *		NULL	on error
 */


TcpCon tcp_open(fhost, fport, lhost, lport, tag,errorp)
in_name	fhost;		/* foreign host address */
uint	fport;		/* foreign port	*/
uint	lport;		/* local port	*/
void 	*tag;
int	*errorp;	/* To return the Error code */

	{
	register TcpCon	con;	/* connection block being opened  */
	int	ret;

	tcpcntrs->active_con++;

	/* first try all the things that could cause failure */
	if (lport == 0)
		lport = tcp_gen_socket();	/* Wants us to pick socket  */
	else if (tcp_is_socket(fhost, fport, lhost, lport))
	{
		*errorp = OUT_OF_RANGE;
		return(NULL);
	}
	if (!(con = tcp_grab(fhost, fport, lhost, lport, SYNSENT)))
	{
		*errorp = ERR_NORSRC;
		return(NULL);
	}

	con->ufield = tag;
	if (ret = tcp_send_learn(con))
		{
		tcpcntrs->current_con++;/* prevents tcp_clean decrement current_con */
					/* unnecessarily                            */
		tcpcntrs->con_fail++;
		con->ufield = 0;	/* prevents telnet upcall to user */
		tcp_clean(con, 0);	/* abort the sucker */
		*errorp = ret;
		return NULL;
		}
	tcp_newdata(con);
	return(con);
	}



/* This INTERNAL procedure grabs new objects for all the structures used
 * for a connection.  If any of these allocations fail, it returns FALSE.
 * It allocates a queue block, packet buffer, 2 timers, the memory for
 * a connection, clips the TCP window if necessary and does an absurd amount
 * of initialization.
 */
TcpCon tcp_grab(fhost, fport, lhost, lport, state)
in_name	fhost;	/* foreign host */
in_name lhost;	/* local host */
uint	fport;	/* foreign port	*/
uint	lport;	/* local port	*/
uint	state;	/* socket state */

	{
	extern TcpCon	tcpconarray;
	register TcpCon	con;
	PACKET	p_ptr;		/* temp for initial buffer */
	byte	*opt_ptr;
	uint	i;
	uint	win;
	uint	lowwin;

	if ((p_ptr = get_x_buf()) == NULL)
		goto pktabort;
	/* COMMIT POINT */
	/* allocate a connection block and output pseudo hdr */
	if (!(con = (TcpCon) malloc(sizeof(tcp_con)))) 
		goto conabort;

	/* adjust window parameters */
	win = _initp->tn_maxw;
	lowwin = _initp->tn_minw;
	if (OutOfBounds(win,1,TCPMAXWIND) || OutOfBounds(lowwin,1,TCPLOWIND))
		{
		win = TCPWINDOW;
		lowwin = TCPLOWIND;
		}

	memset(con, 0, sizeof(tcp_con));
	CreatTimer(&con->tcptm);
	CreatMailbox(&con->out_q);
	con->loc_win	= win;
	con->loc_lowwater = lowwin;
	con->cur_ack	= 1;
	con->conn_state	= state;
	con->max_data	= DFLT_MSS;		/* temp, pending MSS negot. */
	if(lhost == 0)
		con->lhost = _initp->in_me;
	else
		con->lhost = lhost;
	con->srcport    = lport;
	con->dstport    = fport;
	con->fhost      = fhost;
	con->out_q_seqn	= (long)rand() * (long)rand();
	con->retry_time = INITRT;
	/* pseudo tcpip header */
	con->ophp.tp_dst = fhost;
	con->ophp.tp_src = in_mymach(fhost,lhost);
	con->ophp.tp_zero = 0;
	con->ophp.tp_pro  = TCPPROT;
	/* con->saved_pkt, con->ack_time, con->tw_to_live, con->usafe = 0 */

	/* link connection into circular list */
	con->tc_flink = tcp_list.tc_flink;
	con->tc_blink = &tcp_list;
	tcp_list.tc_flink->tc_blink = con;
	tcp_list.tc_flink = con;

	/* set up the output packet: fill in output tcp hdr */
	enqueue((MSGHDR *)p_ptr, (MBOX *)&con->out_q);	/* put 1st packet in out q */
	p_ptr = (PACKET)con->out_q.q_head;
	p_ptr->nb_seq = con->out_q_seqn++;	/* load seq # & count SYN */
	p_ptr->nb_syn = 1;
	p_ptr->nb_thl++;			/* room for MSS option */

	/* set up options */
	opt_ptr = (byte *)in_data(in_head(p_ptr)) + TCP_SIZE;
	*opt_ptr++ = 2;			/* MSS option type */
	*opt_ptr++ = 4;			/* MSS option length */
	*(ushort *)opt_ptr = htons(con->max_data);
	/*p_ptr->nb_len = 4; /* Add the MSS option size */

	/* link connection to its statistics structure */
	con->tc_stats = (byte *)(tcpstats + (con - tcpconarray));
	memset(con->tc_stats, 0, sizeof(TCP_CON_ENTRY));
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.local_ip_addr = con->lhost;
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.rem_ip_addr = fhost;
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.local_tcp_port = lport;
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.rem_tcp_port = fport;
	((TCP_CON_ENTRY *)con->tc_stats)->maxseg = con->max_data;
	return(con);
	
	/* labels for abort situations */
procabort:
	free((char *)con);
conabort:
	in_free(p_ptr);		/* deallocate output packet */
pktabort:
	return(NULL);
	}
