/**			       
*
*	Program Name:	nim960 tcp module
*
*	Filename:	storage.c
*
*	$Log:   /b/gregs/i960/tcpip/tcp/storage.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:08   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:14   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:54   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:30:50   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		5.14.91
*
*	Version:	1.1
*
*	Programmers:	not known
*
*	Modifications:	K Kong	4.19.91
*			Port to the 80960 platform. 
*			i.e.	remove "far", int is 32 bit ...etc
*
*			K Kong	5.14.91
*			Do not use sizeof() operator to get the the size
*			of tcp header (struct tcp) and tcp pseudo header
*			(struct tcpph) as it will give the size of the
*			structure with padded data. What we really 
*			want is the unpadded size.
*			TCP_SIZE and TCPPH_SIZE are the unpadded size of
*			struct tcp and struct tcpph respectively.
*
*	Comments:	This file contains the functions to handle
*			the storage and related stuff. 
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
storage.c - Global storage & related stuff for Multiple-connection TCP

Copyright 1986, by FTP Software, Inc.

Edit history
27-Aug-86	jbvb	get_x_buf() added (used by tcp_grab() and twrite()).
			 zero tcp header in get_x_buf()
29-Aug-86	jbvb	Set data offset in all TCP headers
02-Sep-86	jbvb	Correct debugging messages.
03-Sep-86	jbvb	buf_q replaced with PACKET.
10-Sep-86	jbvb	Cleaned up for release 2.0 of PC/TCP.
*/


#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ether.h>
#include <icmp.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <lme.h>
#include "internal.h"


IPCONN	tcpfd;			/* connection ID used when calling Internet */

struct	tcpph	iphp;		/* Incoming pseudo header for cksum calc */

/* WARNING: IPHP should really be connection dependent, but is not because:
 * 	    +-> (1) checksums on the pseudo-header are (usually) done before
 * paradox--+	    a packet is demuxes for a port.
 *	    +-> (2) packets would have to be demuxed before checksumming
 *	 	    to choose the correct pseudo-header buffer to use.
 */

/*
 * get_x_buf() - allocate and initialize a netbuf structure
 * with pointers to the tcp header and tcp data area.
 *
 * Returns NULL if allocation failed.
 */
PACKET	get_x_buf()
	{
	register PACKET p_ptr;

	if ((p_ptr = in_alloc(512, 0)) == NULL) 
		{
		return(NULL);
		}
	p_ptr->nb_urg = 0;
	p_ptr->nb_seq = 0;
	/* clears the flags word */
	*((ushort *)&p_ptr->nb_urg - 1) = 0;
	p_ptr->nb_thl = TCP_SIZE >> 2;	/* set data offset */
	return(p_ptr);
	}
