
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	snmp_d.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/snmp_d.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:36   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:04   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:46   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/**************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#include <libfuncs.h>
#include <asn1.h>
#include <localio.h>
#include <buffer.h>
#include <decode.h>
#include <snmp.h>
#include <syteksnm.h>


static	int	decode_pkt_to_vblist(LCL_FILE *, SNMP_PKT_P , int, UINT_32_T,
UINT_32_T, UINT_32_T, int,UINT_32_T);
static	int	decode_pkt_to_vb(LCL_FILE *, ALENGTH_T, VB_P  );
static	int	count_var_binds(LCL_FILE *, ALENGTH_T);
/****************************************************************************
NAME:  SNMP_Decode_Packet

PURPOSE:  Decode an SNMP packet.

PARAMETERS:
	unsigned char *	Address of the packet
	int		length of the packet

RETURNS:  SNMP_PKT_P  	SNMP Packet structure, (SNMP_PKT_P  )0 on failure
****************************************************************************/
SNMP_PKT_P  
SNMP_Decode_Packet(pktp, pktl,src_ip,sport,dport,dhost)
POINTER pktp;
int		pktl;
UINT_32_T src_ip;
UINT_32_T dhost;
UINT_32_T sport,dport;
{
	register SNMP_PKT_P	rp;
	LCL_FILE	        in_pkt_stream;
	register LCL_FILE	*in_stream;
	register                type;
	register 		asn1leng;
	OCTET_T		        flags;


	Lcl_Open(&in_pkt_stream,(POINTER)pktp, pktl);
	in_stream = (LCL_FILE *)&in_pkt_stream;

	/*printf("after Lcl_open()\n"); */
	/* Decode the top-level message sequence... */
	flags = A_DecodeTypeClass(in_stream);
	type = A_DecodeTypeValue(in_stream);
	/*printf("after DecodeTypeValue\n"); */
	if ((flags != (A_UNIVERSAL | A_CONSTRUCTOR)) &&
	    (type != A_SEQUENCE))
		return (SNMP_PKT_P )0;

	rp = rcv_snmp_pkt;
	/******
    	Initialize_Pkt(rp);
   	****/

	rp->overall_length = A_DecodeLength(in_stream);
	/*printf("after DecodeLength\n"); */

	/* Validate that the length provided by the caller is consistent with*/
	/* the length given by the ASN.1 wrapper...			*/
	/* If necessary, shrink the local I/O buffer to match.		*/
	asn1leng = Lcl_Tell(in_stream) + rp->overall_length;

	if (asn1leng < pktl)
	{
		(void) Lcl_Resize(in_stream, asn1leng, 0);
	}
	else 
	{
		if (asn1leng > pktl)
			return (SNMP_PKT_P  )0;
	}

	rp->snmp_version = A_DecodeInteger(in_stream);
	/* printf("after DecodeInteger\n"); */

	/* check if version is correct */
	if(rp->snmp_version != VERSION_RFC1067)
	{
		snmp_count->badversion++;
		return (SNMP_PKT_P )0;
	}

	/* Extract the community string */
	/*** use received PDU as buffer for community 
	memset((OCTET_P)rp->community.start_bp,0,CSIZE);
 	******************************************/

	A_DecodeOctetString(in_stream, (EBUFFER_P)&rp->community, CSIZE);
	/*printf("after decodestring\n"); */

	/* Decode the packet type					*/
	/* Since all of the PDUs follow the same form, we can decode them*/
	/* without being concerned as to which PDU we are decoding.	*/
	/* Furthermore, since the VarBindList is the last thing in the PDU, we*/
	/* can ignore the overall length of the sequence forming the PDU.*/

	if (A_DecodeTypeClass(in_stream) != (A_DEFAULT_SCOPE | A_CONSTRUCTOR))
		return (SNMP_PKT_P  )0;

	/*  Save the address of the pdu type. In case of VarBind count error, 
    	we need to return the original packet */
	pdu_typep = in_stream->lbuf_next;     /* ##### */

	rp->pdu_type = A_DecodeTypeValue(in_stream);
	rp->pdu_length = A_DecodeLength(in_stream);

	/* Check whether there is an inconsistency between the PDU length and*/
	/* the overall length indicated by the outermost ASN.1 wrapper.	*/
	/* If so, the packet is ill-formed and must be rejected.	*/

	if (asn1leng != (Lcl_Tell(in_stream) + rp->pdu_length))
	{
		return (SNMP_PKT_P  )0;
	}

	if (rp->pdu_type != TRAP_PDU)
		{ /* Its a non-trap form of pdu */
			rp->pdu.std_pdu.request_id = A_DecodeInteger(in_stream);
		/* save the address of error index and error status. In case of 
	   	VarBind count error, we can return original packet */
			err_statusp = (POINTER)in_stream->lbuf_next + 2;   /* #### */
			rp->pdu.std_pdu.error_status = A_DecodeInteger(in_stream);
			err_indxp = (POINTER)in_stream->lbuf_next + 2;   /* #### */
			rp->pdu.std_pdu.error_index = A_DecodeInteger(in_stream);

			if(pktl  > SNMP_MAX_PACKET_SIZE)
			{
				/* if packet too big for me to handle , I will stop here */
				set_err_resp(TOO_BIG,0);
				udp_send(src_ip,sport,dport,in_stream->lbuf_start,pktl,dhost);
				return (SNMP_PKT_P  )0;
			}

			/* Now deal with the VarBindList */
			/*printf("before decode_pkt_to_vblist\n"); */
			if (decode_pkt_to_vblist(in_stream, (SNMP_PKT_P)rp,asn1leng,src_ip,
			    sport,dport,pktl,dhost) == -1)
			{
				/* free All VarBin if used */
				Free_All_VarBin();
				return (SNMP_PKT_P  )0;
			}

		}
	else { /* It's a trap pdu */
		return (SNMP_PKT_P)0;  /* we are not suppose to receive trap pkt */
	}
	/*printf("after decode_pkt_to_vblist\n"); */
	return rp;
}

/****************************************************************************
NAME:  count_var_binds

PURPOSE:  To figure out how many VarBind items are in a VarBindList
	  On entry, the input stream should be positioned to the start of the
	  data (contents) part of the VarBindList.
	  On exit, the input stream will be positioned to the start of the
	  data (contents) part of the VarBindList.

PARAMETERS:
	LCL_FILE *	The input stream

RETURNS:  int		Count of the entries

Note:	This routine correctly handles the case where the VarBindList is
	empty.
****************************************************************************/
static
int
count_var_binds(stream, leng)
LCL_FILE	*stream;
ALENGTH_T	leng;
{
	register used;
	register tell_place;	/* Offset in stream to VarBind data */
	register items;

	tell_place = Lcl_Tell(stream);

	for(items = 0, used = 0; used < leng;)
	{
		ALENGTH_T	alength;
		int start_place, end_place;

		start_place = Lcl_Tell(stream);
		if (Lcl_Eof(stream)) break;

		/* Skip over the VarBind sequence */
		(void) A_DecodeTypeValue(stream);
		alength = A_DecodeLength(stream);
		if (Lcl_Seek(stream, alength, 1) == -1) break;

		end_place = Lcl_Tell(stream);
		used = used + end_place - start_place;
		items++;
	}

	(void) Lcl_Seek(stream, tell_place, 0);
	return items;
}
set_err_resp(err,index)
int err;
int index;
{
	if(err == TOO_BIG)
		snmp_count->outtoobig++;

	*pdu_typep &=  0xf0;
	*pdu_typep |=  GET_RESPONSE_PDU;
	*err_statusp = err;
	*err_indxp = index ;

}

/****************************************************************************
NAME:  decode_pkt_to_vblist

PURPOSE:  Decode a packet's VarBindList
	  On entry the input stream should be positioned to the tag field
	  of the first VarBind entry.
	  On exit, the stream pointer will be positioned to at the start
	  of the ASN.1 type field of AFTER the VarBindList, normally this
	  will be at the end of the packet.

PARAMETERS:
	LCL_FILE *	The input stream
	VBL_T *		The VarBindList header to be filled-in
	int		The overall size of the packet as indicated by
			the outermost ASN.1 wrapper for the SNMP packet
			(plus the size of the outermost tag/length fields.)

RETURNS:  0 for sucess, -1 for failure.
****************************************************************************/
static
int
decode_pkt_to_vblist(stream, rp, asn1leng,src_ip,sport,dport,len,dhost)
LCL_FILE	*stream;
SNMP_PKT_P  rp;
int		asn1leng;
UINT_32_T src_ip;
UINT_32_T dhost;
UINT_32_T sport,dport;
int len;
{
	register VB_P	vbp;
	register VBL_P 	vblp;
	int	i,j;

	vblp = (VBL_P )&rp->pdu.std_pdu.std_vbl;
	/* Now deal with the VarBindList */
	(void) A_DecodeTypeValue(stream);
	vblp->vbl_length = A_DecodeLength(stream);

	/* Check whether there is an inconsistency between the VBL length and	*/
	/* the overall length indicated by the outermost ASN.1 wrapper.		*/
	/* If so, the packet is ill-formed and must be rejected.		*/

	if (asn1leng != (Lcl_Tell(stream) + vblp->vbl_length))
		return -1;


	/* Count the number of VarBinds.			*/
	if ((vblp->vbl_count = count_var_binds(stream, vblp->vbl_length)) != 0)
	{ /* The VarBindList has contents */


		for (i = 0; i < vblp->vbl_count; i++)
		{
			if((vbp = Get_VarBin()) == 0L)
			{
				/* can not have  a VarBind to do this , return error */
				set_err_resp(TOO_BIG,i+1);
				udp_send(src_ip,sport,dport,stream->lbuf_start,len,dhost);
				return -1;
			}

			if(i== 0)
			{
				/* first VarBind */
				vblp->vblist = vbp;
				vblp->vblast= vbp;
			}
			else
			{
				vblp->vblast->next = vbp;
				vblp->vblast = vbp;
			}
			(void) A_DecodeTypeValue(stream);
			vbp->vb_seq_size = A_DecodeLength(stream);

			if( (decode_pkt_to_vb(stream, vbp->vb_seq_size,(VB_P) vbp)) == -1)
			{  /* can't allocate for current VarBind Object */
				/* before return must put PREVIOUSLY allocated object id and 
			   string buffers back to the link list */
				set_err_resp(TOO_BIG,i+1);
				udp_send(src_ip,sport,dport,stream->lbuf_start,len,dhost);
				return -1;
			}
		}
	}
	return 0;
}

/****************************************************************************
NAME:  decode_pkt_to_vb

PURPOSE:  Decode a VarBind from a packet
	  On entry the input stream should be positioned to the tag field
	  of the VarBind entry.
	  On exit, the stream pointer will be positioned to at the start
	  of the ASN.1 type field of AFTER the VarBind.

PARAMETERS:
	LCL_FILE *	The input stream
	ALENGTH_T	Length of VarBind, from its ASN.1 header
	VB_T	*	The VB_T element to be filled.

RETURNS:  0 for sucess, -1 for failure.
****************************************************************************/
static
int
decode_pkt_to_vb(stream, length, vbp)
LCL_FILE	*stream;
ALENGTH_T	length;
VB_P 		vbp;
{
	register 	id;
	register	leng;
	register        j;
	OCTET_T		flags;

	if( (A_DecodeObjectId(stream, (OBJ_ID_T  *)&(vbp->vb_obj_id))) == -1)
		return  -1;    /* can't get space for object id */



	flags = A_DecodeTypeClass(stream);
	id = A_DecodeTypeValue(stream);
	leng = A_DecodeLength(stream);
	vbp->vb_data_length = leng;
	vbp->vb_data_flags_n_type = flags | id;

	switch (vbp->vb_data_flags_n_type)
	{
	case VT_NUMBER:
		{
			vbp->value_u.v_number = A_DecodeIntegerData(stream, leng);
			break;
		}
	case VT_COUNTER:
	case VT_GAUGE:
	case VT_TIMETICKS:
		{
			vbp->value_u.v_counter = (UINT_32_T)A_DecodeIntegerData(stream, leng);
			break;
		}
	case VT_STRING:
	case VT_OPAQUE:
		A_DecodeOctetStringData(stream, leng, flags,
		    (EBUFFER_P)&(vbp->value_u.v_string),leng);
		break;
	case VT_OBJECT:
		{
			if( (A_DecodeObjectIdData(stream,leng,
			    (OBJ_ID_T  *)&(vbp->value_u.v_object))) == -1)
			{ /* run out of spaces for object id */
				/* before return must put the VarBind object id buffer back */
				return -1;
			}
			break;
		}
	case VT_EMPTY:
		/* Empty has no contents to be decoded */
		break;
	case VT_IPADDRESS:
		{
			EBUFFER_T ipbuff;
			A_DecodeOctetStringData(stream, leng, flags, &ipbuff, 4);
			memcpy((POINTER)vbp->value_u.v_network_address, ipbuff.start_bp, 4);
		}
		break;
	default:
		break;
	}
	return 0;
}

/****************************************************************************
NAME:  Initialize_Pkt

PURPOSE:  Initialize an SNMP packet structure.

PARAMETERS:
	SNMP_PKT_P  	The packet structure to be initialized

RETURNS:  nothing
Initialize_Pkt(rp)
SNMP_PKT_P	rp;
{
	rp->pdu_type = NO_PDU;
	rp->community.remaining = CSIZE;
	rp->community.next_bp = (OCTET_P)rp->community.start_bp;
}
****************************************************************************/

/*******************************
print_object(vbp)
VB_P 		vbp;
{
	register int  j;
	register int  *ptr;

	for(j=0,ptr=vbp->vb_obj_id.component_list;
    	j<vbp->vb_obj_id.num_components;j++,ptr++)
     	printf("%d.",*ptr);
  	printf("\n");
}
*******************/
