
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	setpdu.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/setpdu.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:34   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:50   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:04   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:46   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#include <types.h>
#include <libfuncs.h>
#include <asn1.h>
#include <localio.h>
#include <buffer.h>
#include <decode.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>

static	int 	call_set_test_routine(unsigned int,VB_P,MIBLOC_T *,int);

/****************************************************************************
NAME:  Process_SNMP_Set_PDU

PURPOSE:  Process a Set PDU -- given a decoded Set PDU, validate that
	  the named variables exist, are of the correct type, and are
	  writable.  If so, set all the variables.  In either event,
	  generate the response packet.

PARAMETERS:
	SNMP_PKT_T *	The decoded Set PDU, this will be used for the
			response.
	EBUFFER_T *	Buffer where the resulting PDU should be placed.
			The memory to hold the PDU will be dynamically
			allocated.
	int		SNMP access privilege

RETURNS:  int		0 if things went OK and a reasonable packet is
			in the result buffer.  This DOES NOT mean that
			no errors have occurred -- the result buffer might
			contain an error response packet according to the
			SNMP protocol.
			-1 some sort of error has occurred, the result
			buffer should not be considered to hold a valid
			SNMP packet.
****************************************************************************/
int
Process_SNMP_Set_PDU(pktp, ebuffp, priv)
SNMP_PKT_P	pktp;
EBUFFER_P	ebuffp;
int		priv;
{
	register VB_P	vbp;
	register int	indx,vbno;
	register int    error_code;

	/* We will be using the request PDU to hold the response	*/
	/* There is no need to really do much work on the PDU because	*/
	/* the returned form is almost exactly the received form.	*/
	/* Also, no check will be made for oversize response, because	*/
	/* of the simularity: a no-error response will be exactly the	*/
	/* same size as the GET REQUEST, an error response may be a bit	*/
	/* larger (perhaps by a byte or two), but we are forced to send	*/
	/* it.								*/
	pktp->pdu_type = GET_RESPONSE_PDU;

	/* Validate the existance, type, and writability	*/
	/* of the variables named in the VarBindList.		*/
	vbp = pktp->pdu.std_pdu.std_vbl.vblist;
	if((vbno = pktp->pdu.std_pdu.std_vbl.vbl_count) != 0)
	{
		/*printf("vb#=%d\n",vbno); */
		for (indx = 0; indx < vbno; indx++,vbp=vbp->next)
		{
			MIBLOC_T	ml;
			if (find_object_node((OBJ_ID_T  *)&(vbp->vb_obj_id), &ml) == 0)
			{
				if (ml.ml_flags & ML_IS_LEAF)
				{
				/* Check whether the object is accessable*/
				/* For tabular variables, the object may not*/
				/* even exist.				*/
				/* Also check for access violation.	*/
				/* BELIEVE IT OR DON'T: RFC1067 wants an*/
				/* attempt to set a read only variable	*/
				/* failed with a noSuchName error, not a*/
				/* readOnly error!!!!  For proof see section*/
				/* 4.1.5 (1) of RFC1067.		*/
				/* See the #defined section below for how*/
				/* the code would look if a readOnly error*/
				/* were to be returned.			*/

					if (!(ml.ml_leaf->access_type & WRITE_ACCESS))
					{
						/* AWC 11/30/90 */
						set_err_resp(READ_ONLY,indx+1);
						return -1;
					}
					if (vbp->vb_data_flags_n_type !=
						ml.ml_leaf->expected_tag)
					{ /* Type mismatch */
						set_err_resp(BAD_VALUE,indx+1);
						return -1;
					}

				/***************************************
				 **   AWC 10/12/89
				 **
				 **   add the code to check the minimal privilege 
				 **   to set this parameter 
				 ****************************************/

					if(!CheckPrivilege(ml.ml_leaf->windx,priv))
/****
					if((priv < 0xa) || (boot2->cmdpriv[ml.ml_leaf->windx] > priv))
***/
					{
					/* no priv to set this parameters */
						set_err_resp(NO_SUCH_NAME,indx+1);
						return -1;
					}

					/* This is the way one would think it ought	*/
					/* to be done.			*/
					/*printf("before call set test routine\n"); */
					if ( (error_code = call_set_test_routine(SNMP_TEST,
						(VB_P)vbp,&ml,priv)) != 0 )
					{
						set_err_resp(error_code,indx+1);
						return -1;
					}

					continue;
				}
			}
			/* Couldn't locate a node or the found node is NOT a leaf */
			set_err_resp(NO_SUCH_NAME,indx+1);
			return -1;
		}
	}

	/* Now actually go and set the variables */
	vbp = pktp->pdu.std_pdu.std_vbl.vblist;
	if ((vbno=pktp->pdu.std_pdu.std_vbl.vbl_count) != 0)
	{
		/*printf("vb #=%d\n",vbno); */
		for (indx = 0; indx < vbno; indx++, vbp=vbp->next)
		{
			MIBLOC_T	ml;
			/* Since all the variables have been validated, we assume	*/
			/* that everything will be a perfect match.	*/
			(void)find_object_node((OBJ_ID_T  *)&(vbp->vb_obj_id), &ml);
			/*printf("before call set routine\n"); */
			if ( (error_code = call_set_test_routine(SNMP_SET,(VB_P)vbp,
			    &ml,priv)) != 0 )
			{
				set_err_resp(error_code,indx+1);
				return -1;
			}
		}
	}
	snmp_count->insetvar +=vbno;
	return 0;
}

/****************************************************************************
NAME:  call_set_test_routine

PURPOSE:  Once a leaf node is located, this routine will invoke the set
	  routine referenced by the node.

	  The set routine reference by a node MUST match the data type
	  of the node as expressed by variable "expected_tag" in the node.

PARAMETERS:

RETURNS:  int		0 if things went OK.
			        others if some sort of error has occurred.
****************************************************************************/
static
int
call_set_test_routine(oper_code,vbp,mlp,priv)
unsigned int oper_code;
VB_P		vbp;
MIBLOC_T	*mlp;
int         priv;
{
	register MIBLEAF_P	leaf;
	register int            rtn_code;
	int            length;

	leaf = mlp->ml_leaf;

	switch (leaf->expected_tag)
	{
	case VT_NUMBER:
	case VT_COUNTER:
	case VT_GAUGE:
	case VT_TIMETICKS:
	case VT_IPADDRESS:
		if ( (rtn_code = (*(leaf->svcproc))(
		    oper_code,
		    (byte  *)&mlp->ml_remaining_objid.num_components,
		    (unsigned int  *)mlp->ml_remaining_objid.component_list,
		    (int  *)&length,(INT_32_T  *)&vbp->value_u.v_number,
		    priv)) != 0 )
			return rtn_code;
		break;
	case VT_STRING:
	case VT_OPAQUE:
		length = EBufferUsed((EBUFFER_P)&vbp->value_u.v_string);
		if ( (rtn_code = (*(leaf->svcproc))(
		    oper_code,
		    (byte  *)&mlp->ml_remaining_objid.num_components,
		    (unsigned int  *)mlp->ml_remaining_objid.component_list,
		    (int  *)&length,
		    (OCTET_P)vbp->value_u.v_string.start_bp,
		    priv)) != 0)
			return rtn_code;
		break;
	case VT_OBJECT:
		length = vbp->value_u.v_object.num_components * sizeof(unsigned int);
		if ( (rtn_code = (*(leaf->svcproc))(
		    oper_code,
		    (byte  *)&mlp->ml_remaining_objid.num_components,
		    (unsigned int  *)mlp->ml_remaining_objid.component_list,
		    (int  *)&length,
		    (unsigned int  *)vbp->value_u.v_object.component_list,
		    priv)) != 0 )
			return rtn_code;
		break;
	default:
		break;
	}
	return 0;
}
