
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	objectid.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/objectid.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:30   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:48   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:02   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:42   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#include <libfuncs.h>
#include <asn1.h>
#include <localio.h>
#include <buffer.h>
#include <snmp.h>
#include <objectid.h>
#include <syteksnm.h>

/****************************************************************************
NAME:  build_object_id

PURPOSE:  Build an object id structure

PARAMETERS:
	int		Number of components in the old structure
	unsigned int *	List of components in the old structure
	OBJ_ID_T *	The new Object Identifier structure

RETURNS:  0 if sucessful, -1 if not
****************************************************************************/
int
build_object_id(oldc, oldl, new)
int		oldc;
unsigned int  *oldl;
OBJ_ID_T  *new;
{

	if ((new->num_components = oldc) != 0)
	{
		unsigned int need;

		need = oldc*sizeof(int);
		if ((new->component_list = 
			(unsigned int  *)alloc_mem(MAXOBJLEN*sizeof(int))) ==
			(unsigned int   *)0)

			return -1;

		memcpy((char  *)new->component_list,(char  *)oldl,need);
	}
	return 0;
}
