/**			       
*
*	Program Name:	nim960 Slip Driver
*
*	Filename:	slip.c
*
*	$Log:   /b/gregs/i960/tcpip/slip/slip.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:42:38   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:18   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:16:36   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 10:43:32   pvcs
 * 
 *    Rev 1.0   30 Mar 1992 17:20:22   pvcs
 * Initial revision.
*
*	Creation Date:	3.21.91
*
*	Date:		3.21.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	This is the driver for slip in the nim960
*			environment.  The driver is taken from 
*			rfc1055.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <task.h>
#include <netbuf.h>

extern	MBOX	IpReceiveMbox;	/* mail the incoming packet to here	*/

#define	slip_get_dbd()	snc_get_dbd()


DBD	*snc_get_dbd();

void	slip_rcv();
int	slip_ip_send();
static void	send_char();
static int	recv_char();
static void	send_packet();
static int	recv_packet();

/* SLIP special character codes
 */
#define END             0300    /* indicates end of packet */
#define ESC             0333    /* indicates byte stuffing */
#define ESC_END         0334    /* ESC ESC_END means END data byte */
#define ESC_ESC         0335    /* ESC ESC_ESC means ESC data byte */


/*
 * name		slip_rcv	SLIP receive task
 *
 * synopsis	void slip_rcv(void)
 *
 * description	This task keeps looking for any incoming slip packet.
 *		When a slip packet has been received, it mails the
 *		packet to the receive mail box.
 *
 * returns	it never returns
 */
void slip_rcv()

	{
	DBD	*d;
	int	PacketSize;

	for (;;)
		{

		if ((d = snc_get_dbd()) == NULL)
			{
			/*
			 *	If there is no dbd available
			 *	we try later and hopefully 
			 *	somebody will release one soon.
			 */
			ReSchedule();
			continue;
			}
		PacketSize = recv_packet(d->db_buffer, d->db_bufsiz);
		/*printf("Slip received %d bytes\n", PacketSize);*/
		d->db_actcnt = PacketSize;
		d->nb_len = PacketSize;
		/*
		 *	buffer points to ip
		 */
		d->nb_prot = d->db_buffer;
		d->nb_flags |= PKT_SLIP;	/* this is a slip packet */
		SendMessage((MSGHDR *)d, &IpReceiveMbox);
		ReSchedule();
		}
	}

/*
 * name		slip_ip_send	- send a slip packet
 *
 * synopsis	slip_ip_send(p, len, host, np)
 *		PACKET	*p;	<< the packet
 *		int	len;	<< length of data in packet
 *		in_name	host;	<< NOT used
 *		NID	*up;	<< NOT used
 *
 * description	It sends a slip packet. This models after 
 *		"et_ip_send".
 *
 * returns	0		ok
 *		error code	otherwise
 */

slip_ip_send(p, len, host, np)
register PACKET p;	/*	The packet to be sent	*/
int	len;		/* 	length of data in p	*/
in_name	host;		/*	Not used	*/
NID	*np;		/*	Not used	*/

	
	{
	send_packet(p->nb_prot, len);
	return 0;
	}

/*
 *	sends a character out to the
 *	slip port. If the slip port is not
 *	ready, it reschedule itself and try later until
 *	the slip port is ready to accept the character.
 */
void send_char(uint c)

	{
	while (SlipPutChar(c) == -1)
		{
		ReSchedule();
		}
	}
/*
 *	It waits until a character has been received
 *	from the slip port. 
 */		
recv_char()

	{
	int	c;

	while ((c = SlipGetChar()) == -1)
		ReSchedule();
	/*putchar(c);*/
	return c;
	}	

/* SEND_PACKET: sends a packet of length "len", starting at
 * location "p".
 */
static void send_packet(p, len)
byte	*p;
int	len;

	{
	/*printf("Slip send %d bytes\n");*/

	/* send an initial END character to flush out any data that may
	 * have accumulated in the receiver due to line noise
	 */
	send_char(END);
	/* for each byte in the packet, send the appropriate character
	 * sequence
	 */
	while(len--)
		{
		switch(*p)
			{
			/* if it's the same code as an END character, we send
			 * a special two character code so as not to make the
			 * receiver think we sent an END
			 */
			case END:
				send_char(ESC);
				send_char(ESC_END);
				break;

			/* if it's the same code as an ESC character,
			 * we send a special two character code so as not
			 * to make the receiver think we sent an ESC
			 */
			case ESC:

				send_char(ESC);
				send_char(ESC_ESC);
				break;

				/* otherwise, we just send the character
				 */
			default:

				send_char(*p);
          		}
		p++;
		}
	/* tell the receiver that we're done sending the packet
	 */
	send_char(END);
	}


/* RECV_PACKET: receives a packet into the buffer located at "p".
 *      If more than len bytes are received, the packet will
 *      be truncated.
 *      Returns the number of bytes stored in the buffer.
 */
int recv_packet(p, len)
byte	*p;
int	len;

	{
	byte	c;
	int	received = 0;
	
	/* sit in a loop reading bytes until we put together
	 * a whole packet.
	 * Make sure not to copy them into the packet if we
	 * run out of room.
	 */

	while(1)
		{
		/* get a character to process
		 */
		c = recv_char();

		/* handle bytestuffing if necessary
		 */
		switch(c)
			{
			/* if it's an END character then we're done with
			 * the packet
			 */
			case END:

				/* a minor optimization: if there is no
				 * data in the packet, ignore it. This is
				 * meant to avoid bothering IP with all
				 * the empty packets generated by the
				 * duplicate END characters which are in
				 * turn sent to try to detect line noise.
				 */
				if(received)
					return received;
				else
					break;

			/* if it's the same code as an ESC character, wait
			 * and get another character and then figure out
			 * what to store in the packet based on that.
			 */
			case ESC:
				c = recv_char();

				/* if "c" is not one of these two, then we
				 * have a protocol violation.  The best bet
				 * seems to be to leave the byte alone and
				 * just stuff it into the packet
				 */
				switch(c)
					{
					case ESC_END:
				        	c = END;
			        		break;

					case ESC_ESC:
					        c = ESC;
					        break;
				        }

			/* here we fall into the default handler and let
			 * it store the character for us
			 */
			default:
				if(received < len)
					p[received++] = c;
			}
		}
	}

