/**			       
*
*	Program Name:	nim960 Transmit Program
*
*	Filename:	nim_xmt.c
*
*	$Log:   /b/gregs/i960/tcpip/mpd/nim_xmt.c_v  $
 * 
 *    Rev 1.14   31 Jan 1994 12:43:38   gregs
 * Fixed bug in nim_xmt() that caused the shared ram buffer allocated for fddi packet transmission to be written beyond its boundry.
 * 
 *    Rev 1.13   26 Oct 1993 17:24:54   franks
 * No change.
 * 
 *    Rev 1.12   22 Oct 1993 10:48:00   franks
 * Fixed MaskAllInts() and RestoreIntMask() calls so that the calls are
 * balanced.
 * 
 *    Rev 1.11   12 Oct 1993 10:42:00   franks
 * No change.
 * 
 *    Rev 1.10   11 Oct 1993 16:54:54   franks
 * Changed saveInts variable to register type.
 * 
 *    Rev 1.9   06 Oct 1993 09:59:04   gregs
 * made nim_xmt return immediately if SONIC not initialized.
 * 
 *    Rev 1.8   29 Sep 1993 16:00:18   franks
 * fixed problem that prevented bridge from pinging itself.
 * 
 *    Rev 1.7   29 Sep 1993 10:43:14   franks
 * No change.
 * 
 *    Rev 1.6   29 Sep 1993 10:42:26   vinay
 * changed || to && when checking for STP
 * 
 *    Rev 1.5   20 Sep 1993 14:16:56   vinay
 * copying the rcvport when converting from pkt to dbd ;
 * changed the || to && when checking for the STP packet
 * 
 *    Rev 1.4   08 Sep 1993 11:02:02   gregs
 * 
 *    Rev 1.3   30 Jul 1993 13:54:52   franks
 * Internal engineering release
 * 
 *    Rev 1.2   20 Jul 1993 09:31:04   franks
 * 
 *    Rev 1.1   20 Jul 1993 09:27:42   franks
 * Fixed ping problem.
 * 
 *    Rev 1.0   14 Jul 1993 10:15:38   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 10:40:40   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:25:52   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.14.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*			Use the new driver interface
*				snc_receive()
*				snc_get_dbd()
*				snc_put_dbd()
*				... etc
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <ether.h>
#include <error.h>
#include <netbuf.h>
#include <tcpip.h>
#include <pkt.h>
#include <xlate.h>

#define XMT_OP	01
#define	SNC_PORTLIST	0x7
#define	FDDI_PORTLIST	0x8

byte	snap_hdr[8] = {0xaa, 0xaa, 0x03, 0x0, 0x0, 0x0, 0x0, 0x0};

extern IF_ENTRY	*ifcntrs;
extern MBOX	ReceiveMbox;
extern	int	NumberOfSonicPort;
extern  byte	*bitRevTab;
extern  int	snc_init;


/*----------------------------------------------------------------------- 
* Send a frame from the stack to either ethernet or fddi interface.
* The routine copies the frame from dbd buffer to pkt share ram
* buffer. For frame that goes to ethernet, it leaves the mac header
* intact. For frame that goes to fddi, it put the fddi mac header
* infront of the frame.
*
* What are the callers of this routine:
*	stpc.c
*	et_arp_send
* 	et_ip_send
*-----------------------------------------------------------------------*/
nim_xmt(d, len)
register DBD *d;
int	len; 
{
	register word  saveInts;
	byte	*b;
	int	code = 0;
	DBD	*f;
	char	c;
	int	i;
	int	PortList;
	int	LastPort;
	int	XmtPortList = d->db_xmtportlist;

	byte	fddi_mac[17];
	PKT	*snc_pkt;
	PKT	*fddi_pkt;
	int	minLen;
	word	xmtport;
	long s;
	extern ushort chnl_flk_tx_led;

	if(!snc_init)			/* if SONIC not yet initialized */
		return(0);

	FlickerLeds(XMT_OP);	/* Flicker transmit LED */
	b = (byte *) d->db_buffer + d->db_indent;

	/*
	* Create pkt from dbd and give it to sonic for xmt
	*/
	if (xmtport = (d->db_xmtportlist & SNC_PORTLIST))
	{
		/*
		* ethernet packets must be at least 64 bytes long
		*/
		minLen = (len < ET_MINLEN) ? ET_MINLEN : len;

		/*
		* send a copy to myself if to me or multicast frame
		*/
		if (IsMyNid(b, d->db_rcvportno) || IsMultiCast(b))
		{
		    /*
		    * but only if it is not stp frame
		    */
		    if (*(ushort *)(b+14) != 0x4242 || *(b+16) != 0x03)
		    {
			MaskAllInts(saveInts);
			snc_pkt = (PKT *)GetDramPktBuf(minLen);
			RestoreIntMask(saveInts);
			if (snc_pkt)
			{
			   snc_pkt->pktDataSize = len;
			   snc_pkt->pktTotalSize = len;
			   /* snc_pkt->pktRcvPort = d->db_rcvportno; */
			   snc_pkt->pktRcvPort = 0;
			   memcpy(snc_pkt->pktBufPtr, b, len);
			   SendMessage((MSGHDR *)snc_pkt,(MBOX *)&ReceiveMbox);
			}
		    }
		}

		/*
		* transmit frame to ethernet interface
		*/
		MaskAllInts(saveInts);
		if (snc_pkt = (PKT *)GetShramPktBuf(minLen))
		{
			snc_pkt->pktXmtPort = xmtport;
			snc_pkt->pktTotalSize = snc_pkt->pktDataSize = minLen;
			snc_pkt->pktLocal = TRUE;
			memcpy(snc_pkt->pktBufPtr, b, len);
		 	snc_transmit_pkt(snc_pkt, 1); 
			code=0;
		}
		else
		  code = 1;
		RestoreIntMask(saveInts);
	 }
	 /*
	  * Create pkt from dbd, put in fddi mac header and
	  * then transmit it to fddi interface
	  */
	 if (xmtport = (d->db_xmtportlist & FDDI_PORTLIST))
	 {
		MaskAllInts(saveInts);
		/*
		* ethernet bound packets must be at least 64 bytes long
		*/
		minLen = (len < ET_MINLEN) ? ET_MINLEN : len;

		/* Get a transmit buffer. */
		fddi_pkt = (PKT *)GetShramPktBuf(minLen+8); /* 8 bytes for extra hdr bytes */
													/* added during translation.   */
		 if (fddi_pkt)
		 {
			byte *fddi_frm = (byte *)fddi_pkt->pktDataPtr;

			fddi_pkt->pktXmtPort = FDDI_PORTLIST;
			fddi_pkt->pktTotalSize = fddi_pkt->pktDataSize = minLen;
			fddi_pkt->pktLocal = TRUE;

			/*
			* set up fddi mac header
			* including FC, DA and SA
			*/
			fddi_mac[3] = 0x50;
			{ 
				register XFRMHDR* tmpfp;
				tmpfp = (XFRMHDR*)&(fddi_mac[4]);
	
				for(i=0; i<3; i++)      /* for each word of addr (12 bytes) */
  		       {
					bitrev.w = *((word*)b + i);           /* get 4 bytes */
					*((shrt*)tmpfp + (i*2))   = bitrev.s[0];
					*((shrt*)tmpfp + ((i*2)+1)) = bitrev.s[1];
				}
			}
  		    b+=12;
			memcpy(fddi_frm, (char *)&fddi_mac[3], 13);

		/*
		* fix up fddi llc header
		*/
		if (d->nb_flags & PKT_IEEEHDR)	/* llc or snap */
		{
		    /* Info */
		    memcpy((char *)(fddi_frm+13), (char *)(b+2), len-14);
		}
		else	/* ethernet */
		{
		    /* Type */
		    *(u_short *)&snap_hdr[6] = *(ushort *)b;
		    /* SNAP */
		    memcpy((char *)(fddi_frm+13), (char *)&snap_hdr[0], 8);
		    /* Info */
		    memcpy((char *)(fddi_frm+21), (char *)(b+2), len-14);
			fddi_pkt->pktTotalSize += 7;
			fddi_pkt->pktDataSize +=7 ;
		}
		code |= fddi_transmit_pkt(fddi_pkt, 1);
	  }
	  else
		code = 1;
	  RestoreIntMask(saveInts); 
	}
	/*
	* Hold dbd for application
	*/
	d->db_contrl++;
	free_dbd(d);

	/* counters */

	/*********
	LastPort = 1 << NumberOfSonicPort;
	for (PortList = 1, i = 0; PortList < LastPort; PortList <<= 1, i++)
		{
		if (PortList & XmtPortList)
			{
			if (code)
				{
				(ifcntrs + i)->outerrpkts++;
				}
			else
				{
				(ifcntrs + i)->outbytecnt += len;
				if (IsMultiCast(b))
					(ifcntrs + i)->outbmcastpkts++;
				else
					(ifcntrs + i)->outucastpkts++;
				}
			}
		}
	*********/

	if (code)	{
		return ERR_NETFAIL;
	}
	return 0;
}


/*
 *	Test if the nid is a multicast address
 *	Note:	Broadcast is a multicast address
 */
IsMultiCast(char *nid)

	{
	return *nid & 1;
 	}

IsLatPacket(struct ethhdr *p)

	{
	return p->e_type == 0x0460;
	}

/*
DumpData(unsigned char *p, int length)

	{
	while(length--)
		printf("%x ", *p++);
	printf("\r\n");
	}
*/
