
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	tcptable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/tcptable.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:41:28   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:42:00   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:15:02   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:24:48   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */


/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP TCP TABLE
**  
**          Created on 3-31-89
*******************************************************/


#include <types.h> 
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <netbuf.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>



/****************************************************************
**    SVC_RTOALGORITHM        ( TCP - 1 )
*****************************************************************/
int
svc_tcpRtoAlgorithm(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,(long)TCP_MIL_STD_1778));
}

/****************************************************************
**    SVC_RTOMIN              ( TCP - 2 )
*****************************************************************/
int
svc_tcpRtoMin(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,(long)RTO_LO));
}

/****************************************************************
**    SVC_RTOMAX              ( TCP - 3 )
*****************************************************************/
int
svc_tcpRtoMax(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,(long)RTO_HI));
}

/****************************************************************
**    SVC_TCPMAXCON           ( TCP - 4 )
*****************************************************************/
int
svc_tcpMaxConn(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->maxcon));
}

/****************************************************************
**    SVC_TCPACTOPENS         ( TCP - 5 )
*****************************************************************/
int
svc_tcpActiveOpens(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->active_con));
}

/****************************************************************
**    SVC_TCPPASVOPENS        ( TCP - 6 )
*****************************************************************/
int
svc_tcpPassiveOpens(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->pass_con));
}

/****************************************************************
**    SVC_TCPATMPFAIL         ( TCP - 7 )
*****************************************************************/
int
svc_tcpAttemptFails(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->con_fail));
}

/****************************************************************
**    SVC_TCPCLOSED           ( TCP - 8 )
*****************************************************************/
int
svc_tcpEstabResets(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->close_con));
}
/****************************************************************
**    SVC_TCPCURCON           ( TCP - 9 )
*****************************************************************/
int
svc_tcpCurrEstab(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->current_con));
}

/****************************************************************
**    SVC_TCPINSEGS           ( TCP - 10 )
*****************************************************************/
int
svc_tcpInSegs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->inseg));
}

/****************************************************************
**    SVC_TCPOUTSEGS          ( TCP - 11 )
*****************************************************************/
int
svc_tcpOutSegs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->outseg));
}

/****************************************************************
**    SVC_TCPRETRANSEGS       ( TCP - 12 )
*****************************************************************/
int
svc_tcpRetransSegs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_tcpcommonfnc(service,compc,compl,value,
	    (long)_initp->tcpcntr->retran_seg));
}

svc_tcpcommonfnc(service, compc, compl, value, parm)
unsigned int	service;
byte  *compc;
unsigned int *compl;
UINT_32_T  *value;
long parm;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = (UINT_32_T)parm;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**    SVC_CONSTAT             ( TCPCONENTRY - 1 )
*****************************************************************/
int
svc_tcpConnState(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	int idx,i;
	unsigned int  *cp;

	switch(service) {

	case SNMP_GET:
		if ( (idx=get_tcpid(*compc,(unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		else 
		{
			contblp += idx;
			*value = contblp->tcp_state;
		}
		break;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0 || chk_x_zeros(10,*compc,(unsigned int  *)cp) )
			idx = 0;
		else
		{
			if ( (idx=get_tcpid(*compc,(unsigned int  *)cp)) == -1 )
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=nxt_tcpcon(idx,(byte  *)compc,
		    (unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		contblp += i;
		*value = contblp->tcp_state;
		break;

	}
	return 0;
}

get_tcpid(num,cp)
int num;
unsigned int  *cp;
{
	int i;
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	AIP     local_ip;
	AIP     remote_ip;
	word   local_port;
	word   remote_port;

	if ( num != 10 )
		return -1;
	for ( i=0; i<4; i++,cp++ )
		local_ip.ip[i] = *cp;
	local_port = *cp;
	cp++;
	for ( i=0; i<4; i++,cp++)
		remote_ip.ip[i] = *cp;
	remote_port = *cp;
	for ( i=0; i< _initp->tcpcntr->maxcon; i++,contblp++ )
		if( contblp->tcp_id.local_ip_addr == local_ip.ip_adr 
		    && contblp->tcp_id.rem_ip_addr == remote_ip.ip_adr
		    && contblp->tcp_id.local_tcp_port == local_port
		    && contblp->tcp_id.rem_tcp_port == remote_port )
			return i;
	return -1;
}

nxt_tcpcon(index,compc,compl)
int index;
byte  *compc;
unsigned int  *compl;
{
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	AIP ipp;
	int i,j;

	for ( i=index, contblp+=index; i< _initp->tcpcntr->maxcon; i++,contblp++ )
		if ( contblp->tcp_state != CLOSED )
		{
			ipp.ip_adr = contblp->tcp_id.local_ip_addr;
			for(j=0; j<4; j++, compl++)
				*compl = ipp.ip[j];
			*compl = contblp->tcp_id.local_tcp_port;
			compl++;
			ipp.ip_adr = contblp->tcp_id.rem_ip_addr;
			for(j=0; j<4; j++, compl++)
				*compl = ipp.ip[j];
			*compl = contblp->tcp_id.rem_tcp_port;
			*compc = 10;
			return i;
		}
	return -1;
}

/****************************************************************
**    SVC_CONLOCALADDR        ( TCPCONENTRY - 2 )
*****************************************************************/
int
svc_tcpConnLocalAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	int idx,i;
	unsigned int  *cp;

	switch(service) {

	case SNMP_GET:
		if ( (idx=get_tcpid(*compc,(unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		else 
		{
			contblp += idx;
			*value = (INT_32_T)contblp->tcp_id.local_ip_addr;
		}
		break;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0 || chk_x_zeros(10,*compc,(unsigned int  *)cp) )
			idx = 0;
		else
		{
			if ( (idx=get_tcpid(*compc,(unsigned int  *)cp))==-1)
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=nxt_tcpcon(idx,(byte  *)compc,
		    (unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		contblp += i;
		*value = (INT_32_T)contblp->tcp_id.local_ip_addr;
		break;

	}
	return 0;
}


/****************************************************************
**    SVC_CONLOCALPORT        ( TCPCONENTRY - 3 )
*****************************************************************/
int
svc_tcpConnLocalPort(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	int idx,i;
	unsigned int  *cp;

	switch(service) {

	case SNMP_GET:
		if ( (idx=get_tcpid(*compc,(unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		else 
		{
			contblp += idx;
			*value = contblp->tcp_id.local_tcp_port;
		}
		break;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0 || chk_x_zeros(10,*compc,(unsigned int  *)cp) )
			idx = 0;
		else
		{
			if ( (idx=get_tcpid(*compc,(unsigned int  *)cp)) == -1 )
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=nxt_tcpcon(idx,(byte  *)compc,
		    (unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		contblp += i;
		*value = contblp->tcp_id.local_tcp_port;
		break;


	}
	return 0;
}


/****************************************************************
**    SVC_CONREMADDR        ( TCPCONENTRY - 4 )
*****************************************************************/
int
svc_tcpConnRemAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  * value;
int priv;
{
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	int idx,i;
	unsigned int  *cp;

	switch(service) {

	case SNMP_GET:
		if ( (idx=get_tcpid(*compc,(unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		else 
		{
			contblp += idx;
			*value = (INT_32_T)contblp->tcp_id.rem_ip_addr;
		}
		break;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0 || chk_x_zeros(10,*compc,(unsigned int  *)cp) )
			idx = 0;
		else
		{
			if ( (idx=get_tcpid(*compc,(unsigned int  *)cp)) == -1 )
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=nxt_tcpcon(idx,(byte  *)compc,
		    (unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		contblp += i;
		*value = (INT_32_T)contblp->tcp_id.rem_ip_addr;
		break;


	}
	return 0;
}


/****************************************************************
**    SVC_CONREMPORT          ( TCPCONENTRY -- 5 ) 
*****************************************************************/
int
svc_tcpConnRemPort(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
INT_32_T  *value;
int priv;
{
	TCP_CON_ENTRY  *contblp = _initp->tcpstat;
	int idx,i;
	unsigned int  *cp;

	switch(service) {

	case SNMP_GET:
		if ( (idx=get_tcpid(*compc,(unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		else 
		{
			contblp += idx;
			*value = contblp->tcp_id.rem_tcp_port;
		}
		break;
	case SNMP_GETNXT:
		cp = compl;
		if ( *compc == 0 || chk_x_zeros(10,*compc,(unsigned int  *)cp) )
			idx = 0;
		else
		{
			if ( (idx=get_tcpid(*compc,(unsigned int  *)cp)) == -1 )
				return ERR_INSTANCE;
			idx++;
		}
		if ( (i=nxt_tcpcon(idx,(byte  *)compc,
		    (unsigned int  *)compl)) == -1 )
			return NO_SUCH_NAME;
		contblp += i;
		*value = contblp->tcp_id.rem_tcp_port;
		break;


	}
	return 0;
}


/****************************************************************
**     SVC_TCPINERRS ROUTINE  ( TCP - 14 )
*****************************************************************/
int
svc_tcpInErrs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

/****************************************************************
**     SVC_TCPOUTRSTS ROUTINE  ( IP - 15 )
*****************************************************************/
int
svc_tcpOutRsts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return (svc_snmpnosupport(service, compc, compl, lenp, value, priv));
}

