/**			       
*
*	Program Name:	IP Fragment Reassembly
*
*	Filename:	infrag.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/infrag.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:30   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:56   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:06   gregs
 * Initial revision.
 * 
 *    Rev 1.3   08 Apr 1993 16:18:52   vinay
 * made changes to eliminate 2.2 compiler warnings
 * 
 *    Rev 1.2   19 Jan 1993 15:56:04   kenb
 * Changed the fragmentation handling. Four fragments can now be handled.
 * 
 *    Rev 1.1   13 May 1992 10:29:20   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:22:52   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:	2.20.91		K Kong
*			Create the INFRAG_STAT structure to replace
*			the globals in_reasmtmo, in_reasmreq .....
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * INFRAG.C - Simple reassembly of incoming IP fragments.
 *
 * Copyright (C) 1987 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 24-Jul-87	jbvb	Created, with reference to Philip's non-working code.
 * 30-Jul-87	jbvb	Improve statistics.
 * 20-Sep-87	romkey	removed strings from fragabort() if in kernel.
 * 19-Mar-91	Kwok	Don't manipulate ip address directly
 *			from the packet buffer.  The ip address
 *			may not be properly aligned.  We have to 
 *			copy out the ip address first.
 * */
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <task.h>
#include <ether.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <tcpip.h>
#include <frag.h>
#include "ipconn.h"
#include "internal.h"
/*
 *	Added in by Kwok Kong	2.8.91
 *	These were declared in async\init.c.
 *	However, these are used in here and should be
 *	declared in here.
 */
INFRAG_STAT	InfragStat = {0};

#define	NSLOTS		8	/* reassemble 8 fragments at a time */
#define NPKTS			4 /* 4 fragments possible per id number */

struct	one_frag
	{
	PACKET	p_ptr[NPKTS];		/* packet pointer (NULL if empty slot) */
	TIMER	*f_tmo;		/* reassembly timeout */
	};

static	struct	one_frag frag_tbl[NSLOTS];	/* fragment table */
static	TIMER	frag_timers[NSLOTS];	
static int BuildPacket(), CompletePacket(), AddFragment();

/*
 * infrag() is a very simple-minded implementation of IP fragment
 * reassembly.  It is called from indemux() when a fragment is
 * found, and is expected to dispose of the packet somehow.  If
 * a packet is completed, it recursively calls indemux(), expecting
 * the upper layers to free it.
 *
 * It presently only handles the simplest case:
 *
 *	One packet, fragmented into two (possibly overlapping) pieces.
 *
 * This is all we can reasonably test without patching our Unix,
 * and it should take care of the problem with Bridge gateways.
 */

infrag(new_pkt, len)
PACKET	new_pkt;
uint	len;
{
	int	slot,i;			/* slot in frag_tbl[] */
	ushort	new_offset;
	ushort	reass_offset;
	PACKET	reass_pkt;
	struct	ip	*reass_ip;		/* old packet's IP hdr */
	struct	ip	*pip = in_head(new_pkt);

	InfragStat.reasmreq++;

	/*
	 *	fragment offset is in multiple of 
	 *	8 bytes,  we shift left 3 bits to get
	 *	offset in number of bytes.
	 */
	new_offset = GetIpFragmentOffset(pip) << 3;/* byte swapped by indemux() */
	if (_initp->tlenfree < new_offset + len) 
	{
		InfragStat.reasmfail++;
		return in_discard(new_pkt);
	}

	/* non-terminating frag of non-integral length */
	if (!LAST_FRAG(pip) && ((len - (GetIpHeaderLength(pip) << 2)) % FRAGCHNK) != 0)
	{
		InfragStat.reasmfail++;
		return in_discard(new_pkt);
	}

	if ((slot = reassembling(pip)) < 0) 
	{
	/*
	*	This is the first fragment
	*	received. We expect another fragment to come.
	*/
		if ((slot = NextFreeSlot()) < 0)
		{
			InfragStat.reasmfail++;
			return in_discard(new_pkt);
		}
		frag_tbl[slot].p_ptr[0] = new_pkt;
		CreatTimer(&frag_timers[slot]);
		frag_tbl[slot].f_tmo = &frag_timers[slot];
		StartTimerCall((TIMER *)frag_tbl[slot].f_tmo, 
			FRAGTIME * TPS, frag_rlse, (int)slot);
		InfragStat.reasmok++;
		return;		/* all done */
	}
	else /* We already received at least one fragment */
	{
		if (AddFragment(slot,new_pkt)) /* if this fails to add the packet */
		{
			InfragStat.reasmfail++;
			return in_discard(new_pkt);
		}
		switch(CompletePacket(slot))
		{
			case 1:
				len = BuildPacket(slot); /* Will put packet into first index */
				reass_pkt = frag_tbl[slot].p_ptr[0];
				indemux(reass_pkt,len);
				frag_tbl[slot].p_ptr[0] = NULL; /* Free the slot */
				InfragStat.reasmok++;
				StopTimer(frag_tbl[slot].f_tmo);
				break;

			case 0: /* Not completed yet restart the timer and wait */
				StopTimer(frag_tbl[slot].f_tmo);
				StartTimerCall((TIMER *)frag_tbl[slot].f_tmo, pip->ip_time * TPS,
					frag_rlse, slot);
				break;;

			case 2: /* Delete all of the packets stop the timer and return */
				StopTimer(frag_tbl[slot].f_tmo);
				for (i = 0; i < NPKTS; i++)
					if (frag_tbl[slot].p_ptr[i])
					{
						in_discard((PACKET )&(frag_tbl[slot].p_ptr[i]));
						frag_tbl[slot].p_ptr[i] = NULL;		/* slot is idle */
					}
				break;
			

		}
	}
}

static int BuildPacket(slot)
int slot;
{
	struct ip *nip;
	int len,i = 0;
	PACKET pkt, pkt1 = frag_tbl[slot].p_ptr[0];
	
	for (i = 1; i < NPKTS; i++)
		if (frag_tbl[slot].p_ptr[i] != NULL)
		{
		pkt = frag_tbl[slot].p_ptr[i];
		nip = in_head(pkt);
		len = merge((PACKET )frag_tbl[slot].p_ptr[0],nip);
		putfree((DBD *)frag_tbl[slot].p_ptr[i]);
		frag_tbl[slot].p_ptr[i] = NULL;		/* slot is idle */
		}
		else
			break;

	return len;
}
static int AddFragment(slot,pkt)
int slot;
PACKET pkt;
{
	int offset,oldoffset;
	int len, oldlen,i;
	PACKET pkt_ptr;
	struct	ip	*pip = in_head(pkt);
	struct	ip	*oldpip;
	/*
	* This checks for a duplicate packet and then adds the packet to the
	* array.
	*
	*/

	offset = GetIpFragmentOffset(pip) << 3; /* Byte swapped by indemux */

	for (i = 0; i < NPKTS; i++)
	{
		if (frag_tbl[slot].p_ptr[i] == NULL) /* Found an empty slot */
		{
			frag_tbl[slot].p_ptr[i] = pkt;
			return 0;
		}
		else /* Possible duplicate packet */
		{
			pkt_ptr = frag_tbl[slot].p_ptr[i];
			oldpip = in_head(pkt_ptr);
			oldoffset = GetIpFragmentOffset(oldpip) << 3; /* Byte swapped by indemux */
			if (oldoffset == offset)
				return 1;
		}
	}
	return 1; /* We only handle a fragmentation of a packet into 4 pieces */
}

static int
CompletePacket(slot)
int slot;
{
	int i,offset,len;
	struct frag_pkt {
		PACKET pkt;
		int	offset;
		int len;
		};
	struct frag_pkt pkts[NPKTS];
	PACKET pkt_ptr;
	struct ip *pip;

	for (i = 0; i < NPKTS; i++)
	{
		pkts[i].pkt = NULL;
		pkts[i].offset = -1;
		pkts[i].len = -1;
	}

	for (i = 0; i < NPKTS; i++)
	{
		if (frag_tbl[slot].p_ptr[i] != NULL)
		{
			pkt_ptr = frag_tbl[slot].p_ptr[i];
			pip = in_head(pkt_ptr);
			offset = GetIpFragmentOffset(pip) << 3; /* Byte swapped by indemux */
			len = ntohs(pip->ip_len) - (GetIpHeaderLength(pip) << 2);
			if (FIRST_FRAG(pip)) /* First packet */
			{
				pkts[0].pkt = frag_tbl[slot].p_ptr[i];
				pkts[0].offset = offset;
				pkts[0].len = len;
			}
			else if (LAST_FRAG(pip))
			{
				pkts[3].pkt = frag_tbl[slot].p_ptr[i];
				pkts[3].offset = offset;
				pkts[3].len = len;
			}
			else if (pkts[1].len == -1) /* Not first and not last and this ones */
			{	/* Avaliable for use. */
				pkts[1].pkt = frag_tbl[slot].p_ptr[i];
				pkts[1].offset = offset;
				pkts[1].len = len;
			}
			else if (pkts[2].len == -1)
			{
				pkts[2].pkt = frag_tbl[slot].p_ptr[i];
				pkts[2].offset = offset;
				pkts[2].len = len;
			}
			else
				Errorlog(1,"Packet is fragmented too many times\n");
		}
		else
			break;
	}

	if (pkts[3].pkt == NULL)
		return 0; /* Final fragment not found in queue */
	else if (pkts[0].pkt == NULL)
		return 0; /* First fragment not found in the queue */

	/* 
	* Now the first packet is in packets[0] and the last packet is
	* in packets[3]. I only have to check 2 packets at the most.
	*/
	
	if (pkts[0].len == pkts[1].offset)
	{
		frag_tbl[slot].p_ptr[1] = pkts[1].pkt;
		if (pkts[2].pkt != NULL)
		{
			frag_tbl[slot].p_ptr[2] = pkts[2].pkt;
			frag_tbl[slot].p_ptr[3] = pkts[3].pkt;
			if ((pkts[2].offset != pkts[1].len + pkts[1].offset) ||
				(pkts[3].offset != pkts[2].len + pkts[2].offset))
				return 2; /* The packet is not complete but the arrays are full */
			else
				return 1;
		}
		else 
		{
			frag_tbl[slot].p_ptr[2] = pkts[3].pkt;
			if (pkts[3].offset == pkts[1].len + pkts[1].offset)
				return 1;
			else
				return 0;
		}
	}
	else if (pkts[0].len == pkts[2].offset)
	{
		frag_tbl[slot].p_ptr[1] = pkts[2].pkt;
		if (pkts[1].pkt != NULL)
		{
			frag_tbl[slot].p_ptr[2] = pkts[1].pkt;
			frag_tbl[slot].p_ptr[3] = pkts[3].pkt;
			if ((pkts[1].offset != pkts[2].len + pkts[2].offset) ||
				(pkts[3].offset != pkts[1].len + pkts[1].offset))
				return 2; /* The packet is not complete but the arrays are full */
		}
		else 
		{
			frag_tbl[slot].p_ptr[2] = pkts[3].pkt;
			if (pkts[3].offset == pkts[2].len + pkts[2].offset)
				return 1;
			else
				return 0;
		}
		return 1;
	}
	else if (pkts[0].len == pkts[3].offset) /* Easiest case two fragments */
	{
		frag_tbl[slot].p_ptr[1] = pkts[3].pkt;
		return 1;
	}
	return 0;
}

static int
reassembling(pip)
struct	ip	*pip;

{
	int	slot;
	struct	ip *fragment;
	in_name	frag_ip_src;
	in_name	frag_ip_dest;
	in_name	ip_src;
	in_name	ip_dest;
	PACKET pkt_ptr;

	/*
	 *	Don't manipulate ip address directly
 	 *	from the packet buffer.  The ip address
	 *	may not be properly aligned.  We have to 
	 *	copy out the ip addresses first.
 	 */
	ipcopy(&ip_src, &pip->ip_src);
	ipcopy(&ip_dest, &pip->ip_dest);
	/* look for fragment with matching src, dest, id, and prot. */
	for (slot = NSLOTS - 1; slot >= 0; slot--)
	{
		if (frag_tbl[slot].p_ptr[0] != NULL)
		{
			pkt_ptr = frag_tbl[slot].p_ptr[0];
			fragment = in_head(pkt_ptr);
			ipcopy(&frag_ip_src, &fragment->ip_src);
			ipcopy(&frag_ip_dest, &fragment->ip_dest);
			if (fragment->ip_id == pip->ip_id &&
				fragment->ip_prot == pip->ip_prot &&
				frag_ip_src == ip_src &&
				frag_ip_dest == ip_dest)
				break;			/* found it */
		}
	}
	return(slot);
}

static 
merge(pkt, pip)
PACKET	pkt;		/* destination packet */
struct	ip	*pip;	/* IP header of fragment to append to it */
{
	struct	ip	*rip;
	ushort	copy_len;
	ushort	overlap;

	rip = in_head(pkt);
	overlap = ntohs(rip->ip_len) - (GetIpHeaderLength(rip) << 2);
	copy_len = ntohs(pip->ip_len) - (GetIpHeaderLength(pip) << 2);
	memcpy((char *)rip + ntohs(rip->ip_len), /* Destination of memcpy */
	      (char *)in_data(pip),  /* Start of memcpy */
				copy_len);						/* How much */
	rip->ip_len = ntohs(copy_len + ntohs(rip->ip_len));
	pkt->nb_len += copy_len;
	PutIpFragmentOffset(rip, 0);
	GetIpFlags(rip);
	PutIpFlags(rip, GetIpFlags(rip) & ~IP_MF);
	rip->ip_chksum = 0;
	rip->ip_chksum = ~cksum(rip, GetIpHeaderLength(rip) << 1);
	return (pkt->nb_len);
	}

/*
 * Packet reassembly has timed out.  Find packet descriptor in list;
 * remove from list; free associated resources (timer, packet, descriptor).
 */

static
void frag_rlse(slot)
int	slot;		/* slot in frag_tbl[] that has timed out */
{
	int i;

	for (i = 0; i < NPKTS; i++)
	{
		if (frag_tbl[slot].p_ptr[i]) 
		{
			in_discard((PACKET )&(frag_tbl[slot].p_ptr[i]));
			frag_tbl[slot].p_ptr[i] = NULL;		/* slot is idle */
		}
	}
	InfragStat.reasmtmo++;
}
/*
 *	Search for a free slot in the fragment table
 *	It returns the free slot index if one is found or
 *	-1 if there is no free slot.
 */

static int NextFreeSlot()
{
	int	slot,i;

	for (slot = 0; slot < NSLOTS; slot++)
		if (frag_tbl[slot].p_ptr[0] == NULL)
		{
			for (i = 1; i < NPKTS; i++)
				frag_tbl[slot].p_ptr[i] = NULL;
			return slot;
		}
	return -1;
}
