/**			       
*
*	Program Name:	Reformat IP Packet 
*
*	Filename:	et_trlr.c
*
*	$Log:   /b/gregs/i960/tcpip/drv/et_trlr.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:39:52   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:28:40   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:55:28   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:13:50   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 10:10:04   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:21:06   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*			Replaced all unsigned, unsword, unsigned by ushort.
*			lword by ulong.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
/*
 * TRAILERS.C - Fix up a 4BSD trailer packet for our upper layers.
 *
 * Copyright (C) 1986, 1987 by FTP Software, Inc.
 * 
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 * 
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 20-Aug-87	jbvb	Propagate change to buffer layout (access ether header
 *			 via p->nb_prot instead of p->db_buffer).
 * 20-Sep-87	romkey	Made debugging messages be conditionally compiled in.
 */

#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ether.h>

/* reformat an ethernet IP trailer packet to look like a standard IP
	headers-first packet.
*/
fix_trailer(p, len)
register PACKET p;
int	len;

	{		/* length of the whole packet */
	static char tmp_hdr[128];	/* for packet header */
	struct ethhdr	*pe = (struct ethhdr *)p->db_buffer;
	char	*hdr;
	int	data_len;		/* size of the data portion */
	int	hdr_len;		/* size of the header portion */

	/* figure out how big the data area should be */
	switch(pe->e_type) 
		{
	case ET_TRAILER0: 
		pe->e_type = ET_IP;
		return; /* no data to move */

	case ET_TRAILER1:
		data_len = 512;
		break;

	case ET_TRAILER2:
		data_len = 1024;
		break;

	default: 
		return;
		}

	/* the length is the total length minus all the stuff in front of it */
	hdr_len = len - data_len - ETHRSIZ - 4;
	if (hdr_len <= 0) 
		return;
	/* the headers are right after the data, skipping their 4 byte header */
	hdr = (char *)p->nb_prot + data_len + 4;

	/* shift header to front of data */
	memcpy((char *)tmp_hdr, hdr, hdr_len);
	memmove(p->nb_prot+hdr_len, p->nb_prot, data_len);
	memcpy(p->nb_prot, (char *)tmp_hdr, hdr_len);

	/* disguise it as an IP packet */
	pe->e_type = ET_IP;
	}
