/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	inttbl.s
*
*	$Log:   /b/gregs/i960/system/inttbl.s_v  $
   
      Rev 1.4   12 Oct 1993 10:37:22   franks
   No change.
   
      Rev 1.3   29 Sep 1993 10:26:30   franks
   No change.
   
      Rev 1.2   10 Sep 1993 15:26:48   franks
   No change.
   
      Rev 1.1   08 Sep 1993 13:13:40   franks
   No change.
   
      Rev 1.0   14 Jul 1993 10:26:30   gregs
   Initial revision.
   
      Rev 1.1   14 May 1992 10:29:34   suresh
   Aligned the routines to 16 byte boundary.
   
      Rev 1.0   30 Mar 1992 17:05:04   pvcs
   Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

	.text
	.align  4
	.globl intr

	/* DEFAULT INTERRUPT HANDLER */
intr:
	ldconst 64, r4
	addo sp, r4, sp

	stq g0, -64(sp)
	stq g4, -48(sp)
	stq g8, -32(sp)
	stt g12, -16(sp)


	lda	fmt, g0
	ldob	-8(fp), g1	# Pick vector number out of interrupt record
	call	_printf
	
	ldq -64(sp), g0
	ldq -48(sp), g4
	ldq -32(sp), g8
	ldt -16(sp), g12
	ret

	.align  4
fmt:	.asciz	"\nReceived interrupt @ vector #%d\n"



	/* INITIAL INTERRUPT TABLE */

 	.globl	_ram_int_table     
	.align  4
_ram_int_table: 
	.word	0			# Pending Priorities
	.word	0,0,0,0,0,0,0,0		# Pending Interrupts

	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries   8 -  15
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  16 -  23
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  24 -  31
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  32 -  39
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  40 -  47
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  48 -  55
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  56 -  63
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  64 -  71
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  72 -  79
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  80 -  87
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  88 -  95
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries  96 - 103
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 104 - 111
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 112 - 119
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 120 - 127
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 128 - 135
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 136 - 143
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 144 - 151
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 152 - 159
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 160 - 167
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 168 - 175
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 176 - 183
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 184 - 191
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 192 - 199
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 200 - 207
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 208 - 215
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 216 - 223
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 224 - 231
	.word	intr,intr,intr,intr,intr,intr,intr,intr	# entries 232 - 239
	.word	intr,intr,intr,intr			# entries 240 - 243

	.word	intr,intr,intr,intr	# reserved (244-247)
	.word	_int_nmi		# entry 248:
					#	system error interrupt (MC)
					#	Non-Maskable Interrupt (CA)
	.word	intr,intr,intr		# reserved (249-251)

	.word	intr,intr,intr,intr	# entries 252 - 255
