

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	fault.c
*
*	$Log:   /b/gregs/i960/system/fault.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 10:37:18   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:26:26   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:26:44   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 13:13:36   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:26:14   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:05:00   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of
   Intel Corporation not be used in advertising or publicity
   pertaining to distribution of the software or the documentation
   without specific, written prior permission.

   Intel Corporation does not warrant, guarantee or make any
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness,
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own
   risk.							  */
/******************************************************************/
#include <defines.h>
#include <globals.h>
#include <regs.h>
#include <stop.h>

/* The following two bytes indicate the reason why the user program
 * last stopped.
 */
extern char stop_exit;	/* TRUE => user program exited;
		 * FALSE => user program fault, trace, or srq
		 */
extern char stop_code;	/* Meaning depends on value of stop_exit.
		 * If stop_exit == TRUE, this is the user exit code.
		 * If stop_exit == FALSE,
		 *	Faults:
		 *		0x00: parallel
		 *		0x01: unknown (trace faults have separate
		 *			numbers, see below)
		 *		0x02: operation
		 *		0x03: arithmetic
		 *		0x04: floating point [no a part of 960CA arch.]
		 *		0x05: constraint
		 *		0x06: virtual memory
		 *		0x07: protection
		 *		0x08: machine
		 *		0x09: structural
		 *		0x0a: type
		 *		0x0b: [ reserved ]
		 *		0x0c: process
		 *		0x0d: descriptor
		 *		0x0e: event
		 *		0x0f: [ reserved ]
		 *	Traces:
		 *		0x10: Single-step
		 *		0x11: Branch
		 *		0x12: Call
		 *		0x13: Return
		 *		0x14: Pre-return
		 *		0x15: Supervisor Call
		 *		0x16: Breakpoint
		 *	Other:
		 *		0xfe: application service request (srq)
		 *		0xff: Software breakpoint (set by gdb)
		 */

struct fault_data {
	unsigned reserved;
	unsigned override[3];
	unsigned fdata[3];
	unsigned override_data;
	unsigned pc;
	unsigned ac;
	unsigned int	fsubtype:8,
			freserved:8,
			ftype:8,
			fflags:8;
	unsigned int *faddress;
};

char stop_exit;
char stop_code;
unsigned int register_set[NUM_REGS];  /* local, global, special regs */

void fault_handler();
static void tell_fault_type();
static void trace_fault_handler();


/*****************************************/
/* Fault Handler Routine	 	 */
/* 					 */
/* This is the C-level fault handler.	 */
/* It determines whether or not the	 */
/* fault is a trace fault and dispatches */
/* it appropriately			 */
/*****************************************/

void
fault_handler(fault_ptr)
struct fault_data *fault_ptr;
{
	if  ( fault_ptr->ftype == 1 ){
		trace_fault_handler( fault_ptr );
	} else {
		tell_fault_type(fault_ptr);
		monitor();
	}
}

/*****************************************/
/* Tell fault type			 */
/* 					 */
/*****************************************/
static void
tell_fault_type( fault_ptr )
struct fault_data *fault_ptr;	/* pointer to fault record on stack */
{
	unsigned int type;
	static char *fault_names[] = {
		"Parallel",		/* Type 0 */
		"Trace",		/* Type 1 */
		"Operation",		/* Type 2 */
		"Arithmetic",		/* Type 3 */
		"Floating Point",	/* Type 4 */
		"Constraint",		/* Type 5 */
		"Virtual Memory",	/* Type 6 */
		"Protection",		/* Type 7 */
		"Machine",		/* Type 8 */
		"Structural",		/* Type 9 */
		"Type",			/* Type a */
		"Reserved (0xb)",	/* Type b */
		"Process",		/* Type c */
		"Descriptor",		/* Type d */
		"Event",		/* Type e */
		"Reserved (0xf)"	/* Type f */
	};

	type = fault_ptr->ftype;

	/* Determine (and store for later query by GDB) the
	 * reason why program stopped.
	 */
	stop_exit = FALSE;
	if ( (0 <= type) && (type <= LAST_FAULT) ){
		stop_code = type;
	} else {
		stop_code = FAULT_UNKNOWN;
	}

	if ( (0 <= type) && (type <= LAST_FAULT) ){
		printf( " %s fault at: ", fault_names[type] );
	} else {
		printf(" Unknown fault of type %02x at: ", type );
	}

	printf( "%08X\n", fault_ptr->faddress );
	printf(" Fault record is on stack at %08X: \n", fault_ptr );
	printf(" fdata : %08X %08X %08X\n",
		fault_ptr->fdata[0], fault_ptr->fdata[1], fault_ptr->fdata[2] );
	printf(" fsubtype %02x:     fflags : %02x\n",
			fault_ptr->fsubtype, (unsigned int)fault_ptr->fflags );
}

/****************************************/
/* Trace Fault Handler Routine 		*/
/****************************************/
static void
trace_fault_handler(fault_ptr)
struct fault_data *fault_ptr;
{
	unsigned int *inst_ptr;
	int mask;	/* Masks single bit in fault subtype byte */
	int bitnum;	/* Number of bit currently masked by 'mask' */
	unsigned int subtype;


	inst_ptr = fault_ptr->faddress;
	subtype = fault_ptr->fsubtype;

	printf("\n");

	/* REAL BREAKPOINT */

	printf(" *** Breakpoint at :%08X\n", fault_ptr->faddress );
	printf("  Type(s) : " );
	if (subtype & 0x2 ) printf(" Single-step");
	if (subtype & 0x4 ) printf(" Branch");
	if (subtype & 0x8 ) printf(" Call");
	if (subtype & 0x10) printf(" Return");
	if (subtype & 0x20) printf(" Pre-return");
	if (subtype & 0x40) printf(" Supervisor Call");
	if (subtype & 0x80) printf(" Breakpoint");
	if (!(subtype)) printf(" NMI entry");
	printf("\n");
	dasm( 0, 0, 0, 0 );

	/* Determine why program stopped */
	if (!(*inst_ptr == 0x66003e00))
	{
		mask = 0x02;
		for (bitnum=1; bitnum<=7; bitnum++, mask <<=1)
			if (subtype & mask)
				break;

		/* Store reason for later query by GDB */
		stop_code = LAST_FAULT + bitnum;

		/* Leave ip pointing at next instruction that will
		 * be executed:  trace fault leaves ip pointing
		 * at the instruction that just completed, but rip
		 * points to the next instruction, so copy it to ip.
		 */
		register_set[REG_IP] = register_set[REG_RIP];
	}
	else
	{
		register_set[REG_IP] = register_set[REG_RIP];
	}

	monitor();	/* NO RETURN */
}
