/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	monitor.c
*
*	$Log:   /b/gregs/i960/newdebug/monitor.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 10:36:32   franks
 * Added somemore debug routines
 * 
 *    Rev 1.3   29 Sep 1993 10:25:50   franks
 * Changed pkt command to pktm
 * 
 *    Rev 1.2   10 Sep 1993 15:26:20   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 12:55:32   franks
 * Added a couple of routines to aid in debugging the FDDI driver .
 * 
 *    Rev 1.0   05 Apr 1993 17:27:50   ramki
 * Initial revision.
 * 
 *    Rev 1.1   09 Jun 1992 19:16:00   kwok
 * Declare the static functions at the beginning of the file.
 * 
 *    Rev 1.0   30 Mar 1992 16:54:46   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include <types.h>
#include <dbdefines.h>
#include <globals.h>
#include <regs.h>

struct cmd * lookup_cmd();

	void breakpt();
	void dasm();
	void databreak();
	void delete();
	void delete_data();
	void display();
	void display_regs();
	void display_prcb();
	void fill();
	void go();
	void he_cmd();
	void help();
	void modify();
	void out_message();
	void reset();
	void trace();
	void stack_history();
	void chk_fddidrv();
	void chk_pkt();	
#if 1
        void PrintPktList();
#endif      
/*********************************************************************
 * board identifier
 *********************************************************************/
char boardname[] = "HUGHES960";
char architecture[] = "CA";	/* Processor type */
unsigned char linebuff[LINELEN];/* command line buffer */
#define	XVERSION 	""
#define	VERSION		"3.06"

/************************************************************************
 * COMMAND TABLE
 *
 * The following table describes the keyboard commands.
 * The fields in each entry have the following meanings:
 *
 * cmd_name
 *	Name of command as a '\0'-terminated string.  Only the number of
 *	leading characters required for a match with user-entered input
 *	appear here,
 *
 * cmd_action
 *	Function that actually performs the command.  It should be
 *	invoked with the following arguments, in order:
 *		- the cmd_internal_arg from the command entry.
 *		- the number of following arguments that are valid on
 *			this call (some arguments may be optional).
 *		- one or more user-entered arguments, already parsed
 *			according to the corresponding cmd_argtypes.
 *
 * cmd_internal_arg
 *	First argument to be passed to the command action function.
 *
 * cmd_argtypes
 *	A '\0'-terminated list of characters describing the legal
 *	user-entered arguments to the command.  The ascii version
 *	of each argument should be translated into the corresponding
 *	type before it is passed to the action function.  Valid types are:
 *
 *	D  The text may be either a decimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	H  The text may be either a hexadecimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	S  The ASCII string should be passed unchanged to the action function.
 *
 *	Upper case letters indicate required arguments, lower case letters
 *	indicated optional arguments.  It is assumed that all required
 *	arguments always precede all optional ones.
 *
 ************************************************************************/


struct cmd {
	char *cmd_name;
	void (*cmd_action)();
	long cmd_internal_arg;
	unsigned char cmd_argtypes[4];
};


static const struct cmd
cmd_table[] = {
	{ ".",  0,		0,		""	},
	{ "bd", databreak,	0,		"h",	},
	{ "br", breakpt,	0,		"h",	},
	{ "da", dasm,		0,		"hd",	},
	{ "db", display,	BYTE,		"Sd",	},
	{ "dd", display,	LONG,		"Sd",	},
	{ "de", delete,		0,		"H",	},
	{ "di", display,	INT,		"Sd",	},
	{ "dp", display_prcb,	0,		"",	},
	{ "dq", display,	QUAD,		"Sd",	},
	{ "ds", display,	SHORT,		"Sd",	},
	{ "dt", display,	TRIPLE,		"Sd",	},
	{ "ed", delete_data,	0,		"H",	},
	{ "fi", fill,		0,		"HHH",	},
	{ "go", go,		FALSE,		"h",	},
	{ "?",  help,		0,		"s",	},
	{ "he", help,		0,		"s",	},
	{ "mb", modify,		BYTE,		"Sd",	},
	{ "mo", modify,		INT,		"Sd",	},
	{ "re", display_regs,	0,		"",	},
	{ "rs", reset,		0,		"",	},
	{ "sh", stack_history,	INT,		"d",	},
	{ "st", go,		TRUE,		"h",	},
	{ "tr", trace,		0,		"ss",	},
	{ "ve", out_message,	0,		"",	},
	{ "drv",chk_fddidrv,	0,		"",	},
	{ "pktm",chk_pkt,	0,		"",	},
        { "fpkt",PrintPktList,  0,              "",     },
	{ NULL, 0 }
};



/************************************************/
/* Look up a command in the command table	*/
/************************************************/
static
struct cmd *
lookup_cmd( cmd )
char *cmd;
{
struct cmd *cp;

	for ( cp = (struct cmd *)cmd_table; cp->cmd_name != NULL; cp++ ){
		if ( !strncmp(cmd,cp->cmd_name,strlen(cp->cmd_name)) ){
			return cp;
		}
	}
	return NULL;
}

/************************************************/
/* Monitor Shell             			*/
/************************************************/
void
monitor()
{
struct cmd *cp;
long pargs[4];
static char histbuff[LINELEN] = "";	/* command history buffer */
char *args[MAXARGS];    /* Pointers to the individual words in linebuff.
			 * Each word is '\0'-terminated.
			 */
int nargs;		/* Number of meaningful entries in 'args' */
unsigned char *p;
int i;
int r;
int invalid_arg;

	dopen();

	while (TRUE){
		do {
			dprintf("\n%s", "->");
			readline(linebuff,sizeof(linebuff));
		} while ( linebuff[0] == '\0' );

		for ( p = linebuff; *p; p++ ){
			if ( isupper(*p) ){
				*p = tolower(*p);
			}
		}

		/* Check if first non-blank is repeat command
		 */
		for ( p = linebuff; *p == ' ' || *p == '\t'; p++ ){
			;
		}
		if ( *p == '.' ){
			strcpy(linebuff,histbuff);
			dprintf("\n%s",histbuff);
		} else {
			/* not repeat command, add to history buffer */
			strcpy( histbuff, linebuff );
		}
		dprintf("\n");


		/* Break individual arguments out of command
		 */
		nargs = get_words( linebuff, args, MAXARGS );


		/* Check for valid command and number of arguments
		 */
		if ( (cp=lookup_cmd(args[0])) == NULL ){
			dprintf("Invalid command\n");
			continue;
		}
		if ( nargs > strlen(cp->cmd_argtypes)+1 ){
			/* +1 since nargs includes command name */
			dprintf("Too many arguments\n" );
			continue;
		}


		/* Parse arguments according to types stored in command table
		 */
		p = cp->cmd_argtypes;
		invalid_arg = 0;
		for ( i = 1; i < nargs; i++, p++ ){
			switch ( *p ){
			case 'H':
			case 'h':
				r = get_regnum(args[i]);
				if ( (r != ERROR) && (r < NUM_REGS) ){
					pargs[i] = register_set[r];
				} else if ( !atoh(args[i],&pargs[i]) ){
					dprintf("Invalid hex number: %s\n",args[i]);
					invalid_arg = 1;
				}
				break;
			case 'D':
			case 'd':
				r = get_regnum(args[i]);
				if ( (r != ERROR) && (r < NUM_REGS) ){
					pargs[i] = register_set[r];
				} else if ( !atod(args[i],&pargs[i]) ){
					dprintf("Invalid decimal number: %s\n",
								args[i] );
					invalid_arg = 1;
				}
				break;
			case 'S':
			case 's':
				pargs[i] = (long) args[i];
				break;
			}
		}

		/* Make sure all required arguments were present.
		 * If so, call action function.
		 */
		if ( !invalid_arg ){
			if ( isupper(*p) ){
				dprintf("Missing argument(s)\n" );
			} else {
				cp->cmd_action( cp->cmd_internal_arg, i-1,
						pargs[1], pargs[2], pargs[3] );
			}
		}
	}
}


/************************************************/
/* Start/continue execution of user code	*/
/************************************************/
void
go( step_flag, nargs, addr )
int step_flag;
int nargs;	/* Number of the following arguments that are valid */
int addr;
{
	dprintf("\n");

	if ( nargs == 1 )
		register_set[REG_IP] = addr;

	if ( step_flag ){
		register_set[REG_TC] |= 2;	/* Set single-step */
	} else {
		register_set[REG_TC] &= ~2;	/* Clear single-step */
	}

	register_set[REG_PC] |= 1;	/* Enable trace faults */
	run_user();			/* Perform fault return (asm code) */
	/* NO RETURN */
}


/************************************************/
/* Output the Intro message     		*/
/************************************************/
void
out_message()
{
	dprintf("\n            NINDY monitor for the 80960%s %s\n",
						architecture, boardname );

	dprintf("               	    Version %s%s\n\n", XVERSION, VERSION );
 	dprintf("          Copyright (c) 1989, 1990, Intel Corporation\n");
}

/* -------------------------------------------------------------|
 *  EDIT TRACK OF THIS ROUTINE  -  GetLine                      |
 * -------------------------------------------------------------|
 *  ABSTRACT : This routine will get a line of input from the   |
 *             console.  The length of this line buffer is up   |
 *             to "length" bytes.                               |
 * ------------------------------------------------------------ */

readline(str, length)		/* get a line of input. */
register char *str;		/* buffer for input     */
int	length;			/* of str buffer	*/

	{
	register char *s;

	/* strip parity bit as each char is read */
	for (s = str; (*s = dgetc() & 0x7f) != '\n'; s++)
		if (s == &str[length-1])
			s--;
	if (s == &str[length-1])
		{
		s--;
		dprintf("...Line Overflow: excess discarded\n");
		}
	*s = NULL;			/* NULL over the newline */
	} 




/************************************************/
/* Read Data                       	 	*/
/*                           			*/
/* Read a line of input from the user, and	*/
/* convert it to a hex value.  Return TRUE on	*/
/* success;  print "unchanged" and return FALSE	*/
/* on failure.					*/
/************************************************/
int
read_data(data)
int *data;
{
char buf[16];
int retval;

	readline( buf, sizeof(buf));
	retval = atoh(buf,data);
	dprintf("%s\n", retval ? "" : "unchanged" );
	return retval;
}


/************************************************/
/* get_words:	break individual words out of 	*/
/*		a command.			*/
/*						*/
/* Output:					*/
/*	words[0] is left pointing to first word	*/
/*	in command (command name), words[1]	*/
/*	points to 2nd word (first argument),	*/
/*	etc.  All words are '\0'-terminated.	*/
/*	Words are separated by whitespace or '#'*/
/*						*/
/* Return value:				*/
/*	Number of words in list.		*/
/*	Unused entries in 'words' are zeroed.	*/
/*						*/
/************************************************/
int
get_words( p, words, max )
    register char *p;	/* Pointer to space-separated operands; MUCKED BY US */
    char *words[];	/* Output arg -- see above	*/
    int max;		/* Max number of words to be accommodated.
			 *	'words' must contain 'max' entries.
			 */
{
	register int n;		/* Number of words found */


	for ( n = 0; n < max; n++ ){
		words[n] = NULL;
	}

	n = 0;

	while ( *p != '\0' ){

		/* Skip lead white space */
		while ( *p == ' ' || *p == '\t' || *p == '#' ){
			p++;
		}

		if ( *p == '\0' ){
			break;
		}

		if ( n++ < max ){
			words[n-1] = p;
		}

		/* Find end of word */
		while ( *p != ' ' && *p != '\t' && *p != '#' && *p != '\0' ){
			p++;
		}

		/* Terminate word */
		if ( *p != '\0' ){
			*p++ = '\0';
		}
	}
	return n;
}


/************************************************/
/* Get Register Number       			*/
/*                           			*/
/*	Returns:				*/
/*						*/
/*	- offset into 'register_set' array, if	*/
/*	  register is a local, global, or	*/
/*	  control register.			*/
/*						*/
/*	- ERROR if register name is unknown	*/
/*						*/
/************************************************/
struct tabentry { char *name; int num; };

static const struct tabentry
reg_tab[] = {
    {"g0", REG_G0},  {"g1", REG_G1},  {"g2", REG_G2},  {"g3", REG_G3},
    {"g4", REG_G4},  {"g5", REG_G5},  {"g6", REG_G6},  {"g7", REG_G7},
    {"g8", REG_G8},  {"g9", REG_G9},  {"g10",REG_G10}, {"g11",REG_G11},
    {"g12",REG_G12}, {"g13",REG_G13}, {"g14",REG_G14}, {"fp", REG_FP},
    {"pfp",REG_PFP}, {"sp", REG_SP},  {"rip",REG_RIP}, {"r3", REG_R3},
    {"r4", REG_R4},  {"r5", REG_R5},  {"r6", REG_R6},  {"r7", REG_R7},
    {"r8", REG_R8},  {"r9", REG_R9},  {"r10",REG_R10}, {"r11",REG_R11},
    {"r12",REG_R12}, {"r13",REG_R13}, {"r14",REG_R14}, {"r15",REG_R15},
    {"pc", REG_PC},  {"ac", REG_AC},  {"ip", REG_IP},  {"tc", REG_TC},
    {0,	0}
};

int
get_regnum(reg)
char *reg;	/* Name of register	*/
{
	const struct tabentry *tp;

	for (tp=reg_tab; tp->name != 0; tp++) {
		if (!strcmp(reg,tp->name)) {
			return (tp->num);
		}
	}
	return ERROR;
}


/************************************************/
/* Get Register Name       			*/
/*                           			*/
/*	Returns:				*/
/*						*/
/*	- pointer to string containing name of	*/
/*	  register whose number is 'n', if	*/
/*	  register is a local, global, or	*/
/*	  control register.			*/
/*						*/
/*	- NULL if register name is unknown	*/
/*						*/
/************************************************/

char *
get_regname(n)
int n;		/* Number of register */
{
	const struct tabentry *tp;

	for (tp=reg_tab; tp->name != 0; tp++) {
		if ( tp->num == n ){
			return tp->name;
		}
	}
	return NULL;
}

badarg(s)
char *s;
{
	dprintf("Bad argument: '%s'\n", s );
}

void chk_fddidrv ()
{
  BMAC_DebugGetBMACMode(0);
  BSI_DebugGetBSIMode(0);
  BSI_BrChkDBDs(); 
}

