/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	printf.c
*
*	$Log:   /b/gregs/i960/newdebug/dtty.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 10:36:30   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:25:50   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:26:18   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 12:55:30   franks
 * No change.
 * 
 *    Rev 1.0   05 Apr 1993 17:27:50   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:08   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/********************************************************
 *
 *	COPYRIGHT (c) 1986 by SYTEK Inc.   (unpublished)
 *		*** ALL RIGHTS RESERVED ***
 *
 *     printf, putchar, getchar, gets functionality
 *
 ********************************************************/

#include <types.h>
#include <tty.h>
#include <errorno.h>

extern int fault_cnt;

/* print and scan buffer to be used by the debugger */
char debuf[512];
TTY dtty;

dopen()
{
	*(dtty.t_nxt = dtty.t_buf) = 0;
	dtty.t_col = 0;
}

/*
 * dputc writes the character c to the device.
 *
 * Returns :	c if successful.
 *		EOF on error
 */
dputc(int c)
{
	register TTY *ttyptr = &dtty;

	/* character interpretation */
	switch(c &= 0x7f)
	{
	case '\n':
		uartputc('\n');
		/* fall through */
	case '\r':
		uartputc('\r');
		ttyptr->t_col = 0;		/* at start of line */
		break;

	case '\t':
		do 
			uartputc(' ');/* space til next tab stop */
		while (++ttyptr->t_col & 0x03);
		break;

	default:
		if (c < 0x20)
		{
			uartputc('^');
			uartputc(c | 0x40);
			ttyptr->t_col += 2;	/* took two characters */
		}
		else 
		{
			uartputc(c);
			ttyptr->t_col += 1;	/* took one character */
		}
	} /* end of switch */

	return c;
}

derase(int c)
{
	c &= 0x7f;

	if (c < 0x20)
	{
		uartputc(8); 	/* backspace */
		uartputc(' '); 	/* blank */
		uartputc(8); 	/* backspace */
	}

	uartputc(8); 	/* backspace */
	uartputc(' '); 	/* blank */
	uartputc(8); 	/* backspace */
}


/*
 * dgetc returns the next character from the device.
 *
 * Returns :	next character if successful.
 *		EOF on error
 */
dgetc()
{
	int c;
	register TTY *ttyptr = &dtty;

	if (*ttyptr->t_nxt == 0)	/* empty buffer */
		_dgetline(ttyptr);
	return (int)(*ttyptr->t_nxt++ & 0x7f);/* return next character */
}

_dgetline(TTY *ttyptr)
{
	register int value;
	register char *p = ttyptr->t_nxt = ttyptr->t_buf;
	static char lastchar = '\0';

	for (;;)
	{
		switch (*p = uartgetc())
		{
		case 21:	/* CTRL-U */
			while (p != ttyptr->t_buf)
				derase(*--p);
			break;
		case 8:  	/* CTRL-H */
		case 127:	/* DEL */
			if (p != ttyptr->t_buf)
				derase(*--p);
			break;
		case  4:	/* CTRL-D */
			dputc(*p++);
			/* fall through to new line */
		case '\r':	/* Carriage Return */
			lastchar = *p;
			*p = '\n';	/* convert to line feed */
			dputc(*p++);
			*p = 0;		/* delimit input line */
			return E_SUCCESS;
		case '\n':	/* line feed */
			if (lastchar != '\r')
			{
				lastchar = '\0';
				dputc(*p++);
				*p = 0;		/* delimit input line */
				return E_SUCCESS;
			}
			break;
		default:	/* Character */
			if (p == &ttyptr->t_buf[BUFSIZ-2])
				uartputc(7); /* ring a bell */
			else
				dputc(*p++);
		} /* end of switch */
		lastchar = '\0';
	} /* end of for loop */
}

/*
 * dgets reads at most the next n-1 characters into the array s,
 * stopping if a newline is encountered; the newline included in
 * the array, which is terminated by '\0'.
 *
 * Returns :	s if successful
 *		NULL on error
 */
char *dgets(char *s, int n)
{
	int c;

	while (((c = dgetc() & 0x7f) != '\n') && --n)
		*s++ = (char)c;

	*s = '\0';
	return s;
}



/*
 * dputs writes the string to the device.
 *
 * Returns :	non-negative if successful
 *		EOF on error
 */
dputs(const char *s)
{
	int c;

	while ((c = *s++) != '\0')
		dputc(c);

	return 1;
}

/*
 * fprintf provides formatted output conversion to device.
 *
 * Returns :	number of characters written
 *		negative value on error
 */
dprintf(str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
char *str;	/* control string */
int  arg0;
int  arg1;
int  arg2;
int  arg3;
int  arg4;
int  arg5;
int  arg6;
int  arg7;
{
	int ret;

	ret = sprintf(debuf, str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
	dputs((const char *)debuf);

	return ret;
}

/*
 * fscanf does formatted input conversion from device.
 *
 * Returns :	number of input items converted and assigned
 *		EOF on error
 */
dscanf(fmt, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
register char *fmt;	/* control/matching string */
int  *arg0;
int  *arg1;
int  *arg2;
int  *arg3;
int  *arg4;
int  *arg5;
int  *arg6;
int  *arg7;
{
	dgets(debuf, 512);

	return sscanf(debuf, fmt, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

